/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.item;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.dom.Scaling;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.ItemAttributesRegistry;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.MaterialClass;
import me.athlaeos.valhallammo.item.item_attributes.AttributeWrapper;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SmithingItemPropertyManager {
    private static final NamespacedKey NUMBER_TAGS = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "smithing_treatments");
    private static final NamespacedKey QUALITY_SMITHING = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "quality_smithing");
    private static final NamespacedKey NEUTRAL_QUALITY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "neutral_quality");
    private static final NamespacedKey COUNTER = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "counter");
    private static final NamespacedKey COUNTER_LIMIT = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "counter_limit");
    private static final Map<Integer, String> qualityLore = new TreeMap<Integer, String>();
    private static final Map<Integer, String> tagLore = new HashMap<Integer, String>();
    private static final Map<Integer, String> cleanTagLore = new HashMap<Integer, String>();
    private static final Map<Integer, String> tagRequiredErrors = new HashMap<Integer, String>();
    private static final Map<Integer, String> tagForbiddenErrors = new HashMap<Integer, String>();
    private static final Map<String, Map<MaterialClass, Scaling>> materialScalings = new HashMap<String, Map<MaterialClass, Scaling>>();
    private static double qualityRoundingPrecision = 10.0;

    public static void register(String attribute, MaterialClass materialClass, Scaling scaling) {
        if (attribute == null || materialClass == null || scaling == null) {
            return;
        }
        Map newScaling = materialScalings.getOrDefault(attribute, new HashMap());
        newScaling.put(materialClass, scaling);
        materialScalings.put(attribute, newScaling);
    }

    public static void loadConfig() {
        ConfigurationSection tagRequiredSection;
        ConfigurationSection tagForbiddenSection;
        ConfigurationSection tagSection;
        YamlConfiguration yaml = ConfigManager.getConfig("skills/smithing.yml").get();
        qualityRoundingPrecision = yaml.getDouble("quality_rounding_precision", 10.0);
        ConfigurationSection qualitySection = yaml.getConfigurationSection("quality_lore");
        if (qualitySection != null) {
            for (Object r : qualitySection.getKeys(false)) {
                try {
                    int rating = Integer.parseInt((String)r);
                    String lore = TranslationManager.translatePlaceholders(yaml.getString("quality_lore." + (String)r));
                    if (lore == null) continue;
                    qualityLore.put(rating, Utils.chat(lore));
                }
                catch (IllegalArgumentException ignored) {
                    ValhallaMMO.logWarning("Invalid quality rating in skills/smithing.yml: quality_lore." + (String)r + " is not a number");
                }
            }
        }
        if ((tagSection = yaml.getConfigurationSection("tag_lore")) != null) {
            for (String r : tagSection.getKeys(false)) {
                try {
                    int tag = Integer.parseInt(r);
                    String lore = TranslationManager.translatePlaceholders(yaml.getString("tag_lore." + r));
                    if (lore == null) continue;
                    lore = Utils.chat(lore);
                    String cleaned = ChatColor.stripColor((String)lore.replace("%lv_roman%", "").replace("%lv_normal%", ""));
                    tagLore.put(tag, lore);
                    cleanTagLore.put(tag, cleaned);
                }
                catch (IllegalArgumentException ignored) {
                    ValhallaMMO.logWarning("Invalid number tag in skills/smithing.yml: tag_lore." + r + " is not a number");
                }
            }
        }
        if ((tagForbiddenSection = yaml.getConfigurationSection("tag_error_disallowed")) != null) {
            for (String r : tagForbiddenSection.getKeys(false)) {
                try {
                    int tag = Integer.parseInt(r);
                    String lore = TranslationManager.translatePlaceholders(yaml.getString("tag_error_disallowed." + r));
                    if (lore == null) continue;
                    tagForbiddenErrors.put(tag, Utils.chat(lore));
                }
                catch (IllegalArgumentException ignored) {
                    ValhallaMMO.logWarning("Invalid number tag in skills/smithing.yml: tag_error_disallowed." + r + " is not a number");
                }
            }
        }
        if ((tagRequiredSection = yaml.getConfigurationSection("tag_error_required")) != null) {
            for (String r : tagRequiredSection.getKeys(false)) {
                try {
                    int tag = Integer.parseInt(r);
                    String lore = TranslationManager.translatePlaceholders(yaml.getString("tag_error_required." + r));
                    if (lore == null) continue;
                    tagRequiredErrors.put(tag, Utils.chat(lore));
                }
                catch (IllegalArgumentException ignored) {
                    ValhallaMMO.logWarning("Invalid number tag in skills/smithing.yml: tag_error_required." + r + " is not a number");
                }
            }
        }
    }

    public static void reload() {
        qualityLore.clear();
        materialScalings.clear();
        SmithingItemPropertyManager.loadConfig();
    }

    public static Scaling getScaling(ItemMeta meta, String type) {
        MaterialClass match = MaterialClass.getMatchingClass(meta);
        if (match == null) {
            match = MaterialClass.OTHER;
        }
        return (Scaling)((Map)materialScalings.getOrDefault(type, new HashMap())).get((Object)match);
    }

    public static boolean hasTag(ItemMeta i, int treatment) {
        return SmithingItemPropertyManager.getTags(i).containsKey(treatment);
    }

    public static Map<Integer, Integer> getTags(ItemMeta i) {
        HashMap<Integer, Integer> tags = new HashMap<Integer, Integer>();
        String value = ItemUtils.getPDCString(NUMBER_TAGS, i, null);
        if (StringUtils.isEmpty(value)) {
            return tags;
        }
        for (String tag : value.split(",")) {
            String[] args = tag.split(":");
            Integer id = Catch.catchOrElse(() -> Integer.parseInt(args[0]), null);
            if (id == null) continue;
            Integer level = Catch.catchOrElse(() -> Integer.parseInt(args[1]), null);
            tags.put(id, level == null ? 1 : level);
        }
        return tags;
    }

    public static void addTag(ItemBuilder i, Integer tag, Integer level) {
        if (level <= 0) {
            SmithingItemPropertyManager.removeTag(i, tag);
        } else {
            Map<Integer, Integer> tags = SmithingItemPropertyManager.getTags(i.getMeta());
            tags.put(tag, level);
            SmithingItemPropertyManager.setTags(i, tags);
        }
    }

    public static void removeTag(ItemBuilder i, Integer tag) {
        Map<Integer, Integer> tags = SmithingItemPropertyManager.getTags(i.getMeta());
        tags.remove(tag);
        SmithingItemPropertyManager.setTags(i, tags);
    }

    public static void setTagLore(ItemBuilder builder) {
        if (builder == null) {
            return;
        }
        ArrayList currentLore = builder.getLore() != null ? builder.getLore() : new ArrayList();
        ArrayList<String> newLore = new ArrayList<String>();
        int tagIndex = -1;
        for (String l : currentLore) {
            boolean bl = false;
            String cleanLine = ChatColor.stripColor((String)Utils.chat(l));
            for (String tag : cleanTagLore.values()) {
                if (!cleanLine.contains(tag)) continue;
                bl = true;
                if (tagIndex >= 0) break;
                tagIndex = currentLore.indexOf(l);
                break;
            }
            if (bl) continue;
            newLore.add(l);
        }
        Map<Object, Object> tags = CustomFlag.hasFlag(builder.getMeta(), CustomFlag.HIDE_TAGS) ? new HashMap() : SmithingItemPropertyManager.getTags(builder.getMeta());
        tags.keySet().retainAll(tagLore.keySet());
        for (Integer n : tags.keySet()) {
            String lore = tagLore.get(n).replace("%lv_roman%", StringUtils.toRoman(Math.max(1, (Integer)tags.get(n)))).replace("%lv_normal%", String.valueOf(tags.get(n)));
            if (tagIndex <= 0) {
                newLore.add(lore);
                continue;
            }
            newLore.add(tagIndex, lore);
        }
        builder.lore(newLore);
    }

    public static String getTagLore(Integer i) {
        return tagLore.get(i);
    }

    public static Map<Integer, String> getTagForbiddenErrors() {
        return tagForbiddenErrors;
    }

    public static Map<Integer, String> getTagRequiredErrors() {
        return tagRequiredErrors;
    }

    public static void setQualityLore(ItemBuilder item) {
        if (item == null) {
            return;
        }
        List<Object> currentLore = item.getLore() == null ? new ArrayList() : item.getLore();
        ArrayList<String> newLore = new ArrayList<String>();
        int tagIndex = -1;
        for (String string : currentLore) {
            if (qualityLore.containsValue(string)) {
                if (tagIndex >= 0) continue;
                tagIndex = currentLore.indexOf(string);
                continue;
            }
            newLore.add(string);
        }
        String qualityLore = SmithingItemPropertyManager.getQualityLore(SmithingItemPropertyManager.getQuality(item.getMeta()), SmithingItemPropertyManager.getNeutralQuality(item.getMeta()));
        if (qualityLore == null || CustomFlag.hasFlag(item.getMeta(), CustomFlag.HIDE_QUALITY)) {
            return;
        }
        if (newLore.isEmpty() || tagIndex < 0) {
            newLore.add(qualityLore);
        } else {
            newLore.add(tagIndex, qualityLore);
        }
        item.lore(newLore);
    }

    public static String getQualityLore(int quality, int neutralQuality) {
        String lore = null;
        for (int q : qualityLore.keySet()) {
            if (q + neutralQuality > quality) continue;
            lore = qualityLore.get(q);
        }
        return lore;
    }

    public static int getQuality(ItemMeta meta) {
        return ItemUtils.getPDCInt(QUALITY_SMITHING, meta, 0);
    }

    public static int getNeutralQuality(ItemMeta meta) {
        return ItemUtils.getPDCInt(NEUTRAL_QUALITY, meta, 0);
    }

    public static int getCounter(ItemMeta meta) {
        return ItemUtils.getPDCInt(COUNTER, meta, 0);
    }

    public static boolean hasSmithingQuality(ItemMeta meta) {
        if (meta == null) {
            return false;
        }
        return meta.getPersistentDataContainer().has(QUALITY_SMITHING, PersistentDataType.INTEGER);
    }

    public static void setTags(ItemBuilder item, Map<Integer, Integer> tags) {
        if (item == null) {
            return;
        }
        if (tags == null || tags.isEmpty()) {
            item.getMeta().getPersistentDataContainer().remove(NUMBER_TAGS);
        } else {
            item.stringTag(NUMBER_TAGS, tags.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).map(e -> String.valueOf(e.getKey()) + ":" + String.valueOf(e.getValue())).collect(Collectors.joining(",")));
        }
        SmithingItemPropertyManager.setTagLore(item);
    }

    public static void setQuality(ItemBuilder item, Integer quality) {
        if (item == null) {
            return;
        }
        if (quality == null) {
            item.getMeta().getPersistentDataContainer().remove(QUALITY_SMITHING);
        } else {
            item.intTag(QUALITY_SMITHING, (int)Math.round(Utils.roundToMultiple(quality.intValue(), qualityRoundingPrecision)));
        }
        SmithingItemPropertyManager.setQualityLore(item);
    }

    public static void setNeutralQuality(ItemBuilder meta, Integer quality) {
        if (meta == null) {
            return;
        }
        if (quality == null) {
            meta.getMeta().getPersistentDataContainer().remove(NEUTRAL_QUALITY);
        } else {
            meta.intTag(NEUTRAL_QUALITY, quality);
        }
        if (!SmithingItemPropertyManager.hasSmithingQuality(meta.getMeta())) {
            return;
        }
        SmithingItemPropertyManager.setQualityLore(meta);
    }

    public static void setCounter(ItemMeta meta, Integer counter) {
        if (meta == null) {
            return;
        }
        if (counter == null) {
            meta.getPersistentDataContainer().remove(COUNTER);
        } else {
            meta.getPersistentDataContainer().set(COUNTER, PersistentDataType.INTEGER, (Object)counter);
        }
    }

    public static int getCounterLimit(ItemMeta meta) {
        return ItemUtils.getPDCInt(COUNTER_LIMIT, meta, 0);
    }

    public static void setCounterLimit(ItemMeta meta, Integer limit) {
        if (meta == null) {
            return;
        }
        if (limit == null) {
            meta.getPersistentDataContainer().remove(COUNTER_LIMIT);
        } else {
            meta.getPersistentDataContainer().set(COUNTER_LIMIT, PersistentDataType.INTEGER, (Object)limit);
        }
    }

    public static void applyAttributeScaling(ItemBuilder item, Scaling scaling, int quality, String attribute, double minimumFraction) {
        AttributeWrapper defaultAttribute;
        if (scaling == null) {
            return;
        }
        if (!ItemAttributesRegistry.hasCustomStats(item.getMeta())) {
            ItemAttributesRegistry.applyVanillaStats(item);
        }
        if ((defaultAttribute = ItemAttributesRegistry.getAttribute(item.getMeta(), attribute, true)) == null) {
            return;
        }
        defaultAttribute = defaultAttribute.copy();
        double defaultValue = defaultAttribute.getValue();
        double result = Utils.round6Decimals(scaling.evaluate(scaling.getExpression().replace("%rating%", String.valueOf(quality)), defaultValue));
        result = Math.max(minimumFraction * result, result);
        ItemAttributesRegistry.setStat(item, attribute, result, defaultAttribute.isHidden(), false);
    }
}

