/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.item.arrow_attributes.implementations;

import me.athlaeos.valhallammo.item.item_attributes.ArrowBehavior;
import me.athlaeos.valhallammo.particle.implementations.GenericParticle;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.utility.AnimationUtils;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;
import org.bukkit.projectiles.ProjectileSource;

public class VeryExplosiveArrow
extends ArrowBehavior {
    public VeryExplosiveArrow(String name) {
        super(name);
    }

    @Override
    public void onShoot(EntityShootBowEvent e, double ... args) {
        Entity entity = e.getProjectile();
        if (entity instanceof Projectile) {
            Projectile p = (Projectile)entity;
            AnimationUtils.trailProjectile(p, new GenericParticle(Particle.FLAME), 50);
        }
    }

    @Override
    public void onHit(ProjectileHitEvent e, double ... args) {
        if (args.length == 4) {
            float radius = (float)args[0];
            boolean destructive = (int)args[1] == 1;
            boolean fire = (int)args[2] == 1;
            int count = (int)args[3];
            Location hit = this.getHitLocation(e);
            for (int i = 0; i < count; ++i) {
                ProjectileSource projectileSource = e.getEntity().getShooter();
                if (projectileSource instanceof Entity) {
                    Entity s = (Entity)projectileSource;
                    double multiplier = AccumulativeStatManager.getCachedStats("EXPLOSION_RADIUS_MULTIPLIER", s, 10000L, true);
                    e.getEntity().getWorld().createExplosion(hit, radius *= (float)(1.0 + multiplier), fire, destructive, s);
                    continue;
                }
                e.getEntity().getWorld().createExplosion(hit, radius, fire, destructive, (Entity)e.getEntity());
            }
            e.getEntity().remove();
        }
    }

    @Override
    public void onLaunch(ProjectileLaunchEvent e, double ... args) {
    }

    @Override
    public void onDamage(EntityDamageByEntityEvent e, double ... args) {
    }

    @Override
    public void onPickup(PlayerPickupArrowEvent e, double ... args) {
    }
}

