/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.item.item_attributes;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_stats.DefaultAttributeAdd;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_stats.DefaultAttributeRemove;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_stats.DefaultAttributeScale;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.ItemStack;

public abstract class AttributeWrapper {
    private static final Map<String, Attribute> VANILLA_ATTRIBUTES = new HashMap<String, Attribute>();
    protected final String attribute;
    protected String convertTo = null;
    protected Double min = Double.NEGATIVE_INFINITY;
    protected Double max = Double.MAX_VALUE;
    protected double value;
    protected boolean isHidden = false;
    protected final StatFormat format;
    protected AttributeModifier.Operation operation;
    protected boolean isVanilla;
    protected Attribute vanillaAttribute;
    private Material icon = null;
    private double smallIncrement = 0.01;
    private double bigIncrement = 0.1;

    public AttributeWrapper(String attribute, StatFormat format) {
        this.attribute = attribute;
        this.format = format;
        this.value = 0.0;
        this.operation = AttributeModifier.Operation.ADD_NUMBER;
        this.vanillaAttribute = AttributeWrapper.getAttribute(attribute);
        this.isVanilla = this.vanillaAttribute != null;
    }

    public AttributeWrapper addModifier(Material icon, double smallIncrement, double bigIncrement) {
        this.icon = icon;
        this.smallIncrement = smallIncrement;
        this.bigIncrement = bigIncrement;
        ModifierRegistry.register(new DefaultAttributeAdd("attribute_add_" + this.attribute.toLowerCase(Locale.US), this.attribute, smallIncrement, bigIncrement, icon));
        ModifierRegistry.register(new DefaultAttributeRemove("attribute_remove_" + this.attribute.toLowerCase(Locale.US), this.attribute, icon));
        ModifierRegistry.register(new DefaultAttributeScale("attribute_scale_" + this.attribute.toLowerCase(Locale.US), this.attribute, icon));
        return this;
    }

    public AttributeWrapper addModifier(Material icon) {
        return this.addModifier(icon, 0.01, 0.1);
    }

    public AttributeWrapper convertTo(String newName) {
        this.convertTo = newName;
        if (newName == null) {
            return this;
        }
        try {
            this.vanillaAttribute = Attribute.valueOf((String)newName);
            this.isVanilla = true;
        }
        catch (IllegalArgumentException ignored) {
            this.vanillaAttribute = null;
            this.isVanilla = false;
        }
        return this;
    }

    public Material getIcon() {
        return this.icon;
    }

    public double getSmallIncrement() {
        return this.smallIncrement;
    }

    public double getBigIncrement() {
        return this.bigIncrement;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public String getConvertTo() {
        return this.convertTo;
    }

    public boolean isCompatible(ItemStack i) {
        return true;
    }

    public void onApply(ItemBuilder i) {
    }

    public void onRemove(ItemBuilder i) {
    }

    public Double getMin() {
        return this.min;
    }

    public Double getMax() {
        return this.max;
    }

    public AttributeWrapper min(Double min) {
        this.min = min;
        return this;
    }

    public AttributeWrapper max(Double max) {
        this.max = max;
        return this;
    }

    public double getValue() {
        double val = this.value;
        if (this.min != null) {
            val = Math.max(this.value, this.min);
        }
        if (this.max != null) {
            val = Math.min(this.value, this.max);
        }
        return val;
    }

    public AttributeModifier.Operation getOperation() {
        return this.operation;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public boolean isVanilla() {
        return this.isVanilla;
    }

    public Attribute getVanillaAttribute() {
        return this.vanillaAttribute;
    }

    public StatFormat getFormat() {
        return this.format;
    }

    public String getAttributeName() {
        return TranslationManager.getRawTranslation("attribute_" + this.attribute.toLowerCase(Locale.US));
    }

    public AttributeWrapper setValue(double value) {
        this.value = value;
        return this;
    }

    public AttributeWrapper setOperation(AttributeModifier.Operation operation) {
        this.operation = operation;
        return this;
    }

    public AttributeWrapper setHidden(boolean hidden) {
        this.isHidden = hidden;
        return this;
    }

    public String getLoreDisplay() {
        return null;
    }

    public String getAttributeIcon() {
        return TranslationManager.getTranslation("stat_icon_" + this.attribute.toLowerCase(Locale.US));
    }

    public abstract AttributeWrapper copy();

    private static Attribute getAttribute(String attribute) {
        if (VANILLA_ATTRIBUTES.containsKey(attribute)) {
            return VANILLA_ATTRIBUTES.get(attribute);
        }
        Attribute vanilla = null;
        try {
            vanilla = Attribute.valueOf((String)attribute);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        VANILLA_ATTRIBUTES.put(attribute, vanilla);
        return vanilla;
    }
}

