/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.listeners;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.item.EquipmentClass;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.utility.ItemUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ArmorSwitchListener
implements Listener {
    private static final Map<UUID, DelayedArmorUpdate> taskLimiters = new HashMap<UUID, DelayedArmorUpdate>();

    private void updateArmor(Player who) {
        DelayedArmorUpdate update = taskLimiters.get(who.getUniqueId());
        if (update != null) {
            update.refresh();
        } else {
            update = new DelayedArmorUpdate(who);
            update.runTaskTimer((Plugin)ValhallaMMO.getInstance(), 1L, 1L);
        }
        taskLimiters.put(who.getUniqueId(), update);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryEquip(InventoryClickEvent e) {
        if (e.getClickedInventory() == null) {
            return;
        }
        if (e.getClickedInventory().getType() == InventoryType.PLAYER || e.getClickedInventory().getType() == InventoryType.CREATIVE) {
            if (e.getSlotType() == InventoryType.SlotType.ARMOR) {
                if (ItemUtils.isEmpty(e.getCurrentItem()) && ItemUtils.isEmpty(e.getCursor())) {
                    return;
                }
                this.updateArmor((Player)e.getWhoClicked());
            } else if (e.getClick().isShiftClick() && !ItemUtils.isEmpty(e.getCurrentItem())) {
                ItemStack armor;
                ItemBuilder clicked = new ItemBuilder(e.getCurrentItem());
                EquipmentClass type = EquipmentClass.getMatchingClass(clicked.getMeta());
                if (type == null || !type.isArmor()) {
                    return;
                }
                switch (type) {
                    case HELMET: {
                        ItemStack itemStack = e.getWhoClicked().getInventory().getItem(EquipmentSlot.HEAD);
                        break;
                    }
                    case CHESTPLATE: {
                        ItemStack itemStack = e.getWhoClicked().getInventory().getItem(EquipmentSlot.CHEST);
                        break;
                    }
                    case LEGGINGS: {
                        ItemStack itemStack = e.getWhoClicked().getInventory().getItem(EquipmentSlot.LEGS);
                        break;
                    }
                    case BOOTS: {
                        ItemStack itemStack = e.getWhoClicked().getInventory().getItem(EquipmentSlot.FEET);
                        break;
                    }
                    default: {
                        ItemStack itemStack = armor = null;
                    }
                }
                if (ItemUtils.isEmpty(armor)) {
                    this.updateArmor((Player)e.getWhoClicked());
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDispenserEquip(BlockDispenseArmorEvent e) {
        LivingEntity livingEntity = e.getTargetEntity();
        if (livingEntity instanceof Player) {
            Player p = (Player)livingEntity;
            this.updateArmor(p);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onHandEquip(PlayerInteractEvent e) {
        if (e.useItemInHand() == Event.Result.DENY || ItemUtils.isEmpty(e.getItem()) || !e.getItem().getType().isItem()) {
            return;
        }
        ItemBuilder clicked = new ItemBuilder(e.getItem());
        EquipmentClass type = EquipmentClass.getMatchingClass(clicked.getMeta());
        if (!EquipmentClass.isArmor(type)) {
            return;
        }
        this.updateArmor(e.getPlayer());
    }

    private static class DelayedArmorUpdate
    extends BukkitRunnable {
        private static final int delay = 30;
        private int timer = 30;
        private final Player who;

        public DelayedArmorUpdate(Player who) {
            this.who = who;
        }

        public void run() {
            if (this.timer <= 0) {
                EntityCache.resetEquipment((LivingEntity)this.who);
                AccumulativeStatManager.uncache((Entity)this.who);
                taskLimiters.remove(this.who.getUniqueId());
                this.cancel();
            } else {
                --this.timer;
            }
        }

        public void refresh() {
            this.timer = 30;
        }
    }
}

