/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.listeners;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.CustomRecipeRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicBrewingRecipe;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.event.PlayerCustomBrewEvent;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.utility.BlockUtils;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.BrewingPreventionListener;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BrewingStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BrewingStandListener
implements Listener {
    private static final Map<Location, ActiveBrewingStand> activeStands = new HashMap<Location, ActiveBrewingStand>();
    private static final int fuel = 4;
    private static final int ingredient = 3;
    private static final Collection<Integer> potions = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2));
    private final Collection<InventoryAction> doNotInteractActions = Set.of(InventoryAction.DROP_ALL_CURSOR, InventoryAction.DROP_ALL_SLOT, InventoryAction.DROP_ONE_CURSOR, InventoryAction.DROP_ONE_SLOT, InventoryAction.PICKUP_ONE, InventoryAction.PICKUP_SOME, InventoryAction.PICKUP_ALL, InventoryAction.PICKUP_HALF);
    private static final Collection<UUID> automatedBrewingPlayers = new HashSet<UUID>();

    public BrewingStandListener() {
        if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20)) {
            ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)new BrewingPreventionListener(), (Plugin)ValhallaMMO.getInstance());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBrewingInventoryInteract(InventoryClickEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getWhoClicked().getWorld().getName()) || CustomRecipeRegistry.getBrewingRecipes().isEmpty()) {
            return;
        }
        Inventory inventory = e.getView().getTopInventory();
        if (inventory instanceof BrewerInventory) {
            BrewerInventory b = (BrewerInventory)inventory;
            Player p = (Player)e.getWhoClicked();
            e.setCancelled(true);
            if (this.doNotInteractActions.contains(e.getAction()) || e.getClick() == ClickType.DOUBLE_CLICK) {
                e.setCancelled(false);
            } else if (e.getClickedInventory() instanceof BrewerInventory) {
                if (potions.contains(e.getRawSlot())) {
                    ItemUtils.calculateClickEvent(e, 1, 0, 1, 2);
                } else {
                    ItemUtils.calculateClickEvent(e, 64, 3, 4);
                }
            } else {
                ItemStack clickedItem = e.getCurrentItem();
                if (!ItemUtils.isEmpty(clickedItem)) {
                    switch (clickedItem.getType()) {
                        case BLAZE_POWDER: {
                            ItemUtils.calculateClickEvent(e, 64, 4, 3);
                            break;
                        }
                        case GLASS_BOTTLE: 
                        case POTION: 
                        case LINGERING_POTION: 
                        case SPLASH_POTION: {
                            ItemUtils.calculateClickEvent(e, 1, 0, 1, 2);
                            break;
                        }
                        default: {
                            if (ItemUtils.isEmpty(b.getIngredient())) {
                                ItemUtils.calculateClickEvent(e, 64, 3);
                                break;
                            }
                            if (potions.stream().anyMatch(i -> ItemUtils.isEmpty(b.getItem(i.intValue())))) {
                                ItemUtils.calculateClickEvent(e, 1, 0, 1, 2);
                                break;
                            }
                            ItemUtils.calculateClickEvent(e, 64, 4);
                            break;
                        }
                    }
                } else {
                    ItemUtils.calculateClickEvent(e, 64, 3, 4);
                }
            }
            if (b.getLocation() != null) {
                BlockUtils.setOwner(b.getLocation().getBlock(), p.getUniqueId());
            }
            this.updateStand(b, p, false);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBrewingInventoryDrag(InventoryDragEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getWhoClicked().getWorld().getName()) || CustomRecipeRegistry.getBrewingRecipes().isEmpty()) {
            return;
        }
        Inventory inventory = e.getView().getTopInventory();
        if (inventory instanceof BrewerInventory) {
            BrewerInventory b = (BrewerInventory)inventory;
            Player p = (Player)e.getWhoClicked();
            ItemUtils.calculateDragEvent(e, 1, 0, 1, 2);
            if (b.getLocation() != null) {
                BlockUtils.setOwner(b.getLocation().getBlock(), p.getUniqueId());
            }
            this.updateStand(b, p, false);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onStandPlace(BlockPlaceEvent e) {
        if (e.getBlock().getType() != Material.BREWING_STAND || CustomRecipeRegistry.getBrewingRecipes().isEmpty()) {
            return;
        }
        BlockUtils.setOwner(e.getBlock(), e.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onBrewingInventoryHopperFeed(InventoryMoveItemEvent e) {
        if (e.getDestination().getLocation() == null || e.getDestination().getLocation().getWorld() == null || ValhallaMMO.isWorldBlacklisted(e.getDestination().getLocation().getWorld().getName()) || CustomRecipeRegistry.getBrewingRecipes().isEmpty()) {
            return;
        }
        Inventory inventory = e.getDestination();
        if (inventory instanceof BrewerInventory) {
            BrewerInventory b = (BrewerInventory)inventory;
            if (b.getLocation() == null) {
                e.setCancelled(true);
                return;
            }
            Player owner = BlockUtils.getOwner(b.getLocation().getBlock());
            this.updateStand(b, owner, true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBrew(BrewEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName()) || CustomRecipeRegistry.getBrewingRecipes().isEmpty()) {
            return;
        }
        e.setCancelled(true);
    }

    private void updateStand(BrewerInventory inventory, Player p, boolean automated) {
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
            ItemStack i = inventory.getItem(3);
            ActiveBrewingStand activeStand = activeStands.get(inventory.getLocation());
            if (ItemUtils.isEmpty(i)) {
                if (activeStand != null) {
                    activeStand.cancel();
                }
                activeStands.remove(inventory.getLocation());
                return;
            }
            Map<Integer, DynamicBrewingRecipe> recipes = this.getBrewingRecipes(inventory, p);
            BrewingStand brewingStand = inventory.getHolder();
            if (brewingStand == null) {
                return;
            }
            if (recipes.isEmpty() || activeStand != null && activeStand.visualProgress <= 0) {
                if (activeStand != null) {
                    activeStand.cancel();
                }
                brewingStand.setBrewingTime(0);
                brewingStand.update();
                activeStands.remove(inventory.getLocation());
                return;
            }
            if (activeStand != null) {
                activeStand.recipes = recipes;
            } else {
                brewingStand.setBrewingTime(400);
                double baseDuration = recipes.values().stream().map(DynamicBrewingRecipe::getBrewTime).mapToDouble(a -> a.intValue()).average().orElse(400.0);
                double speedMultiplier = 1.0 + (p == null ? 0.0 : AccumulativeStatManager.getCachedStats("BREWING_SPEED_BONUS", (Entity)p, 10000L, true));
                int duration = (int)(speedMultiplier <= 0.0 ? -1.0 : baseDuration / speedMultiplier);
                ActiveBrewingStand newStand = new ActiveBrewingStand(p, inventory, recipes, duration, automated);
                newStand.runTaskTimer((Plugin)ValhallaMMO.getInstance(), 0L, 1L);
                activeStands.put(brewingStand.getLocation(), newStand);
            }
        }, 1L);
    }

    public static void markAutomatedBrewing(Player player) {
        automatedBrewingPlayers.add(player.getUniqueId());
    }

    public static void unmarkAutomatedBrewing(Player player) {
        automatedBrewingPlayers.remove(player.getUniqueId());
    }

    public static boolean isMarkedAutomatedBrewing(Player player) {
        return automatedBrewingPlayers.contains(player.getUniqueId());
    }

    private Map<Integer, DynamicBrewingRecipe> getBrewingRecipes(BrewerInventory inventory, Player brewer) {
        DynamicBrewingRecipe r;
        PowerProfile p = brewer == null ? null : ProfileCache.getOrCache(brewer, PowerProfile.class);
        boolean allowedAllRecipes = brewer != null && brewer.hasPermission("valhalla.allrecipes");
        HashMap<Integer, DynamicBrewingRecipe> recipes = new HashMap<Integer, DynamicBrewingRecipe>();
        if (inventory.getLocation() != null && inventory.getLocation().getWorld() != null && ValhallaMMO.isWorldBlacklisted(inventory.getLocation().getWorld().getName())) {
            return recipes;
        }
        ItemStack ingredient = inventory.getIngredient();
        if (ItemUtils.isEmpty(ingredient)) {
            return recipes;
        }
        ingredient = ingredient.clone();
        ingredient.setAmount(1);
        Iterator iterator = ((Collection)CustomRecipeRegistry.getBrewingRecipesByIngredient().getOrDefault(ingredient.getType(), new HashSet())).iterator();
        while (iterator.hasNext() && this.validateAndInsertRecipe(r = (DynamicBrewingRecipe)iterator.next(), ingredient, brewer, p, allowedAllRecipes, inventory, recipes) != RecipeStatus.FINISHED) {
        }
        return recipes;
    }

    private RecipeStatus validateAndInsertRecipe(DynamicBrewingRecipe r, ItemStack ingredient, Player brewer, PowerProfile p, boolean allowedAllRecipes, BrewerInventory inventory, Map<Integer, DynamicBrewingRecipe> recipes) {
        if (brewer == null && r.getModifiers().stream().anyMatch(DynamicItemModifier::requiresPlayer)) {
            return RecipeStatus.SKIP;
        }
        if (!(p == null || allowedAllRecipes || r.isUnlockedForEveryone() || p.getUnlockedRecipes().contains(r.getName()) || brewer != null && brewer.hasPermission("valhalla.recipe." + r.getName()))) {
            return RecipeStatus.SKIP;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack slotItem;
            if (recipes.size() == 3) {
                return RecipeStatus.FINISHED;
            }
            if (recipes.containsKey(i) || ItemUtils.isEmpty(slotItem = inventory.getItem(i))) continue;
            slotItem = slotItem.clone();
            if (!r.getApplyOn().getOption().matches(r.getApplyOn().getItem(), slotItem) || !r.getIngredient().getOption().matches(r.getIngredient().getItem(), ingredient)) continue;
            ItemBuilder result = r.tinker() ? new ItemBuilder(slotItem) : new ItemBuilder(r.getResult());
            DynamicItemModifier.modify(ModifierContext.builder(result).items(ingredient).crafter(brewer).validate().get(), r.getModifiers());
            if (ItemUtils.isEmpty(result.getItem()) || CustomFlag.hasFlag(result.getMeta(), CustomFlag.UNCRAFTABLE)) continue;
            recipes.put(i, r);
        }
        return RecipeStatus.SKIP;
    }

    private static enum RecipeStatus {
        SKIP,
        FINISHED;

    }

    private static class ActiveBrewingStand
    extends BukkitRunnable {
        private final boolean disabled;
        private final boolean automated;
        private final Player p;
        private final BrewerInventory inventory;
        private Map<Integer, DynamicBrewingRecipe> recipes;
        private int visualProgress = 400;
        private double actualProgress = 400.0;
        private final double tickStep;

        public ActiveBrewingStand(Player p, BrewerInventory inventory, Map<Integer, DynamicBrewingRecipe> recipes, int duration, boolean automated) {
            this.p = p;
            this.inventory = inventory;
            this.recipes = recipes;
            this.disabled = duration < 0;
            this.tickStep = 400.0 / (double)duration;
            this.automated = automated;
        }

        public void run() {
            Location l = this.inventory.getLocation();
            BrewingStand stand = this.inventory.getHolder();
            boolean consumeFuel = false;
            if (l == null || l.getBlock().getType() != Material.BREWING_STAND || stand == null || ItemUtils.isEmpty(this.inventory.getIngredient())) {
                this.cancel();
                if (l != null) {
                    activeStands.remove(l);
                }
                return;
            }
            if (stand.getFuelLevel() <= 0) {
                if (!ItemUtils.isEmpty(this.inventory.getFuel()) && this.inventory.getFuel().getType() == Material.BLAZE_POWDER) {
                    stand.setFuelLevel(20);
                    consumeFuel = true;
                } else {
                    this.cancel();
                    activeStands.remove(l);
                    return;
                }
            }
            if (!activeStands.containsKey(l)) {
                this.cancel();
            }
            if ((double)this.visualProgress - this.tickStep > 0.0) {
                if (this.disabled || this.recipes.isEmpty()) {
                    this.visualProgress = 10;
                } else {
                    this.actualProgress -= this.tickStep;
                    this.visualProgress = Math.max(0, (int)this.actualProgress);
                }
                stand.setBrewingTime(this.visualProgress);
                stand.update();
                return;
            }
            stand.setFuelLevel(stand.getFuelLevel() - 1);
            if (stand.getFuelLevel() <= 0 && !ItemUtils.isEmpty(this.inventory.getFuel()) && this.inventory.getFuel().getType() == Material.BLAZE_POWDER) {
                stand.setFuelLevel(20);
                consumeFuel = true;
            }
            stand.setBrewingTime(0);
            stand.update();
            if (consumeFuel) {
                ItemStack powder = this.inventory.getFuel();
                if (powder.getAmount() <= 1) {
                    this.inventory.setItem(4, null);
                } else {
                    powder.setAmount(powder.getAmount() - 1);
                }
            }
            ItemStack[] results = new ItemStack[]{null, null, null};
            for (int slot = 0; slot < 3; ++slot) {
                DynamicBrewingRecipe recipe = this.recipes.get(slot);
                ItemStack slotItem = this.inventory.getItem(slot);
                if (ItemUtils.isEmpty(slotItem) || recipe == null) continue;
                if (this.automated) {
                    BrewingStandListener.markAutomatedBrewing(this.p);
                }
                ItemBuilder result = recipe.tinker() ? new ItemBuilder(slotItem) : new ItemBuilder(recipe.getResult());
                DynamicItemModifier.modify(ModifierContext.builder(result).items(this.inventory.getIngredient()).crafter(this.p).executeUsageMechanics().validate().get(), recipe.getModifiers());
                BrewingStandListener.unmarkAutomatedBrewing(this.p);
                PlayerCustomBrewEvent event = new PlayerCustomBrewEvent(this.p, recipe, result.get(), stand, ItemUtils.isEmpty(result.getItem()) && !CustomFlag.hasFlag(result.getMeta(), CustomFlag.UNCRAFTABLE));
                ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                results[slot] = event.getResult();
            }
            if (!(ItemUtils.isEmpty(results[0]) && ItemUtils.isEmpty(results[1]) && ItemUtils.isEmpty(results[2]))) {
                if (!ItemUtils.isEmpty(results[0])) {
                    this.inventory.setItem(0, results[0]);
                }
                if (!ItemUtils.isEmpty(results[1])) {
                    this.inventory.setItem(1, results[1]);
                }
                if (!ItemUtils.isEmpty(results[2])) {
                    this.inventory.setItem(2, results[2]);
                }
                ItemStack ingredient = this.inventory.getIngredient().clone();
                boolean saveIngredient = false;
                if (this.p != null) {
                    saveIngredient = Utils.proc((LivingEntity)this.p, AccumulativeStatManager.getCachedStats("BREWING_INGREDIENT_SAVE_CHANCE", (Entity)this.p, 10000L, true), false);
                }
                if (saveIngredient) {
                    ingredient.setAmount(1);
                    stand.getWorld().dropItem(stand.getLocation().add(0.5, 0.8, 0.5), ingredient);
                }
                if (this.inventory.getIngredient().getAmount() <= 1) {
                    if (!saveIngredient && ItemUtils.getSimilarMaterials(Material.WATER_BUCKET).contains(ingredient.getType())) {
                        this.inventory.setIngredient(new ItemStack(Material.BUCKET));
                    } else {
                        this.inventory.setIngredient(null);
                    }
                } else {
                    this.inventory.getIngredient().setAmount(this.inventory.getIngredient().getAmount() - 1);
                }
            }
            activeStands.remove(stand.getLocation());
            this.cancel();
        }
    }
}

