/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.listeners;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.block.BlockDigProcess;
import me.athlaeos.valhallammo.block.DigPacketInfo;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.event.PrepareBlockBreakEvent;
import me.athlaeos.valhallammo.utility.EntityUtils;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.version.AttributeMappings;
import me.athlaeos.valhallammo.version.PotionEffectMappings;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitRunnable;

public class CustomBreakSpeedListener
implements Listener {
    private static final boolean BLOCK_RECOVERY = ValhallaMMO.getPluginConfig().getBoolean("block_recovery", true);
    private static final int BLOCK_RECOVERY_DELAY = ValhallaMMO.getPluginConfig().getInt("block_recovery_delay", 60);
    private static final float BLOCK_RECOVERY_SPEED = (float)ValhallaMMO.getPluginConfig().getDouble("block_recovery_speed", (double)0.02f);
    private static final boolean VANILLA_BLOCK_BREAK_DELAY = ValhallaMMO.getPluginConfig().getBoolean("block_break_delay", true);
    private static boolean disabled = true;
    private static PotionEffect fatigueEffect;
    public static final UUID FATIGUE_MODIFIER_UUID;
    private static final Map<Location, BlockDigProcess> blockDigProcesses;
    private static final Map<Location, Collection<UUID>> totalMiningBlocks;
    private static final Map<UUID, Collection<Location>> miningPlayers;
    private static final Collection<Location> instantBlockBreaks;
    private static final Attribute BREAK_SPEED;

    public static boolean isBlockRecovery() {
        return BLOCK_RECOVERY;
    }

    public static int getBlockRecoveryDelay() {
        return BLOCK_RECOVERY_DELAY;
    }

    public static float getBlockRecoverySpeed() {
        return BLOCK_RECOVERY_SPEED;
    }

    public static boolean isVanillaBlockBreakDelay() {
        return VANILLA_BLOCK_BREAK_DELAY;
    }

    public CustomBreakSpeedListener() {
        disabled = false;
        fatigueEffect = new PotionEffect(PotionEffectMappings.MINING_FATIGUE.getPotionEffectType(), Integer.MAX_VALUE, -1, false, false, false);
        new BukkitRunnable(){

            public void run() {
                for (Location l : new HashSet<Location>(blockDigProcesses.keySet())) {
                    Block b = l.getBlock();
                    BlockDigProcess process = blockDigProcesses.getOrDefault(l, new BlockDigProcess(b));
                    if (totalMiningBlocks.containsKey(l)) {
                        for (UUID uuid : (Collection)new HashMap<Location, Collection<UUID>>(totalMiningBlocks).getOrDefault(l, new HashSet())) {
                            Player player = ValhallaMMO.getInstance().getServer().getPlayer(uuid);
                            if (player == null) continue;
                            float dmg = DigPacketInfo.damage(player, b);
                            process.damage(player, dmg);
                        }
                        continue;
                    }
                    if (BLOCK_RECOVERY) {
                        if (process.getTicksSinceUpdate() >= BLOCK_RECOVERY_DELAY) {
                            process.heal(BLOCK_RECOVERY_SPEED);
                            if (!(process.getHealth() >= 1.0f)) continue;
                            blockDigProcesses.remove(l);
                            continue;
                        }
                        process.incrementTicksSinceUpdate();
                        continue;
                    }
                    totalMiningBlocks.remove(l);
                    blockDigProcesses.remove(l);
                }
            }
        }.runTaskTimer((Plugin)ValhallaMMO.getInstance(), 1L, 1L);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onStart(BlockDamageEvent e) {
        if (!MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20_5) && ItemUtils.breaksInstantly(e.getBlock().getType()) || ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName())) {
            return;
        }
        e.setCancelled(true);
    }

    public static void onStart(DigPacketInfo info) {
        if (info == null || disabled || !MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20_5) && ItemUtils.breaksInstantly(info.getBlock().getType()) || info.getType() != DigPacketInfo.Type.START || ValhallaMMO.isWorldBlacklisted(info.getBlock().getWorld().getName())) {
            return;
        }
        Block b = info.getBlock();
        DigPacketInfo.resetBlockSpecificCache(info.getDigger().getUniqueId());
        float initialDamage = instantBlockBreaks.contains(b.getLocation()) ? 999.0f : DigPacketInfo.damage(info.getDigger(), b);
        PrepareBlockBreakEvent event = new PrepareBlockBreakEvent(b, info.getDigger());
        ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            initialDamage = 0.0f;
        }
        if (initialDamage >= 1.0f || ItemUtils.breaksInstantly(b.getType())) {
            BlockDigProcess.breakBlockInstantly(info.getDigger(), b);
            if (event.getAdditionalBlocks().isEmpty()) {
                return;
            }
        } else {
            BlockDigProcess process = blockDigProcesses.computeIfAbsent(b.getLocation(), k -> new BlockDigProcess(b));
            Collection playersMining = totalMiningBlocks.getOrDefault(b.getLocation(), new HashSet());
            playersMining.add(info.getDigger().getUniqueId());
            totalMiningBlocks.put(b.getLocation(), playersMining);
            process.damage(info.getDigger(), initialDamage);
        }
        for (Block block : event.getAdditionalBlocks()) {
            float damage;
            float f = damage = instantBlockBreaks.contains(b.getLocation()) ? 999.0f : DigPacketInfo.damage(info.getDigger(), b);
            if (damage >= 1.0f || ItemUtils.breaksInstantly(b.getType())) {
                BlockDigProcess.breakBlockInstantly(info.getDigger(), block);
                continue;
            }
            BlockDigProcess p = blockDigProcesses.computeIfAbsent(block.getLocation(), k -> new BlockDigProcess(block));
            Collection mP = totalMiningBlocks.getOrDefault(block.getLocation(), new HashSet());
            mP.add(info.getDigger().getUniqueId());
            totalMiningBlocks.put(block.getLocation(), mP);
            p.damage(info.getDigger(), damage * 1.01f);
        }
        event.getAdditionalBlocks().add(b);
        miningPlayers.put(info.getDigger().getUniqueId(), event.getAdditionalBlocks().stream().map(Block::getLocation).collect(Collectors.toSet()));
    }

    public static void onStop(DigPacketInfo info) {
        Player p = info.getDigger();
        if (!info.finished() || p == null || disabled || info.getType() == DigPacketInfo.Type.START || ValhallaMMO.isWorldBlacklisted(info.getBlock().getWorld().getName())) {
            return;
        }
        Collection playersMining = totalMiningBlocks.getOrDefault(info.getBlock().getLocation(), new HashSet());
        playersMining.remove(p.getUniqueId());
        if (playersMining.isEmpty()) {
            totalMiningBlocks.remove(info.getBlock().getLocation());
        } else {
            totalMiningBlocks.put(info.getBlock().getLocation(), playersMining);
        }
        for (Location b : (Collection)miningPlayers.getOrDefault(p.getUniqueId(), new HashSet())) {
            Collection miningPlayers = totalMiningBlocks.getOrDefault(b, new HashSet());
            miningPlayers.remove(p.getUniqueId());
            if (miningPlayers.isEmpty()) {
                totalMiningBlocks.remove(b);
                continue;
            }
            totalMiningBlocks.put(b, miningPlayers);
        }
        miningPlayers.remove(p.getUniqueId());
        if (!BLOCK_RECOVERY) {
            totalMiningBlocks.remove(info.getBlock().getLocation());
            blockDigProcesses.remove(info.getBlock().getLocation());
            BlockDigProcess.sendCracks(info.getBlock(), -1);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBreak(BlockBreakEvent e) {
        if (e.getPlayer().getGameMode() == GameMode.CREATIVE || ItemUtils.breaksInstantly(e.getBlock().getType()) || ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName())) {
            return;
        }
        if (!CustomBreakSpeedListener.isFatigued(e.getPlayer())) {
            e.setCancelled(true);
            CustomBreakSpeedListener.fatiguePlayer(e.getPlayer(), true);
            return;
        }
        BlockDigProcess process = blockDigProcesses.get(e.getBlock().getLocation());
        if (process != null) {
            totalMiningBlocks.remove(e.getBlock().getLocation());
            blockDigProcesses.remove(e.getBlock().getLocation());
            return;
        }
        if (instantBlockBreaks.remove(e.getBlock().getLocation())) {
            return;
        }
        if (!totalMiningBlocks.containsKey(e.getBlock().getLocation())) {
            return;
        }
        e.setCancelled(true);
    }

    public static void markInstantBreak(Block b) {
        if (disabled) {
            return;
        }
        instantBlockBreaks.add(b.getLocation());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerLeave(PlayerQuitEvent e) {
        CustomBreakSpeedListener.removeFatiguedPlayer(e.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName())) {
            return;
        }
        CustomBreakSpeedListener.fatiguePlayer(e.getPlayer(), true);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldChange(PlayerChangedWorldEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName())) {
            CustomBreakSpeedListener.removeFatiguedPlayer(e.getPlayer());
        } else {
            CustomBreakSpeedListener.fatiguePlayer(e.getPlayer(), true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerRespawn(PlayerRespawnEvent e) {
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
            CustomBreakSpeedListener.fatiguePlayer(e.getPlayer(), true);
            CustomBreakSpeedListener.fatiguePlayer(e.getPlayer(), true);
        }, 10L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPotionEffect(EntityPotionEffectEvent e) {
        Player p;
        block9: {
            block8: {
                Entity entity;
                if (e.getCause() == EntityPotionEffectEvent.Cause.PLUGIN || !((entity = e.getEntity()) instanceof Player)) break block8;
                p = (Player)entity;
                if (!MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20_5)) break block9;
            }
            return;
        }
        if (e.getOldEffect() != null && (e.getOldEffect().getType() == PotionEffectMappings.HASTE.getPotionEffectType() || e.getOldEffect().getType() == PotionEffectMappings.MINING_FATIGUE.getPotionEffectType())) {
            DigPacketInfo.resetMinerCache(e.getEntity().getUniqueId());
        }
        if (e.getNewEffect() != null && (e.getNewEffect().getType() == PotionEffectMappings.HASTE.getPotionEffectType() || e.getNewEffect().getType() == PotionEffectMappings.MINING_FATIGUE.getPotionEffectType())) {
            DigPacketInfo.resetMinerCache(e.getEntity().getUniqueId());
        }
        if ((e.getAction() == EntityPotionEffectEvent.Action.ADDED || e.getAction() == EntityPotionEffectEvent.Action.CHANGED) && e.getNewEffect() != null && e.getNewEffect().getType() == PotionEffectMappings.MINING_FATIGUE.getPotionEffectType() && e.getNewEffect().getAmplifier() >= 0) {
            e.setOverride(true);
        } else if (!(e.getAction() != EntityPotionEffectEvent.Action.REMOVED && e.getAction() != EntityPotionEffectEvent.Action.CLEARED || e.getOldEffect() == null || e.getOldEffect().getType() != PotionEffectMappings.MINING_FATIGUE.getPotionEffectType() || e.getOldEffect().getAmplifier() >= 0 && e.getOldEffect().getAmplifier() <= 4)) {
            ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> CustomBreakSpeedListener.fatiguePlayer(p, true), 2L);
        }
    }

    public static void fatiguePlayer(Player p, boolean force) {
        if (CustomBreakSpeedListener.isFatigued(p) && !force) {
            return;
        }
        if (BREAK_SPEED != null) {
            double miningSpeed = EntityUtils.getPlayerMiningSpeed(p);
            EntityUtils.addUniqueAttribute((LivingEntity)p, FATIGUE_MODIFIER_UUID, "valhalla_mining_speed_nullifier", BREAK_SPEED, -miningSpeed, AttributeModifier.Operation.ADD_NUMBER);
            EntityUtils.addUniqueAttribute((LivingEntity)p, FATIGUE_MODIFIER_UUID, "valhalla_mining_speed_nullifier", BREAK_SPEED, -miningSpeed, AttributeModifier.Operation.ADD_NUMBER);
        } else {
            p.addPotionEffect(fatigueEffect);
        }
    }

    public static void removeFatiguedPlayer(Player p) {
        if (BREAK_SPEED != null) {
            EntityUtils.removeUniqueAttribute((LivingEntity)p, "valhalla_mining_speed_nullifier", BREAK_SPEED);
        } else {
            PotionEffect effect = p.getPotionEffect(PotionEffectMappings.MINING_FATIGUE.getPotionEffectType());
            if (effect != null && effect.getAmplifier() >= 0 && effect.getAmplifier() < 5) {
                return;
            }
            p.removePotionEffect(PotionEffectMappings.MINING_FATIGUE.getPotionEffectType());
        }
    }

    public static boolean isFatigued(Player p) {
        if (BREAK_SPEED != null) {
            return EntityUtils.hasUniqueAttribute((LivingEntity)p, FATIGUE_MODIFIER_UUID, "valhalla_mining_speed_nullifier", BREAK_SPEED);
        }
        return p.hasPotionEffect(PotionEffectMappings.MINING_FATIGUE.getPotionEffectType());
    }

    public static Map<Location, BlockDigProcess> getBlockDigProcesses() {
        return blockDigProcesses;
    }

    public static Map<Location, Collection<UUID>> getTotalMiningBlocks() {
        return totalMiningBlocks;
    }

    public static Map<UUID, Collection<Location>> getMiningPlayers() {
        return miningPlayers;
    }

    static {
        FATIGUE_MODIFIER_UUID = UUID.fromString("40e606a7-8401-4f13-a539-7dfcd0c3c8a2");
        blockDigProcesses = new ConcurrentHashMap<Location, BlockDigProcess>();
        totalMiningBlocks = new ConcurrentHashMap<Location, Collection<UUID>>();
        miningPlayers = new ConcurrentHashMap<UUID, Collection<Location>>();
        instantBlockBreaks = ConcurrentHashMap.newKeySet();
        BREAK_SPEED = AttributeMappings.BLOCK_BREAK_SPEED.getAttribute();
    }
}

