/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.listeners;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.dom.CustomDamageType;
import me.athlaeos.valhallammo.entities.EntityClassification;
import me.athlaeos.valhallammo.entities.damageindicators.DamageIndicatorRegistry;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.potioneffects.EffectResponsibility;
import me.athlaeos.valhallammo.utility.EntityUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Timer;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

public class EntityDamagedListener
implements Listener {
    private static final boolean customDamageEnabled = ValhallaMMO.getPluginConfig().getBoolean("custom_damage_system", true);
    private static final Collection<String> entityDamageCauses = new HashSet<String>(Set.of("CUSTOM", "THORNS", "ENTITY_ATTACK", "ENTITY_SWEEP_ATTACK", "PROJECTILE", "ENTITY_EXPLOSION", "SONIC_BOOM"));
    private static final Collection<String> trueDamage = new HashSet<String>(Set.of("VOID", "SONIC_BOOM", "STARVATION", "DROWNING", "SUICIDE", "WORLD_BORDER", "KILL", "GENERIC_KILL"));
    private static final Map<UUID, String> customDamageCauses = new HashMap<UUID, String>();
    private static final Map<UUID, UUID> lastDamagedByMap = new HashMap<UUID, UUID>();
    private static final Map<UUID, Double> lastDamageTakenMap = new HashMap<UUID, Double>();
    private static final Map<String, Double> physicalDamageTypes = new HashMap<String, Double>();
    private static final Map<UUID, Collection<String>> noImmunityNextDamage = new HashMap<UUID, Collection<String>>();
    private static final Map<UUID, Map<String, Double>> preparedDamageInstances = new HashMap<UUID, Map<String, Double>>();
    private final boolean pvpOneShotProtection;
    private final boolean pveOneShotProtection;
    private final boolean environmentalOneShotProtection;
    private final double oneShotProtectionCap;
    private final Sound oneShotProtectionSound;
    private final Map<UUID, Double> healthTracker = new HashMap<UUID, Double>();
    private final Map<UUID, Double> absorptionTracker = new HashMap<UUID, Double>();
    private static final Map<UUID, Runnable> damageProcesses = new HashMap<UUID, Runnable>();

    public EntityDamagedListener() {
        YamlConfiguration c = ValhallaMMO.getPluginConfig();
        for (String type : c.getStringList("armor_effective_types")) {
            String[] args = type.split(":");
            physicalDamageTypes.put(args[0], args.length > 1 ? Catch.catchOrElse(() -> StringUtils.parseDouble(args[1]), 1.0) : Double.valueOf(1.0));
        }
        this.pvpOneShotProtection = c.getBoolean("oneshot_protection_players");
        this.pveOneShotProtection = c.getBoolean("oneshot_protection_mobs");
        this.environmentalOneShotProtection = c.getBoolean("oneshot_protection_environment");
        this.oneShotProtectionCap = c.getDouble("oneshot_protection_limit");
        this.oneShotProtectionSound = Utils.getSound(c.getString("oneshot_protection_sound"), Sound.ITEM_TOTEM_USE, null);
    }

    public static Map<String, Double> getPhysicalDamageTypes() {
        return physicalDamageTypes;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onDamageRecord(EntityDamageEvent e) {
        if (e instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent eve = (EntityDamageByEntityEvent)e;
            EntityDamagedListener.setDamager(e.getEntity(), eve.getDamager());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onDamageFirst(EntityDamageEvent e) {
        EntityDamagedListener.setCustomDamageCause(e.getEntity().getUniqueId(), e.getCause().toString());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDamageTaken(EntityDamageEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || !customDamageEnabled) {
            return;
        }
        Entity entity = e.getEntity();
        if (entity instanceof LivingEntity) {
            AttributeInstance healthAttribute;
            double oneShotProtectionFraction;
            Player p;
            boolean applyImmunity;
            double damageAfterImmunity;
            LivingEntity l = (LivingEntity)entity;
            String damageCause = EntityDamagedListener.getLastDamageCause(l);
            CustomDamageType type = CustomDamageType.getCustomType(damageCause);
            Entity lastDamager = EntityDamagedListener.lastDamager(e);
            if (type != null) {
                e.setDamage(e.getDamage() * (1.0 + EffectResponsibility.getResponsibleDamageBuff(e.getEntity(), lastDamager, type)));
            }
            double originalDamage = e.getDamage();
            double customDamage = type == null || type.isFatal() ? EntityDamagedListener.calculateCustomDamage(e) : Math.min(l.getHealth() - 1.0, EntityDamagedListener.calculateCustomDamage(e));
            Entity entity2 = e.getEntity();
            if (entity2 instanceof Player) {
                Player dP = (Player)entity2;
                if (lastDamager instanceof Player) {
                    Player aP = (Player)lastDamager;
                    double bonus = AccumulativeStatManager.getCachedAttackerRelationalStats("PLAYER_DAMAGE_DEALT", (Entity)dP, (Entity)aP, 10000L, true);
                    customDamage *= 1.0 + bonus;
                    double resistance = AccumulativeStatManager.getCachedRelationalStats("PVP_RESISTANCE", (Entity)dP, (Entity)aP, 10000L, true);
                    customDamage *= 1.0 - resistance;
                }
            }
            if (!Timer.isCooldownPassed(l.getUniqueId(), "duration_oneshot_protection")) {
                customDamage = 0.0;
            }
            if ((damageAfterImmunity = this.overrideImmunityFrames(customDamage, l)) < 0.0 && e.getEntityType() != EntityType.ARMOR_STAND) {
                e.setCancelled(true);
                return;
            }
            lastDamageTakenMap.put(l.getUniqueId(), customDamage);
            boolean bl = applyImmunity = l.getHealth() + l.getAbsorptionAmount() - customDamage > 0.0;
            if (DamageIndicatorRegistry.sendDamageIndicator(l, type, customDamage, customDamage - originalDamage)) {
                customDamage = 0.0;
                e.setDamage(0.0);
                applyImmunity = true;
            }
            if (e instanceof EntityDamageByEntityEvent && e.getFinalDamage() <= 1.0E-6 && l instanceof Player && (p = (Player)l).isBlocking()) {
                return;
            }
            if (((lastDamager == null || EntityClassification.matchesClassification(lastDamager.getType(), EntityClassification.UNALIVE)) && this.environmentalOneShotProtection || this.pvpOneShotProtection && lastDamager instanceof Player || this.pveOneShotProtection && lastDamager != null && !EntityClassification.matchesClassification(lastDamager.getType(), EntityClassification.UNALIVE)) && (oneShotProtectionFraction = AccumulativeStatManager.getCachedRelationalStats("ONESHOT_PROTECTION_FRACTION", (Entity)l, lastDamager, 10000L, true)) > 0.0 && (healthAttribute = l.getAttribute(Attribute.GENERIC_MAX_HEALTH)) != null) {
                double maxHealth = healthAttribute.getValue();
                double damageUntilOSP = maxHealth * (1.0 - oneShotProtectionFraction);
                if (maxHealth * this.oneShotProtectionCap >= customDamage && customDamage > damageUntilOSP && l.getHealth() > damageUntilOSP) {
                    customDamage = damageUntilOSP;
                    applyImmunity = true;
                    Timer.setCooldown(l.getUniqueId(), 500, "duration_oneshot_protection");
                    if (l instanceof Player) {
                        Player p2 = (Player)l;
                        PowerProfile profile = ProfileCache.getOrCache(p2, PowerProfile.class);
                        Timer.setCooldownIgnoreIfPermission((Entity)p2, profile.getOneShotProtectionCooldown() * 50, "cooldown_oneshot_protection");
                        Timer.sendCooldownStatus(p2, "cooldown_oneshot_protection", TranslationManager.getTranslation("ability_oneshot_protection"));
                        p2.playSound((Entity)p2, this.oneShotProtectionSound, 1.0f, 1.0f);
                    }
                }
            }
            double damage = customDamage;
            if (applyImmunity) {
                double iFrameMultiplier = 1.0 + AccumulativeStatManager.getCachedRelationalStats("IMMUNITY_FRAME_MULTIPLIER", (Entity)l, lastDamager, 10000L, true);
                int iFrameBonus = (int)AccumulativeStatManager.getCachedRelationalStats("IMMUNITY_FRAME_BONUS", (Entity)l, lastDamager, 10000L, true);
                int iFrames = EntityDamagedListener.isMarkedNoImmunityOnNextDamageInstance((Entity)l, damageCause) ? 0 : (int)Math.max(0.0, iFrameMultiplier * (double)Math.max(0, 10 + iFrameBonus));
                EntityDamagedListener.unmarkNextDamageInstanceNoImmunity((Entity)l, damageCause);
                double predictedAbsorption = this.absorptionTracker.getOrDefault(l.getUniqueId(), l.getAbsorptionAmount()) - damage;
                double predictedHealth = this.healthTracker.getOrDefault(l.getUniqueId(), l.getHealth()) - (predictedAbsorption >= 0.0 ? 0.0 : -predictedAbsorption);
                if (predictedAbsorption > 0.0) {
                    this.absorptionTracker.put(l.getUniqueId(), predictedAbsorption);
                }
                this.healthTracker.put(l.getUniqueId(), predictedHealth);
                if (l instanceof Player && type != null && type.isImmuneable() && customDamage <= 0.0) {
                    e.setCancelled(true);
                }
                if (l.getHealth() - e.getFinalDamage() <= 0.0) {
                    e.setDamage(0.0);
                }
                double healthBefore = l.getHealth();
                damageProcesses.put(l.getUniqueId(), () -> {
                    double maxHealth;
                    l.setNoDamageTicks(iFrames);
                    AttributeInstance health = l.getAttribute(Attribute.GENERIC_MAX_HEALTH);
                    double d = maxHealth = health != null ? health.getValue() : -1.0;
                    if (l.getHealth() > 0.0) {
                        l.setAbsorptionAmount(Math.max(0.0, predictedAbsorption));
                        l.setHealth(Math.max(damageCause.equals("POISON") ? 1.0 : 0.0, Math.min(maxHealth, predictedHealth)));
                    }
                    customDamageCauses.remove(l.getUniqueId());
                    this.healthTracker.remove(l.getUniqueId());
                    this.absorptionTracker.remove(l.getUniqueId());
                    damageProcesses.remove(l.getUniqueId());
                });
                ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
                    Runnable r = damageProcesses.get(l.getUniqueId());
                    if (r != null) {
                        r.run();
                    }
                }, 1L);
            }
        }
    }

    private static Entity lastDamager(EntityDamageEvent e) {
        UUID uUID;
        if (e instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent eve = (EntityDamageByEntityEvent)e;
            uUID = EntityUtils.getTrueDamager(eve).getUniqueId();
        } else {
            uUID = lastDamagedByMap.get(e.getEntity().getUniqueId());
        }
        UUID lastDamagerUUID = uUID;
        return lastDamagerUUID == null ? null : ValhallaMMO.getInstance().getServer().getEntity(lastDamagerUUID);
    }

    public static double calculateCustomDamage(EntityDamageEvent e) {
        LivingEntity l;
        Entity entity;
        String damageCause = customDamageCauses.getOrDefault(e.getEntity().getUniqueId(), e.getCause().toString());
        Entity lastDamager = EntityDamagedListener.lastDamager(e);
        CustomDamageType customDamageType = CustomDamageType.getCustomType(damageCause);
        if (customDamageType != null) {
            double elementalMultiplier = customDamageType.damageMultiplier() == null ? 0.0 : AccumulativeStatManager.getCachedAttackerRelationalStats(customDamageType.damageMultiplier(), e.getEntity(), lastDamager, 10000L, true);
            e.setDamage(e.getDamage() * (1.0 + elementalMultiplier));
            Entity entity2 = e.getEntity();
            if (entity2 instanceof LivingEntity) {
                LivingEntity l2 = (LivingEntity)entity2;
                double resistance = customDamageType.resistance() == null ? 0.0 : AccumulativeStatManager.getCachedRelationalStats(customDamageType.resistance(), (Entity)l2, lastDamager, 10000L, true);
                e.setDamage(Math.max(0.0, e.getDamage() * (1.0 - resistance)));
            }
        }
        if ((entity = e.getEntity()) instanceof LivingEntity) {
            l = (LivingEntity)entity;
            if (!trueDamage.contains(damageCause)) {
                double generalResistance = AccumulativeStatManager.getCachedRelationalStats("DAMAGE_RESISTANCE", (Entity)l, lastDamager, 10000L, true);
                e.setDamage(Math.max(0.0, e.getDamage() * (1.0 - generalResistance)));
            }
        } else {
            return e.getDamage();
        }
        double resistedDamage = e.getDamage();
        YamlConfiguration c = ValhallaMMO.getPluginConfig();
        if (physicalDamageTypes.containsKey(damageCause)) {
            double armorEffectiveness = physicalDamageTypes.get(damageCause);
            double totalArmor = AccumulativeStatManager.getCachedRelationalStats("ARMOR_TOTAL", e.getEntity(), lastDamager, 10000L, true);
            double toughness = Math.max(0.0, AccumulativeStatManager.getCachedRelationalStats("TOUGHNESS", e.getEntity(), lastDamager, 2000L, true));
            if (totalArmor < 0.0) {
                double negativeArmorDamageDebuff = c.getDouble("negative_armor_damage_buff");
                resistedDamage *= 1.0 + -totalArmor * negativeArmorDamageDebuff;
                totalArmor = 0.0;
            } else {
                totalArmor *= armorEffectiveness;
                toughness *= armorEffectiveness;
            }
            String scaling = c.getString("damage_formula_physical", "%damage% * (15 / (15 + %armor%)) - (%toughness% * 0.15)");
            boolean mode = c.getString("damage_formula_mode", "SET").equalsIgnoreCase("set");
            double minimumFraction = c.getDouble("damage_reduction_cap");
            double damageAbsorption = AccumulativeStatManager.getCachedRelationalStats("DAMAGE_ABSORPTION", (Entity)l, lastDamager, 10000L, true);
            double damageResult = Utils.eval(scaling.replace("%damage%", String.format("%.4f", resistedDamage)).replace("%armor%", String.format("%.4f", totalArmor)).replace("%toughness%", String.format("%.4f", toughness)).replace("%absorption%", String.format("%.4f", damageAbsorption)));
            if (mode) {
                return Math.max(damageResult - damageAbsorption, minimumFraction * resistedDamage);
            }
            return resistedDamage * Math.max(minimumFraction, damageResult);
        }
        return resistedDamage;
    }

    private double overrideImmunityFrames(double customDamage, LivingEntity l) {
        if (l.getNoDamageTicks() > 0) {
            EntityDamageEvent previousEvent = l.getLastDamageCause();
            double lastDamage = lastDamageTakenMap.getOrDefault(l.getUniqueId(), previousEvent == null ? 0.0 : previousEvent.getDamage());
            if (customDamage > lastDamage) {
                return customDamage - lastDamage;
            }
            return -1.0;
        }
        return customDamage;
    }

    public static double getLastDamageTaken(UUID entity) {
        return lastDamageTakenMap.getOrDefault(entity, 0.0);
    }

    public static double getLastDamageTaken(UUID entity, double def) {
        return lastDamageTakenMap.getOrDefault(entity, def);
    }

    public static void setDamager(Entity attacked, Entity attacker) {
        lastDamagedByMap.put(attacked.getUniqueId(), attacker.getUniqueId());
    }

    public static void setCustomDamageCause(UUID uuid, String customCause) {
        customDamageCauses.put(uuid, customCause);
    }

    public static String getLastDamageCause(LivingEntity e) {
        return Utils.thisorDefault(EntityUtils.getCustomDamageType((Entity)e), customDamageCauses.getOrDefault(e.getUniqueId(), e.getLastDamageCause() == null ? null : e.getLastDamageCause().getCause().toString()));
    }

    public static Entity getLastDamager(LivingEntity e) {
        Entity entity;
        UUID lastDamagerUUID = lastDamagedByMap.get(e.getUniqueId());
        if (lastDamagerUUID == null) {
            EntityDamageEvent entityDamageEvent = e.getLastDamageCause();
            if (entityDamageEvent instanceof EntityDamageByEntityEvent) {
                EntityDamageByEntityEvent d = (EntityDamageByEntityEvent)entityDamageEvent;
                entity = d.getDamager();
            } else {
                entity = null;
            }
        } else {
            entity = ValhallaMMO.getInstance().getServer().getEntity(lastDamagerUUID);
        }
        return entity;
    }

    public static Collection<String> getEntityDamageCauses() {
        return entityDamageCauses;
    }

    public static void markNextDamageInstanceNoImmunity(Entity entity, String toDamageType) {
        Collection damageTypes = noImmunityNextDamage.getOrDefault(entity.getUniqueId(), new HashSet());
        damageTypes.add(toDamageType);
        noImmunityNextDamage.put(entity.getUniqueId(), damageTypes);
    }

    public static void unmarkNextDamageInstanceNoImmunity(Entity entity, String toDamageType) {
        Collection damageTypes = noImmunityNextDamage.getOrDefault(entity.getUniqueId(), new HashSet());
        damageTypes.remove(toDamageType);
        if (damageTypes.isEmpty()) {
            noImmunityNextDamage.remove(entity.getUniqueId());
        } else {
            noImmunityNextDamage.put(entity.getUniqueId(), damageTypes);
        }
    }

    public static Collection<String> getNoImmunityToNextDamageInstances(Entity entity) {
        return noImmunityNextDamage.getOrDefault(entity.getUniqueId(), new HashSet());
    }

    public static boolean isMarkedNoImmunityOnNextDamageInstance(Entity entity, String toDamageType) {
        return ((Collection)noImmunityNextDamage.getOrDefault(entity.getUniqueId(), new HashSet())).contains(toDamageType);
    }

    public static void prepareDamageInstance(Entity against, String type, double amount) {
        Map preparedInstances = preparedDamageInstances.getOrDefault(against.getUniqueId(), new HashMap());
        preparedInstances.put(type, amount);
        preparedDamageInstances.put(against.getUniqueId(), preparedInstances);
    }

    public static void removeDamageInstance(Entity against, String type) {
        Map preparedInstances = preparedDamageInstances.getOrDefault(against.getUniqueId(), new HashMap());
        preparedInstances.remove(type);
        if (preparedInstances.isEmpty()) {
            preparedDamageInstances.remove(against.getUniqueId());
        } else {
            preparedDamageInstances.put(against.getUniqueId(), preparedInstances);
        }
    }

    public static double getPreparedInstance(Entity against, String type) {
        return ((Map)preparedDamageInstances.getOrDefault(against.getUniqueId(), new HashMap())).getOrDefault(type, 0.0);
    }

    public static Map<String, Double> getPreparedInstances(Entity against) {
        return preparedDamageInstances.getOrDefault(against.getUniqueId(), new HashMap());
    }
}

