/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.listeners;

import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.block.BlockInteractConversions;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.item.WeightClass;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.playerstats.EntityProperties;
import me.athlaeos.valhallammo.utility.Parryer;
import me.athlaeos.valhallammo.utility.Timer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;

public class InteractListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onRightClickWeaponAction(PlayerInteractEvent e) {
        if (e.useItemInHand() == Event.Result.DENY || ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName())) {
            return;
        }
        if (e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK) {
            boolean dualWielding;
            EntityProperties properties = EntityCache.getAndCacheProperties((LivingEntity)e.getPlayer());
            boolean bl = dualWielding = properties.getMainHand() != null && properties.getOffHand() != null && WeightClass.getWeightClass(properties.getMainHand().getMeta()) != WeightClass.WEIGHTLESS && WeightClass.getWeightClass(properties.getOffHand().getMeta()) != WeightClass.WEIGHTLESS;
            if (!dualWielding) {
                if (e.getHand() == EquipmentSlot.OFF_HAND || (double)e.getPlayer().getAttackCooldown() < 0.9) {
                    return;
                }
                Parryer.attemptParry((LivingEntity)e.getPlayer());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockConvert(PlayerInteractEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName()) || e.useItemInHand() == Event.Result.DENY || e.getAction() != Action.RIGHT_CLICK_BLOCK || e.getClickedBlock() == null || !Timer.isCooldownPassed(e.getPlayer().getUniqueId(), "cooldown_block_conversions") || WorldGuardHook.inDisabledRegion(e.getPlayer().getLocation(), e.getPlayer(), "vmmo-abilities-blockconversions")) {
            return;
        }
        if (BlockInteractConversions.trigger(e.getPlayer(), e.getClickedBlock())) {
            e.setCancelled(true);
        }
        Timer.setCooldown(e.getPlayer().getUniqueId(), 250, "cooldown_block_conversions");
    }
}

