/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.listeners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.block.BlockDestructionInfo;
import me.athlaeos.valhallammo.block.BlockExplodeBlockDestructionInfo;
import me.athlaeos.valhallammo.block.EntityExplodeBlockDestructionInfo;
import me.athlaeos.valhallammo.block.GenericBlockDestructionInfo;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.entities.EntityClassification;
import me.athlaeos.valhallammo.entities.MonsterScalingManager;
import me.athlaeos.valhallammo.event.BlockDestructionEvent;
import me.athlaeos.valhallammo.event.ValhallaLootPopulateEvent;
import me.athlaeos.valhallammo.event.ValhallaLootReplacementEvent;
import me.athlaeos.valhallammo.gui.PlayerMenuUtilManager;
import me.athlaeos.valhallammo.gui.implementations.LootFreeSelectionMenu;
import me.athlaeos.valhallammo.hooks.LootinHook;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.loot.LootEntry;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.loot.LootTableRegistry;
import me.athlaeos.valhallammo.loot.ReplacementTable;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.utility.BlockUtils;
import me.athlaeos.valhallammo.utility.EntityUtils;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Timer;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.ArchaeologyListener;
import me.athlaeos.valhallammo.version.EnchantmentMappings;
import me.athlaeos.valhallammo.version.PaperLootRefillHandler;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.PiglinBarterEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTable;
import org.bukkit.loot.LootTables;
import org.bukkit.loot.Lootable;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class LootListener
implements Listener {
    private static final Map<Location, List<ItemStack>> preparedBlockDrops = new HashMap<Location, List<ItemStack>>();
    private static final Map<Location, Double> preparedLuckBuffs = new HashMap<Location, Double>();
    private static final Map<Location, UUID> transferToInventory = new HashMap<Location, UUID>();
    private static final Map<UUID, Double> preparedFishingLuckBuffs = new HashMap<UUID, Double>();
    private static final Map<Location, UUID> blockBreakerMap = new HashMap<Location, UUID>();
    private static final Map<Location, Material> explodedBlocks = new HashMap<Location, Material>();
    private static final Collection<Block> exploded = new HashSet<Block>();
    private final Map<Location, Boolean> chestCache = new HashMap<Location, Boolean>();
    private final Collection<Material> itemDuplicationWhitelist = new HashSet<Material>(ItemUtils.getMaterialSet(ValhallaMMO.getPluginConfig().getStringList("item_duplication_whitelist")));
    private static final Map<UUID, UUID> realKiller = new HashMap<UUID, UUID>();
    private static final Map<UUID, List<ItemStack>> preparedFishingDrops = new HashMap<UUID, List<ItemStack>>();

    public LootListener() {
        if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20)) {
            ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)new ArchaeologyListener(), (Plugin)ValhallaMMO.getInstance());
        }
    }

    public static void setResponsibleBreaker(Block block, Player breaker) {
        blockBreakerMap.put(block.getLocation(), breaker.getUniqueId());
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockPlayerBreak(BlockBreakEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName()) || e.getPlayer().getGameMode() == GameMode.CREATIVE) {
            return;
        }
        Player p = e.getPlayer();
        Pair<Double, Integer> details = this.getFortuneAndLuck(p, e.getBlock());
        int fortune = details.getTwo();
        double luck = details.getOne();
        if (this.onBlockDestruction(e.getBlock(), new LootContext.Builder(e.getBlock().getLocation()).lootedEntity((Entity)p).killer(null).lootingModifier(fortune).luck((float)luck).build(), new GenericBlockDestructionInfo(e.getBlock(), (Cancellable)e), BlockDestructionEvent.BlockDestructionReason.PLAYER_BREAK)) {
            e.setDropItems(false);
        }
        LootListener.clear(e.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlayerBreakFinal(BlockBreakEvent e) {
        if (ArchaeologyListener.isBrushable(e.getBlock().getType())) {
            preparedBlockDrops.remove(e.getBlock().getLocation());
            return;
        }
        for (ItemStack i : (List)preparedBlockDrops.getOrDefault(e.getBlock().getLocation(), new ArrayList())) {
            if (transferToInventory.containsKey(e.getBlock().getLocation()) && transferToInventory.get(e.getBlock().getLocation()).equals(e.getPlayer().getUniqueId())) {
                ItemUtils.addItem(e.getPlayer(), i, false);
                continue;
            }
            e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), i);
        }
        preparedBlockDrops.remove(e.getBlock().getLocation());
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockHarvest(PlayerHarvestBlockEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getHarvestedBlock().getWorld().getName())) {
            return;
        }
        Player p = e.getPlayer();
        Pair<Double, Integer> details = this.getFortuneAndLuck(p, e.getHarvestedBlock());
        int fortune = details.getTwo();
        double luck = details.getOne();
        if (this.onBlockDestruction(e.getHarvestedBlock(), new LootContext.Builder(e.getHarvestedBlock().getLocation()).lootedEntity((Entity)p).killer(null).lootingModifier(fortune).luck((float)luck).build(), new GenericBlockDestructionInfo(e.getHarvestedBlock(), (Cancellable)e), BlockDestructionEvent.BlockDestructionReason.PLAYER_HARVEST)) {
            e.getItemsHarvested().clear();
        }
        LootListener.clear(e.getHarvestedBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockHarvestFinal(PlayerHarvestBlockEvent e) {
        if (ArchaeologyListener.isBrushable(e.getHarvestedBlock().getType())) {
            preparedBlockDrops.remove(e.getHarvestedBlock().getLocation());
            return;
        }
        List drops = preparedBlockDrops.getOrDefault(e.getHarvestedBlock().getLocation(), new ArrayList());
        drops.addAll(e.getItemsHarvested());
        e.getItemsHarvested().clear();
        for (ItemStack i : drops) {
            if (transferToInventory.containsKey(e.getHarvestedBlock().getLocation()) && transferToInventory.get(e.getHarvestedBlock().getLocation()).equals(e.getPlayer().getUniqueId())) {
                ItemUtils.addItem(e.getPlayer(), i, false);
                continue;
            }
            e.getHarvestedBlock().getWorld().dropItemNaturally(e.getHarvestedBlock().getLocation(), i);
        }
        preparedBlockDrops.remove(e.getHarvestedBlock().getLocation());
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockBurnBreak(BlockBurnEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName())) {
            return;
        }
        UUID uuid = blockBreakerMap.get(e.getBlock().getLocation());
        blockBreakerMap.remove(e.getBlock().getLocation());
        Player p = uuid == null ? null : ValhallaMMO.getInstance().getServer().getPlayer(uuid);
        Pair<Double, Integer> details = this.getFortuneAndLuck(p, e.getBlock());
        int fortune = details.getTwo();
        double luck = details.getOne();
        this.onBlockDestruction(e.getBlock(), new LootContext.Builder(e.getBlock().getLocation()).lootedEntity((Entity)p).killer(null).lootingModifier(fortune).luck((float)luck).build(), new GenericBlockDestructionInfo(e.getBlock(), (Cancellable)e), BlockDestructionEvent.BlockDestructionReason.BURN);
        LootListener.clear(e.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBurnBreakFinal(BlockBurnEvent e) {
        if (ArchaeologyListener.isBrushable(e.getBlock().getType())) {
            preparedBlockDrops.remove(e.getBlock().getLocation());
            return;
        }
        for (ItemStack i : (List)preparedBlockDrops.getOrDefault(e.getBlock().getLocation(), new ArrayList())) {
            e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), i);
        }
        preparedBlockDrops.remove(e.getBlock().getLocation());
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockFadeBreak(BlockFadeEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName())) {
            return;
        }
        UUID uuid = blockBreakerMap.get(e.getBlock().getLocation());
        blockBreakerMap.remove(e.getBlock().getLocation());
        Player p = uuid == null ? null : ValhallaMMO.getInstance().getServer().getPlayer(uuid);
        Pair<Double, Integer> details = this.getFortuneAndLuck(p, e.getBlock());
        int fortune = details.getTwo();
        double luck = details.getOne();
        if (this.onBlockDestruction(e.getBlock(), new LootContext.Builder(e.getBlock().getLocation()).lootedEntity((Entity)p).killer(null).lootingModifier(fortune).luck((float)luck).build(), new GenericBlockDestructionInfo(e.getBlock(), (Cancellable)e), BlockDestructionEvent.BlockDestructionReason.FADE)) {
            e.setCancelled(true);
            e.getBlock().setType(e.getNewState().getType());
        }
        LootListener.clear(e.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockFadeBreakFinal(BlockFadeEvent e) {
        if (ArchaeologyListener.isBrushable(e.getBlock().getType())) {
            preparedBlockDrops.remove(e.getBlock().getLocation());
            return;
        }
        for (ItemStack i : (List)preparedBlockDrops.getOrDefault(e.getBlock().getLocation(), new ArrayList())) {
            e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), i);
        }
        preparedBlockDrops.remove(e.getBlock().getLocation());
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockDecay(LeavesDecayEvent e) {
        List<Player> nearby;
        Player p;
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName())) {
            return;
        }
        UUID uuid = blockBreakerMap.get(e.getBlock().getLocation());
        blockBreakerMap.remove(e.getBlock().getLocation());
        Player player = p = uuid == null ? null : ValhallaMMO.getInstance().getServer().getPlayer(uuid);
        if (p == null && !(nearby = EntityUtils.getNearbyPlayers(e.getBlock().getLocation(), 100.0)).isEmpty()) {
            p = nearby.get(0);
        }
        Pair<Double, Integer> details = this.getFortuneAndLuck(p, e.getBlock());
        int fortune = details.getTwo();
        double luck = details.getOne();
        if (this.onBlockDestruction(e.getBlock(), new LootContext.Builder(e.getBlock().getLocation()).lootedEntity((Entity)p).killer(null).lootingModifier(fortune).luck((float)luck).build(), new GenericBlockDestructionInfo(e.getBlock(), (Cancellable)e), BlockDestructionEvent.BlockDestructionReason.DECAY)) {
            e.setCancelled(true);
            e.getBlock().setType(Material.AIR);
        }
        LootListener.clear(e.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockDecayFinal(LeavesDecayEvent e) {
        if (ArchaeologyListener.isBrushable(e.getBlock().getType())) {
            preparedBlockDrops.remove(e.getBlock().getLocation());
            return;
        }
        for (ItemStack i : (List)preparedBlockDrops.getOrDefault(e.getBlock().getLocation(), new ArrayList())) {
            e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), i);
        }
        preparedBlockDrops.remove(e.getBlock().getLocation());
    }

    private Pair<Double, Integer> getFortuneAndLuck(Player p, Block b) {
        int fortune = 0;
        double luck = 0.0;
        if (p != null) {
            AttributeInstance luckInstance = p.getAttribute(Attribute.GENERIC_LUCK);
            luck = luckInstance == null ? 0.0 : luckInstance.getValue();
            luck += preparedLuckBuffs.getOrDefault(b.getLocation(), 0.0).doubleValue();
            ItemStack hand = p.getInventory().getItemInMainHand();
            if (!ItemUtils.isEmpty(hand)) {
                if (hand.containsEnchantment(EnchantmentMappings.FORTUNE.getEnchantment())) {
                    fortune = hand.getEnchantmentLevel(EnchantmentMappings.FORTUNE.getEnchantment());
                } else if (hand.containsEnchantment(Enchantment.SILK_TOUCH)) {
                    fortune = -1;
                }
            }
        }
        return new Pair<Double, Integer>(luck, fortune);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockReplaceBreak(BlockFromToEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName())) {
            return;
        }
        UUID uuid = blockBreakerMap.get(e.getBlock().getLocation());
        blockBreakerMap.remove(e.getBlock().getLocation());
        Player p = uuid == null ? null : ValhallaMMO.getInstance().getServer().getPlayer(uuid);
        Pair<Double, Integer> details = this.getFortuneAndLuck(p, e.getBlock());
        int fortune = details.getTwo();
        double luck = details.getOne();
        if (!e.getBlock().getType().isAir() && e.getBlock().getType() != e.getToBlock().getType()) {
            this.onBlockDestruction(e.getBlock(), new LootContext.Builder(e.getBlock().getLocation()).lootedEntity((Entity)p).killer(null).lootingModifier(fortune).luck((float)luck).build(), new GenericBlockDestructionInfo(e.getBlock(), (Cancellable)e), BlockDestructionEvent.BlockDestructionReason.REPLACED);
        }
        LootListener.clear(e.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockReplaceBreakFinal(BlockFromToEvent e) {
        if (ArchaeologyListener.isBrushable(e.getBlock().getType())) {
            preparedBlockDrops.remove(e.getBlock().getLocation());
            return;
        }
        for (ItemStack i : (List)preparedBlockDrops.getOrDefault(e.getBlock().getLocation(), new ArrayList())) {
            e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), i);
        }
        preparedBlockDrops.remove(e.getBlock().getLocation());
    }

    public static void markExploded(Block b) {
        explodedBlocks.put(b.getLocation(), b.getType());
    }

    public static void setFortuneLevel(Entity e, int level) {
        e.setMetadata("valhalla_explosive_fortune", (MetadataValue)new FixedMetadataValue((Plugin)ValhallaMMO.getInstance(), (Object)level));
    }

    public static int getFortuneLevel(Entity e) {
        if (!e.hasMetadata("valhalla_explosive_fortune")) {
            return 0;
        }
        Optional value = e.getMetadata("valhalla_explosive_fortune").stream().findAny();
        return value.map(MetadataValue::asInt).orElse(0);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockBlockExplodeBreak(BlockExplodeEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName())) {
            return;
        }
        ArrayList<Block> blocks = new ArrayList<Block>(e.blockList());
        blocks.addAll(explodedBlocks.keySet().stream().map(Location::getBlock).toList());
        for (Block b : blocks) {
            exploded.add(b);
            double extraLuck = preparedLuckBuffs.getOrDefault(b.getLocation(), 0.0);
            if (this.onBlockDestruction(b, new LootContext.Builder(b.getLocation()).lootedEntity(null).killer(null).lootingModifier(0).luck((float)extraLuck).build(), new BlockExplodeBlockDestructionInfo(b, (Cancellable)e), BlockDestructionEvent.BlockDestructionReason.BLOCK_EXPLOSION)) {
                e.blockList().remove(b);
                b.setType(Material.AIR);
            }
            LootListener.clear(b);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBlockExplodeBreakFinal(BlockExplodeEvent e) {
        if (ArchaeologyListener.isBrushable(e.getBlock().getType())) {
            preparedBlockDrops.remove(e.getBlock().getLocation());
            return;
        }
        ArrayList<Block> blocks = new ArrayList<Block>(e.blockList());
        blocks.addAll(explodedBlocks.keySet().stream().map(Location::getBlock).toList());
        for (Block b : blocks) {
            if (!ArchaeologyListener.isBrushable(b.getType())) {
                for (ItemStack i : (List)preparedBlockDrops.getOrDefault(b.getLocation(), new ArrayList())) {
                    b.getWorld().dropItemNaturally(b.getLocation(), i);
                }
            }
            preparedBlockDrops.remove(b.getLocation());
        }
    }

    public static boolean destroyedByExplosion(Block b) {
        return exploded.contains(b);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockEntityExplodeBreak(EntityExplodeEvent e) {
        AttributeInstance attributeInstance;
        Entity owner;
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName())) {
            return;
        }
        Optional uuidMeta = e.getEntity().getMetadata("valhalla_entity_owner").stream().findAny();
        UUID uuid = uuidMeta.map(metadataValue -> UUID.fromString(metadataValue.asString())).orElse(null);
        Entity entity = owner = uuid == null ? null : ValhallaMMO.getInstance().getServer().getEntity(uuid);
        if (owner instanceof LivingEntity) {
            LivingEntity l = (LivingEntity)owner;
            attributeInstance = l.getAttribute(Attribute.GENERIC_LUCK);
        } else {
            attributeInstance = null;
        }
        AttributeInstance luckInstance = attributeInstance;
        double luck = luckInstance == null ? 0.0 : luckInstance.getValue();
        ArrayList<Block> blocks = new ArrayList<Block>(e.blockList());
        blocks.addAll(explodedBlocks.keySet().stream().map(Location::getBlock).toList());
        for (Block b : blocks) {
            if (ArchaeologyListener.isBrushable(b.getType())) continue;
            exploded.add(b);
            double extraLuck = preparedLuckBuffs.getOrDefault(b.getLocation(), 0.0);
            if (this.onBlockDestruction(b, new LootContext.Builder(b.getLocation()).lootedEntity(owner != null ? owner : e.getEntity()).killer(null).lootingModifier(LootListener.getFortuneLevel(e.getEntity())).luck((float)(luck + extraLuck)).build(), new EntityExplodeBlockDestructionInfo(b, (Cancellable)e), BlockDestructionEvent.BlockDestructionReason.ENTITY_EXPLOSION)) {
                e.blockList().remove(b);
                b.setType(Material.AIR);
            }
            LootListener.clear(b);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockEntityExplodeBreakFinal(EntityExplodeEvent e) {
        Optional uuidMeta = e.getEntity().getMetadata("valhalla_entity_owner").stream().findAny();
        UUID uuid = uuidMeta.map(metadataValue -> UUID.fromString(metadataValue.asString())).orElse(null);
        Entity owner = uuid == null ? null : ValhallaMMO.getInstance().getServer().getEntity(uuid);
        ArrayList<Block> blocks = new ArrayList<Block>(e.blockList());
        blocks.addAll(explodedBlocks.keySet().stream().map(Location::getBlock).toList());
        for (Block b : blocks) {
            if (!ArchaeologyListener.isBrushable(b.getType())) {
                for (ItemStack i : (List)preparedBlockDrops.getOrDefault(b.getLocation(), new ArrayList())) {
                    if (owner instanceof Player) {
                        Player p = (Player)owner;
                        if (transferToInventory.containsKey(b.getLocation()) && transferToInventory.get(b.getLocation()).equals(p.getUniqueId())) {
                            ItemUtils.addItem(p, i, false);
                            continue;
                        }
                    }
                    b.getWorld().dropItemNaturally(b.getLocation(), i);
                }
            }
            preparedBlockDrops.remove(b.getLocation());
        }
    }

    public static void setEntityOwner(Entity entity, Entity owner) {
        entity.setMetadata("valhalla_entity_owner", (MetadataValue)new FixedMetadataValue((Plugin)ValhallaMMO.getInstance(), (Object)owner.getUniqueId().toString()));
    }

    private boolean onBlockDestruction(Block b, LootContext context, BlockDestructionInfo info, BlockDestructionEvent.BlockDestructionReason reason) {
        BlockDestructionEvent destroyEvent = new BlockDestructionEvent(b, info, reason);
        ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)destroyEvent);
        Material originalMaterial = explodedBlocks.getOrDefault(b.getLocation(), b.getType());
        explodedBlocks.remove(b.getLocation());
        if (!destroyEvent.getInfo().isCancelled(info.getEvent())) {
            me.athlaeos.valhallammo.loot.LootTable table = LootTableRegistry.getLootTable(b, originalMaterial);
            if (table == null || !BlockUtils.canReward(b) || ArchaeologyListener.isBrushable(b.getType())) {
                return false;
            }
            LootTableRegistry.setLootTable(b, null);
            List<ItemStack> generatedLoot = LootTableRegistry.getLoot(table, context, LootTable.LootType.BREAK);
            ValhallaLootPopulateEvent loottableEvent = new ValhallaLootPopulateEvent(table, context, generatedLoot);
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)loottableEvent);
            if (!loottableEvent.isCancelled()) {
                LootListener.prepareBlockDrops(b, loottableEvent.getDrops());
                return switch (loottableEvent.getPreservationType()) {
                    default -> throw new IncompatibleClassChangeError();
                    case LootTable.VanillaLootPreservationType.CLEAR -> true;
                    case LootTable.VanillaLootPreservationType.KEEP -> false;
                    case LootTable.VanillaLootPreservationType.CLEAR_UNLESS_EMPTY -> !loottableEvent.getDrops().isEmpty();
                };
            }
        }
        return false;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onContainerPlace(BlockPlaceEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName())) {
            return;
        }
        ItemStack placed = e.getItemInHand();
        if (ItemUtils.isEmpty(placed)) {
            return;
        }
        ItemBuilder item = new ItemBuilder(placed);
        me.athlaeos.valhallammo.loot.LootTable table = LootTableRegistry.getLootTable(item.getMeta());
        if (table == null) {
            return;
        }
        LootTableRegistry.setLootTable(e.getBlock(), table);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onChestOpen(PlayerInteractEvent e) {
        AttributeInstance luckInstance;
        Container c;
        Lootable l;
        Block b;
        block23: {
            block22: {
                if (e.getClickedBlock() == null || ValhallaMMO.isWorldBlacklisted(e.getClickedBlock().getWorld().getName()) || e.useInteractedBlock() == Event.Result.DENY || e.getAction() != Action.RIGHT_CLICK_BLOCK || e.getHand() == EquipmentSlot.OFF_HAND) {
                    return;
                }
                b = e.getClickedBlock();
                BlockState blockState = b.getState();
                if (!(blockState instanceof Lootable)) break block22;
                l = (Lootable)blockState;
                blockState = b.getState();
                if (!(blockState instanceof Container)) break block22;
                c = (Container)blockState;
                if (!ArchaeologyListener.isBrushable(b.getState()) && l.getLootTable() != null) break block23;
            }
            return;
        }
        if (ValhallaMMO.isUsingPaperMC() && !PaperLootRefillHandler.canGenerateLoot(b.getState(), e.getPlayer())) {
            return;
        }
        LootTable lootTable = l.getLootTable();
        me.athlaeos.valhallammo.loot.LootTable table = LootTableRegistry.getLootTable(b, b.getType());
        if (table == null) {
            table = LootTableRegistry.getLootTable(lootTable.getKey());
        }
        double luck = (luckInstance = e.getPlayer().getAttribute(Attribute.GENERIC_LUCK)) == null ? 0.0 : luckInstance.getValue();
        LootContext context = new LootContext.Builder(b.getLocation()).killer(null).lootedEntity((Entity)e.getPlayer()).lootingModifier(0).luck((float)luck).build();
        if (ValhallaMMO.isHookFunctional(LootinHook.class)) {
            LootinHook.prepareChestOpeningForLootin(e.getPlayer(), l.getLootTable(), table, context);
            return;
        }
        if (table != null) {
            LootTableRegistry.setLootTable(b, null);
            List<ItemStack> loot = LootTableRegistry.getLoot(table, context, LootTable.LootType.CONTAINER);
            ValhallaLootPopulateEvent loottableEvent = new ValhallaLootPopulateEvent(table, context, loot);
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)loottableEvent);
            if (!loottableEvent.isCancelled()) {
                boolean skip = false;
                switch (loottableEvent.getPreservationType()) {
                    case CLEAR: {
                        l.setLootTable(null);
                        b.getState().update();
                        c.getInventory().clear();
                        break;
                    }
                    case CLEAR_UNLESS_EMPTY: {
                        if (loottableEvent.getDrops().isEmpty()) break;
                        l.setLootTable(null);
                        b.getState().update();
                        c.getInventory().clear();
                        break;
                    }
                    case KEEP: {
                        if (!loottableEvent.getDrops().isEmpty()) break;
                        skip = true;
                    }
                }
                if (!skip) {
                    int i;
                    ArrayList<ItemStack> drops = new ArrayList<ItemStack>(loottableEvent.getDrops());
                    for (i = 0; i < c.getInventory().getSize() - drops.size(); ++i) {
                        drops.add(null);
                    }
                    Collections.shuffle(drops);
                    for (i = 0; i < drops.size(); ++i) {
                        ItemStack drop = (ItemStack)drops.get(i);
                        if (ItemUtils.isEmpty(drop)) continue;
                        if (i > c.getInventory().getSize() - 1) break;
                        c.getInventory().setItem(i, drop);
                    }
                }
            }
        }
        ReplacementTable replacementTable = LootTableRegistry.getReplacementTable(lootTable.getKey());
        ReplacementTable globalTable = LootTableRegistry.getGlobalReplacementTable();
        ValhallaLootReplacementEvent event = new ValhallaLootReplacementEvent(replacementTable, context);
        if (replacementTable != null) {
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
        }
        if (replacementTable == null || !event.isCancelled()) {
            for (int i = 0; i < c.getInventory().getSize(); ++i) {
                ItemStack globalReplacement;
                ItemStack item = c.getInventory().getItem(i);
                if (ItemUtils.isEmpty(item)) continue;
                ItemStack replacement = LootTableRegistry.getReplacement(replacementTable, context, LootTable.LootType.CONTAINER, item);
                if (!ItemUtils.isEmpty(replacement)) {
                    item = replacement;
                }
                if (!ItemUtils.isEmpty(globalReplacement = LootTableRegistry.getReplacement(globalTable, context, LootTable.LootType.CONTAINER, item))) {
                    item = globalReplacement;
                }
                if (ItemUtils.isEmpty(item)) continue;
                c.getInventory().setItem(i, item);
            }
        }
    }

    @EventHandler
    public void onHopperTransfer(InventoryMoveItemEvent e) {
        Lootable l;
        Container c;
        Boolean value = this.chestCache.get(e.getDestination().getLocation());
        if (value != null) {
            if (value.booleanValue()) {
                e.setCancelled(true);
            }
            return;
        }
        InventoryHolder inventoryHolder = e.getDestination().getHolder();
        if (inventoryHolder instanceof Container && (inventoryHolder = (c = (Container)inventoryHolder).getBlock().getState()) instanceof Lootable && (l = (Lootable)inventoryHolder).getLootTable() != null) {
            e.setCancelled(true);
            this.chestCache.put(e.getDestination().getLocation(), true);
            return;
        }
        inventoryHolder = e.getDestination().getHolder();
        if (inventoryHolder instanceof Entity && (c = (Entity)inventoryHolder) instanceof Lootable && (l = (Lootable)c).getLootTable() != null) {
            e.setCancelled(true);
            this.chestCache.put(e.getDestination().getLocation(), true);
            return;
        }
        this.chestCache.put(e.getDestination().getLocation(), false);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onChestCartOpen(PlayerInteractAtEntityEvent e) {
        InventoryHolder c;
        Lootable l;
        Entity entity;
        block21: {
            block20: {
                if (ValhallaMMO.isWorldBlacklisted(e.getRightClicked().getWorld().getName()) || e.getHand() == EquipmentSlot.OFF_HAND) {
                    return;
                }
                entity = e.getRightClicked();
                if (entity.getType() != EntityType.MINECART_CHEST || !(entity instanceof Lootable)) break block20;
                l = (Lootable)entity;
                if (!(entity instanceof InventoryHolder)) break block20;
                c = (InventoryHolder)entity;
                if (l.getLootTable() != null) break block21;
            }
            return;
        }
        if (ValhallaMMO.isUsingPaperMC() && !PaperLootRefillHandler.canGenerateLoot(entity, e.getPlayer())) {
            return;
        }
        me.athlaeos.valhallammo.loot.LootTable table = LootTableRegistry.getLootTable(l.getLootTable().getKey());
        AttributeInstance luckInstance = e.getPlayer().getAttribute(Attribute.GENERIC_LUCK);
        double luck = luckInstance == null ? 0.0 : luckInstance.getValue();
        LootContext context = new LootContext.Builder(entity.getLocation()).killer(null).lootedEntity((Entity)e.getPlayer()).lootingModifier(0).luck((float)luck).build();
        if (table != null) {
            List<ItemStack> loot = LootTableRegistry.getLoot(table, context, LootTable.LootType.CONTAINER);
            ValhallaLootPopulateEvent loottableEvent = new ValhallaLootPopulateEvent(table, context, loot);
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)loottableEvent);
            if (!loottableEvent.isCancelled()) {
                boolean skip = false;
                switch (loottableEvent.getPreservationType()) {
                    case CLEAR: {
                        l.setLootTable(null);
                        c.getInventory().clear();
                        break;
                    }
                    case CLEAR_UNLESS_EMPTY: {
                        if (loottableEvent.getDrops().isEmpty()) break;
                        l.setLootTable(null);
                        c.getInventory().clear();
                        break;
                    }
                    case KEEP: {
                        if (!loottableEvent.getDrops().isEmpty()) break;
                        skip = true;
                    }
                }
                if (!skip) {
                    int i;
                    ArrayList<ItemStack> drops = new ArrayList<ItemStack>(loottableEvent.getDrops());
                    for (i = 0; i < c.getInventory().getSize() - drops.size(); ++i) {
                        drops.add(null);
                    }
                    Collections.shuffle(drops);
                    for (i = 0; i < drops.size(); ++i) {
                        ItemStack drop = (ItemStack)drops.get(i);
                        if (ItemUtils.isEmpty(drop)) continue;
                        if (i > c.getInventory().getSize() - 1) break;
                        c.getInventory().setItem(i, drop);
                    }
                }
            }
        }
        ReplacementTable replacementTable = l.getLootTable() == null ? null : LootTableRegistry.getReplacementTable(l.getLootTable().getKey());
        ReplacementTable globalTable = LootTableRegistry.getGlobalReplacementTable();
        ValhallaLootReplacementEvent event = new ValhallaLootReplacementEvent(replacementTable, context);
        if (replacementTable != null) {
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
        }
        if (replacementTable == null || !event.isCancelled()) {
            for (int i = 0; i < c.getInventory().getSize(); ++i) {
                ItemStack globalReplacement;
                ItemStack item = c.getInventory().getItem(i);
                if (ItemUtils.isEmpty(item)) continue;
                ItemStack replacement = LootTableRegistry.getReplacement(replacementTable, context, LootTable.LootType.CONTAINER, item);
                if (!ItemUtils.isEmpty(replacement)) {
                    item = replacement;
                }
                if (!ItemUtils.isEmpty(globalReplacement = LootTableRegistry.getReplacement(globalTable, context, LootTable.LootType.CONTAINER, item))) {
                    item = globalReplacement;
                }
                if (ItemUtils.isEmpty(item)) continue;
                c.getInventory().setItem(i, item);
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onItemClick(PlayerInteractEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName()) || !Timer.isCooldownPassed(e.getPlayer().getUniqueId(), "attempts_loottable_item") || e.useItemInHand() == Event.Result.DENY || e.getHand() == EquipmentSlot.OFF_HAND || e.getAction() != Action.RIGHT_CLICK_AIR && e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack clickedItem = e.getPlayer().getInventory().getItemInMainHand();
        if (ItemUtils.isEmpty(clickedItem) || clickedItem.getType().isBlock()) {
            return;
        }
        ItemBuilder item = new ItemBuilder(clickedItem);
        me.athlaeos.valhallammo.loot.LootTable table = LootTableRegistry.getLootTable(item.getMeta());
        if (table == null) {
            return;
        }
        Timer.setCooldown(e.getPlayer().getUniqueId(), 500, "attempts_loottable_item");
        e.setCancelled(true);
        Sound sound = LootTableRegistry.getLootSound(item.getMeta());
        AttributeInstance luckInstance = e.getPlayer().getAttribute(Attribute.GENERIC_LUCK);
        double luck = luckInstance == null ? 0.0 : luckInstance.getValue();
        LootContext context = new LootContext.Builder(e.getPlayer().getLocation()).killer(null).lootedEntity((Entity)e.getPlayer()).lootingModifier(0).luck((float)luck).build();
        if (LootTableRegistry.isFreeSelectionTable(item.getMeta())) {
            new LootFreeSelectionMenu(PlayerMenuUtilManager.getPlayerMenuUtility(e.getPlayer()), table, context, LootTableRegistry.allowRepeatedFreeSelection(item.getMeta()), selection -> {
                ItemBuilder handItem;
                ItemBuilder itemBuilder = handItem = ItemUtils.isEmpty(e.getPlayer().getInventory().getItemInMainHand()) ? null : new ItemBuilder(e.getPlayer().getInventory().getItemInMainHand());
                if (handItem == null) {
                    return;
                }
                me.athlaeos.valhallammo.loot.LootTable storedTable = LootTableRegistry.getLootTable(handItem.getMeta());
                if (storedTable == null || !storedTable.getKey().equals(table.getKey())) {
                    return;
                }
                ArrayList<ItemStack> rewards = new ArrayList<ItemStack>();
                for (LootEntry entry : selection.keySet()) {
                    int times = (Integer)selection.get(entry);
                    for (int i2 = 0; i2 < times; ++i2) {
                        ItemBuilder reward = new ItemBuilder(entry.getDrop());
                        DynamicItemModifier.modify(ModifierContext.builder(reward).crafter(e.getPlayer()).executeUsageMechanics().validate().get(), entry.getModifiers());
                        if (CustomFlag.hasFlag(reward.getMeta(), CustomFlag.UNCRAFTABLE)) continue;
                        int quantityMin = Utils.randomAverage((float)entry.getBaseQuantityMin() + (float)Math.max(0, context.getLootingModifier()) * entry.getQuantityMinFortuneBase());
                        int quantityMax = Utils.randomAverage((float)entry.getBaseQuantityMax() + (float)Math.max(0, context.getLootingModifier()) * entry.getQuantityMaxFortuneBase());
                        if (quantityMax < quantityMin) {
                            quantityMax = quantityMin;
                        }
                        int quantity = Utils.getRandom().nextInt(Math.max(1, quantityMax - quantityMin)) + quantityMin;
                        int trueQuantity = entry.getDrop().getAmount() * quantity;
                        if (trueQuantity <= 0) continue;
                        ArrayList<ItemStack> loot = new ArrayList<ItemStack>(ItemUtils.decompressStacks(Map.of(reward.get(), trueQuantity)));
                        rewards.addAll(loot);
                    }
                }
                if (sound != null) {
                    e.getPlayer().playSound((Entity)e.getPlayer(), sound, 1.0f, 1.0f);
                }
                rewards.forEach(i -> ItemUtils.addItem(e.getPlayer(), i, true));
                ItemStack hand = e.getPlayer().getInventory().getItemInMainHand();
                if (hand.getAmount() <= 1) {
                    e.getPlayer().getInventory().setItemInMainHand(null);
                } else {
                    hand.setAmount(hand.getAmount() - 1);
                }
            }).open();
        } else {
            List<ItemStack> loot = LootTableRegistry.getLoot(table, context, LootTable.LootType.CONTAINER);
            ValhallaLootPopulateEvent loottableEvent = new ValhallaLootPopulateEvent(table, context, loot);
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)loottableEvent);
            if (!loottableEvent.isCancelled()) {
                loottableEvent.getDrops().forEach(i -> ItemUtils.addItem(e.getPlayer(), i, true));
                if (clickedItem.getAmount() <= 1) {
                    e.getPlayer().getInventory().setItemInMainHand(null);
                } else {
                    clickedItem.setAmount(clickedItem.getAmount() - 1);
                }
            }
            if (sound != null) {
                e.getPlayer().playSound((Entity)e.getPlayer(), sound, 1.0f, 1.0f);
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onEntityDrops(EntityDeathEvent e) {
        EntityDamageByEntityEvent event;
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || EntityClassification.matchesClassification(e.getEntityType(), EntityClassification.UNALIVE)) {
            return;
        }
        LivingEntity entity = e.getEntity();
        Player killer = entity.getKiller();
        EntityDamageEvent lastDamageSource = entity.getLastDamageCause();
        if (killer == null && lastDamageSource instanceof EntityDamageByEntityEvent && (event = (EntityDamageByEntityEvent)lastDamageSource).getDamager() instanceof LivingEntity) {
            killer = event.getDamager();
        }
        HashSet<Material> droppedHandTypes = new HashSet<Material>();
        EntityEquipment equipment = entity.getEquipment();
        if (equipment != null) {
            if (!ItemUtils.isEmpty(equipment.getItemInMainHand()) && equipment.getItemInMainHandDropChance() >= 0.95f) {
                droppedHandTypes.add(equipment.getItemInMainHand().getType());
            }
            if (!ItemUtils.isEmpty(equipment.getItemInOffHand()) && equipment.getItemInOffHandDropChance() >= 0.95f) {
                droppedHandTypes.add(equipment.getItemInOffHand().getType());
            }
            if (!ItemUtils.isEmpty(equipment.getHelmet()) && equipment.getHelmetDropChance() >= 0.95f) {
                droppedHandTypes.add(equipment.getHelmet().getType());
            }
            if (!ItemUtils.isEmpty(equipment.getChestplate()) && equipment.getChestplateDropChance() >= 0.95f) {
                droppedHandTypes.add(equipment.getChestplate().getType());
            }
            if (!ItemUtils.isEmpty(equipment.getLeggings()) && equipment.getLeggingsDropChance() >= 0.95f) {
                droppedHandTypes.add(equipment.getLeggings().getType());
            }
            if (!ItemUtils.isEmpty(equipment.getBoots()) && equipment.getBootsDropChance() >= 0.95f) {
                droppedHandTypes.add(equipment.getBoots().getType());
            }
        }
        double dropMultiplier = killer == null || entity instanceof Player ? 0.0 : AccumulativeStatManager.getCachedStats("ENTITY_DROPS", (Entity)killer, 10000L, true) + MonsterScalingManager.getLootMultiplier(e.getEntity());
        ItemUtils.multiplyItems(e.getDrops(), 1.0 + dropMultiplier, false, i -> this.itemDuplicationWhitelist.contains(i.getType()) && !droppedHandTypes.contains(i.getType()));
        int looting = 0;
        double luck = 0.0;
        if (killer != null) {
            AttributeInstance luckInstance = entity.getKiller() == null ? null : entity.getKiller().getAttribute(Attribute.GENERIC_LUCK);
            luck = luckInstance == null ? 0.0 : luckInstance.getValue();
            luck += AccumulativeStatManager.getCachedStats("ENTITY_DROP_LUCK", (Entity)killer, 10000L, true);
            if (killer instanceof HumanEntity) {
                HumanEntity h = (HumanEntity)killer;
                looting = ItemUtils.isEmpty(h.getInventory().getItemInMainHand()) ? 0 : h.getInventory().getItemInMainHand().getEnchantmentLevel(EnchantmentMappings.FORTUNE.getEnchantment());
            }
        }
        me.athlaeos.valhallammo.loot.LootTable table = LootTableRegistry.getLootTable((Entity)entity);
        LootContext context = new LootContext.Builder(entity.getLocation()).killer(null).lootedEntity((Entity)entity).lootingModifier(looting).luck((float)luck).build();
        if (table != null) {
            if (killer != null) {
                realKiller.put(entity.getUniqueId(), killer.getUniqueId());
            }
            List<ItemStack> loot = LootTableRegistry.getLoot(table, context, LootTable.LootType.KILL);
            realKiller.remove(entity.getUniqueId());
            ValhallaLootPopulateEvent loottableEvent = new ValhallaLootPopulateEvent(table, context, loot);
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)loottableEvent);
            if (!loottableEvent.isCancelled()) {
                boolean skip = false;
                switch (loottableEvent.getPreservationType()) {
                    case CLEAR: {
                        e.getDrops().clear();
                        break;
                    }
                    case CLEAR_UNLESS_EMPTY: {
                        if (loottableEvent.getDrops().isEmpty()) break;
                        e.getDrops().clear();
                        break;
                    }
                    case KEEP: {
                        if (!loottableEvent.getDrops().isEmpty()) break;
                        skip = true;
                    }
                }
                if (!skip) {
                    e.getDrops().addAll(loottableEvent.getDrops());
                }
            }
        }
        if (e.getEntity() instanceof Player) {
            return;
        }
        ReplacementTable replacementTable = LootTableRegistry.getReplacementTable(e.getEntityType());
        ReplacementTable globalTable = LootTableRegistry.getGlobalReplacementTable();
        ValhallaLootReplacementEvent event2 = new ValhallaLootReplacementEvent(replacementTable, context);
        if (replacementTable != null) {
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event2);
        }
        if (replacementTable == null || !event2.isCancelled()) {
            for (int i2 = 0; i2 < e.getDrops().size(); ++i2) {
                ItemStack globalReplacement;
                ItemStack item = (ItemStack)e.getDrops().get(i2);
                if (droppedHandTypes.contains(item.getType()) || ItemUtils.isEmpty(item)) continue;
                ItemStack replacement = LootTableRegistry.getReplacement(replacementTable, context, LootTable.LootType.KILL, item = item.clone());
                if (!ItemUtils.isEmpty(replacement)) {
                    item = replacement;
                }
                if (!ItemUtils.isEmpty(globalReplacement = LootTableRegistry.getReplacement(globalTable, context, LootTable.LootType.KILL, item))) {
                    item = globalReplacement;
                }
                if (ItemUtils.isEmpty(item)) continue;
                e.getDrops().set(i2, item);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityEquipmentSpawn(EntitySpawnEvent e) {
        LivingEntity le;
        Entity entity;
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || !((entity = e.getEntity()) instanceof LivingEntity) || (le = (LivingEntity)entity).getEquipment() == null || EntityClassification.matchesClassification(e.getEntityType(), EntityClassification.UNALIVE)) {
            return;
        }
        AttributeInstance maxHealth = le.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (e.getEntity().getCustomName() != null || maxHealth != null && maxHealth.getDefaultValue() != maxHealth.getValue()) {
            return;
        }
        LootContext context = new LootContext.Builder(le.getLocation()).killer(null).lootedEntity((Entity)le).lootingModifier(0).luck(0.0f).build();
        EntityEquipment entityEquipment = le.getEquipment();
        ItemStack[] equipment = new ItemStack[]{null, null, null, null, null, null};
        if (!ItemUtils.isEmpty(entityEquipment.getItemInMainHand())) {
            equipment[0] = entityEquipment.getItemInMainHand();
        }
        if (!ItemUtils.isEmpty(entityEquipment.getItemInOffHand())) {
            equipment[1] = entityEquipment.getItemInOffHand();
        }
        if (!ItemUtils.isEmpty(entityEquipment.getHelmet())) {
            equipment[2] = entityEquipment.getHelmet();
        }
        if (!ItemUtils.isEmpty(entityEquipment.getChestplate())) {
            equipment[3] = entityEquipment.getChestplate();
        }
        if (!ItemUtils.isEmpty(entityEquipment.getLeggings())) {
            equipment[4] = entityEquipment.getLeggings();
        }
        if (!ItemUtils.isEmpty(entityEquipment.getBoots())) {
            equipment[5] = entityEquipment.getBoots();
        }
        ReplacementTable replacementTable = LootTableRegistry.getReplacementTable(e.getEntityType());
        ReplacementTable globalTable = LootTableRegistry.getGlobalReplacementTable();
        ValhallaLootReplacementEvent event = new ValhallaLootReplacementEvent(replacementTable, context);
        if (replacementTable != null) {
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
        }
        if (replacementTable == null || !event.isCancelled()) {
            for (int i = 0; i < equipment.length; ++i) {
                ItemStack globalReplacement;
                ItemStack item = equipment[i];
                if (ItemUtils.isEmpty(item)) continue;
                ItemStack replacement = LootTableRegistry.getReplacement(replacementTable, context, LootTable.LootType.KILL, item);
                if (!ItemUtils.isEmpty(replacement)) {
                    item = replacement;
                }
                if (!ItemUtils.isEmpty(globalReplacement = LootTableRegistry.getReplacement(globalTable, context, LootTable.LootType.KILL, item))) {
                    item = globalReplacement;
                }
                if (ItemUtils.isEmpty(item)) continue;
                equipment[i] = item;
            }
        }
        if (!ItemUtils.isEmpty(equipment[0])) {
            entityEquipment.setItemInMainHand(equipment[0]);
        }
        if (!ItemUtils.isEmpty(equipment[1])) {
            entityEquipment.setItemInOffHand(equipment[1]);
        }
        if (!ItemUtils.isEmpty(equipment[2])) {
            entityEquipment.setHelmet(equipment[2]);
        }
        if (!ItemUtils.isEmpty(equipment[3])) {
            entityEquipment.setChestplate(equipment[3]);
        }
        if (!ItemUtils.isEmpty(equipment[4])) {
            entityEquipment.setLeggings(equipment[4]);
        }
        if (!ItemUtils.isEmpty(equipment[5])) {
            entityEquipment.setBoots(equipment[5]);
        }
    }

    public static Entity getRealKiller(Entity victim) {
        UUID killer = realKiller.get(victim.getUniqueId());
        return killer == null ? null : ValhallaMMO.getInstance().getServer().getEntity(killer);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockDrops(BlockDropItemEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName()) || !transferToInventory.containsKey(e.getBlock().getLocation())) {
            LootListener.clear(e.getBlock());
            return;
        }
        Pair<Double, Integer> details = this.getFortuneAndLuck(e.getPlayer(), e.getBlock());
        int fortune = details.getTwo();
        double luck = details.getOne();
        LootContext context = new LootContext.Builder(e.getBlock().getLocation()).lootedEntity((Entity)e.getPlayer()).killer(null).lootingModifier(fortune).luck((float)luck).build();
        boolean transfer = transferToInventory.containsKey(e.getBlock().getLocation()) && transferToInventory.get(e.getBlock().getLocation()).equals(e.getPlayer().getUniqueId());
        ReplacementTable replacementTable = LootTableRegistry.getReplacementTable(e.getBlockState().getType());
        ReplacementTable globalTable = LootTableRegistry.getGlobalReplacementTable();
        ValhallaLootReplacementEvent event = new ValhallaLootReplacementEvent(replacementTable, context);
        if (replacementTable != null) {
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
        }
        if (replacementTable == null || !event.isCancelled()) {
            List drops = preparedBlockDrops.getOrDefault(e.getBlock().getLocation(), new ArrayList());
            for (int i = 0; i < drops.size(); ++i) {
                ItemStack globalReplacement;
                ItemStack item = (ItemStack)drops.get(i);
                if (ItemUtils.isEmpty(item)) continue;
                ItemStack replacement1 = LootTableRegistry.getReplacement(replacementTable, context, LootTable.LootType.BREAK, item);
                if (!ItemUtils.isEmpty(replacement1)) {
                    item = replacement1;
                }
                ItemStack itemStack = globalReplacement = event.executeGlobal() ? LootTableRegistry.getReplacement(globalTable, context, LootTable.LootType.BREAK, item) : null;
                if (!ItemUtils.isEmpty(globalReplacement)) {
                    item = globalReplacement;
                }
                if (ItemUtils.isEmpty(item)) continue;
                drops.set(i, item);
            }
            preparedBlockDrops.put(e.getBlock().getLocation(), drops);
        }
        for (ItemStack item : (List)preparedBlockDrops.getOrDefault(e.getBlock().getLocation(), new ArrayList())) {
            if (transfer) {
                ItemUtils.addItem(e.getPlayer(), item, false);
                continue;
            }
            e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), item);
        }
        preparedBlockDrops.remove(e.getBlock().getLocation());
        if (!event.isCancelled()) {
            for (int i = 0; i < e.getItems().size(); ++i) {
                ItemStack globalReplacement;
                ItemStack item = ((Item)e.getItems().get(i)).getItemStack();
                ItemStack replacement = LootTableRegistry.getReplacement(replacementTable, context, LootTable.LootType.BREAK, item);
                if (!ItemUtils.isEmpty(replacement)) {
                    item = replacement;
                }
                ItemStack itemStack = globalReplacement = event.executeGlobal() ? LootTableRegistry.getReplacement(globalTable, context, LootTable.LootType.BREAK, item) : null;
                if (!ItemUtils.isEmpty(globalReplacement)) {
                    item = globalReplacement;
                }
                if (ItemUtils.isEmpty(item)) continue;
                ((Item)e.getItems().get(i)).setItemStack(item);
            }
        }
        if (transfer) {
            for (Item i : e.getItems()) {
                ItemUtils.addItem(e.getPlayer(), i.getItemStack(), false);
            }
            e.getItems().clear();
        }
        LootListener.clear(e.getBlock());
    }

    public static void clear(Block b) {
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
            transferToInventory.remove(b.getLocation());
            preparedBlockDrops.remove(b.getLocation());
            preparedLuckBuffs.remove(b.getLocation());
            explodedBlocks.remove(b.getLocation());
            exploded.remove(b);
        }, 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFishFinal(PlayerFishEvent e) {
        preparedFishingLuckBuffs.remove(e.getPlayer().getUniqueId());
        if (e.getState() != PlayerFishEvent.State.CAUGHT_FISH) {
            return;
        }
        ((List)preparedFishingDrops.getOrDefault(e.getPlayer().getUniqueId(), new ArrayList())).forEach(d -> {
            Item item = e.getHook().getWorld().dropItem(e.getHook().getLocation(), d);
            item.setVelocity(this.fishingItemVelocity(e.getHook().getLocation(), e.getPlayer().getLocation().add(0.0, e.getPlayer().getBoundingBox().getHeight() / 2.0, 0.0)));
        });
        preparedFishingDrops.remove(e.getPlayer().getUniqueId());
    }

    private Vector fishingItemVelocity(Location hook, Location player) {
        double d = player.getX() - hook.getX();
        double e = player.getY() - hook.getY();
        double f = player.getZ() - hook.getZ();
        return new Vector(d * 0.1, e * 0.1 + Math.sqrt(Math.sqrt(d * d + e * e + f * f)) * 0.08, f * 0.1);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPiglinBarter(PiglinBarterEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName())) {
            return;
        }
        me.athlaeos.valhallammo.loot.LootTable table = LootTableRegistry.getLootTable(LootTables.PIGLIN_BARTERING);
        LootContext context = new LootContext.Builder(e.getEntity().getLocation()).killer(null).lootedEntity(null).lootingModifier(0).luck(0.0f).build();
        if (table != null) {
            List<ItemStack> loot = LootTableRegistry.getLoot(table, context, LootTable.LootType.PIGLIN_BARTER);
            ValhallaLootPopulateEvent loottableEvent = new ValhallaLootPopulateEvent(table, context, loot);
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)loottableEvent);
            if (!loottableEvent.isCancelled()) {
                boolean skip = false;
                switch (loottableEvent.getPreservationType()) {
                    case CLEAR: {
                        e.getOutcome().clear();
                        break;
                    }
                    case CLEAR_UNLESS_EMPTY: {
                        if (loottableEvent.getDrops().isEmpty()) break;
                        e.getOutcome().clear();
                        break;
                    }
                    case KEEP: {
                        if (!loottableEvent.getDrops().isEmpty()) break;
                        skip = true;
                    }
                }
                if (!skip) {
                    e.getOutcome().addAll(loottableEvent.getDrops());
                }
            }
        }
        ReplacementTable replacementTable = LootTableRegistry.getReplacementTable(LootTables.PIGLIN_BARTERING);
        ReplacementTable globalTable = LootTableRegistry.getGlobalReplacementTable();
        ValhallaLootReplacementEvent event = new ValhallaLootReplacementEvent(replacementTable, context);
        if (replacementTable != null) {
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
        }
        if (replacementTable == null || !event.isCancelled()) {
            for (int i = 0; i < e.getOutcome().size(); ++i) {
                ItemStack globalReplacement;
                ItemStack item = (ItemStack)e.getOutcome().get(i);
                if (ItemUtils.isEmpty(item)) continue;
                ItemStack replacement1 = LootTableRegistry.getReplacement(replacementTable, context, LootTable.LootType.PIGLIN_BARTER, item);
                if (!ItemUtils.isEmpty(replacement1)) {
                    item = replacement1;
                }
                ItemStack itemStack = globalReplacement = event.executeGlobal() ? LootTableRegistry.getReplacement(globalTable, context, LootTable.LootType.PIGLIN_BARTER, item) : null;
                if (!ItemUtils.isEmpty(globalReplacement)) {
                    item = globalReplacement;
                }
                if (ItemUtils.isEmpty(item)) continue;
                e.getOutcome().set(i, item);
            }
        }
    }

    public static void addPreparedLuck(Block b, double luck) {
        double existing = preparedLuckBuffs.getOrDefault(b.getLocation(), 0.0);
        preparedLuckBuffs.put(b.getLocation(), existing + luck);
    }

    public static void addPreparedLuck(Player p, double luck) {
        double existing = preparedFishingLuckBuffs.getOrDefault(p.getUniqueId(), 0.0);
        preparedFishingLuckBuffs.put(p.getUniqueId(), existing + luck);
    }

    public static double getPreparedLuck(Player p) {
        return preparedFishingLuckBuffs.getOrDefault(p.getUniqueId(), 0.0);
    }

    public static double getPreparedLuck(Block b) {
        return preparedLuckBuffs.getOrDefault(b.getLocation(), 0.0);
    }

    public static List<ItemStack> getPreparedExtraDrops(Block b) {
        return preparedBlockDrops.getOrDefault(b.getLocation(), new ArrayList());
    }

    public static List<ItemStack> getPreparedExtraDrops(Player p) {
        return preparedFishingDrops.getOrDefault(p.getUniqueId(), new ArrayList());
    }

    public static void setInstantPickup(Block b, Player who) {
        transferToInventory.put(b.getLocation(), who.getUniqueId());
    }

    public static void prepareFishingDrops(UUID fisher, ItemStack ... items) {
        LootListener.prepareFishingDrops(fisher, List.of(items));
    }

    public static void prepareFishingDrops(UUID fisher, List<ItemStack> items) {
        List preparedDrops = preparedFishingDrops.getOrDefault(fisher, new ArrayList());
        preparedDrops.addAll(items);
        preparedFishingDrops.put(fisher, preparedDrops);
    }

    public static void prepareBlockDrops(Block b, ItemStack ... items) {
        LootListener.prepareBlockDrops(b, List.of(items));
    }

    public static void prepareBlockDrops(Block b, List<ItemStack> items) {
        List preparedDrops = preparedBlockDrops.getOrDefault(b.getLocation(), new ArrayList());
        preparedDrops.addAll(items);
        preparedBlockDrops.put(b.getLocation(), preparedDrops);
    }

    public static Map<UUID, List<ItemStack>> getPreparedFishingDrops() {
        return preparedFishingDrops;
    }

    public static Map<Location, List<ItemStack>> getPreparedBlockDrops() {
        return preparedBlockDrops;
    }
}

