/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.listeners;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.entities.EntityAttributeStats;
import me.athlaeos.valhallammo.listeners.EntityAttackListener;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.utility.EntityUtils;
import me.athlaeos.valhallammo.utility.Timer;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class MovementListener
implements Listener {
    private static final Map<UUID, Vector> lastMovementVectors = new HashMap<UUID, Vector>();

    public MovementListener() {
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskTimer((Plugin)ValhallaMMO.getInstance(), () -> {
            for (Player p : ValhallaMMO.getInstance().getServer().getOnlinePlayers()) {
                if (Timer.isCooldownPassed(p.getUniqueId(), "delay_combat_update")) {
                    EntityAttackListener.updateCombatStatus(p);
                    Timer.setCooldown(p.getUniqueId(), 500, "delay_combat_update");
                }
                if (!Timer.isCooldownPassed(p.getUniqueId(), "delay_movement_update")) continue;
                if (ValhallaMMO.isWorldBlacklisted(p.getWorld().getName())) {
                    EntityAttributeStats.removeStats((LivingEntity)p);
                } else {
                    EntityAttributeStats.updateStats((LivingEntity)p);
                    AttributeInstance armorInstance = p.getAttribute(Attribute.GENERIC_ARMOR);
                    EntityUtils.removeUniqueAttribute((LivingEntity)p, "armor_nullifier", Attribute.GENERIC_ARMOR);
                    EntityUtils.removeUniqueAttribute((LivingEntity)p, "armor_display", Attribute.GENERIC_ARMOR);
                    if (armorInstance != null) {
                        double totalArmor = AccumulativeStatManager.getCachedStats("ARMOR_TOTAL", (Entity)p, 10000L, true);
                        int scale = ValhallaMMO.getPluginConfig().getInt("armor_scale", 50);
                        double newArmor = Math.max(0.0, Math.min(20.0, totalArmor / (double)scale * 20.0));
                        EntityUtils.addUniqueAttribute((LivingEntity)p, EntityAttributeStats.ARMOR_NULLIFIER, "armor_nullifier", Attribute.GENERIC_ARMOR, -armorInstance.getValue(), AttributeModifier.Operation.ADD_NUMBER);
                        EntityUtils.addUniqueAttribute((LivingEntity)p, EntityAttributeStats.ARMOR_DISPLAY, "armor_display", Attribute.GENERIC_ARMOR, newArmor, AttributeModifier.Operation.ADD_NUMBER);
                    }
                }
                Timer.setCooldown(p.getUniqueId(), 10000, "delay_movement_update");
            }
        }, 20L, 20L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName())) {
            return;
        }
        if (e.getTo() == null) {
            lastMovementVectors.remove(e.getPlayer().getUniqueId());
            return;
        }
        lastMovementVectors.put(e.getPlayer().getUniqueId(), e.getTo().toVector().subtract(e.getFrom().toVector()));
    }

    public static void resetAttributeStats(Player p) {
        MovementListener.resetAttributeStats(p.getUniqueId());
    }

    public static void resetAttributeStats(UUID uuid) {
        Timer.setCooldown(uuid, 0, "delay_movement_update");
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerToggleSneak(PlayerToggleSneakEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName())) {
            return;
        }
        if (e.isSneaking()) {
            double sneakSpeedBonus = AccumulativeStatManager.getCachedStats("SNEAK_MOVEMENT_SPEED_BONUS", (Entity)e.getPlayer(), 10000L, true);
            EntityUtils.addUniqueAttribute((LivingEntity)e.getPlayer(), EntityAttributeStats.SNEAK_MOVEMENT, "valhalla_sneak_movement_modifier", Attribute.GENERIC_MOVEMENT_SPEED, sneakSpeedBonus, AttributeModifier.Operation.ADD_SCALAR);
        } else {
            EntityUtils.removeUniqueAttribute((LivingEntity)e.getPlayer(), "valhalla_sneak_movement_modifier", Attribute.GENERIC_MOVEMENT_SPEED);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerToggleSprint(PlayerToggleSprintEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName())) {
            return;
        }
        if (e.isSprinting()) {
            double sneakSpeedBonus = AccumulativeStatManager.getCachedStats("SPRINT_MOVEMENT_SPEED_BONUS", (Entity)e.getPlayer(), 10000L, true);
            EntityUtils.addUniqueAttribute((LivingEntity)e.getPlayer(), EntityAttributeStats.SPRINT_MOVEMENT, "valhalla_sprint_movement_modifier", Attribute.GENERIC_MOVEMENT_SPEED, sneakSpeedBonus, AttributeModifier.Operation.ADD_SCALAR);
        } else {
            EntityUtils.removeUniqueAttribute((LivingEntity)e.getPlayer(), "valhalla_sprint_movement_modifier", Attribute.GENERIC_MOVEMENT_SPEED);
        }
    }

    public static Map<UUID, Vector> getLastMovementVectors() {
        return lastMovementVectors;
    }
}

