/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.listeners;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.item.WeightClass;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.playerstats.EntityProperties;
import me.athlaeos.valhallammo.utility.EntityUtils;
import me.athlaeos.valhallammo.utility.Timer;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.util.RayTraceResult;

public class ReachAttackListener
implements Listener {
    private static final Collection<UUID> cancelNextReachAttack = new HashSet<UUID>();
    private static final Collection<UUID> reachHitTracker = new HashSet<UUID>();
    private static final Map<UUID, ArmSwingReason> lastArmSwingReasons = new HashMap<UUID, ArmSwingReason>();

    public static Map<UUID, ArmSwingReason> getLastArmSwingReasons() {
        return lastArmSwingReasons;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSwing(PlayerAnimationEvent e) {
        RayTraceResult rayTrace;
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName()) || e.getAnimationType() != PlayerAnimationType.ARM_SWING || lastArmSwingReasons.getOrDefault(e.getPlayer().getUniqueId(), ArmSwingReason.ATTACK) != ArmSwingReason.ATTACK) {
            return;
        }
        EntityProperties properties = EntityCache.getAndCacheProperties((LivingEntity)e.getPlayer());
        if (properties.getMainHand() != null && WeightClass.getWeightClass(properties.getMainHand().getMeta()) == WeightClass.WEIGHTLESS) {
            return;
        }
        Player p = e.getPlayer();
        if (cancelNextReachAttack.remove(p.getUniqueId())) {
            return;
        }
        double reach = AccumulativeStatManager.getCachedStats("ATTACK_REACH_BONUS", (Entity)e.getPlayer(), 10000L, true);
        double multiplier = 1.0 + AccumulativeStatManager.getCachedStats("ATTACK_REACH_MULTIPLIER", (Entity)e.getPlayer(), 10000L, true);
        Timer.setCooldown(e.getPlayer().getUniqueId(), 0, "parry_vulnerable");
        Timer.setCooldown(e.getPlayer().getUniqueId(), 0, "parry_effective");
        if (reach <= 0.0 || multiplier <= 0.0) {
            return;
        }
        reach = (EntityUtils.getPlayerReach(e.getPlayer()) + reach) * multiplier;
        Location eyes = p.getEyeLocation();
        Entity vehicle = p.getVehicle();
        if (vehicle instanceof LivingEntity) {
            LivingEntity v = (LivingEntity)vehicle;
            vehicle.getLocation().add(0.0, v.getEyeHeight() + 0.625 * p.getEyeHeight(), 0.0);
        }
        if ((rayTrace = p.getWorld().rayTrace(eyes, eyes.getDirection(), reach - 0.1, FluidCollisionMode.NEVER, true, 0.1, entity -> !entity.equals((Object)p) || e.getPlayer().getPassengers().contains(entity) || entity.equals((Object)vehicle) || entity.isDead())) != null) {
            Entity hit = rayTrace.getHitEntity();
            if (hit == null) {
                return;
            }
            p.attack(hit);
            reachHitTracker.add(p.getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onDamage(EntityDamageByEntityEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName())) {
            return;
        }
        Entity entity2 = e.getDamager();
        if (entity2 instanceof Player) {
            double multiplier;
            double reach;
            double defaultReach;
            double actualReach;
            Player p = (Player)entity2;
            if (!ReachAttackListener.usedReachAttack(p)) {
                ReachAttackListener.cancelNextReachAttack(p);
            }
            if ((actualReach = ((defaultReach = 3.0) + (reach = AccumulativeStatManager.getCachedStats("ATTACK_REACH_BONUS", (Entity)p, 10000L, true))) * (multiplier = 1.0 + AccumulativeStatManager.getCachedStats("ATTACK_REACH_MULTIPLIER", (Entity)p, 10000L, true))) < defaultReach) {
                if (actualReach <= 0.5) {
                    e.setCancelled(true);
                    ReachAttackListener.setLastArmSwingReason(p, ArmSwingReason.FAILED_ATTACK);
                    return;
                }
                RayTraceResult rayTrace = e.getDamager().getWorld().rayTrace(((LivingEntity)e.getDamager()).getEyeLocation(), ((LivingEntity)e.getDamager()).getEyeLocation().getDirection(), actualReach - 0.5, FluidCollisionMode.NEVER, true, 0.5, entity -> !entity.equals((Object)e.getDamager()) && !entity.equals((Object)e.getDamager().getVehicle()));
                if (rayTrace == null || rayTrace.getHitEntity() == null) {
                    e.setCancelled(true);
                    ReachAttackListener.setLastArmSwingReason(p, ArmSwingReason.FAILED_ATTACK);
                    return;
                }
            }
            ReachAttackListener.setLastArmSwingReason(p, ArmSwingReason.ATTACK);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInteract(PlayerInteractEvent e) {
        if (e.getHand() == EquipmentSlot.HAND) {
            switch (e.getAction()) {
                case RIGHT_CLICK_BLOCK: {
                    ReachAttackListener.setLastArmSwingReason(e.getPlayer(), ArmSwingReason.BLOCK_INTERACT);
                    break;
                }
                case LEFT_CLICK_BLOCK: {
                    ReachAttackListener.setLastArmSwingReason(e.getPlayer(), ArmSwingReason.BLOCK_DAMAGE);
                    break;
                }
                case RIGHT_CLICK_AIR: {
                    ReachAttackListener.setLastArmSwingReason(e.getPlayer(), ArmSwingReason.AIR_INTERACT);
                    break;
                }
                case LEFT_CLICK_AIR: {
                    ReachAttackListener.setLastArmSwingReason(e.getPlayer(), ArmSwingReason.ATTACK);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInteract(PlayerInteractAtEntityEvent e) {
        ReachAttackListener.setLastArmSwingReason(e.getPlayer(), ArmSwingReason.ENTITY_INTERACT);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onItemDrop(PlayerDropItemEvent e) {
        ReachAttackListener.setLastArmSwingReason(e.getPlayer(), ArmSwingReason.DROP_ITEM);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockDamage(BlockDamageEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName())) {
            return;
        }
        ReachAttackListener.setLastArmSwingReason(e.getPlayer(), ArmSwingReason.BLOCK_DAMAGE);
    }

    public static boolean usedReachAttack(Player p) {
        return reachHitTracker.remove(p.getUniqueId());
    }

    public static void cancelNextReachAttack(Player p) {
        cancelNextReachAttack.add(p.getUniqueId());
    }

    public static void setLastArmSwingReason(Player p, ArmSwingReason reason) {
        if (Timer.isCooldownPassed(p.getUniqueId(), "arm_swing_reason_delay")) {
            lastArmSwingReasons.put(p.getUniqueId(), reason);
            Timer.setCooldown(p.getUniqueId(), 40, "arm_swing_reason_delay");
        }
    }

    public static enum ArmSwingReason {
        ATTACK,
        FAILED_ATTACK,
        BLOCK_DAMAGE,
        AIR_INTERACT,
        BLOCK_INTERACT,
        ENTITY_INTERACT,
        DROP_ITEM;

    }
}

