/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.listeners;

import me.athlaeos.valhallammo.crafting.CustomRecipeRegistry;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicCookingRecipe;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicGridRecipe;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicSmithingRecipe;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import org.bukkit.NamespacedKey;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRecipeDiscoverEvent;

public class RecipeDiscoveryListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onRecipeDiscover(PlayerRecipeDiscoverEvent e) {
        if (CustomRecipeRegistry.getDisabledRecipes().contains(e.getRecipe())) {
            e.setCancelled(true);
        }
        if (CustomRecipeRegistry.getAllKeyedRecipes().containsKey(e.getRecipe()) && CustomRecipeRegistry.getAllKeyedRecipes().get(e.getRecipe()).isHiddenFromBook()) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        for (NamespacedKey key : CustomRecipeRegistry.getDisabledRecipes()) {
            e.getPlayer().undiscoverRecipe(key);
        }
        PowerProfile profile = ProfileRegistry.getMergedProfile(e.getPlayer(), PowerProfile.class);
        boolean allPermission = e.getPlayer().hasPermission("valhalla.allrecipes");
        for (DynamicGridRecipe dynamicGridRecipe : CustomRecipeRegistry.getGridRecipes().values()) {
            if (!dynamicGridRecipe.isHiddenFromBook() && (dynamicGridRecipe.isUnlockedForEveryone() || profile.getUnlockedRecipes().contains(dynamicGridRecipe.getName()) || allPermission || e.getPlayer().hasPermission("valhalla.recipe." + dynamicGridRecipe.getName()))) {
                e.getPlayer().discoverRecipe(dynamicGridRecipe.getKey());
            } else {
                e.getPlayer().undiscoverRecipe(dynamicGridRecipe.getKey());
            }
            e.getPlayer().undiscoverRecipe(dynamicGridRecipe.getKey2());
        }
        for (DynamicSmithingRecipe dynamicSmithingRecipe : CustomRecipeRegistry.getSmithingRecipes().values()) {
            if (!dynamicSmithingRecipe.isHiddenFromBook() && (dynamicSmithingRecipe.isUnlockedForEveryone() || profile.getUnlockedRecipes().contains(dynamicSmithingRecipe.getName()) || allPermission || e.getPlayer().hasPermission("valhalla.recipe." + dynamicSmithingRecipe.getName()))) {
                e.getPlayer().discoverRecipe(dynamicSmithingRecipe.getKey());
                continue;
            }
            e.getPlayer().undiscoverRecipe(dynamicSmithingRecipe.getKey());
        }
        for (DynamicCookingRecipe dynamicCookingRecipe : CustomRecipeRegistry.getCookingRecipes().values()) {
            if (!dynamicCookingRecipe.isHiddenFromBook() && (dynamicCookingRecipe.isUnlockedForEveryone() || profile.getUnlockedRecipes().contains(dynamicCookingRecipe.getName()) || allPermission || e.getPlayer().hasPermission("valhalla.recipe." + dynamicCookingRecipe.getName()))) {
                e.getPlayer().discoverRecipe(dynamicCookingRecipe.getKey());
                continue;
            }
            e.getPlayer().undiscoverRecipe(dynamicCookingRecipe.getKey());
        }
    }
}

