/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.localization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.MaterialTranslationsDTO;
import me.athlaeos.valhallammo.localization.PluginTranslationDTO;
import me.athlaeos.valhallammo.utility.Utils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Material;

public class TranslationManager {
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private static PluginTranslationDTO pluginTranslations;
    private static PluginTranslationDTO defaultTranslations;
    private static MaterialTranslationsDTO materialTranslations;
    private static String language;

    public static String getTranslation(String key) {
        if (pluginTranslations == null) {
            return "";
        }
        Map<String, String> translations = pluginTranslations.getStringTranslations();
        String translation = translations.get(key);
        if (translation == null) {
            if (!key.contains("<lang.") && !translations.containsKey(key)) {
                ValhallaMMO.logWarning("No translated value mapped for key " + key);
            }
            return TranslationManager.translatePlaceholders(key);
        }
        return TranslationManager.translatePlaceholders(translation);
    }

    public static String getRawTranslation(String key) {
        if (pluginTranslations == null) {
            return "";
        }
        String translation = pluginTranslations.getStringTranslations().get(key);
        if (translation == null) {
            return null;
        }
        return TranslationManager.translatePlaceholders(translation);
    }

    public static PluginTranslationDTO getDefaultTranslations() {
        return defaultTranslations;
    }

    public static List<String> getListTranslation(String key) {
        if (pluginTranslations == null) {
            return new ArrayList<String>();
        }
        return pluginTranslations.getStringListTranslations().getOrDefault(key, new ArrayList());
    }

    public static String getIndexedString(int id) {
        if (pluginTranslations == null) {
            return "";
        }
        return pluginTranslations.getStringIndex().getOrDefault(id, "invalid_id_" + id);
    }

    public static List<String> getIndexedStringList(int id) {
        if (pluginTranslations == null) {
            return new ArrayList<String>();
        }
        return pluginTranslations.getStringListIndex().getOrDefault(id, Collections.singletonList("invalid_id_" + id));
    }

    public static String getMaterialTranslation(Material m) {
        if (materialTranslations == null) {
            return "";
        }
        return materialTranslations.getMaterialTranslations().getOrDefault(m.toString(), me.athlaeos.valhallammo.utility.StringUtils.toPascalCase(m.toString().replace("_", " ")));
    }

    public static MaterialTranslationsDTO getMaterialTranslations() {
        return materialTranslations;
    }

    public static String translatePlaceholders(String originalString) {
        if (originalString == null) {
            return null;
        }
        String[] matches = StringUtils.substringsBetween((String)originalString, (String)"<lang.", (String)">");
        if (matches == null) {
            return originalString;
        }
        for (String s : matches) {
            originalString = originalString.replace("<lang." + s + ">", TranslationManager.getTranslation(s));
        }
        return originalString;
    }

    public static List<String> translateListPlaceholders(List<String> originalList) {
        ArrayList<String> newList = new ArrayList<String>();
        if (originalList == null) {
            return newList;
        }
        for (String l : originalList) {
            String subString = StringUtils.substringBetween((String)l, (String)"<lang.", (String)">");
            if (subString == null) {
                newList.add(l);
                continue;
            }
            List<String> placeholderList = TranslationManager.getListTranslation(subString);
            if (placeholderList.isEmpty()) {
                newList.add(TranslationManager.translatePlaceholders(l));
                continue;
            }
            for (String s : placeholderList) {
                newList.add(TranslationManager.translatePlaceholders(s));
            }
        }
        return newList;
    }

    public static void load(String l) {
        language = l;
        ValhallaMMO.logInfo("Loading ValhallaMMO config with language " + l + " selected");
        try (BufferedReader langReader = new BufferedReader(new FileReader(new File(ValhallaMMO.getInstance().getDataFolder(), "/languages/" + l + ".json"), StandardCharsets.UTF_8));){
            pluginTranslations = (PluginTranslationDTO)gson.fromJson((Reader)langReader, PluginTranslationDTO.class);
        }
        catch (IOException exception) {
            ValhallaMMO.logSevere(exception.getMessage());
            exception.printStackTrace();
        }
        try (BufferedReader matReader = new BufferedReader(new FileReader(new File(ValhallaMMO.getInstance().getDataFolder(), "/languages/materials/" + l + ".json"), StandardCharsets.UTF_8));){
            materialTranslations = (MaterialTranslationsDTO)gson.fromJson((Reader)matReader, MaterialTranslationsDTO.class);
        }
        catch (IOException exception) {
            ValhallaMMO.logSevere(exception.getMessage());
            exception.printStackTrace();
        }
        int entriesAdded = 0;
        InputStream defaultStream = ((Object)((Object)ValhallaMMO.getInstance())).getClass().getResourceAsStream("/languages/en-us.json");
        if (defaultStream != null) {
            try (InputStreamReader defaultReader = new InputStreamReader(defaultStream, StandardCharsets.UTF_8);){
                defaultTranslations = (PluginTranslationDTO)gson.fromJson((Reader)defaultReader, PluginTranslationDTO.class);
                for (String key : defaultTranslations.getStringTranslations().keySet()) {
                    if (pluginTranslations.getStringTranslations().containsKey(key)) continue;
                    pluginTranslations.getStringTranslations().put(key, defaultTranslations.getStringTranslations().get(key));
                    if (entriesAdded == 0 && !l.equalsIgnoreCase("en-us")) {
                        ValhallaMMO.logWarning("Language file was outdated! New english entries added to /languages/" + l + ".json. Sorry for the spam, but if you don't use the default (en-us) be sure to keep track of and translate the following entries to your locale");
                    }
                    if (!l.equalsIgnoreCase("en-us")) {
                        ValhallaMMO.logWarning("string > " + key);
                    }
                    ++entriesAdded;
                }
                for (String key : defaultTranslations.getStringListTranslations().keySet()) {
                    if (pluginTranslations.getStringListTranslations().containsKey(key)) continue;
                    pluginTranslations.getStringListTranslations().put(key, defaultTranslations.getStringListTranslations().get(key));
                    if (entriesAdded == 0 && !l.equalsIgnoreCase("en-us")) {
                        ValhallaMMO.logWarning("Language file was outdated! New english entries added to /languages/" + l + ".json. Sorry for the spam, but if you don't use the default (en-us) be sure to keep track of and translate the following entries to your locale");
                    }
                    if (!l.equalsIgnoreCase("en-us")) {
                        ValhallaMMO.logWarning("list > " + key);
                    }
                    ++entriesAdded;
                }
            }
            catch (IOException exception) {
                ValhallaMMO.logSevere(exception.getMessage());
                exception.printStackTrace();
            }
            if (entriesAdded > 0) {
                try (FileWriter writer = new FileWriter(new File(ValhallaMMO.getInstance().getDataFolder(), "languages/" + l + ".json"), StandardCharsets.UTF_8);){
                    gson.toJson((Object)pluginTranslations, (Appendable)writer);
                }
                catch (IOException exception) {
                    ValhallaMMO.logSevere(exception.getMessage());
                    exception.printStackTrace();
                }
            }
        }
    }

    public static void translateItem(ItemBuilder item) {
        String displayName;
        if (item == null) {
            return;
        }
        if (item.getName() != null && (displayName = item.getName()).contains("<lang.")) {
            item.name(Utils.chat(TranslationManager.translatePlaceholders(displayName)));
        }
        if (item.getLore() != null) {
            List<Object> lore = item.getLore() == null ? new ArrayList() : item.getLore();
            List<Object> newLore = new ArrayList<String>();
            if (lore != null) {
                for (String string : lore) {
                    if (!string.contains("<lang.")) continue;
                    for (String s : TranslationManager.translateListPlaceholders(lore)) {
                        newLore.add(Utils.chat(s));
                    }
                }
                if (newLore.isEmpty()) {
                    newLore = lore;
                }
            }
            item.lore(newLore);
        }
    }

    public static String getLanguage() {
        return language;
    }
}

