/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.loot;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.loot.LootEntry;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;

public class LootPool {
    private final String parentTable;
    private final String key;
    private final Map<UUID, LootEntry> entries = new HashMap<UUID, LootEntry>();
    private final Collection<LootPredicate> predicates = new HashSet<LootPredicate>();
    private boolean weighted = false;
    private int weightedRolls = 1;
    private double bonusLuckRolls = 0.5;
    private double dropChance = 1.0;
    private double dropLuckChance = 0.0;
    private LootTable.PredicateSelection predicateSelection = LootTable.PredicateSelection.ANY;

    public LootPool(String key, String parentTable) {
        this.key = key;
        this.parentTable = parentTable;
    }

    public String getKey() {
        return this.key;
    }

    public String getParentTable() {
        return this.parentTable;
    }

    public LootEntry addEntry(ItemStack drop) {
        UUID random = UUID.randomUUID();
        LootEntry entry = new LootEntry(random, drop, this.key);
        this.entries.put(random, entry);
        return entry;
    }

    public Map<UUID, LootEntry> getEntries() {
        return this.entries;
    }

    public Collection<LootPredicate> getPredicates() {
        return this.predicates;
    }

    public int getWeightedRolls() {
        return this.weightedRolls;
    }

    public int getRolls(LootContext context) {
        return Utils.randomAverage((double)this.weightedRolls + (double)context.getLuck() * this.bonusLuckRolls);
    }

    public boolean isWeighted() {
        return this.weighted;
    }

    public double getBonusLuckRolls() {
        return this.bonusLuckRolls;
    }

    public LootTable.PredicateSelection getPredicateSelection() {
        return this.predicateSelection;
    }

    public double getDropChance() {
        return this.dropChance;
    }

    public double getDropLuckChance() {
        return this.dropLuckChance;
    }

    public void setWeightedRolls(int weightedRolls) {
        this.weightedRolls = weightedRolls;
    }

    public void setWeighted(boolean weighted) {
        this.weighted = weighted;
    }

    public void setBonusLuckRolls(double bonusLuckRolls) {
        this.bonusLuckRolls = bonusLuckRolls;
    }

    public void setPredicateSelection(LootTable.PredicateSelection predicateSelection) {
        this.predicateSelection = predicateSelection;
    }

    public void setDropChance(double dropChance) {
        this.dropChance = dropChance;
    }

    public void setDropLuckChance(double dropLuckChance) {
        this.dropLuckChance = dropLuckChance;
    }
}

