/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.loot;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import me.athlaeos.valhallammo.loot.LootPool;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import org.bukkit.Material;
import org.bukkit.loot.LootContext;

public class LootTable {
    private final String key;
    private final Map<String, LootPool> pools = new HashMap<String, LootPool>();
    private Material icon = Material.CHEST;
    private VanillaLootPreservationType vanillaLootPreservationType = VanillaLootPreservationType.KEEP;

    public LootTable(String key) {
        this.key = key;
    }

    public LootPool addPool(String key) {
        LootPool pool = new LootPool(key, this.key);
        this.pools.put(key, pool);
        return pool;
    }

    public String getKey() {
        return this.key;
    }

    public Material getIcon() {
        return this.icon;
    }

    public void setIcon(Material icon) {
        this.icon = icon;
    }

    public Map<String, LootPool> getPools() {
        return this.pools;
    }

    public VanillaLootPreservationType getVanillaLootPreservationType() {
        return this.vanillaLootPreservationType;
    }

    public void setVanillaLootPreservationType(VanillaLootPreservationType vanillaLootPreservationType) {
        this.vanillaLootPreservationType = vanillaLootPreservationType;
    }

    public boolean failsPredicates(PredicateSelection predicateSelection, LootType type, LootContext context, Collection<LootPredicate> predicates) {
        boolean bl;
        block6: {
            block5: {
                if (predicates.isEmpty()) {
                    return false;
                }
                switch (predicateSelection.ordinal()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case 1: {
                        if (!predicates.stream().allMatch(p -> !p.isCompatibleWithLootType(type) || p.test(context))) break;
                        break block5;
                    }
                    case 0: {
                        if (predicates.stream().anyMatch(p -> !p.isCompatibleWithLootType(type) || p.test(context))) break block5;
                    }
                }
                bl = true;
                break block6;
            }
            bl = false;
        }
        return bl;
    }

    public static enum VanillaLootPreservationType {
        CLEAR,
        CLEAR_UNLESS_EMPTY,
        KEEP;

    }

    public static enum PredicateSelection {
        ANY,
        ALL;

    }

    public static enum LootType {
        BREAK,
        CONTAINER,
        FISH,
        KILL,
        PIGLIN_BARTER,
        ARCHAEOLOGY,
        VILLAGER,
        VAULT;

    }
}

