/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.loot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.IngredientChoice;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.dom.Weighted;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.loot.LootEntry;
import me.athlaeos.valhallammo.loot.LootPool;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.loot.LootTableConfiguration;
import me.athlaeos.valhallammo.loot.ReplacementEntry;
import me.athlaeos.valhallammo.loot.ReplacementPool;
import me.athlaeos.valhallammo.loot.ReplacementTable;
import me.athlaeos.valhallammo.loot.ReplacementTableConfiguration;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import me.athlaeos.valhallammo.persistence.GsonAdapter;
import me.athlaeos.valhallammo.persistence.ItemStackGSONAdapter;
import me.athlaeos.valhallammo.shaded.com.jeff_media.customblockdata.CustomBlockData;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTables;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class LootTableRegistry {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(LootPredicate.class, new GsonAdapter("PRED_TYPE")).registerTypeAdapter(DynamicItemModifier.class, new GsonAdapter("MOD_TYPE")).registerTypeAdapter(Weighted.class, new GsonAdapter("WEIGHTED_IMPL")).registerTypeAdapter(IngredientChoice.class, new GsonAdapter("CHOICE")).registerTypeHierarchyAdapter(ConfigurationSerializable.class, (Object)new ItemStackGSONAdapter()).setPrettyPrinting().disableHtmlEscaping().enableComplexMapKeySerialization().create();
    private static final NamespacedKey STORED_LOOT_TABLE = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "loot_table");
    private static final NamespacedKey FREE_SELECTION_TABLE = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "free_selection_loot_table");
    private static final NamespacedKey FREE_SELECTION_ALLOW_DUPLICATES = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "free_selection_allow_duplicates");
    private static final NamespacedKey LOOT_ITEM_SOUND = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "loot_item_sound");
    private static final Map<String, ReplacementTable> replacementTables = new HashMap<String, ReplacementTable>();
    private static final Map<String, String> blockReplacementTables = new HashMap<String, String>();
    private static final Map<String, String> entityReplacementTables = new HashMap<String, String>();
    private static final Map<NamespacedKey, String> keyedReplacementTables = new HashMap<NamespacedKey, String>();
    private static String globalReplacementTable = null;
    private static final Map<String, Map<String, ReplacementPool>> replacementTableCache = new HashMap<String, Map<String, ReplacementPool>>();
    private static final Map<String, LootTable> lootTables = new HashMap<String, LootTable>();
    private static final Map<String, String> blockLootTables = new HashMap<String, String>();
    private static final Map<String, String> entityLootTables = new HashMap<String, String>();
    private static final Map<NamespacedKey, String> lootTableAdditions = new HashMap<NamespacedKey, String>();
    private static String fishingLootTableFish;
    private static String fishingLootTableTreasure;
    private static String fishingLootTableJunk;
    private static String fishingReplacementTableFish;
    private static String fishingReplacementTableTreasure;
    private static String fishingReplacementTableJunk;
    private static LootTableConfiguration lootTableConfiguration;
    private static ReplacementTableConfiguration replacementTableConfiguration;

    public static void loadFiles() {
        File f = new File(ValhallaMMO.getInstance().getDataFolder(), "/loot_table_config.json");
        try {
            f.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (BufferedReader lootConfigReader = new BufferedReader(new FileReader(f, StandardCharsets.UTF_8));){
            LootTableConfiguration configuration = (LootTableConfiguration)gson.fromJson((Reader)lootConfigReader, LootTableConfiguration.class);
            if (configuration == null) {
                configuration = new LootTableConfiguration();
            }
            lootTableConfiguration = configuration;
            LootTableRegistry.applyConfiguration(configuration);
        }
        catch (IOException exception) {
            ValhallaMMO.logSevere(exception.getMessage());
            exception.printStackTrace();
        }
        File lootTablesFolder = new File(ValhallaMMO.getInstance().getDataFolder(), "/loot_tables");
        lootTablesFolder.mkdirs();
        File[] lootTables = lootTablesFolder.listFiles();
        if (lootTables != null) {
            for (File lootTable : lootTables) {
                MinecraftVersion fileVersionFilter;
                if (!lootTable.getName().endsWith(".json") || (fileVersionFilter = (MinecraftVersion)Arrays.stream(MinecraftVersion.values()).filter(v -> v.getVersionString() != null && lootTable.getName().contains(v.getVersionString() + "+")).findFirst().orElse(null)) != null && !MinecraftVersion.currentVersionNewerThan(fileVersionFilter)) continue;
                LootTableRegistry.loadFromFile(lootTable);
            }
        }
        File f2 = new File(ValhallaMMO.getInstance().getDataFolder(), "/replacement_table_config.json");
        try {
            f2.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (BufferedReader lootConfigReader = new BufferedReader(new FileReader(f2, StandardCharsets.UTF_8));){
            ReplacementTableConfiguration configuration = (ReplacementTableConfiguration)gson.fromJson((Reader)lootConfigReader, ReplacementTableConfiguration.class);
            if (configuration == null) {
                configuration = new ReplacementTableConfiguration();
            }
            replacementTableConfiguration = configuration;
            LootTableRegistry.applyConfiguration(configuration);
        }
        catch (IOException exception) {
            ValhallaMMO.logSevere(exception.getMessage());
            exception.printStackTrace();
        }
        File replacementTablesFolder = new File(ValhallaMMO.getInstance().getDataFolder(), "/replacement_tables");
        replacementTablesFolder.mkdirs();
        File[] replacementTables = replacementTablesFolder.listFiles();
        if (replacementTables != null) {
            for (File lootTable : replacementTables) {
                MinecraftVersion fileVersionFilter;
                if (!lootTable.getName().endsWith(".json") || (fileVersionFilter = (MinecraftVersion)Arrays.stream(MinecraftVersion.values()).filter(v -> v.getVersionString() != null && lootTable.getName().contains(v.getVersionString() + "+")).findFirst().orElse(null)) != null && !MinecraftVersion.currentVersionNewerThan(fileVersionFilter)) continue;
                LootTableRegistry.loadReplacementTableFromFile(lootTable);
            }
        }
    }

    public static void applyConfiguration(LootTableConfiguration lootTableConfiguration) {
        if (lootTableConfiguration == null) {
            return;
        }
        blockLootTables.putAll(lootTableConfiguration.getBlockLootTables());
        entityLootTables.putAll(lootTableConfiguration.getEntityLootTables());
        lootTableAdditions.putAll(lootTableConfiguration.getLootTableAdditions());
        if (lootTableConfiguration.getFishingLootTableFish() != null) {
            fishingLootTableFish = lootTableConfiguration.getFishingLootTableFish();
        }
        if (lootTableConfiguration.getFishingLootTableJunk() != null) {
            fishingLootTableJunk = lootTableConfiguration.getFishingLootTableJunk();
        }
        if (lootTableConfiguration.getFishingLootTableTreasure() != null) {
            fishingLootTableTreasure = lootTableConfiguration.getFishingLootTableTreasure();
        }
    }

    public static void applyConfiguration(ReplacementTableConfiguration replacementTableConfiguration) {
        if (replacementTableConfiguration == null) {
            return;
        }
        blockReplacementTables.putAll(replacementTableConfiguration.getBlockReplacementTables());
        entityReplacementTables.putAll(replacementTableConfiguration.getEntityReplacementTables());
        keyedReplacementTables.putAll(replacementTableConfiguration.getKeyedReplacementTables());
        if (replacementTableConfiguration.getGlobalReplacementTable() != null) {
            globalReplacementTable = replacementTableConfiguration.getGlobalReplacementTable();
        }
        if (replacementTableConfiguration.getFishingReplacementTableFish() != null) {
            fishingReplacementTableFish = replacementTableConfiguration.getFishingReplacementTableFish();
        }
        if (replacementTableConfiguration.getFishingReplacementTableFish() != null) {
            fishingReplacementTableJunk = replacementTableConfiguration.getFishingReplacementTableJunk();
        }
        if (replacementTableConfiguration.getFishingReplacementTableJunk() != null) {
            fishingReplacementTableTreasure = replacementTableConfiguration.getFishingReplacementTableTreasure();
        }
    }

    public static LootTableConfiguration getLootTableConfiguration() {
        return lootTableConfiguration;
    }

    public static ReplacementTableConfiguration getReplacementTableConfiguration() {
        return replacementTableConfiguration;
    }

    public static void loadLootTable(File file) {
        LootTableRegistry.loadFromFile(file);
    }

    public static void loadFromFile(File file) {
        try (BufferedReader tableReader = new BufferedReader(new FileReader(file, StandardCharsets.UTF_8));){
            LootTable table = (LootTable)gson.fromJson((Reader)tableReader, LootTable.class);
            LootTableRegistry.registerLootTable(table, true);
        }
        catch (IOException exception) {
            ValhallaMMO.logSevere(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public static void loadReplacementTableFromFile(File file) {
        try (BufferedReader tableReader = new BufferedReader(new FileReader(file, StandardCharsets.UTF_8));){
            ReplacementTable table = (ReplacementTable)gson.fromJson((Reader)tableReader, ReplacementTable.class);
            LootTableRegistry.registerReplacementTable(table, true);
        }
        catch (IOException exception) {
            ValhallaMMO.logSevere(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public static ItemStack getReplacement(ReplacementTable table, LootContext context, LootTable.LootType type, ItemStack toReplace) {
        if (table == null) {
            return null;
        }
        Map cachedTableMap = replacementTableCache.computeIfAbsent(table.getKey(), key -> new HashMap());
        ReplacementPool pool = cachedTableMap.compute(toReplace.toString(), (key, cached) -> {
            if (cached == null) {
                for (ReplacementPool possible : table.getReplacementPools().values()) {
                    if (!possible.getToReplace().getOption().matches(possible.getToReplace().getItem(), toReplace)) continue;
                    return possible;
                }
                return ReplacementPool.NONE;
            }
            return cached;
        });
        if (pool == ReplacementPool.NONE || table.failsPredicates(pool.getPredicateSelection(), type, context, pool.getPredicates())) {
            return null;
        }
        Collection<ReplacementEntry> entries = pool.getEntries().values();
        entries.removeIf(entry -> context.getKiller() == null && DynamicItemModifier.requiresPlayer(entry.getModifiers()) || table.failsPredicates(entry.getPredicateSelection(), type, context, entry.getPredicates()));
        List<ReplacementEntry> weighted = Utils.weightedSelection(entries, 1, context.getLuck(), context.getLootingModifier());
        if (weighted.isEmpty()) {
            return null;
        }
        ReplacementEntry selectedEntry = weighted.get(0);
        if (selectedEntry == null || ItemUtils.isEmpty(selectedEntry.getReplaceBy())) {
            return null;
        }
        ItemBuilder builder = selectedEntry.tinker() ? new ItemBuilder(toReplace) : new ItemBuilder(selectedEntry.getReplaceBy());
        DynamicItemModifier.modify(ModifierContext.builder(builder).crafter((Player)context.getKiller()).executeUsageMechanics().validate().get(), selectedEntry.getModifiers());
        return CustomFlag.hasFlag(builder.getMeta(), CustomFlag.UNCRAFTABLE) ? null : builder.get();
    }

    public static List<ItemStack> getLoot(LootTable table, LootContext context, LootTable.LootType type) {
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        for (LootPool pool : table.getPools().values()) {
            if (table.failsPredicates(pool.getPredicateSelection(), type, context, pool.getPredicates()) || Utils.getRandom().nextDouble() > pool.getDropChance() + pool.getDropLuckChance() * (double)context.getLuck()) continue;
            ArrayList passed = new ArrayList();
            ArrayList<LootEntry> selectedEntries = new ArrayList<LootEntry>();
            for (LootEntry entry : pool.getEntries().values()) {
                if (table.failsPredicates(entry.getPredicateSelection(), type, context, entry.getPredicates())) continue;
                (entry.isGuaranteedPresent() ? selectedEntries : passed).add(entry);
            }
            if (passed.isEmpty() && selectedEntries.isEmpty()) continue;
            if (pool.isWeighted()) {
                selectedEntries.addAll(Utils.weightedSelection(passed, pool.getRolls(context), context.getLuck(), context.getLootingModifier()));
            } else {
                for (LootEntry entry : passed) {
                    if (!Utils.proc(entry.getChance(context.getLuck()), 0.0, true)) continue;
                    selectedEntries.add(entry);
                }
            }
            for (LootEntry selectedEntry : selectedEntries) {
                ItemStack item;
                if (ItemUtils.isEmpty(selectedEntry.getDrop())) continue;
                if (selectedEntry.getModifiers().isEmpty()) {
                    item = selectedEntry.getDrop().clone();
                } else {
                    ItemBuilder builder = new ItemBuilder(selectedEntry.getDrop());
                    if (context.getKiller() == null && DynamicItemModifier.requiresPlayer(selectedEntry.getModifiers())) continue;
                    DynamicItemModifier.modify(ModifierContext.builder(builder).crafter((Player)context.getKiller()).executeUsageMechanics().validate().get(), selectedEntry.getModifiers());
                    if (CustomFlag.hasFlag(builder.getMeta(), CustomFlag.UNCRAFTABLE)) continue;
                    item = builder.get();
                }
                int quantityMin = Utils.randomAverage((float)selectedEntry.getBaseQuantityMin() + (float)Math.max(0, context.getLootingModifier()) * selectedEntry.getQuantityMinFortuneBase());
                int quantityMax = Utils.randomAverage((float)selectedEntry.getBaseQuantityMax() + (float)Math.max(0, context.getLootingModifier()) * selectedEntry.getQuantityMaxFortuneBase());
                if (quantityMax < quantityMin) {
                    quantityMax = quantityMin;
                }
                int quantity = Utils.getRandom().nextInt(Math.max(1, quantityMax - quantityMin + 1)) + quantityMin;
                int trueQuantity = selectedEntry.getDrop().getAmount() * quantity;
                if (trueQuantity > 0) {
                    loot.addAll(ItemUtils.decompressStacks(Map.of(item, trueQuantity)));
                    continue;
                }
                loot.add(item);
            }
        }
        return loot;
    }

    public static void saveAll() {
        new File(ValhallaMMO.getInstance().getDataFolder(), "/loot_tables").mkdirs();
        for (LootTable table : lootTables.values()) {
            File f2 = new File(ValhallaMMO.getInstance().getDataFolder(), "/loot_tables/" + table.getKey() + ".json");
            try {
                f2.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try (FileWriter writer = new FileWriter(f2);){
                gson.toJson((Object)table, (Appendable)writer);
            }
            catch (IOException exception) {
                ValhallaMMO.logSevere(exception.getMessage());
                exception.printStackTrace();
            }
        }
        LootTableConfiguration lootConfiguration = new LootTableConfiguration();
        lootConfiguration.getBlockLootTables().putAll(blockLootTables);
        lootConfiguration.getLootTableAdditions().putAll(lootTableAdditions);
        lootConfiguration.getEntityLootTables().putAll(entityLootTables);
        lootConfiguration.setFishingLootTableFish(fishingLootTableFish);
        lootConfiguration.setFishingLootTableJunk(fishingLootTableJunk);
        lootConfiguration.setFishingLootTableTreasure(fishingLootTableTreasure);
        File f = new File(ValhallaMMO.getInstance().getDataFolder(), "/loot_table_config.json");
        try {
            f.createNewFile();
        }
        catch (IOException f2) {
            // empty catch block
        }
        try (FileWriter writer = new FileWriter(f);){
            gson.toJson((Object)lootConfiguration, (Appendable)writer);
        }
        catch (IOException exception) {
            ValhallaMMO.logSevere(exception.getMessage());
            exception.printStackTrace();
        }
        new File(ValhallaMMO.getInstance().getDataFolder(), "/replacement_tables").mkdirs();
        for (ReplacementTable table : replacementTables.values()) {
            File f22 = new File(ValhallaMMO.getInstance().getDataFolder(), "/replacement_tables/" + table.getKey() + ".json");
            try {
                f22.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try (FileWriter writer = new FileWriter(f22);){
                gson.toJson((Object)table, (Appendable)writer);
            }
            catch (IOException exception) {
                ValhallaMMO.logSevere(exception.getMessage());
                exception.printStackTrace();
            }
        }
        ReplacementTableConfiguration replacementConfiguration = new ReplacementTableConfiguration();
        replacementConfiguration.getBlockReplacementTables().putAll(blockReplacementTables);
        replacementConfiguration.getKeyedReplacementTables().putAll(keyedReplacementTables);
        replacementConfiguration.getEntityReplacementTables().putAll(entityReplacementTables);
        replacementConfiguration.setGlobalReplacementTables(globalReplacementTable);
        replacementConfiguration.setFishingReplacementTableFish(fishingReplacementTableFish);
        replacementConfiguration.setFishingReplacementTableJunk(fishingReplacementTableJunk);
        replacementConfiguration.setFishingReplacementTableTreasure(fishingReplacementTableTreasure);
        File f2 = new File(ValhallaMMO.getInstance().getDataFolder(), "/replacement_table_config.json");
        try {
            f2.createNewFile();
        }
        catch (IOException f22) {
            // empty catch block
        }
        try (FileWriter writer = new FileWriter(f2);){
            gson.toJson((Object)replacementConfiguration, (Appendable)writer);
        }
        catch (IOException exception) {
            ValhallaMMO.logSevere(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public static void resetReplacementTableCache() {
        replacementTableCache.clear();
    }

    public static void registerLootTable(LootTable table, boolean overwrite) {
        if (overwrite || !lootTables.containsKey(table.getKey())) {
            lootTables.put(table.getKey(), table);
        }
    }

    public static void registerReplacementTable(ReplacementTable table, boolean overwrite) {
        if (overwrite || !replacementTables.containsKey(table.getKey())) {
            replacementTables.put(table.getKey(), table);
            LootTableRegistry.resetReplacementTableCache();
        }
    }

    public static LootTable getLootTable(Material block) {
        String table = blockLootTables.get(block.toString());
        if (table == null) {
            return null;
        }
        return lootTables.get(table);
    }

    public static LootTable getLootTable(EntityType entity) {
        String table = entityLootTables.get(entity.toString());
        if (table == null) {
            return null;
        }
        return lootTables.get(table);
    }

    public static ReplacementTable getReplacementTable(Material block) {
        String table = blockReplacementTables.get(block.toString());
        if (table == null) {
            return null;
        }
        return replacementTables.get(table);
    }

    public static ReplacementTable getReplacementTable(EntityType entity) {
        String table = entityReplacementTables.get(entity.toString());
        if (table == null) {
            return null;
        }
        return replacementTables.get(table);
    }

    public static LootTable getLootTable(LootTables lootTable) {
        return LootTableRegistry.getLootTable(lootTable.getKey());
    }

    public static ReplacementTable getReplacementTable(LootTables lootTable) {
        return LootTableRegistry.getReplacementTable(lootTable.getKey());
    }

    public static LootTable getLootTable(NamespacedKey lootTable) {
        String table = lootTableAdditions.get(lootTable);
        if (table == null) {
            return null;
        }
        return lootTables.get(table);
    }

    public static ReplacementTable getReplacementTable(NamespacedKey replacementTable) {
        String table = keyedReplacementTables.get(replacementTable);
        if (table == null) {
            return null;
        }
        return replacementTables.get(table);
    }

    public static LootTable getFishingFishLootTable() {
        if (fishingLootTableFish == null) {
            return null;
        }
        return lootTables.get(fishingLootTableFish);
    }

    public static LootTable getFishingTreasureLootTable() {
        if (fishingLootTableTreasure == null) {
            return null;
        }
        return lootTables.get(fishingLootTableTreasure);
    }

    public static LootTable getFishingJunkLootTable() {
        if (fishingLootTableJunk == null) {
            return null;
        }
        return lootTables.get(fishingLootTableJunk);
    }

    public static ReplacementTable getFishingFishReplacementTable() {
        if (fishingLootTableFish == null) {
            return null;
        }
        return replacementTables.get(fishingReplacementTableFish);
    }

    public static ReplacementTable getFishingTreasureReplacementTable() {
        if (fishingLootTableTreasure == null) {
            return null;
        }
        return replacementTables.get(fishingReplacementTableTreasure);
    }

    public static ReplacementTable getFishingJunkLReplacementTable() {
        if (fishingLootTableJunk == null) {
            return null;
        }
        return replacementTables.get(fishingReplacementTableJunk);
    }

    public static Map<String, String> getBlockLootTables() {
        return blockLootTables;
    }

    public static Map<String, String> getEntityLootTables() {
        return entityLootTables;
    }

    public static Map<NamespacedKey, String> getLootTableAdditions() {
        return lootTableAdditions;
    }

    public static Map<String, String> getBlockReplacementTables() {
        return blockReplacementTables;
    }

    public static Map<String, String> getEntityReplacementTables() {
        return entityReplacementTables;
    }

    public static Map<NamespacedKey, String> getKeyedReplacementTables() {
        return keyedReplacementTables;
    }

    public static String getGlobalReplacementTableName() {
        return globalReplacementTable;
    }

    public static ReplacementTable getGlobalReplacementTable() {
        return replacementTables.get(globalReplacementTable);
    }

    public static String getFishingLootTableFish() {
        return fishingLootTableFish;
    }

    public static String getFishingLootTableJunk() {
        return fishingLootTableJunk;
    }

    public static String getFishingLootTableTreasure() {
        return fishingLootTableTreasure;
    }

    public static String getFishingReplacementTableFish() {
        return fishingReplacementTableFish;
    }

    public static String getFishingReplacementTableJunk() {
        return fishingReplacementTableJunk;
    }

    public static String getFishingReplacementTableTreasure() {
        return fishingReplacementTableTreasure;
    }

    public static void setFishingLootTableFish(String fishingLootTableFish) {
        LootTableRegistry.fishingLootTableFish = fishingLootTableFish;
    }

    public static void setFishingLootTableTreasure(String fishingLootTableTreasure) {
        LootTableRegistry.fishingLootTableTreasure = fishingLootTableTreasure;
    }

    public static void setFishingLootTableJunk(String fishingLootTableJunk) {
        LootTableRegistry.fishingLootTableJunk = fishingLootTableJunk;
    }

    public static void setFishingReplacementTableJunk(String fishingReplacementTableJunk) {
        LootTableRegistry.fishingReplacementTableJunk = fishingReplacementTableJunk;
    }

    public static void setFishingReplacementTableFish(String fishingReplacementTableFish) {
        LootTableRegistry.fishingReplacementTableFish = fishingReplacementTableFish;
    }

    public static void setFishingReplacementTableTreasure(String fishingReplacementTableTreasure) {
        LootTableRegistry.fishingReplacementTableTreasure = fishingReplacementTableTreasure;
    }

    public static Map<String, LootTable> getLootTables() {
        return lootTables;
    }

    public static Map<String, ReplacementTable> getReplacementTables() {
        return replacementTables;
    }

    public static LootTable getLootTable(ItemMeta meta) {
        return lootTables.get(ItemUtils.getPDCString(STORED_LOOT_TABLE, meta, ""));
    }

    public static LootTable getLootTable(Entity e) {
        return lootTables.getOrDefault(e.getPersistentDataContainer().getOrDefault(STORED_LOOT_TABLE, PersistentDataType.STRING, (Object)""), LootTableRegistry.getLootTable(e.getType()));
    }

    public static LootTable getLootTable(Block b, Material def) {
        CustomBlockData customBlockData = new CustomBlockData(b, (Plugin)ValhallaMMO.getInstance());
        return lootTables.getOrDefault(customBlockData.getOrDefault(STORED_LOOT_TABLE, PersistentDataType.STRING, ""), LootTableRegistry.getLootTable(def));
    }

    public static void setLootTable(ItemMeta meta, LootTable table) {
        if (table == null) {
            meta.getPersistentDataContainer().remove(STORED_LOOT_TABLE);
        } else {
            meta.getPersistentDataContainer().set(STORED_LOOT_TABLE, PersistentDataType.STRING, (Object)table.getKey());
        }
    }

    public static void setLootTable(Entity e, LootTable table) {
        if (table == null) {
            e.getPersistentDataContainer().remove(STORED_LOOT_TABLE);
        } else {
            e.getPersistentDataContainer().set(STORED_LOOT_TABLE, PersistentDataType.STRING, (Object)table.getKey());
        }
    }

    public static void setLootTable(Block b, LootTable table) {
        CustomBlockData customBlockData = new CustomBlockData(b, (Plugin)ValhallaMMO.getInstance());
        if (table == null) {
            customBlockData.remove(STORED_LOOT_TABLE);
        } else {
            customBlockData.set(STORED_LOOT_TABLE, PersistentDataType.STRING, table.getKey());
        }
    }

    public static void setFreeSelectionTable(ItemMeta meta, boolean freeSelection, boolean allowRepeats) {
        if (freeSelection) {
            meta.getPersistentDataContainer().set(FREE_SELECTION_TABLE, PersistentDataType.BYTE, (Object)1);
        } else {
            meta.getPersistentDataContainer().remove(FREE_SELECTION_TABLE);
        }
        if (allowRepeats) {
            meta.getPersistentDataContainer().set(FREE_SELECTION_ALLOW_DUPLICATES, PersistentDataType.BYTE, (Object)1);
        } else {
            meta.getPersistentDataContainer().remove(FREE_SELECTION_ALLOW_DUPLICATES);
        }
    }

    public static boolean isFreeSelectionTable(ItemMeta meta) {
        return meta.getPersistentDataContainer().has(FREE_SELECTION_TABLE, PersistentDataType.BYTE);
    }

    public static boolean allowRepeatedFreeSelection(ItemMeta meta) {
        return meta.getPersistentDataContainer().has(FREE_SELECTION_ALLOW_DUPLICATES, PersistentDataType.BYTE);
    }

    public static void setGlobalReplacementTable(String globalReplacementTable) {
        LootTableRegistry.globalReplacementTable = globalReplacementTable;
    }

    public static void setLootSound(ItemMeta meta, Sound sound) {
        if (sound == null) {
            meta.getPersistentDataContainer().remove(LOOT_ITEM_SOUND);
        } else {
            meta.getPersistentDataContainer().set(LOOT_ITEM_SOUND, PersistentDataType.STRING, (Object)sound.toString());
        }
    }

    public static Sound getLootSound(ItemMeta meta) {
        try {
            return Utils.getSound((String)meta.getPersistentDataContainer().getOrDefault(LOOT_ITEM_SOUND, PersistentDataType.STRING, (Object)""));
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }
}

