/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.loot;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.SlotEntry;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.MaterialChoice;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.loot.ReplacementEntry;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ReplacementPool {
    public static final ReplacementPool NONE = new ReplacementPool("", "");
    private final String parentTable;
    private final String key;
    private final Map<UUID, ReplacementEntry> entries = new HashMap<UUID, ReplacementEntry>();
    private final Collection<LootPredicate> predicates = new HashSet<LootPredicate>();
    private LootTable.PredicateSelection predicateSelection = LootTable.PredicateSelection.ANY;
    private SlotEntry toReplace = new SlotEntry(new ItemStack(Material.IRON_PICKAXE), new MaterialChoice());

    public ReplacementPool(String key, String parentTable) {
        this.key = key;
        this.parentTable = parentTable;
    }

    public ReplacementPool(String key, String parentTable, ItemStack toReplace) {
        this.key = key;
        this.parentTable = parentTable;
        this.toReplace = new SlotEntry(toReplace, new MaterialChoice());
    }

    public ReplacementEntry addEntry(ItemStack drop) {
        UUID random = UUID.randomUUID();
        ReplacementEntry entry = new ReplacementEntry(random, this.key, drop);
        this.entries.put(random, entry);
        return entry;
    }

    public String getParentTable() {
        return this.parentTable;
    }

    public String getKey() {
        return this.key;
    }

    public SlotEntry getToReplace() {
        return this.toReplace;
    }

    public LootTable.PredicateSelection getPredicateSelection() {
        return this.predicateSelection;
    }

    public Collection<LootPredicate> getPredicates() {
        return this.predicates;
    }

    public Map<UUID, ReplacementEntry> getEntries() {
        return this.entries;
    }

    public void setToReplace(SlotEntry toReplace) {
        this.toReplace = toReplace;
    }

    public void setPredicateSelection(LootTable.PredicateSelection predicateSelection) {
        this.predicateSelection = predicateSelection;
    }
}

