/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.loot.predicates.implementations;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;

public class BiomeFilter
extends LootPredicate {
    private final Material icon;
    private final String name;
    private final Collection<NamespacedKey> biomes;

    public BiomeFilter(Material icon, String name, Biome ... biomes) {
        this.icon = icon;
        this.name = name;
        this.biomes = new HashSet<NamespacedKey>(Arrays.stream(biomes).map(Biome::getKey).toList());
    }

    public BiomeFilter(Material icon, String name, NamespacedKey ... biomes) {
        this.icon = icon;
        this.name = name;
        this.biomes = new HashSet<NamespacedKey>(Set.of(biomes));
    }

    @Override
    public String getKey() {
        return "biome_" + ChatColor.stripColor((String)Utils.chat(this.name)).toLowerCase(Locale.US).replace(" ", "_");
    }

    @Override
    public Material getIcon() {
        return this.icon;
    }

    @Override
    public String getDisplayName() {
        return "&fBiome Filter: " + this.name;
    }

    @Override
    public String getDescription() {
        return "&fRequires the environment to be within the " + this.name + " &fbiome";
    }

    @Override
    public String getActiveDescription() {
        return "&fRequires the environment to " + (this.isInverted() ? "&cNOT&f " : "") + "be within the " + this.name + " &fbiome";
    }

    @Override
    public LootPredicate createNew() {
        return new BiomeFilter(this.icon, this.name, this.biomes.toArray(new NamespacedKey[0]));
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(2, new ItemBuilder(Material.TNT).name("&eInvert Condition").lore(this.inverted ? "&cCondition is inverted" : "&aCondition not inverted", "&fInverted conditions must &cnot &fpass", "&fthis condition. ", "&6Click to toggle").get()).map(new HashSet());
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 2) {
            this.inverted = !this.inverted;
        }
    }

    @Override
    public boolean test(LootContext context) {
        Block b = context.getLocation().getBlock();
        return this.biomes.contains(b.getBiome().getKey()) != this.inverted;
    }
}

