/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.loot.predicates.implementations;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import me.athlaeos.valhallammo.utility.ItemUtils;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;

public class BlockMaterialFilter
extends LootPredicate {
    private final Collection<Material> blocks = new HashSet<Material>();

    @Override
    public String getKey() {
        return "container_block_material";
    }

    @Override
    public Material getIcon() {
        return Material.BARREL;
    }

    @Override
    public String getDisplayName() {
        return "&fBlock Material";
    }

    @Override
    public String getDescription() {
        return "&fRequires the container to be one of the given material types";
    }

    @Override
    public String getActiveDescription() {
        return "&fRequires the container to " + (this.isInverted() ? "&cNOT&f " : "") + "be one of &e" + this.blocks.stream().map(b -> b.toString().toLowerCase(Locale.US)).collect(Collectors.joining(", "));
    }

    @Override
    public LootPredicate createNew() {
        return new BlockMaterialFilter();
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(2, new ItemBuilder(Material.TNT).name("&eInvert Condition").lore(this.inverted ? "&cCondition is inverted" : "&aCondition not inverted", "&fInverted conditions must &cnot &fpass", "&fthis condition. ", "&6Click to toggle").appendLore(this.blocks.isEmpty() ? List.of("&cNone, condition always passes") : this.blocks.stream().map(b -> "&f>" + b.toString().toLowerCase(Locale.US)).toList()).get()).map(Set.of(new Pair<Integer, ItemStack>(12, new ItemBuilder(Material.TNT).name("&eSelect Type").lore("&6Click with item in cursor to", "&6add required block type", "&cShift-Click to clear list", "&fCurrently: ").appendLore(this.blocks.isEmpty() ? List.of("&cNone, condition always passes") : this.blocks.stream().map(b -> "&f>" + b.toString().toLowerCase(Locale.US)).toList()).get())));
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 2) {
            this.inverted = !this.inverted;
        } else if (button == 12) {
            if (!ItemUtils.isEmpty(e.getCursor()) && e.getCursor().getType().isBlock() && !e.isShiftClick()) {
                this.blocks.add(e.getCursor().getType());
            } else if (e.isShiftClick()) {
                this.blocks.clear();
            }
        }
    }

    @Override
    public boolean test(LootContext context) {
        if (this.blocks.isEmpty()) {
            return true;
        }
        return this.blocks.contains(context.getLocation().getBlock().getType()) != this.inverted;
    }

    @Override
    public boolean isCompatibleWithLootType(LootTable.LootType type) {
        return type == LootTable.LootType.CONTAINER;
    }
}

