/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.loot.predicates.implementations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.entities.EntityClassification;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.listeners.LootListener;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;

public class ContextEntityKillerFilter
extends LootPredicate {
    private static final List<EntityType> types = new ArrayList<EntityType>(EntityClassification.getEntityTypes(c -> c != EntityClassification.UNALIVE));
    private final Collection<EntityType> entities = new HashSet<EntityType>();
    private EntityType entity = EntityType.PLAYER;

    public ContextEntityKillerFilter() {
        types.sort(Comparator.comparing(Enum::toString));
    }

    @Override
    public String getKey() {
        return "context_entity_killer";
    }

    @Override
    public Material getIcon() {
        return Material.IRON_SWORD;
    }

    @Override
    public String getDisplayName() {
        return "&fEntity Killer";
    }

    @Override
    public String getDescription() {
        return "&fRequires responsible killer to be one of the given entity types. If none selected, the entity must be killed by nothing";
    }

    @Override
    public String getActiveDescription() {
        return "&fRequires the responsible killer to " + (this.isInverted() ? "&cNOT&f " : "") + "be one of &e" + this.entities.stream().map(Enum::toString).collect(Collectors.joining(", "));
    }

    @Override
    public LootPredicate createNew() {
        return new ContextEntityKillerFilter();
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        Object info;
        if (types.isEmpty()) {
            info = "&cNo entities found(???)";
        } else {
            int currentIndex;
            if (this.entity == null) {
                this.entity = types.get(0);
            }
            String before = (currentIndex = types.indexOf(this.entity)) <= 0 ? "" : String.valueOf(types.get(currentIndex - 1)) + " > &e";
            String after = currentIndex + 1 >= types.size() ? "" : "&f > " + String.valueOf(types.get(currentIndex + 1));
            info = "&f" + before + String.valueOf(this.entity) + after;
        }
        return new Pair<Integer, ItemStack>(2, new ItemBuilder(Material.TNT).name("&eInvert Condition").lore(this.inverted ? "&cCondition is inverted" : "&aCondition not inverted", "&fInverted conditions must &cnot &fpass", "&fthis condition. ", "&6Click to toggle").get()).map(Set.of(new Pair<Integer, ItemStack>(12, new ItemBuilder(Material.GRASS_BLOCK).name("&eSelect Entity Type").lore(new String[]{info, "&6Click to cycle", "&6Shift-Click to add to selection", "&cMiddle-Click to clear selection", "&fCurrently: "}).appendLore(types.isEmpty() ? List.of("&cNone, condition always passes") : types.stream().map(b -> "&f>" + String.valueOf(b)).toList()).get())));
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 2) {
            this.inverted = !this.inverted;
        } else if (button == 12) {
            if (e.isShiftClick()) {
                this.entities.add(this.entity);
            } else if (e.getClick() == ClickType.MIDDLE) {
                this.entities.clear();
            } else {
                if (types.isEmpty()) {
                    return;
                }
                int currentIndex = this.entity == null ? -1 : types.indexOf(this.entity);
                currentIndex = Math.max(0, Math.min(types.size() - 1, currentIndex + (e.isLeftClick() ? 1 : -1)));
                this.entity = types.get(currentIndex);
            }
        }
    }

    @Override
    public boolean test(LootContext context) {
        if (context.getLootedEntity() == null) {
            return this.inverted;
        }
        Entity killer = LootListener.getRealKiller(context.getLootedEntity());
        if (killer == null) {
            return this.inverted;
        }
        return this.entities.contains(killer.getType()) != this.inverted;
    }

    @Override
    public boolean isCompatibleWithLootType(LootTable.LootType type) {
        return type == LootTable.LootType.KILL;
    }

    static {
        types.add(EntityType.FALLING_BLOCK);
    }
}

