/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.loot.predicates.implementations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.dom.CustomDamageType;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.listeners.EntityDamagedListener;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;

public class DamageTypeDeathCauseFilter
extends LootPredicate {
    private final Collection<String> damageTypes = new HashSet<String>();
    private String damageType = null;

    @Override
    public String getKey() {
        return "death_cause";
    }

    @Override
    public Material getIcon() {
        return Material.GOLDEN_SWORD;
    }

    @Override
    public String getDisplayName() {
        return "&fDamage Type Cause of Death";
    }

    @Override
    public String getDescription() {
        return "&fRequires the entity to have died from a type of damage. ";
    }

    @Override
    public String getActiveDescription() {
        return "&fRequires the entity to " + (this.isInverted() ? "&cNOT&f " : "") + "have died from &e" + String.join((CharSequence)", ", this.damageTypes);
    }

    @Override
    public LootPredicate createNew() {
        return new DamageTypeDeathCauseFilter();
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        int currentIndex;
        ArrayList<String> damageTypes = new ArrayList<String>(CustomDamageType.getRegisteredTypes().keySet());
        if (this.damageType == null) {
            this.damageType = (String)damageTypes.get(0);
        }
        String before = (currentIndex = damageTypes.indexOf(this.damageType)) <= 0 ? "" : (String)damageTypes.get(currentIndex - 1) + " > &e";
        String after = currentIndex + 1 >= damageTypes.size() ? "" : "&f > " + (String)damageTypes.get(currentIndex + 1);
        String info = "&f" + before + this.damageType + after;
        return new Pair<Integer, ItemStack>(2, new ItemBuilder(Material.TNT).name("&eInvert Condition").lore(this.inverted ? "&cCondition is inverted" : "&aCondition not inverted", "&fInverted conditions must &cnot &fpass", "&fthis condition. ", "&6Click to toggle").get()).map(Set.of(new Pair<Integer, ItemStack>(12, new ItemBuilder(Material.GOLDEN_SWORD).name("&eSelect Damage Type").lore(info, "&6Click to cycle", "&6Shift-Click to add to selection", "&cMiddle-Click to clear selection", "&fCurrently: ").appendLore(damageTypes.isEmpty() ? List.of("&cNone, condition always passes") : damageTypes.stream().map(b -> "&f>" + b).toList()).get())));
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 2) {
            this.inverted = !this.inverted;
        } else if (button == 12) {
            if (e.isShiftClick()) {
                this.damageTypes.add(this.damageType);
            } else if (e.getClick() == ClickType.MIDDLE) {
                this.damageTypes.clear();
            } else {
                ArrayList<String> damageTypes = new ArrayList<String>(CustomDamageType.getRegisteredTypes().keySet());
                if (damageTypes.isEmpty()) {
                    return;
                }
                int currentIndex = this.damageType == null ? -1 : damageTypes.indexOf(this.damageType);
                currentIndex = Math.max(0, Math.min(damageTypes.size() - 1, currentIndex + (e.isLeftClick() ? 1 : -1)));
                this.damageType = (String)damageTypes.get(currentIndex);
            }
        }
    }

    @Override
    public boolean test(LootContext context) {
        CustomDamageType customType;
        Entity entity = context.getLootedEntity();
        if (!(entity instanceof LivingEntity)) {
            return this.inverted;
        }
        LivingEntity l = (LivingEntity)entity;
        String lastDamageCause = EntityDamagedListener.getLastDamageCause(l);
        CustomDamageType customDamageType = customType = lastDamageCause == null ? null : CustomDamageType.getCustomType(lastDamageCause);
        if (this.damageTypes.isEmpty() || customType == null) {
            return this.inverted;
        }
        return this.damageTypes.contains(customType.getType()) != this.inverted;
    }

    @Override
    public boolean isCompatibleWithLootType(LootTable.LootType type) {
        return type == LootTable.LootType.KILL;
    }
}

