/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.loot.predicates.implementations;

import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;

public class LuckFilter
extends LootPredicate {
    private int from = 0;

    @Override
    public String getKey() {
        return "luck";
    }

    @Override
    public Material getIcon() {
        return Material.RABBIT_FOOT;
    }

    @Override
    public String getDisplayName() {
        return "&fLuck";
    }

    @Override
    public String getDescription() {
        return "&fRequires a minimum of luck";
    }

    @Override
    public String getActiveDescription() {
        return "&fRequires luck to " + (this.isInverted() ? "&cNOT&f " : "") + "be above &e" + this.from;
    }

    @Override
    public LootPredicate createNew() {
        return new LuckFilter();
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(2, new ItemBuilder(Material.TNT).name("&eInvert Condition").lore(this.inverted ? "&cCondition is inverted" : "&aCondition not inverted", "&fInverted conditions must &cnot &fpass", "&fthis condition. ", "&6Click to toggle").get()).map(Set.of(new Pair<Integer, ItemStack>(12, new ItemBuilder(Material.LIGHT).name("&eSelect Luck Requirement").lore("&eIs currently " + this.from, "&fLuck must " + (this.isInverted() ? "&cNOT&f " : "") + "be above " + this.from, "&6Click to add/subtract 1", "&6Shift-Click to add/subtract 5").get())));
    }

    public void setFrom(int from) {
        this.from = from;
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 2) {
            this.inverted = !this.inverted;
        } else if (button == 12) {
            this.from += (e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 5 : 1);
        }
    }

    @Override
    public boolean test(LootContext context) {
        return context.getLuck() >= (float)this.from != this.inverted;
    }
}

