/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.loot.predicates.implementations;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.SmithingItemPropertyManager;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import me.athlaeos.valhallammo.utility.ItemUtils;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.loot.LootContext;

public class MinedWithTaggedToolFilter
extends LootPredicate {
    private final Collection<Integer> tags = new HashSet<Integer>();
    private int tag = 0;

    @Override
    public String getKey() {
        return "mined_with_tagged_tool";
    }

    @Override
    public Material getIcon() {
        return Material.NAME_TAG;
    }

    @Override
    public String getDisplayName() {
        return "&fMined with Tagged Tool";
    }

    @Override
    public String getDescription() {
        return "&fRequires the block to be mined with a tool having all of the specified smithing tags";
    }

    @Override
    public String getActiveDescription() {
        return "&fRequires the block to " + (this.isInverted() ? "&cNOT&f " : "") + "be mined with a tool having all of &e" + this.tags.stream().map(t -> t + "(" + SmithingItemPropertyManager.getTagLore(t) + ")").collect(Collectors.joining(", "));
    }

    @Override
    public LootPredicate createNew() {
        return new MinedWithTaggedToolFilter();
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(2, new ItemBuilder(Material.TNT).name("&eInvert Condition").lore(this.inverted ? "&cCondition is inverted" : "&aCondition not inverted", "&fInverted conditions must &cnot &fpass", "&fthis condition. ", "&6Click to toggle").get()).map(Set.of(new Pair<Integer, ItemStack>(12, new ItemBuilder(Material.GRASS_BLOCK).name("&eSelect Entity Type").lore("&f" + this.tag, "&6Click to cycle", "&6Shift-Click to add to selection", "&cMiddle-Click to clear selection", "&fCurrently: ").appendLore(this.tags.isEmpty() ? List.of("&cNone, condition always passes") : this.tags.stream().map(t -> "&f>" + t + "(" + SmithingItemPropertyManager.getTagLore(t) + ")").toList()).get())));
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 2) {
            this.inverted = !this.inverted;
        } else if (button == 12) {
            if (e.isShiftClick()) {
                this.tags.add(this.tag);
            } else if (e.getClick() == ClickType.MIDDLE) {
                this.tags.clear();
            } else {
                this.tag = Math.max(0, this.tag + (e.isLeftClick() ? 1 : -1));
            }
        }
    }

    @Override
    public boolean test(LootContext context) {
        if (this.tags.isEmpty()) {
            return this.inverted;
        }
        ItemStack tool = null;
        HumanEntity humanEntity = context.getKiller();
        if (humanEntity instanceof Player) {
            Player p = (Player)humanEntity;
            tool = p.getInventory().getItemInMainHand();
        } else {
            humanEntity = context.getLootedEntity();
            if (humanEntity instanceof Player) {
                Player p = (Player)humanEntity;
                tool = p.getInventory().getItemInMainHand();
            }
        }
        if (ItemUtils.isEmpty(tool)) {
            return this.inverted;
        }
        ItemMeta meta = ItemUtils.getItemMeta(tool);
        if (meta == null) {
            return this.inverted;
        }
        return SmithingItemPropertyManager.getTags(meta).keySet().containsAll(this.tags) != this.inverted;
    }

    @Override
    public boolean isCompatibleWithLootType(LootTable.LootType type) {
        return type == LootTable.LootType.BREAK || type == LootTable.LootType.KILL;
    }
}

