/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.loot.predicates.implementations;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.dom.Structures;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;

public class NearbyStructureFilter
extends LootPredicate {
    private static final List<String> structs = Arrays.stream(Structures.values()).map(Enum::toString).toList();
    private final Map<Structures, Integer> structures = new HashMap<Structures, Integer>();
    private String structure = "VILLAGE_TAIGA";
    private int range = 2;

    @Override
    public String getKey() {
        return "nearby_structure";
    }

    @Override
    public Material getIcon() {
        return Material.EMERALD;
    }

    @Override
    public String getDisplayName() {
        return "&fNearby Structure";
    }

    @Override
    public String getDescription() {
        return "&fRequires area to be within range of the given structure(s). &cNot recommended if no NMS version was registered on startup, because range parameter is ignored by many structures and can so cause lag.";
    }

    @Override
    public String getActiveDescription() {
        return "&fRequires the area to " + (this.isInverted() ? "&cNOT&f " : "") + "be within range of &e" + this.structures.keySet().stream().map(Enum::toString).collect(Collectors.joining(", "));
    }

    @Override
    public LootPredicate createNew() {
        return new NearbyStructureFilter();
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        Object info;
        if (structs.isEmpty()) {
            info = "&cNo structures found(???)";
        } else {
            int currentIndex;
            if (this.structure == null) {
                this.structure = "VILLAGE_TAIGA";
            }
            String before = (currentIndex = structs.indexOf(this.structure)) <= 0 ? "" : structs.get(currentIndex - 1) + " > &e";
            String after = currentIndex + 1 >= structs.size() ? "" : "&f > " + structs.get(currentIndex + 1);
            info = "&f" + before + this.structure + after;
        }
        return new Pair<Integer, ItemStack>(2, new ItemBuilder(Material.TNT).name("&eInvert Condition").lore(this.inverted ? "&cCondition is inverted" : "&aCondition not inverted", "&fInverted conditions must &cnot &fpass", "&fthis condition. ", "&6Click to toggle").get()).map(Set.of(new Pair<Integer, ItemStack>(20, new ItemBuilder(Material.EMERALD).name("&eAdd Villages").lore("&fAdds all village types to the list", "&fCurrently: ").appendLore(this.structures.isEmpty() ? List.of("&cNone, condition always passes") : this.structures.keySet().stream().map(b -> "&f>" + String.valueOf(b) + ":" + String.valueOf(this.structures.get(b))).toList()).get()), new Pair<Integer, ItemStack>(21, new ItemBuilder(Material.CRYING_OBSIDIAN).name("&eAdd Ruined Portals").lore("&fAdds all ruined portal types", "&fto the list", "&fCurrently: ").appendLore(this.structures.isEmpty() ? List.of("&cNone, condition always passes") : this.structures.keySet().stream().map(b -> "&f>" + String.valueOf(b) + ":" + String.valueOf(this.structures.get(b))).toList()).get()), new Pair<Integer, ItemStack>(22, new ItemBuilder(Material.NETHER_BRICK).name("&eAdd Nether Structures").lore("&fAdds all nether structure types", "&fto the list", "&fCurrently: ").appendLore(this.structures.isEmpty() ? List.of("&cNone, condition always passes") : this.structures.keySet().stream().map(b -> "&f>" + String.valueOf(b) + ":" + String.valueOf(this.structures.get(b))).toList()).get()), new Pair<Integer, ItemStack>(23, new ItemBuilder(Material.KELP).name("&eAdd Ocean Ruins").lore("&fAdds all ocean ruin types", "&fto the list", "&fCurrently: ").appendLore(this.structures.isEmpty() ? List.of("&cNone, condition always passes") : this.structures.keySet().stream().map(b -> "&f>" + String.valueOf(b) + ":" + String.valueOf(this.structures.get(b))).toList()).get()), new Pair<Integer, ItemStack>(24, new ItemBuilder(Material.OAK_PLANKS).name("&eAdd Shipwrecks").lore("&fAdds all shipwreck types to the list", "&fCurrently: ").appendLore(this.structures.isEmpty() ? List.of("&cNone, condition always passes") : this.structures.keySet().stream().map(b -> "&f>" + String.valueOf(b) + ":" + String.valueOf(this.structures.get(b))).toList()).get()), new Pair<Integer, ItemStack>(11, new ItemBuilder(Material.GRASS_BLOCK).name("&eSelect Structure Type").lore(new String[]{info, "&6Click to cycle", "&6Shift-Click to add to selection", "&cMiddle-Click to clear selection", "&fCurrently: "}).appendLore(this.structures.isEmpty() ? List.of("&cNone, condition always passes") : this.structures.keySet().stream().map(b -> "&f>" + String.valueOf(b) + ":" + String.valueOf(this.structures.get(b))).toList()).get()), new Pair<Integer, ItemStack>(13, new ItemBuilder(Material.GRASS_BLOCK).name("&eDetection Range").lore("&fSet to " + this.range, "&fDetermines the detection range in", "&fwhich to find structures.", "&eIN CHUNKS&f, should not be very", "&flarge or this will lag.", "&fUnexplored structures will not work.", "&6Click to add/subtract 1 (16bl)", "&6Shift-Click to add/subtract 4 (64bl)").get())));
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 2) {
            this.inverted = !this.inverted;
        } else if (button == 11) {
            if (e.isShiftClick()) {
                this.structures.put(Structures.valueOf(this.structure), this.range);
            } else if (e.getClick() == ClickType.MIDDLE) {
                this.structures.clear();
            } else {
                if (structs.isEmpty()) {
                    return;
                }
                int currentIndex = this.structure == null ? -1 : structs.indexOf(this.structure);
                currentIndex = Math.max(0, Math.min(structs.size() - 1, currentIndex + (e.isLeftClick() ? 1 : -1)));
                this.structure = structs.get(currentIndex);
            }
        } else if (button == 13) {
            this.range = Math.max(1, this.range + (e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 4 : 1));
        } else if (button == 20) {
            this.structures.put(Structures.VILLAGE_DESERT, this.range);
            this.structures.put(Structures.VILLAGE_PLAINS, this.range);
            this.structures.put(Structures.VILLAGE_SAVANNA, this.range);
            this.structures.put(Structures.VILLAGE_SNOWY, this.range);
            this.structures.put(Structures.VILLAGE_TAIGA, this.range);
        } else if (button == 21) {
            this.structures.put(Structures.RUINED_PORTAL, this.range);
            this.structures.put(Structures.RUINED_PORTAL_DESERT, this.range);
            this.structures.put(Structures.RUINED_PORTAL_JUNGLE, this.range);
            this.structures.put(Structures.RUINED_PORTAL_MOUNTAIN, this.range);
            this.structures.put(Structures.RUINED_PORTAL_NETHER, this.range);
            this.structures.put(Structures.RUINED_PORTAL_OCEAN, this.range);
            this.structures.put(Structures.RUINED_PORTAL_SWAMP, this.range);
        } else if (button == 22) {
            this.structures.put(Structures.BASTION_REMNANT, this.range);
            this.structures.put(Structures.FORTRESS, this.range);
        } else if (button == 23) {
            this.structures.put(Structures.OCEAN_RUIN_COLD, this.range);
            this.structures.put(Structures.OCEAN_RUIN_WARM, this.range);
        } else if (button == 24) {
            this.structures.put(Structures.SHIPWRECK, this.range);
            this.structures.put(Structures.SHIPWRECK_BEACHED, this.range);
        }
    }

    @Override
    public boolean test(LootContext context) {
        if (context.getLocation().getWorld() == null) {
            return this.inverted;
        }
        if (ValhallaMMO.getNms().getNearestStructure(context.getLocation().getWorld(), context.getLocation(), this.structures) != null) {
            return !this.inverted;
        }
        return this.inverted;
    }
}

