/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.nms;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.event.PlayerJumpEvent;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.listeners.JumpListener;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.utility.EntityUtils;
import me.athlaeos.valhallammo.utility.MathUtils;
import me.athlaeos.valhallammo.version.AttributeMappings;
import me.athlaeos.valhallammo.version.PotionEffectMappings;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInputEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;

public class JumpInputListener
implements Listener {
    private final Collection<UUID> holdingSpace = new HashSet<UUID>();
    private final Attribute jumpHeightAttribute = AttributeMappings.JUMP_STRENGTH.getAttribute();
    private final Map<UUID, Integer> jumpsLeft = new HashMap<UUID, Integer>();

    @EventHandler(priority=EventPriority.MONITOR)
    public void onJumpKey(PlayerInputEvent e) {
        if (!e.getInput().isJump()) {
            this.holdingSpace.remove(e.getPlayer().getUniqueId());
            return;
        }
        if (this.holdingSpace.contains(e.getPlayer().getUniqueId())) {
            return;
        }
        this.holdingSpace.add(e.getPlayer().getUniqueId());
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName()) || this.jumpsLeft.getOrDefault(e.getPlayer().getUniqueId(), 0) <= 0 || e.getPlayer().getGameMode() == GameMode.CREATIVE || e.getPlayer().getGameMode() == GameMode.SPECTATOR || EntityUtils.isOnGround((Entity)e.getPlayer()) || WorldGuardHook.inDisabledRegion(e.getPlayer().getLocation(), e.getPlayer(), "vmmo-double-jumping")) {
            return;
        }
        double jumpHeightBonus = 0.0;
        if (this.jumpHeightAttribute == null) {
            jumpHeightBonus = MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20_5) ? 0.0 : AccumulativeStatManager.getCachedStats("JUMP_HEIGHT_MULTIPLIER", (Entity)e.getPlayer(), 10000L, true);
        } else {
            AttributeInstance instance = e.getPlayer().getAttribute(this.jumpHeightAttribute);
            if (instance != null) {
                jumpHeightBonus = instance.getValue();
            }
        }
        PotionEffect jumpEffect = e.getPlayer().getPotionEffect(PotionEffectMappings.JUMP_BOOST.getPotionEffectType());
        double jumpLevel = 0.0;
        if (jumpEffect != null) {
            jumpLevel = jumpEffect.getAmplifier() + 1;
        }
        float f = e.getPlayer().getEyeLocation().getYaw() * ((float)Math.PI / 180);
        double motionX = e.getPlayer().getVelocity().getX() - (e.getPlayer().isSprinting() ? MathUtils.sin(f) * 0.2 : 0.0);
        double motionY = 0.42 + (jumpLevel += 2.0 * jumpHeightBonus) * (double)0.1f;
        double motionZ = e.getPlayer().getVelocity().getZ() + (e.getPlayer().isSprinting() ? MathUtils.cos(f) * 0.2 : 0.0);
        if (JumpListener.getMultiJumpAnimation() != null) {
            JumpListener.getMultiJumpAnimation().animate((LivingEntity)e.getPlayer(), e.getPlayer().getLocation(), e.getPlayer().getEyeLocation().getDirection(), 0);
        }
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> e.getPlayer().setVelocity(new Vector(motionX, motionY, motionZ)), 1L);
        e.getPlayer().setFallDistance(0.0f);
        int remainingJumps = this.jumpsLeft.getOrDefault(e.getPlayer().getUniqueId(), 0) - 1;
        this.jumpsLeft.put(e.getPlayer().getUniqueId(), remainingJumps);
    }

    @EventHandler
    public void onPlayerJump(PlayerJumpEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName())) {
            return;
        }
        int extraJumps = (int)AccumulativeStatManager.getCachedStats("JUMPS_BONUS", (Entity)e.getPlayer(), 10000L, true);
        if (extraJumps <= 0) {
            return;
        }
        this.jumpsLeft.put(e.getPlayer().getUniqueId(), extraJumps);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onFallDamage(EntityDamageEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || e.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        double jumpHeightBonus = AccumulativeStatManager.getCachedStats("JUMP_HEIGHT_MULTIPLIER", e.getEntity(), 10000L, true);
        if (jumpHeightBonus == 0.0) {
            return;
        }
        double fallDamage = Math.max(0.0, (double)(e.getEntity().getFallDistance() - 3.0f) - jumpHeightBonus);
        if (e.getEntity().getLocation().subtract(0.0, 0.2, 0.0).getBlock().getType() == Material.POINTED_DRIPSTONE) {
            fallDamage *= 2.0;
        }
        e.setDamage(fallDamage);
    }
}

