/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.nms;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.nms.NetworkHandler;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PacketListener
implements Listener {
    private final NetworkHandler handler;
    private final Map<UUID, Channel> channels = new HashMap<UUID, Channel>();

    public PacketListener(NetworkHandler handler) {
        this.handler = handler;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        this.addChannel(e.getPlayer());
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent e) {
        this.closeChannel(e.getPlayer());
    }

    public void addChannel(final Player p) {
        ChannelDuplexHandler duplexHandler = new ChannelDuplexHandler(this){
            final /* synthetic */ PacketListener this$0;
            {
                this.this$0 = this$0;
            }

            public void channelRead(ChannelHandlerContext ctx, Object packet) throws Exception {
                if (this.this$0.handler.readBefore(p, packet) == NetworkHandler.PacketStatus.DENY) {
                    return;
                }
                super.channelRead(ctx, packet);
                this.this$0.handler.readAfter(p, packet);
            }

            public void write(ChannelHandlerContext ctx, Object packet, ChannelPromise promise) throws Exception {
                if (this.this$0.handler.writeBefore(p, packet) == NetworkHandler.PacketStatus.DENY) {
                    return;
                }
                super.write(ctx, packet, promise);
                this.this$0.handler.writeAfter(p, packet);
            }
        };
        Channel channel = ValhallaMMO.getNms().channel(p);
        this.channels.put(p.getUniqueId(), channel);
        channel.pipeline().addBefore("packet_handler", "valhalla_" + String.valueOf(p.getUniqueId()), (ChannelHandler)duplexHandler);
    }

    public void closeChannel(Player p) {
        Channel channel = this.channels.get(p.getUniqueId());
        if (channel == null) {
            return;
        }
        channel.eventLoop().submit(() -> {
            channel.pipeline().remove("valhalla_" + String.valueOf(p.getUniqueId()));
            return null;
        });
    }

    public void addAll() {
        for (Player p : ValhallaMMO.getInstance().getServer().getOnlinePlayers()) {
            this.addChannel(p);
        }
    }

    public void closeAll() {
        for (Player p : ValhallaMMO.getInstance().getServer().getOnlinePlayers()) {
            this.closeChannel(p);
        }
    }

    public void sendPacket(Player p, Object packet) {
        Channel channel = this.channels.get(p.getUniqueId());
        if (channel == null) {
            return;
        }
        channel.pipeline().writeAndFlush(packet);
    }
}

