/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.parties;

import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.parties.Party;
import me.athlaeos.valhallammo.parties.PartyManager;
import me.athlaeos.valhallammo.placeholder.PlaceholderRegistry;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class PartyChatListener
implements Listener {
    private static boolean consoleSpyEnabled = true;

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChat(AsyncPlayerChatEvent e) {
        if (!e.getMessage().startsWith("pc:") && !PartyManager.getPartyChatPlayers().contains(e.getPlayer().getUniqueId())) {
            return;
        }
        if (PartyManager.getPartyChatPlayers().contains(e.getPlayer().getUniqueId()) && e.getMessage().startsWith("!")) {
            e.setMessage(e.getMessage().replaceFirst("!", ""));
            return;
        }
        Party party = PartyManager.getParty(e.getPlayer());
        if (party == null && e.getMessage().startsWith("pc:")) {
            e.setCancelled(true);
            PartyManager.ErrorStatus.NOT_IN_PARTY.sendErrorMessage((CommandSender)e.getPlayer());
            return;
        }
        if (party == null) {
            return;
        }
        e.setMessage(e.getMessage().replaceFirst("pc:", ""));
        PartyManager.ErrorStatus chatStatus = PartyManager.hasPermission(e.getPlayer(), "party_chat");
        if (chatStatus != null) {
            chatStatus.sendErrorMessage((CommandSender)e.getPlayer());
            e.setCancelled(true);
            return;
        }
        PartyManager.PartyRank rank = PartyManager.getPartyRanks().get(party.getMembers().getOrDefault(e.getPlayer().getUniqueId(), ""));
        String title = party.getLeader().equals(e.getPlayer().getUniqueId()) ? PartyManager.getLeaderTitle() : (rank != null ? rank.title() : "");
        String newChatFormat = PartyManager.getPartyChatFormat().replace("%rank%", title).replace("%party%", party.getDisplayName());
        newChatFormat = PlaceholderRegistry.parse(newChatFormat, e.getPlayer());
        newChatFormat = PlaceholderRegistry.parsePapi(newChatFormat, e.getPlayer());
        e.getRecipients().clear();
        e.setCancelled(true);
        for (Player p : PartyManager.getOnlinePartyMembers(party)) {
            p.sendMessage(String.format(Utils.chat(newChatFormat), e.getPlayer().getDisplayName(), e.getMessage()));
        }
        String spyChatMessage = PartyManager.getPartySpyFormat().replace("%rank%", title).replace("%party%", party.getDisplayName());
        spyChatMessage = PlaceholderRegistry.parse(spyChatMessage, e.getPlayer());
        spyChatMessage = PlaceholderRegistry.parsePapi(spyChatMessage, e.getPlayer());
        for (Player p : Utils.getOnlinePlayersFromUUIDs(PartyManager.getPartySpyPlayers()).values()) {
            if (party.getMembers().containsKey(p.getUniqueId()) || party.getLeader().equals(p.getUniqueId())) continue;
            p.sendMessage(String.format(Utils.chat(spyChatMessage), e.getPlayer().getDisplayName(), e.getMessage()));
        }
        if (consoleSpyEnabled) {
            Utils.sendMessage((CommandSender)ValhallaMMO.getInstance().getServer().getConsoleSender(), String.format(Utils.chat(spyChatMessage), e.getPlayer().getDisplayName(), e.getMessage()));
        }
    }

    public static boolean toggleConsoleSpyEnabled() {
        consoleSpyEnabled = !consoleSpyEnabled;
        return consoleSpyEnabled;
    }
}

