/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.persistence.implementations;

import com.google.common.collect.ClassToInstanceMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.listeners.JoinLeaveListener;
import me.athlaeos.valhallammo.persistence.implementations.SQL;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.params.SetParams;

public class RedisLockedSQL
extends SQL {
    private static final long LOCK_TIMEOUT = 5000L;
    private static final String EDITION_LOCK = "vmmo:player:lock";
    protected final Queue<List<Profile>> saveQueue = new ConcurrentLinkedQueue<List<Profile>>();
    private JedisPool pool;

    @Override
    public int minimumProfileThreadCount() {
        return 4;
    }

    public boolean acquireLock(String editionKey, String lockValue) {
        try (Jedis jedis = this.pool.getResource();){
            SetParams setParams = (SetParams)new SetParams().nx().px(5000L);
            String result = jedis.set("vmmo:player:lock:" + editionKey, lockValue, setParams);
            if (!result.equals("OK")) {
                boolean bl = false;
                return bl;
            }
            String value = jedis.get("vmmo:player:lock:" + editionKey);
            boolean bl = lockValue.equals(value);
            return bl;
        }
    }

    public boolean hasLock(String editionKey) {
        try (Jedis jedis = this.pool.getResource();){
            String currentLockValue = jedis.get("vmmo:player:lock:" + editionKey);
            boolean bl = currentLockValue != null;
            return bl;
        }
    }

    public void releaseLock(String editionKey, String lockValue) {
        try (Jedis jedis = this.pool.getResource();){
            String currentLockValue = jedis.get("vmmo:player:lock:" + editionKey);
            if (currentLockValue.equals(lockValue)) {
                jedis.del("vmmo:player:lock:" + editionKey);
            }
        }
    }

    public void startSaveQueue() {
        this.profileThreads.execute(() -> {
            while (!ValhallaMMO.disabling() || !this.saveQueue.isEmpty()) {
                String lock;
                List<Profile> profiles = this.saveQueue.poll();
                if (profiles == null || profiles.isEmpty()) {
                    return;
                }
                UUID owner = profiles.get(0).getOwner();
                String key = owner.toString();
                if (!this.acquireLock(key, lock = UUID.randomUUID().toString())) {
                    this.saveQueue.add(profiles);
                    return;
                }
                try {
                    for (Profile profile : profiles) {
                        if (profile.getOwner() == null) continue;
                        this.insertOrUpdateProfile(profile.getOwner(), profile);
                    }
                }
                finally {
                    this.saving.remove(owner);
                    this.releaseLock(key, lock);
                    Player player = Bukkit.getPlayer((UUID)owner);
                    if (player != null && player.isOnline()) continue;
                    this.uncacheProfile(owner);
                }
            }
        });
    }

    @Override
    public void saveProfile(UUID uuid) {
        String lock;
        CompletableFuture future = this.persistentProfiles.getIfPresent(uuid);
        if (future == null || !future.isDone()) {
            return;
        }
        if (!this.saving.add(uuid)) {
            return;
        }
        ClassToInstanceMap profiles = (ClassToInstanceMap)future.join();
        String lockKey = uuid.toString();
        if (!this.acquireLock(lockKey, lock = UUID.randomUUID().toString())) {
            this.saveQueue.add(new ArrayList(profiles.values()));
            return;
        }
        this.profileThreads.execute(() -> {
            try {
                if (!JoinLeaveListener.getLoadedProfiles().contains(uuid)) {
                    this.releaseLock(lockKey, lock);
                    return;
                }
                for (Profile profile : profiles.values()) {
                    this.insertOrUpdateProfile(uuid, profile);
                }
            }
            finally {
                this.saving.remove(uuid);
                this.releaseLock(lockKey, lock);
                Player player = Bukkit.getPlayer((UUID)uuid);
                if (player == null || !player.isOnline()) {
                    this.uncacheProfile(uuid);
                }
            }
        });
    }

    public JedisPool getPool() {
        if (this.pool != null) {
            return this.pool;
        }
        try {
            this.pool = new JedisPool(ValhallaMMO.getPluginConfig().getString("redis_url", "redis://127.0.0.1:6379"));
        }
        catch (Exception ex) {
            this.pool = null;
            ValhallaMMO.getInstance().getLogger().severe("Failed to initialize Jedis connection");
            ex.printStackTrace();
        }
        return this.pool;
    }
}

