/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.persistence.implementations;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.persistence.ProfilePersistence;
import org.bukkit.configuration.file.YamlConfiguration;

public class SQL
extends ProfilePersistence {
    private Connection conn;

    @Override
    public int minimumProfileThreadCount() {
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection(boolean migrating) {
        try {
            if (this.conn != null && !this.conn.isClosed()) {
                return this.conn;
            }
            YamlConfiguration config = ConfigManager.getConfig("config.yml").reload().get();
            String host = config.getString("db_host");
            String database = config.getString("db_database");
            String username = config.getString("db_username");
            String password = config.getString("db_password");
            int port = config.getInt("db_port");
            int ping_delay = config.getInt("db_ping_delay");
            ValhallaMMO valhallaMMO = ValhallaMMO.getInstance();
            synchronized (valhallaMMO) {
                Class.forName("com.mysql.jdbc.Driver");
                this.conn = DriverManager.getConnection("jdbc:mysql://" + host + ":" + port + "/" + database, username, password);
                if (migrating) {
                    return this.conn;
                }
                ValhallaMMO.logFine("MySQL Database connection created!");
                this.profileThreads.scheduleAtFixedRate(() -> {
                    try {
                        this.conn.prepareStatement("/* ping */ SELECT 1;").execute();
                    }
                    catch (SQLException ex) {
                        throw new RuntimeException("Database ping failed", ex);
                    }
                }, ping_delay, ping_delay, TimeUnit.MILLISECONDS);
            }
            return this.conn;
        }
        catch (Exception e) {
            ValhallaMMO.logInfo("Database connection failed " + String.valueOf(e));
            return null;
        }
    }

    @Override
    public void addColumnIfNotExists(String tableName, String columnName, String columnType) {
        try {
            PreparedStatement procedureCreationStatement = this.conn.prepareStatement("SELECT " + columnName + " FROM " + tableName + ";");
            procedureCreationStatement.execute();
        }
        catch (SQLException e) {
            try {
                PreparedStatement procedureCreationStatement = this.conn.prepareStatement("ALTER TABLE " + tableName + " ADD COLUMN " + columnName + " " + columnType + ";");
                procedureCreationStatement.execute();
            }
            catch (SQLException ex) {
                ValhallaMMO.logSevere("SQLException when trying to add column " + columnName + " " + columnType + " to " + tableName + ". ");
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getType() {
        return "mysql";
    }
}

