/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.placeholder.placeholders;

import me.athlaeos.valhallammo.placeholder.Placeholder;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import org.bukkit.entity.Player;

public class NumericProfileStatPlaceholder
extends Placeholder {
    private StatFormat format;
    private final Class<? extends Profile> type;
    private final String stat;

    public NumericProfileStatPlaceholder(String placeholder, Class<? extends Profile> type, String stat, StatFormat format) {
        super(placeholder);
        this.type = type;
        this.stat = stat;
        this.format = format;
    }

    public StatFormat getFormat() {
        return this.format;
    }

    public void setFormat(StatFormat format) {
        this.format = format;
    }

    @Override
    public String parse(String s, Player p) {
        Profile profile = ProfileCache.getOrCache(p, this.type);
        if (profile.intStatNames().contains(this.stat)) {
            return s.replace(this.placeholder, this.format.format(profile.getInt(this.stat)));
        }
        if (profile.floatStatNames().contains(this.stat)) {
            return s.replace(this.placeholder, this.format.format(Float.valueOf(profile.getFloat(this.stat))));
        }
        if (profile.doubleStatNames().contains(this.stat)) {
            return s.replace(this.placeholder, this.format.format(profile.getDouble(this.stat)));
        }
        throw new IllegalArgumentException("Numeric stat placeholder uses stat " + this.stat + ", but it's not a number");
    }
}

