/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.playerstats;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.block.DigPacketInfo;
import me.athlaeos.valhallammo.entities.EntityClassification;
import me.athlaeos.valhallammo.entities.MonsterScalingManager;
import me.athlaeos.valhallammo.item.WeightClass;
import me.athlaeos.valhallammo.listeners.MovementListener;
import me.athlaeos.valhallammo.parties.PartyManager;
import me.athlaeos.valhallammo.placeholder.PlaceholderRegistry;
import me.athlaeos.valhallammo.placeholder.placeholders.TotalRawStatPlaceholder;
import me.athlaeos.valhallammo.placeholder.placeholders.TotalStatPlaceholder;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatSource;
import me.athlaeos.valhallammo.playerstats.EvEAccumulativeStatSource;
import me.athlaeos.valhallammo.playerstats.StatCollector;
import me.athlaeos.valhallammo.playerstats.StatCollectorBuilder;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.AlchemyProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.ArcheryProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.DiggingProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.EnchantingProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.FarmingProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.FishingProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.HeavyArmorProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.HeavyWeaponsProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.LightArmorProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.LightWeaponsProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.MiningProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.SmithingProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.WoodcuttingProfile;
import me.athlaeos.valhallammo.playerstats.statsources.ArcheryChargedShotInaccuracySource;
import me.athlaeos.valhallammo.playerstats.statsources.ArcheryChargedShotVelocitySource;
import me.athlaeos.valhallammo.playerstats.statsources.ArmorPenetrationBreachEnchantmentSource;
import me.athlaeos.valhallammo.playerstats.statsources.AttributeAttackerSource;
import me.athlaeos.valhallammo.playerstats.statsources.AttributeDefenderSource;
import me.athlaeos.valhallammo.playerstats.statsources.AttributeSource;
import me.athlaeos.valhallammo.playerstats.statsources.DefensiveSourceSource;
import me.athlaeos.valhallammo.playerstats.statsources.DiggingStatSource;
import me.athlaeos.valhallammo.playerstats.statsources.FishingLuckFullMoonSource;
import me.athlaeos.valhallammo.playerstats.statsources.FishingLuckLotSSource;
import me.athlaeos.valhallammo.playerstats.statsources.FishingLuckNewMoonSource;
import me.athlaeos.valhallammo.playerstats.statsources.FishingLuckRainSource;
import me.athlaeos.valhallammo.playerstats.statsources.GlobalBuffSource;
import me.athlaeos.valhallammo.playerstats.statsources.MainHandPenalty;
import me.athlaeos.valhallammo.playerstats.statsources.MiningDrillingActiveSource;
import me.athlaeos.valhallammo.playerstats.statsources.MiningStatSource;
import me.athlaeos.valhallammo.playerstats.statsources.MiningUnbreakableBlocksSource;
import me.athlaeos.valhallammo.playerstats.statsources.PermissionStatSource;
import me.athlaeos.valhallammo.playerstats.statsources.PotionEffectAttackerSource;
import me.athlaeos.valhallammo.playerstats.statsources.PotionEffectSingleUseSource;
import me.athlaeos.valhallammo.playerstats.statsources.PotionEffectSource;
import me.athlaeos.valhallammo.playerstats.statsources.ProfileArmorlessArmorSource;
import me.athlaeos.valhallammo.playerstats.statsources.ProfileStatAttackerHeldItemSource;
import me.athlaeos.valhallammo.playerstats.statsources.ProfileStatAttackerSource;
import me.athlaeos.valhallammo.playerstats.statsources.ProfileStatAttackerVictimClassSource;
import me.athlaeos.valhallammo.playerstats.statsources.ProfileStatAttackerWeightSource;
import me.athlaeos.valhallammo.playerstats.statsources.ProfileStatDefenderArmorWeightSetSource;
import me.athlaeos.valhallammo.playerstats.statsources.ProfileStatDefenderArmorWeightSource;
import me.athlaeos.valhallammo.playerstats.statsources.ProfileStatSource;
import me.athlaeos.valhallammo.playerstats.statsources.ProfileStatWeightSource;
import me.athlaeos.valhallammo.playerstats.statsources.ResistanceArmorWeightClassSource;
import me.athlaeos.valhallammo.playerstats.statsources.ResistanceDamageResistanceSource;
import me.athlaeos.valhallammo.playerstats.statsources.ResistanceEnchantmentSource;
import me.athlaeos.valhallammo.playerstats.statsources.SetBonusSource;
import me.athlaeos.valhallammo.playerstats.statsources.TotalHeavyArmorSource;
import me.athlaeos.valhallammo.playerstats.statsources.TotalLightArmorSource;
import me.athlaeos.valhallammo.playerstats.statsources.TotalWeightlessArmorSource;
import me.athlaeos.valhallammo.playerstats.statsources.VanillaAttributeDefenderSource;
import me.athlaeos.valhallammo.playerstats.statsources.WoodcuttingStatSource;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.EnchantmentMappings;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AccumulativeStatManager {
    private static final Map<String, StatCollector> sources = new HashMap<String, StatCollector>();
    private static final Map<UUID, Map<String, Map.Entry<Long, Double>>> STAT_CACHE;
    private static long lastMapCleanup;

    public static Map<String, StatCollector> getSources() {
        return sources;
    }

    public static void register(String stat, AccumulativeStatSource ... s) {
        StatCollector existingSource = sources.get(stat);
        if (existingSource == null) {
            existingSource = new StatCollectorBuilder().addSources(s).build();
            PlaceholderRegistry.registerPlaceholder(new TotalStatPlaceholder("%stat_source_" + stat.toLowerCase(Locale.US) + "%", stat));
            PlaceholderRegistry.registerPlaceholder(new TotalRawStatPlaceholder("%stat_source_raw_" + stat.toLowerCase(Locale.US) + "%", stat));
        } else {
            existingSource.getStatSources().addAll(Arrays.asList(s));
        }
        AccumulativeStatManager.register(stat, existingSource);
    }

    public static void registerOffensive(String stat, AccumulativeStatSource ... s) {
        StatCollector existingSource = sources.get(stat);
        if (existingSource == null) {
            existingSource = new StatCollectorBuilder().addSources(s).setAttackerPossessive().build();
            PlaceholderRegistry.registerPlaceholder(new TotalStatPlaceholder("%stat_source_" + stat.toLowerCase(Locale.US) + "%", stat));
            PlaceholderRegistry.registerPlaceholder(new TotalRawStatPlaceholder("%stat_source_raw_" + stat.toLowerCase(Locale.US) + "%", stat));
        } else {
            existingSource.getStatSources().addAll(Arrays.asList(s));
        }
        AccumulativeStatManager.register(stat, existingSource);
    }

    public static void register(String stat, StatCollector collector) {
        sources.put(stat, collector);
    }

    public static StatCollector getStatCollector(String stat) {
        if (!sources.containsKey(stat)) {
            throw new IllegalArgumentException("A stat collector with the name " + stat + " was fetched, but it does not exist");
        }
        return sources.get(stat);
    }

    public static double getStats(String stat, Entity e, boolean use) {
        LivingEntity l;
        StatCollector collector = AccumulativeStatManager.getStatCollector(stat);
        Collection<AccumulativeStatSource> existingSources = collector.getStatSources();
        double value = 0.0;
        for (AccumulativeStatSource s : existingSources) {
            value += s.fetch(e, use);
        }
        if (!collector.isAttackerPossessive() && e instanceof LivingEntity && !((l = (LivingEntity)e) instanceof Player)) {
            value += MonsterScalingManager.getStatValue(l, stat);
        }
        if (!collector.isAttackerPossessive() && e instanceof Player) {
            Player p = (Player)e;
            value += PartyManager.getCompanyStats(p, stat);
        }
        return (double)Math.round(value * 1000000.0) / 1000000.0;
    }

    public static double getRelationalStats(String stat, Entity e1, Entity e2, boolean use) {
        LivingEntity l;
        LivingEntity l2;
        if (e1 == null) {
            return 0.0;
        }
        if (e2 == null) {
            return AccumulativeStatManager.getStats(stat, e1, use);
        }
        StatCollector collector = AccumulativeStatManager.getStatCollector(stat);
        Collection<AccumulativeStatSource> existingSources = collector.getStatSources();
        double value = 0.0;
        for (AccumulativeStatSource s : existingSources) {
            if (s instanceof EvEAccumulativeStatSource) {
                EvEAccumulativeStatSource os = (EvEAccumulativeStatSource)((Object)s);
                value += os.fetch(e1, e2, use);
                continue;
            }
            value += s.fetch(e1, use);
        }
        if (collector.isAttackerPossessive() && e2 instanceof LivingEntity && !((l2 = (LivingEntity)e2) instanceof Player)) {
            value += MonsterScalingManager.getStatValue(l2, stat);
        } else if (!collector.isAttackerPossessive() && e1 instanceof LivingEntity && !((l = (LivingEntity)e1) instanceof Player)) {
            value += MonsterScalingManager.getStatValue(l, stat);
        }
        if (collector.isAttackerPossessive() && e2 instanceof Player) {
            Player p = (Player)e2;
            value += PartyManager.getCompanyStats(p, stat);
        } else if (!collector.isAttackerPossessive() && e1 instanceof Player) {
            Player p = (Player)e1;
            value += PartyManager.getCompanyStats(p, stat);
        }
        return Utils.round6Decimals(value);
    }

    public static double getCachedStats(String stat, Entity p, long refreshAfter, boolean use) {
        if (p == null) {
            return 0.0;
        }
        Double cachedValue = AccumulativeStatManager.getValidCachedStat(p, stat);
        if (cachedValue != null) {
            return cachedValue;
        }
        double statValue = AccumulativeStatManager.getStats(stat, p, use);
        AccumulativeStatManager.cacheStat(p, stat, statValue, refreshAfter);
        return statValue;
    }

    public static double getCachedRelationalStats(String stat, Entity victimPrimary, Entity attacker, long refreshAfter, boolean use) {
        if (victimPrimary == null) {
            return 0.0;
        }
        Double cachedValue = AccumulativeStatManager.getValidCachedStat(victimPrimary, stat);
        if (cachedValue != null) {
            return cachedValue;
        }
        double statValue = AccumulativeStatManager.getRelationalStats(stat, victimPrimary, attacker, use);
        AccumulativeStatManager.cacheStat(victimPrimary, stat, statValue, refreshAfter);
        return statValue;
    }

    public static double getCachedAttackerRelationalStats(String stat, Entity victim, Entity attackerPrimary, long refreshAfter, boolean use) {
        if (victim == null || attackerPrimary == null) {
            return 0.0;
        }
        Double cachedValue = AccumulativeStatManager.getValidCachedStat(attackerPrimary, stat);
        if (cachedValue != null) {
            return cachedValue;
        }
        double statValue = AccumulativeStatManager.getRelationalStats(stat, victim, attackerPrimary, use);
        AccumulativeStatManager.cacheStat(attackerPrimary, stat, statValue, refreshAfter);
        return statValue;
    }

    private static double getCachedStatIgnoringExpiration(Entity e, String stat) {
        Map currentCachedStats = STAT_CACHE.getOrDefault(e.getUniqueId(), new HashMap());
        if (currentCachedStats.get(stat) != null) {
            return (Double)((Map.Entry)currentCachedStats.get(stat)).getValue();
        }
        return 0.0;
    }

    public static void cacheStat(Entity e, String stat, double amount, long cacheFor) {
        STAT_CACHE.compute(e.getUniqueId(), (uuid, cache) -> {
            if (cache == null) {
                cache = new HashMap<String, AbstractMap.SimpleEntry<Long, Double>>();
            }
            cache.put(stat, new AbstractMap.SimpleEntry<Long, Double>(System.currentTimeMillis() + cacheFor, amount));
            return cache;
        });
    }

    private static boolean isStatCached(Entity e, String stat) {
        return AccumulativeStatManager.getValidCachedStat(e, stat) != null;
    }

    private static Double getValidCachedStat(Entity e, String stat) {
        AccumulativeStatManager.attemptMapCleanup();
        Map<String, Map.Entry<Long, Double>> stats = STAT_CACHE.get(e.getUniqueId());
        if (stats == null) {
            return null;
        }
        Map.Entry<Long, Double> cache = stats.get(stat);
        return cache != null && cache.getKey() > System.currentTimeMillis() ? cache.getValue() : null;
    }

    private static void attemptMapCleanup() {
        Bukkit.getScheduler().runTask((Plugin)ValhallaMMO.getInstance(), () -> {
            if (lastMapCleanup + 120000L < System.currentTimeMillis()) {
                for (UUID uuid : new HashSet<UUID>(STAT_CACHE.keySet())) {
                    Entity entity = Bukkit.getEntity((UUID)uuid);
                    if (entity != null && entity.isValid()) continue;
                    STAT_CACHE.remove(uuid);
                }
                lastMapCleanup = System.currentTimeMillis();
            }
        });
    }

    public static void uncacheStat(Entity e, String stat) {
        Map<String, Map.Entry<Long, Double>> stats = STAT_CACHE.get(e.getUniqueId());
        if (stats != null) {
            stats.remove(stat);
        }
    }

    public static void uncacheStat(UUID uuid, String stat) {
        Map<String, Map.Entry<Long, Double>> stats = STAT_CACHE.get(uuid);
        if (stats != null) {
            stats.remove(stat);
        }
    }

    public static void uncache(UUID uuid) {
        STAT_CACHE.remove(uuid);
    }

    public static void uncache(Entity e) {
        STAT_CACHE.remove(e.getUniqueId());
    }

    public static void uncacheProfile(Player player, Class<? extends Profile> type) {
        AccumulativeStatManager.uncacheProfile(player.getUniqueId(), type);
    }

    public static void uncacheProfile(UUID uuid, Class<? extends Profile> type) {
        AccumulativeStatManager.uncache(uuid);
        ProfileCache.resetCache(uuid, type);
    }

    public static void resetAllCaches(UUID uuid) {
        AccumulativeStatManager.uncache(uuid);
        MovementListener.resetAttributeStats(uuid);
        ProfileCache.resetCache(uuid);
        DigPacketInfo.resetMinerCache(uuid);
    }

    public static void resetAllCaches(Entity e) {
        AccumulativeStatManager.uncache(e);
        if (e instanceof Player) {
            Player p = (Player)e;
            MovementListener.resetAttributeStats(p);
            ProfileCache.resetCache(p);
            DigPacketInfo.resetMinerCache(e.getUniqueId());
        }
    }

    static {
        AccumulativeStatManager.register("GLOBAL_EXP_GAIN", new PermissionStatSource("valhalla.exp.all"), new ProfileStatSource(PowerProfile.class, "allSkillEXPMultiplier"), new GlobalBuffSource("percent_skill_exp_gain"), new AttributeSource("SKILL_EXP_GAIN"), new PotionEffectSource("SKILL_EXP_GAIN"));
        AccumulativeStatManager.register("ARMOR_TOTAL", new DefensiveSourceSource("TOTAL_LIGHT_ARMOR"), new DefensiveSourceSource("TOTAL_HEAVY_ARMOR"), new DefensiveSourceSource("TOTAL_WEIGHTLESS_ARMOR"));
        AccumulativeStatManager.register("TOTAL_LIGHT_ARMOR", new TotalLightArmorSource());
        AccumulativeStatManager.register("LIGHT_ARMOR", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setArmorBonus", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "armorBonusPerPiece", WeightClass.LIGHT), new VanillaAttributeDefenderSource("GENERIC_ARMOR", AttributeModifier.Operation.ADD_NUMBER).weight(WeightClass.LIGHT).penalty("armor"), new PotionEffectSource("LIGHT_ARMOR"));
        AccumulativeStatManager.register("LIGHT_ARMOR_MULTIPLIER", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setArmorMultiplier", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "armorMultiplierPerPiece", WeightClass.LIGHT), new ProfileStatSource(LightArmorProfile.class, "lightArmorMultiplier"));
        AccumulativeStatManager.register("TOTAL_HEAVY_ARMOR", new TotalHeavyArmorSource());
        AccumulativeStatManager.register("HEAVY_ARMOR", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setArmorBonus", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "armorBonusPerPiece", WeightClass.HEAVY), new VanillaAttributeDefenderSource("GENERIC_ARMOR", AttributeModifier.Operation.ADD_NUMBER).weight(WeightClass.HEAVY).penalty("armor"), new PotionEffectSource("HEAVY_ARMOR"));
        AccumulativeStatManager.register("HEAVY_ARMOR_MULTIPLIER", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setArmorMultiplier", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "armorMultiplierPerPiece", WeightClass.HEAVY), new ProfileStatSource(HeavyArmorProfile.class, "heavyArmorMultiplier"));
        AccumulativeStatManager.register("TOTAL_WEIGHTLESS_ARMOR", new ProfileArmorlessArmorSource(), new SetBonusSource("GENERIC_ARMOR"), new TotalWeightlessArmorSource());
        AccumulativeStatManager.register("WEIGHTLESS_ARMOR", new VanillaAttributeDefenderSource("GENERIC_ARMOR", AttributeModifier.Operation.ADD_NUMBER).weight(WeightClass.WEIGHTLESS).penalty("armor"), new ProfileStatSource(PowerProfile.class, "armorBonus"), new GlobalBuffSource("armor_bonus"), new PotionEffectSource("ARMOR_FLAT"));
        AccumulativeStatManager.register("ARMOR_MULTIPLIER_BONUS", new VanillaAttributeDefenderSource("GENERIC_ARMOR", AttributeModifier.Operation.ADD_SCALAR), new ProfileStatSource(PowerProfile.class, "armorMultiplierBonus"), new GlobalBuffSource("fraction_armor_bonus"), new PotionEffectSource("ARMOR_FRACTION"));
        AccumulativeStatManager.register("TOUGHNESS", new VanillaAttributeDefenderSource("GENERIC_ARMOR_TOUGHNESS", AttributeModifier.Operation.ADD_NUMBER).penalty("armor"), new DefensiveSourceSource("TOUGHNESS_BONUS"));
        AccumulativeStatManager.registerOffensive("LIGHT_ARMOR_FLAT_IGNORED", new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "penetrationFlatLight", WeightClass.HEAVY), new ProfileStatAttackerWeightSource(LightWeaponsProfile.class, "penetrationFlatLight", WeightClass.LIGHT), new AttributeAttackerSource("LIGHT_ARMOR_PENETRATION_FLAT").penalty("attribute"), new PotionEffectAttackerSource("LIGHT_ARMOR_PENETRATION_FLAT"));
        AccumulativeStatManager.registerOffensive("LIGHT_ARMOR_FRACTION_IGNORED", new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "penetrationFractionLight", WeightClass.HEAVY), new ProfileStatAttackerWeightSource(LightWeaponsProfile.class, "penetrationFractionLight", WeightClass.LIGHT), new AttributeAttackerSource("LIGHT_ARMOR_PENETRATION_FRACTION").penalty("attribute"), new PotionEffectAttackerSource("LIGHT_ARMOR_PENETRATION_FRACTION"));
        AccumulativeStatManager.registerOffensive("HEAVY_ARMOR_FLAT_IGNORED", new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "penetrationFlatHeavy", WeightClass.HEAVY), new ProfileStatAttackerWeightSource(LightWeaponsProfile.class, "penetrationFlatHeavy", WeightClass.LIGHT), new AttributeAttackerSource("HEAVY_ARMOR_PENETRATION_FLAT").penalty("attribute"), new PotionEffectAttackerSource("HEAVY_ARMOR_PENETRATION_FLAT"));
        AccumulativeStatManager.registerOffensive("HEAVY_ARMOR_FRACTION_IGNORED", new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "penetrationFractionHeavy", WeightClass.HEAVY), new ProfileStatAttackerWeightSource(LightWeaponsProfile.class, "penetrationFractionHeavy", WeightClass.LIGHT), new AttributeAttackerSource("HEAVY_ARMOR_PENETRATION_FRACTION").penalty("attribute"), new PotionEffectAttackerSource("HEAVY_ARMOR_PENETRATION_FRACTION"));
        AccumulativeStatManager.registerOffensive("ARMOR_FLAT_IGNORED", new ArmorPenetrationBreachEnchantmentSource(false), new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "penetrationFlat", WeightClass.HEAVY), new ProfileStatAttackerWeightSource(LightWeaponsProfile.class, "penetrationFlat", WeightClass.LIGHT), new GlobalBuffSource("armor_penetration"), new AttributeAttackerSource("ARMOR_PENETRATION_FLAT").penalty("attribute"), new PotionEffectAttackerSource("ARMOR_PENETRATION_FLAT"));
        AccumulativeStatManager.registerOffensive("ARMOR_FRACTION_IGNORED", new ArmorPenetrationBreachEnchantmentSource(true), new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "penetrationFraction", WeightClass.HEAVY), new ProfileStatAttackerWeightSource(LightWeaponsProfile.class, "penetrationFraction", WeightClass.LIGHT), new GlobalBuffSource("fraction_armor_penetration"), new AttributeAttackerSource("ARMOR_PENETRATION_FRACTION").penalty("attribute"), new PotionEffectAttackerSource("ARMOR_PENETRATION_FRACTION"));
        AccumulativeStatManager.register("BACK_PROTECTION", new ProfileStatSource(PowerProfile.class, "backDamageReduction"), new AttributeDefenderSource("BACK_PROTECTION"), new PotionEffectSource("BACK_PROTECTION"));
        AccumulativeStatManager.register("FRONT_PROTECTION", new ProfileStatSource(PowerProfile.class, "frontDamageReduction"), new AttributeDefenderSource("FRONT_PROTECTION"), new PotionEffectSource("FRONT_PROTECTION"));
        AccumulativeStatManager.register("DAMAGE_ABSORPTION", new ProfileStatSource(PowerProfile.class, "damageAbsorption"), new AttributeDefenderSource("DAMAGE_ABSORPTION"), new PotionEffectSource("DAMAGE_ABSORPTION"));
        AccumulativeStatManager.register("HEALTH_BONUS", new SetBonusSource("GENERIC_MAX_HEALTH"), new ProfileStatSource(PowerProfile.class, "healthBonus"), new GlobalBuffSource("health_bonus"), new PotionEffectSource("MAX_HEALTH_FLAT"));
        AccumulativeStatManager.register("HEALTH_MULTIPLIER_BONUS", new ProfileStatSource(PowerProfile.class, "healthMultiplier"), new GlobalBuffSource("fraction_health_bonus"), new PotionEffectSource("MAX_HEALTH_FRACTION"));
        AccumulativeStatManager.register("MOVEMENT_SPEED_BONUS", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setMovementSpeed", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setMovementSpeed", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "movementSpeedPerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "movementSpeedPerPiece", WeightClass.LIGHT), new SetBonusSource("GENERIC_MOVEMENT_SPEED"), new ProfileStatSource(PowerProfile.class, "movementSpeedBonus"), new GlobalBuffSource("movement_speed"), new PotionEffectSource("MOVEMENT_SPEED"));
        AccumulativeStatManager.register("KNOCKBACK_RESISTANCE", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setKnockbackResistance", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setKnockbackResistance", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "knockbackResistancePerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "knockbackResistancePerPiece", WeightClass.LIGHT), new SetBonusSource("GENERIC_KNOCKBACK_RESISTANCE"), new ResistanceArmorWeightClassSource("knockback_resistance"), new ProfileStatSource(PowerProfile.class, "knockbackResistanceBonus"), new GlobalBuffSource("knockback_resistance"), new PotionEffectSource("KNOCKBACK_RESISTANCE"));
        AccumulativeStatManager.register("TOUGHNESS_BONUS", new SetBonusSource("GENERIC_ARMOR_TOUGHNESS"), new ProfileStatSource(PowerProfile.class, "toughnessBonus"), new GlobalBuffSource("toughness_bonus"), new PotionEffectSource("ARMOR_TOUGHNESS_FLAT"));
        AccumulativeStatManager.register("ATTACK_DAMAGE_BONUS", new SetBonusSource("GENERIC_ATTACK_DAMAGE"), new ProfileStatSource(PowerProfile.class, "attackDamageBonus"), new GlobalBuffSource("attack_damage_bonus"), new PotionEffectSource("EXTRA_ATTACK_DAMAGE"));
        AccumulativeStatManager.register("ATTACK_SPEED_BONUS", new SetBonusSource("GENERIC_ATTACK_SPEED"), new ProfileStatWeightSource(HeavyWeaponsProfile.class, "attackSpeedMultiplier", WeightClass.HEAVY, false), new ProfileStatWeightSource(LightWeaponsProfile.class, "attackSpeedMultiplier", WeightClass.LIGHT, false), new MainHandPenalty("speed"), new ProfileStatSource(PowerProfile.class, "attackSpeedBonus"), new GlobalBuffSource("fraction_attack_speed_bonus"), new PotionEffectSource("ATTACK_SPEED"));
        AccumulativeStatManager.register("LUCK_BONUS", new SetBonusSource("GENERIC_LUCK"), new ProfileStatSource(PowerProfile.class, "luckBonus"), new GlobalBuffSource("luck_bonus"), new PotionEffectSource("CUSTOM_LUCK"));
        AccumulativeStatManager.register("BLOCK_REACH", new SetBonusSource("GENERIC_BLOCK_INTERACTION_RANGE"), new ProfileStatSource(PowerProfile.class, "blockReachBonus"), new PotionEffectSource("GENERIC_BLOCK_INTERACTION_RANGE"), new GlobalBuffSource("block_reach"));
        AccumulativeStatManager.register("STEP_HEIGHT", new SetBonusSource("GENERIC_STEP_HEIGHT"), new ProfileStatSource(PowerProfile.class, "stepHeightBonus"), new PotionEffectSource("GENERIC_STEP_HEIGHT"), new GlobalBuffSource("step_height"));
        AccumulativeStatManager.register("SCALE", new SetBonusSource("GENERIC_SCALE"), new ProfileStatSource(PowerProfile.class, "scaleMultiplier"), new PotionEffectSource("GENERIC_SCALE"), new GlobalBuffSource("scale"));
        AccumulativeStatManager.register("GRAVITY", new SetBonusSource("GENERIC_GRAVITY"), new ProfileStatSource(PowerProfile.class, "gravity"), new PotionEffectSource("GENERIC_GRAVITY"), new GlobalBuffSource("gravity"));
        AccumulativeStatManager.register("SAFE_FALLING_DISTANCE", new SetBonusSource("GENERIC_SAFE_FALL_DISTANCE"), new ProfileStatSource(PowerProfile.class, "safeFallingDistance"), new PotionEffectSource("GENERIC_SAFE_FALL_DISTANCE"), new GlobalBuffSource("safe_falling_distance"));
        AccumulativeStatManager.register("FALL_DAMAGE_MULTIPLIER", new SetBonusSource("GENERIC_FALL_DAMAGE_MULTIPLIER"), new PotionEffectSource("GENERIC_FALL_DAMAGE_MULTIPLIER"), new GlobalBuffSource("fall_damage_multiplier"));
        AccumulativeStatManager.register("WATER_MOVEMENT_EFFICIENCY_BONUS", new ProfileStatSource(PowerProfile.class, "waterMovementEfficiencyBonus"), new PotionEffectSource("WATER_MOVEMENT_EFFICIENCY_BONUS"));
        AccumulativeStatManager.register("SUBMERGED_MINING_SPEED_BONUS", new ProfileStatSource(PowerProfile.class, "submergedMiningSpeedBonus"), new PotionEffectSource("SUBMERGED_MINING_SPEED_BONUS"));
        AccumulativeStatManager.register("FLIGHT_SPEED_BONUS", new PotionEffectSource("FLIGHT_SPEED_BONUS"));
        AccumulativeStatManager.register("OXYGEN_BONUS", new ProfileStatSource(PowerProfile.class, "oxygenBonus"), new PotionEffectSource("OXYGEN_BONUS"));
        AccumulativeStatManager.registerOffensive("DAMAGE_DEALT", new ProfileStatAttackerVictimClassSource(FarmingProfile.class, "butcheryDamageMultiplier", EntityClassification.ANIMAL), new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "damageMultiplier", WeightClass.HEAVY), new ProfileStatAttackerWeightSource(LightWeaponsProfile.class, "damageMultiplier", WeightClass.LIGHT), new AttributeAttackerSource("DAMAGE_ALL").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "attackDamageMultiplier"), new GlobalBuffSource("fraction_damage_bonus"), new PotionEffectAttackerSource("DAMAGE_ALL"));
        AccumulativeStatManager.registerOffensive("MELEE_DAMAGE_DEALT", new AttributeAttackerSource("DAMAGE_MELEE").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "meleeAttackDamageMultiplier"), new GlobalBuffSource("fraction_melee_damage_bonus"), new PotionEffectAttackerSource("DAMAGE_MELEE"));
        AccumulativeStatManager.registerOffensive("RANGED_DAMAGE_DEALT", new ProfileStatAttackerHeldItemSource(ArcheryProfile.class, "bowDamageMultiplier", Material.BOW), new ProfileStatAttackerHeldItemSource(ArcheryProfile.class, "crossbowDamageMultiplier", Material.CROSSBOW), new AttributeAttackerSource("DAMAGE_RANGED").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "rangedAttackDamageMultiplier"), new GlobalBuffSource("fraction_ranged_damage_bonus"), new PotionEffectAttackerSource("DAMAGE_RANGED"));
        AccumulativeStatManager.registerOffensive("UNARMED_DAMAGE_DEALT", new AttributeAttackerSource("DAMAGE_UNARMED").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "unarmedAttackDamageMultiplier"), new GlobalBuffSource("fraction_unarmed_damage_bonus"), new PotionEffectAttackerSource("DAMAGE_UNARMED"));
        AccumulativeStatManager.registerOffensive("PLAYER_DAMAGE_DEALT", new AttributeAttackerSource("DAMAGE_PLAYER").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "playerDamageMultiplier"), new GlobalBuffSource("fraction_player_damage_bonus"), new PotionEffectAttackerSource("DAMAGE_PLAYER"));
        AccumulativeStatManager.registerOffensive("MOUNTED_DAMAGE_DEALT", new AttributeAttackerSource("DAMAGE_MOUNTED").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "mountedDamageMultiplier"), new GlobalBuffSource("fraction_mounted_damage_bonus"), new PotionEffectAttackerSource("DAMAGE_MOUNTED"));
        AccumulativeStatManager.registerOffensive("VELOCITY_DAMAGE_BONUS", new AttributeAttackerSource("VELOCITY_DAMAGE"), new PotionEffectAttackerSource("VELOCITY_DAMAGE"));
        AccumulativeStatManager.registerOffensive("LIGHT_ARMOR_DAMAGE_BONUS", new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "damageToLightArmorMultiplier", WeightClass.HEAVY), new ProfileStatAttackerWeightSource(LightWeaponsProfile.class, "damageToLightArmorMultiplier", WeightClass.LIGHT), new AttributeAttackerSource("LIGHT_ARMOR_DAMAGE"), new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "damageToLightArmorMultiplier", WeightClass.HEAVY));
        AccumulativeStatManager.registerOffensive("HEAVY_ARMOR_DAMAGE_BONUS", new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "damageToHeavyArmorMultiplier", WeightClass.HEAVY), new ProfileStatAttackerWeightSource(LightWeaponsProfile.class, "damageToHeavyArmorMultiplier", WeightClass.LIGHT), new AttributeAttackerSource("HEAVY_ARMOR_DAMAGE"), new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "damageToHeavyArmorMultiplier", WeightClass.HEAVY));
        AccumulativeStatManager.registerOffensive("FIRE_DAMAGE_BONUS", new AttributeAttackerSource("EXTRA_FIRE_DAMAGE").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "fireDamageBonus"), new PotionEffectAttackerSource("EXTRA_FIRE_DAMAGE"));
        AccumulativeStatManager.registerOffensive("EXPLOSION_DAMAGE_BONUS", new AttributeAttackerSource("EXTRA_EXPLOSION_DAMAGE").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "explosionDamageBonus"), new PotionEffectAttackerSource("EXTRA_EXPLOSION_DAMAGE"));
        AccumulativeStatManager.registerOffensive("POISON_DAMAGE_BONUS", new AttributeAttackerSource("EXTRA_POISON_DAMAGE").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "poisonDamageBonus"), new PotionEffectAttackerSource("EXTRA_POISON_DAMAGE"));
        AccumulativeStatManager.registerOffensive("MAGIC_DAMAGE_BONUS", new AttributeAttackerSource("EXTRA_MAGIC_DAMAGE").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "magicDamageBonus"), new PotionEffectAttackerSource("EXTRA_MAGIC_DAMAGE"));
        AccumulativeStatManager.registerOffensive("LIGHTNING_DAMAGE_BONUS", new AttributeAttackerSource("EXTRA_LIGHTNING_DAMAGE").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "lightningDamageBonus"), new PotionEffectAttackerSource("EXTRA_LIGHTNING_DAMAGE"));
        AccumulativeStatManager.registerOffensive("FREEZING_DAMAGE_BONUS", new AttributeAttackerSource("EXTRA_FREEZING_DAMAGE").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "freezingDamageBonus"), new PotionEffectAttackerSource("EXTRA_FREEZING_DAMAGE"));
        AccumulativeStatManager.registerOffensive("RADIANT_DAMAGE_BONUS", new AttributeAttackerSource("EXTRA_RADIANT_DAMAGE").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "radiantDamageBonus"), new PotionEffectAttackerSource("EXTRA_RADIANT_DAMAGE"));
        AccumulativeStatManager.registerOffensive("NECROTIC_DAMAGE_BONUS", new AttributeAttackerSource("EXTRA_NECROTIC_DAMAGE").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "necroticDamageBonus"), new PotionEffectAttackerSource("EXTRA_NECROTIC_DAMAGE"));
        AccumulativeStatManager.registerOffensive("BLUDGEONING_DAMAGE_BONUS", new AttributeAttackerSource("EXTRA_BLUDGEONING_DAMAGE").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "bludgeoningDamageBonus"), new PotionEffectAttackerSource("EXTRA_BLUDGEONING_DAMAGE"));
        AccumulativeStatManager.registerOffensive("FIRE_DAMAGE_DEALT", new AttributeAttackerSource("DAMAGE_FIRE").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "fireDamageMultiplier"), new GlobalBuffSource("fraction_fire_damage_bonus"), new PotionEffectAttackerSource("DAMAGE_FIRE"));
        AccumulativeStatManager.registerOffensive("EXPLOSION_DAMAGE_DEALT", new AttributeAttackerSource("DAMAGE_EXPLOSION").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "explosionDamageMultiplier"), new GlobalBuffSource("fraction_explosion_damage_bonus"), new PotionEffectAttackerSource("DAMAGE_EXPLOSION"));
        AccumulativeStatManager.registerOffensive("POISON_DAMAGE_DEALT", new AttributeAttackerSource("DAMAGE_POISON").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "poisonDamageMultiplier"), new GlobalBuffSource("fraction_poison_damage_bonus"), new PotionEffectAttackerSource("DAMAGE_POISON"));
        AccumulativeStatManager.registerOffensive("BLUDGEONING_DAMAGE_DEALT", new AttributeAttackerSource("DAMAGE_BLUDGEONING").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "bludgeoningDamageMultiplier"), new GlobalBuffSource("fraction_bludgeoning_damage_bonus"), new PotionEffectAttackerSource("DAMAGE_BLUDGEONING"));
        AccumulativeStatManager.registerOffensive("MAGIC_DAMAGE_DEALT", new AttributeAttackerSource("DAMAGE_MAGIC").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "magicDamageMultiplier"), new GlobalBuffSource("fraction_magic_damage_bonus"), new PotionEffectAttackerSource("DAMAGE_MAGIC"));
        AccumulativeStatManager.registerOffensive("LIGHTNING_DAMAGE_DEALT", new AttributeAttackerSource("DAMAGE_LIGHTNING").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "lightningDamageMultiplier"), new GlobalBuffSource("fraction_lightning_damage_bonus"), new PotionEffectAttackerSource("DAMAGE_LIGHTNING"));
        AccumulativeStatManager.registerOffensive("FREEZING_DAMAGE_DEALT", new AttributeAttackerSource("DAMAGE_FREEZING").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "freezingDamageMultiplier"), new GlobalBuffSource("fraction_freezing_damage_bonus"), new PotionEffectAttackerSource("DAMAGE_FREEZING"));
        AccumulativeStatManager.registerOffensive("RADIANT_DAMAGE_DEALT", new AttributeAttackerSource("DAMAGE_RADIANT").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "radiantDamageMultiplier"), new GlobalBuffSource("fraction_radiant_damage_bonus"), new PotionEffectAttackerSource("DAMAGE_RADIANT"));
        AccumulativeStatManager.registerOffensive("NECROTIC_DAMAGE_DEALT", new AttributeAttackerSource("DAMAGE_NECROTIC").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "necroticDamageMultiplier"), new GlobalBuffSource("fraction_necrotic_damage_bonus"), new PotionEffectAttackerSource("DAMAGE_NECROTIC"));
        AccumulativeStatManager.registerOffensive("POWER_ATTACK_DAMAGE_MULTIPLIER", new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "powerAttackDamageMultiplier", WeightClass.HEAVY), new ProfileStatAttackerWeightSource(LightWeaponsProfile.class, "powerAttackDamageMultiplier", WeightClass.LIGHT), new ProfileStatAttackerSource(PowerProfile.class, "powerAttackDamageMultiplier"));
        AccumulativeStatManager.registerOffensive("POWER_ATTACK_RADIUS", new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "powerAttackRadius", WeightClass.HEAVY), new ProfileStatAttackerWeightSource(LightWeaponsProfile.class, "powerAttackRadius", WeightClass.LIGHT), new ProfileStatAttackerSource(PowerProfile.class, "powerAttackRadius"));
        AccumulativeStatManager.registerOffensive("POWER_ATTACK_DAMAGE_FRACTION", new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "powerAttackFraction", WeightClass.HEAVY), new ProfileStatAttackerWeightSource(LightWeaponsProfile.class, "powerAttackFraction", WeightClass.LIGHT), new ProfileStatAttackerSource(PowerProfile.class, "powerAttackFraction"));
        AccumulativeStatManager.register("ATTACK_REACH_BONUS", new ProfileStatWeightSource(HeavyWeaponsProfile.class, "attackReachBonus", WeightClass.HEAVY, false), new ProfileStatWeightSource(LightWeaponsProfile.class, "attackReachBonus", WeightClass.LIGHT, false), new AttributeSource("ATTACK_REACH").penalty("attribute"), new ProfileStatSource(PowerProfile.class, "attackReachBonus"), new GlobalBuffSource("attack_reach_bonus"), new PotionEffectSource("ATTACK_REACH"));
        AccumulativeStatManager.register("ATTACK_REACH_MULTIPLIER", new ProfileStatWeightSource(HeavyWeaponsProfile.class, "attackReachMultiplier", WeightClass.HEAVY, false), new ProfileStatWeightSource(LightWeaponsProfile.class, "attackReachMultiplier", WeightClass.LIGHT, false), new AttributeSource("ATTACK_REACH_MULTIPLIER").penalty("attribute"), new ProfileStatSource(PowerProfile.class, "attackReachMultiplier"), new GlobalBuffSource("attack_reach_multiplier"), new PotionEffectSource("ATTACK_REACH_MULTIPLIER"));
        AccumulativeStatManager.register("RANGED_INACCURACY", new ArcheryChargedShotInaccuracySource(), new ProfileStatSource(ArcheryProfile.class, "inaccuracy"), new AttributeSource("ARROW_ACCURACY", true).penalty("attribute"), new PotionEffectSource("ARROW_ACCURACY", true));
        AccumulativeStatManager.register("RANGED_VELOCITY_BONUS", new ArcheryChargedShotVelocitySource(), new ProfileStatSource(ArcheryProfile.class, "arrowVelocityMultiplier"), new AttributeSource("BOW_STRENGTH").penalty("damage"), new PotionEffectSource("BOW_STRENGTH"), new PotionEffectSource("ARROW_VELOCITY"));
        AccumulativeStatManager.register("RANGED_DAMAGE_BONUS", new PotionEffectSource("ARROW_DAMAGE"));
        AccumulativeStatManager.register("RANGED_PIERCING_BONUS", new PotionEffectSource("ARROW_PIERCING"));
        AccumulativeStatManager.registerOffensive("KNOCKBACK_BONUS", new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "knockbackMultiplier", WeightClass.HEAVY), new ProfileStatAttackerWeightSource(LightWeaponsProfile.class, "knockbackMultiplier", WeightClass.LIGHT), new AttributeAttackerSource("KNOCKBACK").penalty("attribute"), new ProfileStatAttackerSource(PowerProfile.class, "attackKnockbackBonus"), new GlobalBuffSource("knockback_bonus"), new PotionEffectAttackerSource("KNOCKBACK"));
        AccumulativeStatManager.register("IMMUNITY_FRAME_BONUS", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setImmunityFlatBonus", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setImmunityFlatBonus", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "immunityFlatBonusPerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "immunityFlatBonusPerPiece", WeightClass.LIGHT), new AttributeDefenderSource("IMMUNITY_BONUS_FLAT").penalty("attribute"), new ProfileStatSource(PowerProfile.class, "immunityFrameBonus"), new GlobalBuffSource("immunity_frame_bonus"), new PotionEffectSource("IMMUNITY_BONUS_FLAT"));
        AccumulativeStatManager.register("IMMUNITY_FRAME_MULTIPLIER", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setImmunityFractionBonus", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setImmunityFractionBonus", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "immunityFractionBonusPerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "immunityFractionBonusPerPiece", WeightClass.LIGHT), new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "immunityReductionFraction", WeightClass.HEAVY).n(), new ProfileStatAttackerWeightSource(LightWeaponsProfile.class, "immunityReductionFraction", WeightClass.LIGHT).n(), new AttributeDefenderSource("IMMUNITY_BONUS_FRACTION").penalty("attribute"), new AttributeAttackerSource("IMMUNITY_REDUCTION", true).penalty("attribute"), new ProfileStatSource(PowerProfile.class, "immunityFrameMultiplier"), new GlobalBuffSource("fraction_immunity_frame_bonus"), new PotionEffectAttackerSource("IMMUNITY_REDUCTION", true), new PotionEffectSource("IMMUNITY_BONUS_FRACTION"));
        AccumulativeStatManager.registerOffensive("BLEED_CHANCE", new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "bleedChance", WeightClass.HEAVY), new ProfileStatAttackerWeightSource(LightWeaponsProfile.class, "bleedChance", WeightClass.LIGHT), new AttributeAttackerSource("BLEED_CHANCE").penalty("attribute"), new ProfileStatAttackerSource(PowerProfile.class, "bleedChance"), new GlobalBuffSource("bleed_chance"), new PotionEffectAttackerSource("BLEED_CHANCE"));
        AccumulativeStatManager.registerOffensive("BLEED_DAMAGE", new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "bleedDamage", WeightClass.HEAVY), new ProfileStatAttackerWeightSource(LightWeaponsProfile.class, "bleedDamage", WeightClass.LIGHT), new AttributeAttackerSource("BLEED_DAMAGE").penalty("attribute"), new ProfileStatAttackerSource(PowerProfile.class, "bleedDamage"), new GlobalBuffSource("bleed_damage"), new PotionEffectAttackerSource("BLEED_DAMAGE"));
        AccumulativeStatManager.registerOffensive("BLEED_DURATION", new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "bleedDuration", WeightClass.HEAVY), new ProfileStatAttackerWeightSource(LightWeaponsProfile.class, "bleedDuration", WeightClass.LIGHT), new AttributeAttackerSource("BLEED_DURATION").penalty("attribute"), new ProfileStatAttackerSource(PowerProfile.class, "bleedDuration"), new GlobalBuffSource("bleed_duration"), new PotionEffectAttackerSource("BLEED_DURATION"));
        AccumulativeStatManager.register("DODGE_CHANCE", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setDodgeChance", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setDodgeChance", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "dodgeChancePerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "dodgeChancePerPiece", WeightClass.LIGHT), new AttributeDefenderSource("DODGE_CHANCE").penalty("attribute"), new ProfileStatSource(PowerProfile.class, "dodgeChance"), new GlobalBuffSource("dodge_chance"), new PotionEffectSource("DODGE_CHANCE"));
        AccumulativeStatManager.register("REFLECT_CHANCE", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setReflectChance", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setReflectChance", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "reflectChancePerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "reflectChancePerPiece", WeightClass.LIGHT), new AttributeDefenderSource("REFLECT_CHANCE").penalty("attribute"), new ProfileStatSource(PowerProfile.class, "reflectChance"), new GlobalBuffSource("reflect_chance"), new PotionEffectSource("REFLECT_CHANCE"));
        AccumulativeStatManager.register("REFLECT_FRACTION", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setReflectFraction", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setReflectFraction", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "reflectFractionPerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "reflectFractionPerPiece", WeightClass.LIGHT), new AttributeDefenderSource("REFLECT_FRACTION").penalty("attribute"), new ProfileStatSource(PowerProfile.class, "reflectFraction"), new GlobalBuffSource("reflect_fraction"), new PotionEffectSource("REFLECT_FRACTION"));
        AccumulativeStatManager.registerOffensive("DISMOUNT_CHANCE", new AttributeAttackerSource("DISMOUNT_CHANCE").penalty("attribute"), new ProfileStatAttackerSource(PowerProfile.class, "dismountChance"), new PotionEffectAttackerSource("DISMOUNT_CHANCE"), new GlobalBuffSource("dismount_chance"));
        AccumulativeStatManager.registerOffensive("STUN_CHANCE", new ProfileStatAttackerHeldItemSource(ArcheryProfile.class, "bowStunChance", Material.BOW), new ProfileStatAttackerHeldItemSource(ArcheryProfile.class, "crossbowStunChance", Material.CROSSBOW), new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "stunChance", WeightClass.HEAVY), new ProfileStatAttackerWeightSource(LightWeaponsProfile.class, "stunChance", WeightClass.LIGHT), new AttributeAttackerSource("STUN_CHANCE").penalty("attribute"), new ProfileStatAttackerSource(PowerProfile.class, "stunChance"), new GlobalBuffSource("stun_chance"), new PotionEffectAttackerSource("STUN_CHANCE"));
        AccumulativeStatManager.registerOffensive("STUN_DURATION_BONUS", new ProfileStatAttackerHeldItemSource(ArcheryProfile.class, "stunDuration", Material.BOW, Material.CROSSBOW), new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "stunDuration", WeightClass.HEAVY), new ProfileStatAttackerWeightSource(LightWeaponsProfile.class, "stunDuration", WeightClass.LIGHT), new ProfileStatAttackerSource(PowerProfile.class, "stunDurationBonus"));
        AccumulativeStatManager.registerOffensive("CRIT_CHANCE", new ProfileStatAttackerHeldItemSource(ArcheryProfile.class, "bowCritChance", Material.BOW), new ProfileStatAttackerHeldItemSource(ArcheryProfile.class, "crossbowCritChance", Material.CROSSBOW), new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "critChance", WeightClass.HEAVY), new ProfileStatAttackerWeightSource(LightWeaponsProfile.class, "critChance", WeightClass.LIGHT), new AttributeAttackerSource("CRIT_CHANCE").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "critChance"), new PotionEffectAttackerSource("CRIT_CHANCE"));
        AccumulativeStatManager.registerOffensive("CRIT_DAMAGE", new ProfileStatAttackerHeldItemSource(ArcheryProfile.class, "critDamage", Material.BOW, Material.CROSSBOW), new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "critDamage", WeightClass.HEAVY), new ProfileStatAttackerWeightSource(LightWeaponsProfile.class, "critDamage", WeightClass.LIGHT), new AttributeAttackerSource("CRIT_DAMAGE").penalty("damage"), new ProfileStatAttackerSource(PowerProfile.class, "critDamage"), new PotionEffectAttackerSource("CRIT_DAMAGE"));
        AccumulativeStatManager.register("CROSSBOW_MAGAZINE", new AttributeSource("CROSSBOW_MAGAZINE"), new ProfileStatSource(PowerProfile.class, "crossbowMagazine"));
        AccumulativeStatManager.registerOffensive("SHIELD_DISARMING", new AttributeAttackerSource("SHIELD_DISARMING"), new PotionEffectAttackerSource("SHIELD_DISARMING"), new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "shieldDisarming", WeightClass.HEAVY), new ProfileStatAttackerWeightSource(LightWeaponsProfile.class, "shieldDisarming", WeightClass.LIGHT), new ProfileStatAttackerSource(PowerProfile.class, "shieldDisarming"));
        AccumulativeStatManager.registerOffensive("LIFE_STEAL", new AttributeAttackerSource("LIFE_STEAL"), new PotionEffectAttackerSource("LIFE_STEAL"), new ProfileStatAttackerWeightSource(HeavyWeaponsProfile.class, "lifeSteal", WeightClass.HEAVY), new ProfileStatAttackerWeightSource(LightWeaponsProfile.class, "lifeSteal", WeightClass.LIGHT), new ProfileStatAttackerSource(PowerProfile.class, "lifeSteal"));
        AccumulativeStatManager.register("PARRY_EFFECTIVENESS_DURATION", new ProfileStatSource(PowerProfile.class, "parryEffectiveDuration"), new ProfileStatWeightSource(LightWeaponsProfile.class, "parryEffectiveDuration", WeightClass.LIGHT, false), new ProfileStatWeightSource(HeavyWeaponsProfile.class, "parryEffectiveDuration", WeightClass.HEAVY, false));
        AccumulativeStatManager.register("PARRY_VULNERABLE_DURATION", new ProfileStatSource(PowerProfile.class, "parryVulnerableDuration"), new ProfileStatWeightSource(LightWeaponsProfile.class, "parryVulnerableDuration", WeightClass.LIGHT, false), new ProfileStatWeightSource(HeavyWeaponsProfile.class, "parryVulnerableDuration", WeightClass.HEAVY, false));
        AccumulativeStatManager.register("PARRY_ENEMY_DEBUFF_DURATION", new ProfileStatSource(PowerProfile.class, "parryEnemyDebuffDuration"), new ProfileStatWeightSource(LightWeaponsProfile.class, "parryEnemyDebuffDuration", WeightClass.LIGHT, false), new ProfileStatWeightSource(HeavyWeaponsProfile.class, "parryEnemyDebuffDuration", WeightClass.HEAVY, false));
        AccumulativeStatManager.register("PARRY_SELF_DEBUFF_DURATION", new ProfileStatSource(PowerProfile.class, "parrySelfDebuffDuration"), new ProfileStatWeightSource(LightWeaponsProfile.class, "parrySelfDebuffDuration", WeightClass.LIGHT, false), new ProfileStatWeightSource(HeavyWeaponsProfile.class, "parrySelfDebuffDuration", WeightClass.HEAVY, false));
        AccumulativeStatManager.register("PARRY_DAMAGE_REDUCTION", new ProfileStatSource(PowerProfile.class, "parryDamageReduction"), new ProfileStatWeightSource(LightWeaponsProfile.class, "parryDamageReduction", WeightClass.LIGHT, false), new ProfileStatWeightSource(HeavyWeaponsProfile.class, "parryDamageReduction", WeightClass.HEAVY, false));
        AccumulativeStatManager.register("PARRY_COOLDOWN", new ProfileStatSource(PowerProfile.class, "parryCooldown"), new ProfileStatWeightSource(LightWeaponsProfile.class, "parryCooldown", WeightClass.LIGHT, false), new ProfileStatWeightSource(HeavyWeaponsProfile.class, "parryCooldown", WeightClass.HEAVY, false));
        AccumulativeStatManager.register("PARRY_SUCCESS_COOLDOWN_REDUCTION", new ProfileStatSource(PowerProfile.class, "parryCooldownSuccessReduction"), new ProfileStatWeightSource(LightWeaponsProfile.class, "parryCooldownSuccessReduction", WeightClass.LIGHT, false), new ProfileStatWeightSource(HeavyWeaponsProfile.class, "parryCooldownSuccessReduction", WeightClass.HEAVY, false));
        AccumulativeStatManager.register("DAMAGE_RESISTANCE", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setDamageResistance", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setDamageResistance", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "damageResistancePerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "damageResistancePerPiece", WeightClass.LIGHT), new ResistanceEnchantmentSource(EnchantmentMappings.PROTECTION.getEnchantment(), "protection"), new ResistanceArmorWeightClassSource("damage_resistance"), new ResistanceDamageResistanceSource(), new AttributeDefenderSource("DAMAGE_RESISTANCE").penalty("resistance"), new ProfileStatSource(PowerProfile.class, "damageResistance"), new GlobalBuffSource("damage_resistance"), new AttributeDefenderSource("DAMAGE_TAKEN").negative(), new PotionEffectSource("DAMAGE_TAKEN", true), new PotionEffectSource("CUSTOM_DAMAGE_RESISTANCE"));
        AccumulativeStatManager.register("MELEE_RESISTANCE", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setMeleeResistance", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setMeleeResistance", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "meleeResistancePerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "meleeResistancePerPiece", WeightClass.LIGHT), new ResistanceEnchantmentSource(EnchantmentMappings.PROTECTION.getEnchantment(), "protection_melee"), new ResistanceArmorWeightClassSource("melee_resistance"), new AttributeDefenderSource("MELEE_RESISTANCE").penalty("resistance"), new ProfileStatSource(PowerProfile.class, "meleeResistance"), new GlobalBuffSource("melee_resistance"), new PotionEffectSource("MELEE_RESISTANCE"));
        AccumulativeStatManager.register("PROJECTILE_RESISTANCE", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setProjectileResistance", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setProjectileResistance", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "projectileResistancePerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "projectileResistancePerPiece", WeightClass.LIGHT), new ResistanceEnchantmentSource(EnchantmentMappings.PROJECTILE_PROTECTION.getEnchantment(), "projectile_protection"), new ResistanceArmorWeightClassSource("projectile_resistance"), new AttributeDefenderSource("PROJECTILE_RESISTANCE").penalty("resistance"), new ProfileStatSource(PowerProfile.class, "projectileResistance"), new GlobalBuffSource("projectile_resistance"), new PotionEffectSource("PROJECTILE_RESISTANCE"));
        AccumulativeStatManager.register("BLUDGEONING_RESISTANCE", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setBludgeoningResistance", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setBludgeoningResistance", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "bludgeoningResistancePerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "bludgeoningResistancePerPiece", WeightClass.LIGHT), new ResistanceEnchantmentSource(EnchantmentMappings.PROTECTION.getEnchantment(), "protection_bludgeoning"), new ResistanceArmorWeightClassSource("bludgeoning_resistance"), new AttributeDefenderSource("BLUDGEONING_RESISTANCE").penalty("resistance"), new ProfileStatSource(PowerProfile.class, "bludgeoningResistance"), new GlobalBuffSource("bludgeoning_resistance"), new PotionEffectSource("BLUDGEONING_RESISTANCE"));
        AccumulativeStatManager.register("FIRE_RESISTANCE", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setFireResistance", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setFireResistance", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "fireResistancePerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "fireResistancePerPiece", WeightClass.LIGHT), new ResistanceEnchantmentSource(EnchantmentMappings.FIRE_PROTECTION.getEnchantment(), "fire_protection"), new ResistanceArmorWeightClassSource("fire_resistance"), new AttributeDefenderSource("FIRE_RESISTANCE").penalty("resistance"), new ProfileStatSource(PowerProfile.class, "fireResistance"), new GlobalBuffSource("fire_resistance"), new PotionEffectSource("CUSTOM_FIRE_RESISTANCE"));
        AccumulativeStatManager.register("EXPLOSION_RESISTANCE", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setExplosionResistance", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setExplosionResistance", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "explosionResistancePerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "explosionResistancePerPiece", WeightClass.LIGHT), new ResistanceEnchantmentSource(EnchantmentMappings.BLAST_PROTECTION.getEnchantment(), "blast_protection"), new ResistanceArmorWeightClassSource("explosion_resistance"), new AttributeDefenderSource("EXPLOSION_RESISTANCE").penalty("resistance"), new ProfileStatSource(PowerProfile.class, "explosionResistance"), new GlobalBuffSource("explosion_resistance"), new PotionEffectSource("EXPLOSION_RESISTANCE"));
        AccumulativeStatManager.register("MAGIC_RESISTANCE", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setMagicResistance", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setMagicResistance", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "magicResistancePerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "magicResistancePerPiece", WeightClass.LIGHT), new ResistanceEnchantmentSource(EnchantmentMappings.PROTECTION.getEnchantment(), "protection_magic"), new ResistanceArmorWeightClassSource("magic_resistance"), new AttributeDefenderSource("MAGIC_RESISTANCE").penalty("resistance"), new ProfileStatSource(PowerProfile.class, "magicResistance"), new GlobalBuffSource("magic_resistance"), new PotionEffectSource("MAGIC_RESISTANCE"));
        AccumulativeStatManager.register("POISON_RESISTANCE", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setPoisonResistance", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setPoisonResistance", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "poisonResistancePerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "poisonResistancePerPiece", WeightClass.LIGHT), new ResistanceEnchantmentSource(EnchantmentMappings.PROTECTION.getEnchantment(), "protection_poison"), new ResistanceArmorWeightClassSource("poison_resistance"), new AttributeDefenderSource("POISON_RESISTANCE").penalty("resistance"), new ProfileStatSource(PowerProfile.class, "poisonResistance"), new GlobalBuffSource("poison_resistance"), new PotionEffectSource("POISON_RESISTANCE"));
        AccumulativeStatManager.register("FREEZING_RESISTANCE", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setFreezingResistance", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setFreezingResistance", "setAmount", WeightClass.LIGHT), new ResistanceEnchantmentSource(EnchantmentMappings.PROTECTION.getEnchantment(), "protection_freezing"), new ResistanceArmorWeightClassSource("freezing_resistance"), new AttributeDefenderSource("FREEZING_RESISTANCE").penalty("resistance"), new ProfileStatSource(PowerProfile.class, "freezingResistance"), new GlobalBuffSource("freezing_resistance"), new PotionEffectSource("FREEZING_RESISTANCE"));
        AccumulativeStatManager.register("LIGHTNING_RESISTANCE", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setLightningResistance", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setLightningResistance", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "lightningResistancePerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "lightningResistancePerPiece", WeightClass.LIGHT), new ResistanceEnchantmentSource(EnchantmentMappings.PROTECTION.getEnchantment(), "protection_lightning"), new ResistanceArmorWeightClassSource("lightning_resistance"), new AttributeDefenderSource("LIGHTNING_RESISTANCE").penalty("resistance"), new ProfileStatSource(PowerProfile.class, "lightningResistance"), new GlobalBuffSource("lightning_resistance"), new PotionEffectSource("LIGHTNING_RESISTANCE"));
        AccumulativeStatManager.register("RADIANT_RESISTANCE", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setRadiantResistance", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setRadiantResistance", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "radiantResistancePerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "radiantResistancePerPiece", WeightClass.LIGHT), new ResistanceEnchantmentSource(EnchantmentMappings.PROTECTION.getEnchantment(), "protection_radiant"), new ResistanceArmorWeightClassSource("radiant_resistance"), new AttributeDefenderSource("RADIANT_RESISTANCE").penalty("resistance"), new ProfileStatSource(PowerProfile.class, "radiantResistance"), new GlobalBuffSource("radiant_resistance"), new PotionEffectSource("RADIANT_RESISTANCE"));
        AccumulativeStatManager.register("NECROTIC_RESISTANCE", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setNecroticResistance", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setNecroticResistance", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "necroticResistancePerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "necroticResistancePerPiece", WeightClass.LIGHT), new ResistanceEnchantmentSource(EnchantmentMappings.PROTECTION.getEnchantment(), "protection_necrotic"), new ResistanceArmorWeightClassSource("necrotic_resistance"), new AttributeDefenderSource("NECROTIC_RESISTANCE").penalty("resistance"), new ProfileStatSource(PowerProfile.class, "necroticResistance"), new GlobalBuffSource("necrotic_resistance"), new PotionEffectSource("NECROTIC_RESISTANCE"));
        AccumulativeStatManager.register("FALLING_RESISTANCE", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setFallDamageResistance", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setFallDamageResistance", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "fallDamageResistancePerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "fallDamageResistancePerPiece", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "freezingResistancePerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "freezingResistancePerPiece", WeightClass.LIGHT), new ResistanceEnchantmentSource(EnchantmentMappings.FEATHER_FALLING.getEnchantment(), "feather_falling"), new ResistanceArmorWeightClassSource("fall_resistance"), new AttributeDefenderSource("FALL_DAMAGE_RESISTANCE").penalty("resistance"), new ProfileStatSource(PowerProfile.class, "fallDamageResistance"), new GlobalBuffSource("fall_damage_resistance"), new PotionEffectSource("FALL_DAMAGE_RESISTANCE"));
        AccumulativeStatManager.register("STUN_RESISTANCE", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setStunResistance", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setStunResistance", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "stunResistancePerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "stunResistancePerPiece", WeightClass.LIGHT), new ResistanceArmorWeightClassSource("stun_resistance"), new AttributeDefenderSource("STUN_RESISTANCE").penalty("resistance"), new ProfileStatSource(PowerProfile.class, "stunResistance"), new GlobalBuffSource("stun_resistance"), new PotionEffectSource("STUN_RESISTANCE"));
        AccumulativeStatManager.register("BLEED_RESISTANCE", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setBleedResistance", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setBleedResistance", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "bleedResistancePerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "bleedResistancePerPiece", WeightClass.LIGHT), new ResistanceArmorWeightClassSource("bleeding_resistance"), new AttributeDefenderSource("BLEED_RESISTANCE").penalty("resistance"), new ProfileStatSource(PowerProfile.class, "bleedResistance"), new GlobalBuffSource("bleeding_resistance"), new PotionEffectSource("BLEED_RESISTANCE"));
        AccumulativeStatManager.register("CRIT_CHANCE_RESISTANCE", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setCritChanceResistance", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setCritChanceResistance", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "critChanceResistancePerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "critChanceResistancePerPiece", WeightClass.LIGHT), new ResistanceArmorWeightClassSource("crit_chance_resistance"), new AttributeDefenderSource("CRIT_CHANCE_RESISTANCE").penalty("resistance"), new ProfileStatSource(PowerProfile.class, "critChanceResistance"), new PotionEffectSource("CRIT_CHANCE_RESISTANCE"));
        AccumulativeStatManager.register("CRIT_DAMAGE_RESISTANCE", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setCritDamageResistance", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setCritDamageResistance", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "critDamageResistancePerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "critDamageResistancePerPiece", WeightClass.LIGHT), new ResistanceArmorWeightClassSource("crit_damage_resistance"), new AttributeDefenderSource("CRIT_DAMAGE_RESISTANCE").penalty("resistance"), new ProfileStatSource(PowerProfile.class, "critDamageResistance"), new PotionEffectSource("CRIT_DAMAGE_RESISTANCE"));
        AccumulativeStatManager.register("PVP_RESISTANCE", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setPvPResistance", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setPvPResistance", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "pvpResistancePerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "pvpResistancePerPiece", WeightClass.LIGHT), new AttributeDefenderSource("PVP_RESISTANCE").penalty("resistance"), new ProfileStatSource(PowerProfile.class, "pvpResistance"), new PotionEffectSource("PVP_RESISTANCE"));
        AccumulativeStatManager.register("HEALING_BONUS", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setHealingBonus", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setHealingBonus", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "healingBonusPerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "healingBonusPerPiece", WeightClass.LIGHT), new AttributeSource("HEALING_BONUS").penalty("attribute"), new ProfileStatSource(PowerProfile.class, "healthRegenerationBonus"), new GlobalBuffSource("healing_bonus"), new PotionEffectSource("HEALING_BONUS"));
        AccumulativeStatManager.register("HUNGER_SAVE_CHANCE", new ProfileStatDefenderArmorWeightSetSource(HeavyArmorProfile.class, "setHungerSaveChance", "setAmount", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSetSource(LightArmorProfile.class, "setHungerSaveChance", "setAmount", WeightClass.LIGHT), new ProfileStatDefenderArmorWeightSource(HeavyArmorProfile.class, "hungerSaveChancePerPiece", WeightClass.HEAVY), new ProfileStatDefenderArmorWeightSource(LightArmorProfile.class, "hungerSaveChancePerPiece", WeightClass.LIGHT), new AttributeSource("FOOD_CONSUMPTION").penalty("attribute"), new ProfileStatSource(PowerProfile.class, "hungerSaveChance"), new GlobalBuffSource("fraction_hunger_reduction"), new PotionEffectSource("FOOD_CONSUMPTION"));
        AccumulativeStatManager.register("COOLDOWN_REDUCTION", new AttributeSource("COOLDOWN_REDUCTION").penalty("attribute"), new ProfileStatSource(PowerProfile.class, "cooldownReduction"), new GlobalBuffSource("cooldown_reduction"), new PotionEffectSource("COOLDOWN_REDUCTION"));
        AccumulativeStatManager.register("CRAFTING_TIME_REDUCTION", new AttributeSource("CRAFTING_SPEED").penalty("attribute"), new ProfileStatSource(PowerProfile.class, "craftingTimeReduction"), new GlobalBuffSource("crafting_time_reduction"), new PotionEffectSource("CRAFTING_SPEED"));
        AccumulativeStatManager.register("COOKING_SPEED_BONUS", new AttributeSource("COOKING_SPEED").penalty("attribute"), new ProfileStatSource(PowerProfile.class, "cookingSpeedBonus"), new GlobalBuffSource("cooking_time_reduction"), new PotionEffectSource("COOKING_SPEED"));
        AccumulativeStatManager.register("AMMO_SAVE_CHANCE", new ProfileStatSource(ArcheryProfile.class, "ammoSaveChance"), new AttributeSource("AMMO_CONSUMPTION", true), new PotionEffectSource("AMMO_CONSUMPTION", true));
        AccumulativeStatManager.register("DURABILITY_BONUS", new AttributeSource("DURABILITY"), new ProfileStatSource(PowerProfile.class, "durabilityMultiplier"), new GlobalBuffSource("fraction_durability_bonus"), new PotionEffectSource("DURABILITY"));
        AccumulativeStatManager.register("ENTITY_DROPS", new ProfileStatWeightSource(HeavyWeaponsProfile.class, "dropsMultiplier", WeightClass.HEAVY, false), new ProfileStatWeightSource(LightWeaponsProfile.class, "dropsMultiplier", WeightClass.LIGHT, false), new AttributeSource("ENTITY_DROPS").penalty("attribute"), new ProfileStatSource(PowerProfile.class, "entityDropMultiplier"), new GlobalBuffSource("entity_drops"), new PotionEffectSource("ENTITY_DROPS"));
        AccumulativeStatManager.register("ENTITY_DROP_LUCK", new ProfileStatAttackerVictimClassSource(FarmingProfile.class, "butcheryLuck", EntityClassification.ANIMAL), new ProfileStatWeightSource(HeavyWeaponsProfile.class, "rareDropsMultiplier", WeightClass.HEAVY, false), new ProfileStatWeightSource(LightWeaponsProfile.class, "rareDropsMultiplier", WeightClass.LIGHT, false), new AttributeSource("ENTITY_RARE_DROPS").penalty("attribute"), new ProfileStatSource(PowerProfile.class, "entityRareDropMultiplier"), new GlobalBuffSource("entity_rare_drops"), new PotionEffectSource("ENTITY_RARE_DROPS"));
        AccumulativeStatManager.register("JUMP_HEIGHT_MULTIPLIER", new AttributeSource("JUMP_HEIGHT").penalty("attribute"), new ProfileStatSource(PowerProfile.class, "jumpHeightBonus"), new PotionEffectSource("JUMP_HEIGHT"));
        AccumulativeStatManager.register("JUMPS_BONUS", new AttributeSource("JUMPS").penalty("attribute"), new ProfileStatSource(PowerProfile.class, "jumpBonus"), new PotionEffectSource("JUMPS"));
        AccumulativeStatManager.register("SNEAK_MOVEMENT_SPEED_BONUS", new AttributeSource("SNEAK_MOVEMENT_SPEED_BONUS").penalty("attribute"), new ProfileStatSource(PowerProfile.class, "sneakMovementSpeedBonus"), new GlobalBuffSource("movement_sneak_speed"), new PotionEffectSource("SNEAK_MOVEMENT_SPEED_BONUS"));
        AccumulativeStatManager.register("SPRINT_MOVEMENT_SPEED_BONUS", new AttributeSource("SPRINT_MOVEMENT_SPEED_BONUS").penalty("attribute"), new ProfileStatSource(PowerProfile.class, "sprintMovementSpeedBonus"), new GlobalBuffSource("movement_sprint_speed"), new PotionEffectSource("SPRINT_MOVEMENT_SPEED_BONUS"));
        AccumulativeStatManager.register("DIG_SPEED", new PotionEffectSource("DIG_SPEED"), new AttributeSource("DIG_SPEED"));
        AccumulativeStatManager.register("BLOCK_SPECIFIC_DIG_SPEED", new DiggingStatSource("diggingSpeedBonus"), new WoodcuttingStatSource("woodcuttingSpeedBonus"), new MiningDrillingActiveSource(), new MiningStatSource("miningSpeedBonus"), new MiningUnbreakableBlocksSource());
        AccumulativeStatManager.register("FISHING_LUCK", new FishingLuckRainSource(), new AttributeSource("FISHING_LUCK"), new PotionEffectSource("FISHING_LUCK"), new FishingLuckLotSSource(), new FishingLuckFullMoonSource(), new FishingLuckNewMoonSource());
        AccumulativeStatManager.register("FISHING_SPEED_MULTIPLIER", new AttributeSource("FISHING_LUCK"), new PotionEffectSource("FISHING_LUCK"), new FishingLuckLotSSource(), new FishingLuckFullMoonSource(), new FishingLuckNewMoonSource());
        AccumulativeStatManager.register("EXPLOSION_RADIUS_MULTIPLIER", new ProfileStatSource(MiningProfile.class, "tntBlastRadius"), new AttributeSource("EXPLOSION_POWER"), new PotionEffectSource("EXPLOSION_POWER"), new GlobalBuffSource("blast_mining_radius_multiplier"));
        AccumulativeStatManager.register("ONESHOT_PROTECTION_FRACTION", new ProfileStatSource(PowerProfile.class, "oneShotProtectionFraction"), new GlobalBuffSource("one_shot_protect"));
        AccumulativeStatManager.register("FOOD_BONUS_VEGETABLE", new ProfileStatSource(PowerProfile.class, "foodBonusVegetable"));
        AccumulativeStatManager.register("FOOD_BONUS_SEASONING", new ProfileStatSource(PowerProfile.class, "foodBonusSeasoning"));
        AccumulativeStatManager.register("FOOD_BONUS_ALCOHOLIC", new ProfileStatSource(PowerProfile.class, "foodBonusAlcoholic"));
        AccumulativeStatManager.register("FOOD_BONUS_BEVERAGE", new ProfileStatSource(PowerProfile.class, "foodBonusBeverage"));
        AccumulativeStatManager.register("FOOD_BONUS_SPOILED", new ProfileStatSource(PowerProfile.class, "foodBonusSpoiled"));
        AccumulativeStatManager.register("FOOD_BONUS_SEAFOOD", new ProfileStatSource(PowerProfile.class, "foodBonusSeafood"));
        AccumulativeStatManager.register("FOOD_BONUS_MAGICAL", new ProfileStatSource(PowerProfile.class, "foodBonusMagical"));
        AccumulativeStatManager.register("FOOD_BONUS_SWEET", new ProfileStatSource(PowerProfile.class, "foodBonusSweet"));
        AccumulativeStatManager.register("FOOD_BONUS_GRAIN", new ProfileStatSource(PowerProfile.class, "foodBonusGrain"));
        AccumulativeStatManager.register("FOOD_BONUS_FRUIT", new ProfileStatSource(PowerProfile.class, "foodBonusFruit"));
        AccumulativeStatManager.register("FOOD_BONUS_NUTS", new ProfileStatSource(PowerProfile.class, "foodBonusNuts"));
        AccumulativeStatManager.register("FOOD_BONUS_DAIRY", new ProfileStatSource(PowerProfile.class, "foodBonusDairy"));
        AccumulativeStatManager.register("FOOD_BONUS_MEAT", new ProfileStatSource(PowerProfile.class, "foodBonusMeat"));
        AccumulativeStatManager.register("FOOD_BONUS_FATS", new ProfileStatSource(PowerProfile.class, "foodBonusFats"));
        AccumulativeStatManager.register("SMITHING_QUALITY_GENERAL", new AttributeSource("SMITHING_QUALITY").penalty("attribute"), new ProfileStatSource(SmithingProfile.class, "genericCraftingSkill"), new GlobalBuffSource("smithing_quality"), new PotionEffectSource("SMITHING_QUALITY"), new PotionEffectSingleUseSource("SMITHING_MASTERPIECE_FLAT"));
        AccumulativeStatManager.register("SMITHING_QUALITY_WOOD", new ProfileStatSource(SmithingProfile.class, "woodCraftingSkill"));
        AccumulativeStatManager.register("SMITHING_QUALITY_LEATHER", new ProfileStatSource(SmithingProfile.class, "leatherCraftingSkill"));
        AccumulativeStatManager.register("SMITHING_QUALITY_STONE", new ProfileStatSource(SmithingProfile.class, "stoneCraftingSkill"));
        AccumulativeStatManager.register("SMITHING_QUALITY_CHAINMAIL", new ProfileStatSource(SmithingProfile.class, "chainCraftingSkill"));
        AccumulativeStatManager.register("SMITHING_QUALITY_GOLD", new ProfileStatSource(SmithingProfile.class, "goldCraftingSkill"));
        AccumulativeStatManager.register("SMITHING_QUALITY_IRON", new ProfileStatSource(SmithingProfile.class, "ironCraftingSkill"));
        AccumulativeStatManager.register("SMITHING_QUALITY_DIAMOND", new ProfileStatSource(SmithingProfile.class, "diamondCraftingSkill"));
        AccumulativeStatManager.register("SMITHING_QUALITY_NETHERITE", new ProfileStatSource(SmithingProfile.class, "netheriteCraftingSkill"));
        AccumulativeStatManager.register("SMITHING_QUALITY_BOW", new ProfileStatSource(SmithingProfile.class, "bowCraftingSkill"));
        AccumulativeStatManager.register("SMITHING_QUALITY_CROSSBOW", new ProfileStatSource(SmithingProfile.class, "crossbowCraftingSkill"));
        AccumulativeStatManager.register("SMITHING_QUALITY_PRISMARINE", new ProfileStatSource(SmithingProfile.class, "prismarineCraftingSkill"));
        AccumulativeStatManager.register("SMITHING_QUALITY_ENDERIC", new ProfileStatSource(SmithingProfile.class, "endericCraftingSkill"));
        AccumulativeStatManager.register("SMITHING_QUALITY_COPPER", new ProfileStatSource(SmithingProfile.class, "copperCraftingSkill"));
        AccumulativeStatManager.register("SMITHING_QUALITY_CUSTOM1", new ProfileStatSource(SmithingProfile.class, "custom1CraftingSkill"));
        AccumulativeStatManager.register("SMITHING_QUALITY_CUSTOM2", new ProfileStatSource(SmithingProfile.class, "custom2CraftingSkill"));
        AccumulativeStatManager.register("SMITHING_QUALITY_CUSTOM3", new ProfileStatSource(SmithingProfile.class, "custom3CraftingSkill"));
        AccumulativeStatManager.register("SMITHING_QUALITY_CUSTOM4", new ProfileStatSource(SmithingProfile.class, "custom4CraftingSkill"));
        AccumulativeStatManager.register("SMITHING_QUALITY_CUSTOM5", new ProfileStatSource(SmithingProfile.class, "custom5CraftingSkill"));
        AccumulativeStatManager.register("SMITHING_QUALITY_CUSTOM6", new ProfileStatSource(SmithingProfile.class, "custom6CraftingSkill"));
        AccumulativeStatManager.register("SMITHING_QUALITY_CUSTOM7", new ProfileStatSource(SmithingProfile.class, "custom7CraftingSkill"));
        AccumulativeStatManager.register("SMITHING_QUALITY_CUSTOM8", new ProfileStatSource(SmithingProfile.class, "custom8CraftingSkill"));
        AccumulativeStatManager.register("SMITHING_QUALITY_CUSTOM9", new ProfileStatSource(SmithingProfile.class, "custom9CraftingSkill"));
        AccumulativeStatManager.register("SMITHING_QUALITY_CUSTOM10", new ProfileStatSource(SmithingProfile.class, "custom10CraftingSkill"));
        AccumulativeStatManager.register("SMITHING_QUALITY_OTHER", new ProfileStatSource(SmithingProfile.class, "otherCraftingSkill"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_GENERAL", new AttributeSource("SMITHING_QUALITY_FRACTION").penalty("attribute"), new ProfileStatSource(SmithingProfile.class, "genericCraftingSkillFractionBonus"), new GlobalBuffSource("smithing_quality_fraction"), new PotionEffectSource("SMITHING_QUALITY_FRACTION"), new PotionEffectSingleUseSource("SMITHING_MASTERPIECE_FRACTION"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_WOOD", new ProfileStatSource(SmithingProfile.class, "woodCraftingSkillFractionBonus"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_LEATHER", new ProfileStatSource(SmithingProfile.class, "leatherCraftingSkillFractionBonus"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_STONE", new ProfileStatSource(SmithingProfile.class, "stoneCraftingSkillFractionBonus"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_CHAINMAIL", new ProfileStatSource(SmithingProfile.class, "chainCraftingSkillFractionBonus"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_GOLD", new ProfileStatSource(SmithingProfile.class, "goldCraftingSkillFractionBonus"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_IRON", new ProfileStatSource(SmithingProfile.class, "ironCraftingSkillFractionBonus"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_DIAMOND", new ProfileStatSource(SmithingProfile.class, "diamondCraftingSkillFractionBonus"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_NETHERITE", new ProfileStatSource(SmithingProfile.class, "netheriteCraftingSkillFractionBonus"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_BOW", new ProfileStatSource(SmithingProfile.class, "bowCraftingSkillFractionBonus"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_CROSSBOW", new ProfileStatSource(SmithingProfile.class, "crossbowCraftingSkillFractionBonus"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_PRISMARINE", new ProfileStatSource(SmithingProfile.class, "prismarineCraftingSkillFractionBonus"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_ENDERIC", new ProfileStatSource(SmithingProfile.class, "endericCraftingSkillFractionBonus"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_COPPER", new ProfileStatSource(SmithingProfile.class, "copperCraftingSkillFractionBonus"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_CUSTOM1", new ProfileStatSource(SmithingProfile.class, "custom1CraftingSkillFractionBonus"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_CUSTOM2", new ProfileStatSource(SmithingProfile.class, "custom2CraftingSkillFractionBonus"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_CUSTOM3", new ProfileStatSource(SmithingProfile.class, "custom3CraftingSkillFractionBonus"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_CUSTOM4", new ProfileStatSource(SmithingProfile.class, "custom4CraftingSkillFractionBonus"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_CUSTOM5", new ProfileStatSource(SmithingProfile.class, "custom5CraftingSkillFractionBonus"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_CUSTOM6", new ProfileStatSource(SmithingProfile.class, "custom6CraftingSkillFractionBonus"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_CUSTOM7", new ProfileStatSource(SmithingProfile.class, "custom7CraftingSkillFractionBonus"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_CUSTOM8", new ProfileStatSource(SmithingProfile.class, "custom8CraftingSkillFractionBonus"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_CUSTOM9", new ProfileStatSource(SmithingProfile.class, "custom9CraftingSkillFractionBonus"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_CUSTOM10", new ProfileStatSource(SmithingProfile.class, "custom10CraftingSkillFractionBonus"));
        AccumulativeStatManager.register("SMITHING_FRACTION_QUALITY_OTHER", new ProfileStatSource(SmithingProfile.class, "otherCraftingSkillFractionBonus"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_GENERAL", new PermissionStatSource("valhalla.exp.smithing"), new ProfileStatSource(SmithingProfile.class, "genericEXPMultiplier"), new GlobalBuffSource("smithing_experience"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_WOOD", new ProfileStatSource(SmithingProfile.class, "woodEXPMultiplier"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_LEATHER", new ProfileStatSource(SmithingProfile.class, "leatherEXPMultiplier"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_STONE", new ProfileStatSource(SmithingProfile.class, "stoneEXPMultiplier"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_CHAINMAIL", new ProfileStatSource(SmithingProfile.class, "chainEXPMultiplier"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_GOLD", new ProfileStatSource(SmithingProfile.class, "goldEXPMultiplier"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_IRON", new ProfileStatSource(SmithingProfile.class, "ironEXPMultiplier"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_DIAMOND", new ProfileStatSource(SmithingProfile.class, "diamondEXPMultiplier"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_NETHERITE", new ProfileStatSource(SmithingProfile.class, "netheriteEXPMultiplier"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_BOW", new ProfileStatSource(SmithingProfile.class, "bowEXPMultiplier"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_CROSSBOW", new ProfileStatSource(SmithingProfile.class, "crossbowEXPMultiplier"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_PRISMARINE", new ProfileStatSource(SmithingProfile.class, "prismarineEXPMultiplier"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_ENDERIC", new ProfileStatSource(SmithingProfile.class, "endericEXPMultiplier"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_COPPER", new ProfileStatSource(SmithingProfile.class, "copperEXPMultiplier"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_CUSTOM1", new ProfileStatSource(SmithingProfile.class, "custom1EXPMultiplier"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_CUSTOM2", new ProfileStatSource(SmithingProfile.class, "custom2EXPMultiplier"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_CUSTOM3", new ProfileStatSource(SmithingProfile.class, "custom3EXPMultiplier"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_CUSTOM4", new ProfileStatSource(SmithingProfile.class, "custom4EXPMultiplier"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_CUSTOM5", new ProfileStatSource(SmithingProfile.class, "custom5EXPMultiplier"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_CUSTOM6", new ProfileStatSource(SmithingProfile.class, "custom6EXPMultiplier"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_CUSTOM7", new ProfileStatSource(SmithingProfile.class, "custom7EXPMultiplier"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_CUSTOM8", new ProfileStatSource(SmithingProfile.class, "custom8EXPMultiplier"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_CUSTOM9", new ProfileStatSource(SmithingProfile.class, "custom9EXPMultiplier"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_CUSTOM10", new ProfileStatSource(SmithingProfile.class, "custom10EXPMultiplier"));
        AccumulativeStatManager.register("SMITHING_EXP_GAIN_OTHER", new ProfileStatSource(SmithingProfile.class, "otherEXPMultiplier"));
        AccumulativeStatManager.register("ALCHEMY_QUALITY_GENERAL", new AttributeSource("ALCHEMY_QUALITY").penalty("attribute"), new ProfileStatSource(AlchemyProfile.class, "genericBrewingSkill"), new GlobalBuffSource("alchemy_quality"), new PotionEffectSource("ALCHEMY_QUALITY"), new PotionEffectSingleUseSource("ALCHEMY_MASTERPIECE_FLAT"));
        AccumulativeStatManager.register("ALCHEMY_QUALITY_DEBUFF", new ProfileStatSource(AlchemyProfile.class, "debuffBrewingSkill"));
        AccumulativeStatManager.register("ALCHEMY_QUALITY_BUFF", new ProfileStatSource(AlchemyProfile.class, "buffBrewingSkill"));
        AccumulativeStatManager.register("ALCHEMY_FRACTION_QUALITY_GENERAL", new AttributeSource("ALCHEMY_QUALITY_FRACTION").penalty("attribute"), new ProfileStatSource(AlchemyProfile.class, "genericBrewingSkillFractionBonus"), new GlobalBuffSource("alchemy_quality_fraction"), new PotionEffectSource("ALCHEMY_QUALITY_FRACTION"), new PotionEffectSingleUseSource("ALCHEMY_MASTERPIECE_FRACTION"));
        AccumulativeStatManager.register("ALCHEMY_FRACTION_QUALITY_DEBUFF", new ProfileStatSource(AlchemyProfile.class, "buffBrewingSkillFractionBonus"));
        AccumulativeStatManager.register("ALCHEMY_FRACTION_QUALITY_BUFF", new ProfileStatSource(AlchemyProfile.class, "debuffBrewingSkillFractionBonus"));
        AccumulativeStatManager.register("BREWING_SPEED_BONUS", new AttributeSource("BREWING_SPEED").penalty("attribute"), new ProfileStatSource(AlchemyProfile.class, "brewingTimeReduction"), new GlobalBuffSource("brewing_speed"), new PotionEffectSource("BREWING_SPEED"));
        AccumulativeStatManager.register("BREWING_INGREDIENT_SAVE_CHANCE", new AttributeSource("BREWING_INGREDIENT_CONSUMPTION").penalty("attribute"), new ProfileStatSource(AlchemyProfile.class, "brewingIngredientSaveChance"), new GlobalBuffSource("brewing_ingredient_save_chance"), new PotionEffectSource("BREWING_INGREDIENT_CONSUMPTION", true));
        AccumulativeStatManager.register("POTION_SAVE_CHANCE", new AttributeSource("POTION_CONSUMPTION").penalty("attribute"), new ProfileStatSource(AlchemyProfile.class, "potionSaveChance"), new GlobalBuffSource("potion_save_chance"), new PotionEffectSource("POTION_CONSUMPTION"));
        AccumulativeStatManager.register("THROW_VELOCITY_BONUS", new AttributeSource("THROWING_VELOCITY").penalty("attribute"), new ProfileStatSource(AlchemyProfile.class, "throwVelocity"), new GlobalBuffSource("throw_velocity"), new PotionEffectSource("THROWING_VELOCITY"));
        AccumulativeStatManager.register("ALCHEMY_EXP_GAIN", new PermissionStatSource("valhalla.exp.alchemy"), new ProfileStatSource(AlchemyProfile.class, "alchemyEXPMultiplier"), new GlobalBuffSource("alchemy_experience"));
        AccumulativeStatManager.register("SPLASH_INTENSITY_MINIMUM", new AttributeSource("SPLASH_INTENSITY_MINIMUM"), new PotionEffectSource("SPLASH_INTENSITY_MINIMUM"), new ProfileStatSource(AlchemyProfile.class, "splashIntensityMinimum"), new GlobalBuffSource("splash_intensity_minimum"));
        AccumulativeStatManager.register("LINGERING_DURATION_MULTIPLIER", new AttributeSource("LINGERING_DURATION_MULTIPLIER"), new PotionEffectSource("LINGERING_DURATION_MULTIPLIER"), new ProfileStatSource(AlchemyProfile.class, "lingeringDurationMultiplier"), new GlobalBuffSource("lingering_duration"));
        AccumulativeStatManager.register("LINGERING_RADIUS_MULTIPLIER", new AttributeSource("LINGERING_RADIUS_MULTIPLIER"), new PotionEffectSource("LINGERING_RADIUS_MULTIPLIER"), new ProfileStatSource(AlchemyProfile.class, "lingeringRadiusMultiplier"), new GlobalBuffSource("lingering_radius"));
        AccumulativeStatManager.register("ENCHANTING_QUALITY", new AttributeSource("ENCHANTING_QUALITY"), new PotionEffectSource("ENCHANTING_QUALITY"), new ProfileStatSource(EnchantingProfile.class, "enchantingSkill"), new GlobalBuffSource("enchanting_quality"), new PotionEffectSingleUseSource("ENCHANTING_MASTERPIECE_FLAT"));
        AccumulativeStatManager.register("ENCHANTING_FRACTION_QUALITY", new AttributeSource("ENCHANTING_QUALITY_FRACTION"), new PotionEffectSource("ENCHANTING_QUALITY_FRACTION"), new ProfileStatSource(EnchantingProfile.class, "enchantingSkillFractionBonus"), new GlobalBuffSource("enchanting_quality"), new PotionEffectSingleUseSource("ENCHANTING_MASTERPIECE_FRACTION"));
        AccumulativeStatManager.register("ENCHANTING_QUALITY_ANVIL", new AttributeSource("ANVIL_QUALITY"), new PotionEffectSource("ANVIL_QUALITY"), new ProfileStatSource(EnchantingProfile.class, "anvilSkill"));
        AccumulativeStatManager.register("ENCHANTING_FRACTION_QUALITY_ANVIL", new AttributeSource("ANVIL_QUALITY_FRACTION"), new PotionEffectSource("ANVIL_QUALITY_FRACTION"), new ProfileStatSource(EnchantingProfile.class, "anvilSkillFractionBonus"));
        AccumulativeStatManager.register("ENCHANTING_AMPLIFY_CHANCE", new ProfileStatSource(EnchantingProfile.class, "enchantmentAmplificationChance"), new GlobalBuffSource("enchanting_amplify_chance"));
        AccumulativeStatManager.register("ENCHANTING_LAPIS_SAVE_CHANCE", new AttributeSource("LAPIS_SAVE_CHANCE", true), new PotionEffectSource("LAPIS_SAVE_CHANCE", true), new ProfileStatSource(EnchantingProfile.class, "lapisSaveChance"), new GlobalBuffSource("enchanting_lapis_save_chance"));
        AccumulativeStatManager.register("ENCHANTING_VANILLA_EXP_GAIN", new AttributeSource("VANILLA_EXP_GAIN"), new PotionEffectSource("VANILLA_EXP_GAIN"), new ProfileStatSource(EnchantingProfile.class, "essenceMultiplier"), new GlobalBuffSource("vanilla_exp_multiplier"));
        AccumulativeStatManager.register("ENCHANTING_REFUND_CHANCE", new AttributeSource("ENCHANTING_REFUND_CHANCE"), new PotionEffectSource("ENCHANTING_REFUND_CHANCE"), new ProfileStatSource(EnchantingProfile.class, "essenceRefundChance"), new GlobalBuffSource("enchanting_exp_refund_chance"));
        AccumulativeStatManager.register("ENCHANTING_REFUND_AMOUNT", new AttributeSource("ENCHANTING_REFUND_FRACTION"), new PotionEffectSource("ENCHANTING_REFUND_FRACTION"), new ProfileStatSource(EnchantingProfile.class, "essenceRefundFraction"), new GlobalBuffSource("enchanting_exp_refund_amount"));
        AccumulativeStatManager.register("ENCHANTING_EXP_GAIN", new PermissionStatSource("valhalla.exp.enchanting"), new ProfileStatSource(EnchantingProfile.class, "enchantingEXPMultiplier"), new GlobalBuffSource("enchanting_experience"));
        AccumulativeStatManager.register("BUTCHERY_DROP_MULTIPLIER", new ProfileStatSource(FarmingProfile.class, "butcheryDrops"), new AttributeSource("FARMING_DROPS"), new PotionEffectSource("FARMING_DROPS"), new GlobalBuffSource("butchery_drop_multiplier"));
        AccumulativeStatManager.register("FARMING_DROP_MULTIPLIER", new ProfileStatSource(FarmingProfile.class, "farmingDrops"), new AttributeSource("FARMING_DROPS"), new PotionEffectSource("FARMING_DROPS"), new GlobalBuffSource("farming_drop_multiplier"));
        AccumulativeStatManager.register("FARMING_LUCK", new ProfileStatSource(FarmingProfile.class, "farmingLuck"), new AttributeSource("FARMING_RARE_DROPS"), new PotionEffectSource("FARMING_RARE_DROPS"), new GlobalBuffSource("farming_luck"));
        AccumulativeStatManager.register("FARMING_EXP_GAIN", new PermissionStatSource("valhalla.exp.farming"), new ProfileStatSource(FarmingProfile.class, "farmingEXPMultiplier"), new GlobalBuffSource("farming_experience"));
        AccumulativeStatManager.register("MINING_DROP_MULTIPLIER", new ProfileStatSource(MiningProfile.class, "miningDrops"), new AttributeSource("MINING_DROPS"), new PotionEffectSource("MINING_DROPS"), new GlobalBuffSource("mining_drop_multiplier"));
        AccumulativeStatManager.register("MINING_LUCK", new ProfileStatSource(MiningProfile.class, "miningLuck"), new AttributeSource("MINING_RARE_DROPS"), new PotionEffectSource("MINING_RARE_DROPS"), new GlobalBuffSource("mining_luck"));
        AccumulativeStatManager.register("BLASTING_DROP_MULTIPLIER", new ProfileStatSource(MiningProfile.class, "blastingDrops"), new AttributeSource("MINING_DROPS"), new PotionEffectSource("MINING_DROPS"), new GlobalBuffSource("blasting_drop_multiplier"));
        AccumulativeStatManager.register("BLASTING_LUCK", new ProfileStatSource(MiningProfile.class, "blastingLuck"), new AttributeSource("MINING_RARE_DROPS"), new PotionEffectSource("MINING_RARE_DROPS"), new GlobalBuffSource("blasting_luck"));
        AccumulativeStatManager.register("MINING_EXP_GAIN", new PermissionStatSource("valhalla.exp.mining"), new ProfileStatSource(MiningProfile.class, "miningEXPMultiplier"), new GlobalBuffSource("mining_experience"));
        AccumulativeStatManager.register("DIGGING_DROP_MULTIPLIER", new ProfileStatSource(DiggingProfile.class, "diggingDrops"), new AttributeSource("DIGGING_DROPS"), new PotionEffectSource("DIGGING_DROPS"), new GlobalBuffSource("digging_drop_multiplier"));
        AccumulativeStatManager.register("DIGGING_LUCK", new ProfileStatSource(DiggingProfile.class, "diggingLuck"), new AttributeSource("DIGGING_RARE_DROPS"), new PotionEffectSource("DIGGING_RARE_DROPS"), new GlobalBuffSource("digging_luck"));
        AccumulativeStatManager.register("DIGGING_ARCHAEOLOGY_LUCK", new ProfileStatSource(DiggingProfile.class, "archaeologyLuck"), new AttributeSource("DIGGING_RARE_DROPS"), new PotionEffectSource("DIGGING_RARE_DROPS"), new GlobalBuffSource("archaeology_luck"));
        AccumulativeStatManager.register("DIGGING_EXP_GAIN", new PermissionStatSource("valhalla.exp.digging"), new ProfileStatSource(DiggingProfile.class, "diggingEXPMultiplier"), new GlobalBuffSource("digging_experience"));
        AccumulativeStatManager.register("WOODCUTTING_DROP_MULTIPLIER", new ProfileStatSource(WoodcuttingProfile.class, "woodcuttingDrops"), new AttributeSource("WOODCUTTING_DROPS"), new PotionEffectSource("WOODCUTTING_DROPS"), new GlobalBuffSource("woodcutting_drop_multiplier"));
        AccumulativeStatManager.register("WOODCUTTING_LUCK", new ProfileStatSource(WoodcuttingProfile.class, "woodcuttingLuck"), new AttributeSource("WOODCUTTING_RARE_DROPS"), new PotionEffectSource("WOODCUTTING_RARE_DROPS"), new GlobalBuffSource("woodcutting_luck"));
        AccumulativeStatManager.register("WOODCUTTING_EXP_GAIN", new PermissionStatSource("valhalla.exp.woodcutting"), new ProfileStatSource(WoodcuttingProfile.class, "woodcuttingEXPMultiplier"), new GlobalBuffSource("woodcutting_experience"));
        AccumulativeStatManager.register("FISHING_EXP_GAIN", new PermissionStatSource("valhalla.exp.fishing"), new ProfileStatSource(FishingProfile.class, "fishingEXPMultiplier"), new GlobalBuffSource("fishing_experience"));
        AccumulativeStatManager.register("ARCHERY_EXP_GAIN", new PermissionStatSource("valhalla.exp.archery"), new ProfileStatSource(ArcheryProfile.class, "archeryEXPMultiplier"), new GlobalBuffSource("archery_experience"));
        AccumulativeStatManager.register("LIGHT_ARMOR_EXP_GAIN", new PermissionStatSource("valhalla.exp.light_armor"), new ProfileStatSource(LightArmorProfile.class, "lightArmorEXPMultiplier"), new GlobalBuffSource("light_armor_experience"));
        AccumulativeStatManager.register("HEAVY_ARMOR_EXP_GAIN", new PermissionStatSource("valhalla.exp.heavy_armor"), new ProfileStatSource(HeavyArmorProfile.class, "heavyArmorEXPMultiplier"), new GlobalBuffSource("heavy_armor_experience"));
        AccumulativeStatManager.register("LIGHT_WEAPONS_EXP_GAIN", new PermissionStatSource("valhalla.exp.light_weapons"), new ProfileStatSource(LightWeaponsProfile.class, "lightWeaponsEXPMultiplier"), new GlobalBuffSource("light_weapons_experience"));
        AccumulativeStatManager.register("HEAVY_WEAPONS_EXP_GAIN", new PermissionStatSource("valhalla.exp.heavy_weapons"), new ProfileStatSource(HeavyWeaponsProfile.class, "heavyWeaponsEXPMultiplier"), new GlobalBuffSource("heavy_weapons_experience"));
        STAT_CACHE = new ConcurrentHashMap<UUID, Map<String, Map.Entry<Long, Double>>>();
        lastMapCleanup = System.currentTimeMillis();
    }
}

