/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.playerstats;

import java.util.Arrays;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatSource;
import me.athlaeos.valhallammo.playerstats.StatCollector;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import me.athlaeos.valhallammo.playerstats.statsources.ProfileStatSource;

public class StatCollectorBuilder {
    private final StatCollector collector = new StatCollector();

    public StatCollector build() {
        if (this.collector.getFormat() != null) {
            return this.collector;
        }
        ProfileStatSource profileSource = this.collector.getStatSources().stream().filter(p -> p instanceof ProfileStatSource).findAny().orElse(null);
        if (profileSource != null && profileSource.getFormat() != null) {
            this.collector.setFormat(profileSource.getFormat());
        } else {
            this.collector.setFormat(StatFormat.FLOAT_P2);
        }
        return this.collector;
    }

    public StatCollectorBuilder setAttackerPossessive() {
        this.collector.setAttackerPossessive(true);
        return this;
    }

    public StatCollectorBuilder addSources(AccumulativeStatSource ... sources) {
        this.collector.getStatSources().addAll(Arrays.asList(sources));
        return this;
    }

    public StatCollectorBuilder setStatFormat(StatFormat format) {
        this.collector.setFormat(format);
        return this;
    }
}

