/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.playerstats.profiles;

import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.persistence.ProfilePersistence;
import me.athlaeos.valhallammo.persistence.implementations.RedisLockedSQL;
import me.athlaeos.valhallammo.persistence.implementations.SQL;
import me.athlaeos.valhallammo.persistence.implementations.SQLite;
import me.athlaeos.valhallammo.placeholder.PlaceholderRegistry;
import me.athlaeos.valhallammo.placeholder.placeholders.NumericProfileStatPlaceholder;
import me.athlaeos.valhallammo.placeholder.placeholders.ProfileNextLevelEXPPlaceholder;
import me.athlaeos.valhallammo.placeholder.placeholders.ProfileNextLevelPlaceholder;
import me.athlaeos.valhallammo.playerstats.LeaderboardManager;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.ResetType;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.AlchemyProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.ArcheryProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.DiggingProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.EnchantingProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.FarmingProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.FishingProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.HeavyArmorProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.HeavyWeaponsProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.LightArmorProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.LightWeaponsProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.MiningProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.SmithingProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.WoodcuttingProfile;
import me.athlaeos.valhallammo.skills.skills.Skill;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerEvent;

public class ProfileRegistry {
    private static ProfilePersistence persistence = null;
    private static final int delay_profile_saving = ConfigManager.getConfig("config.yml").reload().get().getInt("db_persist_delay");
    private static Map<Class<? extends Profile>, Profile> registeredProfiles = Collections.unmodifiableMap(new HashMap());
    private static final boolean savingProfilesMessage = ValhallaMMO.getPluginConfig().getBoolean("saving_profiles_notification");
    private static long lastSaved = 0L;

    public static void registerDefaultProfiles() {
        ProfileRegistry.registerProfileType(new PowerProfile(null));
        ProfileRegistry.registerProfileType(new AlchemyProfile(null));
        ProfileRegistry.registerProfileType(new SmithingProfile(null));
        ProfileRegistry.registerProfileType(new EnchantingProfile(null));
        ProfileRegistry.registerProfileType(new HeavyWeaponsProfile(null));
        ProfileRegistry.registerProfileType(new LightWeaponsProfile(null));
        ProfileRegistry.registerProfileType(new ArcheryProfile(null));
        ProfileRegistry.registerProfileType(new HeavyArmorProfile(null));
        ProfileRegistry.registerProfileType(new LightArmorProfile(null));
        ProfileRegistry.registerProfileType(new MiningProfile(null));
        ProfileRegistry.registerProfileType(new FarmingProfile(null));
        ProfileRegistry.registerProfileType(new WoodcuttingProfile(null));
        ProfileRegistry.registerProfileType(new DiggingProfile(null));
        ProfileRegistry.registerProfileType(new FishingProfile(null));
    }

    public static void registerProfileType(Profile p) {
        MutableClassToInstanceMap profiles = MutableClassToInstanceMap.create(new HashMap<Class<? extends Profile>, Profile>(registeredProfiles));
        profiles.put(p.getClass(), (Object)p);
        registeredProfiles = ImmutableClassToInstanceMap.copyOf((Map)profiles);
        p.initStats();
        p.registerPerkRewards();
        persistence.createProfileTable(p);
        for (String numberStat : p.getNumberStatProperties().keySet()) {
            StatFormat format = p.getNumberStatProperties().get(numberStat).getFormat();
            if (format == null) continue;
            PlaceholderRegistry.registerPlaceholder(new NumericProfileStatPlaceholder("%" + p.getClass().getSimpleName().toLowerCase(Locale.US) + "_" + numberStat.toLowerCase(Locale.US) + "%", p.getClass(), numberStat, format));
        }
        PlaceholderRegistry.registerPlaceholder(new ProfileNextLevelPlaceholder("%" + p.getClass().getSimpleName().toLowerCase(Locale.US) + "_next_level%", p.getClass(), StatFormat.INT));
        PlaceholderRegistry.registerPlaceholder(new ProfileNextLevelEXPPlaceholder("%" + p.getClass().getSimpleName().toLowerCase(Locale.US) + "_next_level_exp%", p.getClass(), StatFormat.INT));
    }

    public static boolean setupDatabase() {
        if (persistence != null) {
            return true;
        }
        YamlConfiguration config = ValhallaMMO.getPluginConfig();
        String type = config.getString("db_type", "sqlite").toLowerCase(Locale.ROOT);
        boolean redis = config.getBoolean("redis_lock", false);
        if (type.equals("mysql")) {
            if (redis) {
                persistence = new RedisLockedSQL();
                if (((RedisLockedSQL)persistence).getPool() == null) {
                    return false;
                }
            } else {
                persistence = new SQL();
            }
        } else {
            if (!type.equals("sqlite")) {
                ValhallaMMO.logWarning("Invalid database type " + type + ", defaulting to sqlite");
            }
            if (redis) {
                ValhallaMMO.logWarning("Redis locking is enabled, but database is not MySQL, no redis locking will be used.");
            }
            persistence = new SQLite();
        }
        if (persistence.getConnection() == null) {
            return false;
        }
        ProfileRegistry.persistence.profileThreads.scheduleAtFixedRate(() -> {
            if (lastSaved + (long)delay_profile_saving > System.currentTimeMillis()) {
                return;
            }
            try {
                long start = System.currentTimeMillis();
                if (savingProfilesMessage) {
                    ValhallaMMO.logFine("Starting saving all profiles");
                }
                ProfileRegistry.saveAll(false);
                long end = System.currentTimeMillis();
                if (savingProfilesMessage) {
                    ValhallaMMO.logFine("Finished saving all profiles in " + (double)(end - start) / 1000.0 + "s");
                }
                LeaderboardManager.refreshLeaderboards();
            }
            catch (Exception e) {
                throw new RuntimeException("An error occurred while saving profiles", e);
            }
            lastSaved = System.currentTimeMillis();
        }, delay_profile_saving, delay_profile_saving, TimeUnit.MILLISECONDS);
        return true;
    }

    public static void saveAll(boolean async) {
        persistence.saveAllProfiles(async);
        ProfileCache.cleanCache();
        LeaderboardManager.refreshLeaderboards();
    }

    public static ProfilePersistence getPersistence() {
        return persistence;
    }

    public static void setPersistence(ProfilePersistence p) {
        if (p == null) {
            return;
        }
        persistence = p;
    }

    public static boolean isLoaded(PlayerEvent e) {
        return persistence.isLoaded(e.getPlayer().getUniqueId());
    }

    public static boolean isLoaded(Player p) {
        return p != null && persistence.isLoaded(p.getUniqueId());
    }

    public static void setPersistentProfile(Player p, Profile profile, Class<? extends Profile> type) {
        persistence.trySetPersistentProfile(p.getUniqueId(), profile, type);
    }

    public static void setBlankSkillProfile(Player p, Class<? extends Profile> type) {
        ProfileRegistry.setSkillProfile(p, ProfileRegistry.getBlankProfile(p, type), type);
    }

    public static void setSkillProfile(Player p, Profile profile, Class<? extends Profile> type) {
        persistence.trySetSkillProfile(p.getUniqueId(), profile, type);
    }

    public static <P extends Profile> P getPersistentProfile(Player p, Class<P> type) {
        P profile = persistence.getPersistentProfile(p.getUniqueId(), type);
        return profile == null ? ProfileRegistry.getBlankProfile(p, type) : profile;
    }

    public static <P extends Profile> P getSkillProfile(Player p, Class<P> type) {
        P profile = persistence.getSkillProfile(p.getUniqueId(), type);
        return profile == null ? ProfileRegistry.getBlankProfile(p, type) : profile;
    }

    public static <P extends Profile> P getMergedProfile(Player p, Class<P> type) {
        P p1 = ProfileRegistry.getPersistentProfile(p, type);
        P p2 = ProfileRegistry.getSkillProfile(p, type);
        return (P)((Profile)p2).merge((Profile)p1, p);
    }

    public static Map<Class<? extends Profile>, Profile> getRegisteredProfiles() {
        return new HashMap<Class<? extends Profile>, Profile>(registeredProfiles);
    }

    public static <P extends Profile> P getBlankProfile(Class<P> type) {
        return ProfileRegistry.getBlankProfile((UUID)null, type);
    }

    public static <P extends Profile> P getBlankProfile(Player owner, Class<P> type) {
        return ProfileRegistry.getBlankProfile(owner.getUniqueId(), type);
    }

    public static <P extends Profile> P getBlankProfile(UUID owner, Class<P> type) {
        if (!registeredProfiles.containsKey(type)) {
            throw new IllegalArgumentException("Profile type " + type.getSimpleName() + " was not yet registered for usage");
        }
        return (P)registeredProfiles.get(type).getBlankProfile(owner);
    }

    public static void reset(Player p, ResetType type) {
        persistence.resetProfile(p, type);
    }

    public static <S extends Skill> void reset(Player p, Class<S> type) {
        persistence.resetSkillProgress(p, type);
    }

    public static <P extends Profile> P copyDefaultStats(P profile) {
        Profile defaultProfile = registeredProfiles.get(profile.getClass());
        if (defaultProfile == null) {
            return profile;
        }
        profile.copyStats(defaultProfile);
        return profile;
    }
}

