/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.playerstats.profiles.implementations;

import java.util.Collection;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.item.FoodClass;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.playerstats.profiles.properties.BooleanProperties;
import me.athlaeos.valhallammo.playerstats.profiles.properties.PropertyBuilder;
import me.athlaeos.valhallammo.skills.skills.Skill;
import me.athlaeos.valhallammo.skills.skills.implementations.PowerSkill;
import org.bukkit.NamespacedKey;
import org.bukkit.plugin.Plugin;

public class PowerProfile
extends Profile {
    private static final NamespacedKey key = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "profile_power");

    public float getShieldDisarming() {
        return this.getFloat("shieldDisarming");
    }

    public void setShieldDiarming(float value) {
        this.setFloat("shieldDisarming", value);
    }

    public float getLifeSteal() {
        return this.getFloat("lifeSteal");
    }

    public void setLifeSteal(float value) {
        this.setFloat("lifeSteal", value);
    }

    public float getFoodBonus(FoodClass foodClass) {
        return this.getFloat(switch (foodClass) {
            default -> throw new IncompatibleClassChangeError();
            case FoodClass.VEGETABLE -> "foodBonusVegetable";
            case FoodClass.SEASONING -> "foodBonusSeasoning";
            case FoodClass.ALCOHOLIC -> "foodBonusAlcoholic";
            case FoodClass.BEVERAGE -> "foodBonusBeverage";
            case FoodClass.SPOILED -> "foodBonusSpoiled";
            case FoodClass.SEAFOOD -> "foodBonusSeafood";
            case FoodClass.MAGICAL -> "foodBonusMagical";
            case FoodClass.SWEET -> "foodBonusSweet";
            case FoodClass.GRAIN -> "foodBonusGrain";
            case FoodClass.FRUIT -> "foodBonusFruit";
            case FoodClass.DAIRY -> "foodBonusNuts";
            case FoodClass.NUTS -> "foodBonusDairy";
            case FoodClass.MEAT -> "foodBonusMeat";
            case FoodClass.FATS -> "foodBonusFats";
        });
    }

    public void setFoodBonus(FoodClass foodClass, float value) {
        this.setFloat(switch (foodClass) {
            default -> throw new IncompatibleClassChangeError();
            case FoodClass.VEGETABLE -> "foodBonusVegetable";
            case FoodClass.SEASONING -> "foodBonusSeasoning";
            case FoodClass.ALCOHOLIC -> "foodBonusAlcoholic";
            case FoodClass.BEVERAGE -> "foodBonusBeverage";
            case FoodClass.SPOILED -> "foodBonusSpoiled";
            case FoodClass.SEAFOOD -> "foodBonusSeafood";
            case FoodClass.MAGICAL -> "foodBonusMagical";
            case FoodClass.SWEET -> "foodBonusSweet";
            case FoodClass.GRAIN -> "foodBonusGrain";
            case FoodClass.FRUIT -> "foodBonusFruit";
            case FoodClass.DAIRY -> "foodBonusNuts";
            case FoodClass.NUTS -> "foodBonusDairy";
            case FoodClass.MEAT -> "foodBonusMeat";
            case FoodClass.FATS -> "foodBonusFats";
        }, value);
    }

    public boolean hasAquaAffinity() {
        return this.getBoolean("miningAffinityWater");
    }

    public void setAquaAffinity(boolean affinity) {
        this.setBoolean("miningAffinityWater", affinity);
    }

    public boolean hasInventoryRepairingKeepEnchanting() {
        return this.getBoolean("inventoryRepairingKeepEnchanting");
    }

    public void setInventoryRepairingKeepEnchanting(boolean affinity) {
        this.setBoolean("inventoryRepairingKeepEnchanting", affinity);
    }

    public boolean hasAerialAffinity() {
        return this.getBoolean("miningAffinityAir");
    }

    public void setAerialAffinity(boolean affinity) {
        this.setBoolean("miningAffinityAir", affinity);
    }

    public boolean isBadFoodImmune() {
        return this.getBoolean("badFoodImmune");
    }

    public void setBadFoodImmune(boolean immune) {
        this.setBoolean("badFoodImmune", immune);
    }

    public boolean hidePotionEffectBar() {
        return this.getBoolean("hidePotionEffectBar");
    }

    public void togglePotionEffectBar() {
        this.setBoolean("hidePotionEffectBar", !this.hidePotionEffectBar());
    }

    public boolean hideCraftingEffects() {
        return this.getBoolean("hideCraftingEffects");
    }

    public void toggleCraftingEffects() {
        this.setBoolean("hideCraftingEffects", !this.hideCraftingEffects());
    }

    public boolean hideExperienceGain() {
        return this.getBoolean("hideExperienceGain");
    }

    public void toggleExperienceGain() {
        this.setBoolean("hideExperienceGain", !this.hideExperienceGain());
    }

    public boolean hideGlobalBuffs() {
        return this.getBoolean("hideGlobalBuffs");
    }

    public void toggleGlobalBuffs() {
        this.setBoolean("hideGlobalBuffs", !this.hideGlobalBuffs());
    }

    public float getOneShotProtectionFraction() {
        return this.getFloat("oneShotProtectionFraction");
    }

    public void setOneShotProtectionFraction(float volume) {
        this.setFloat("oneShotProtectionFraction", volume);
    }

    public float getWaterMovementEfficiencyBonus() {
        return this.getFloat("waterMovementEfficiencyBonus");
    }

    public void setWaterMovementEfficiencyBonus(float volume) {
        this.setFloat("waterMovementEfficiencyBonus", volume);
    }

    public float getSubmergedMiningSpeedBonus() {
        return this.getFloat("submergedMiningSpeedBonus");
    }

    public void setSubmergedMiningSpeedBonus(float volume) {
        this.setFloat("submergedMiningSpeedBonus", volume);
    }

    public float getFrontDamageReduction() {
        return this.getFloat("frontDamageReduction");
    }

    public void setFrontDamageReduction(float volume) {
        this.setFloat("frontDamageReduction", volume);
    }

    public float getBackDamageReduction() {
        return this.getFloat("backDamageReduction");
    }

    public void setBackDamageReduction(float volume) {
        this.setFloat("backDamageReduction", volume);
    }

    public float getDamageAbsorption() {
        return this.getFloat("damageAbsorption");
    }

    public void setDamageAbsorption(float volume) {
        this.setFloat("damageAbsorption", volume);
    }

    public float getFlightSpeedBonus() {
        return this.getFloat("flightSpeedBonus");
    }

    public void setFlightSpeedBonus(float volume) {
        this.setFloat("flightSpeedBonus", volume);
    }

    public float getOxygenBonus() {
        return this.getFloat("oxygenBonus");
    }

    public void setOxygenBonus(float volume) {
        this.setFloat("oxygenBonus", volume);
    }

    public float getCraftingSoundVolume() {
        return this.getFloat("craftingEffectVolume");
    }

    public void setCraftingSoundVolume(float volume) {
        this.setFloat("craftingEffectVolume", volume);
    }

    public float getArmorlessArmor() {
        return this.getFloat("armorlessArmor");
    }

    public void setArmorlessArmor(float volume) {
        this.setFloat("armorlessArmor", volume);
    }

    public int getSpendableSkillPoints() {
        return this.getInt("spendableSkillPoints");
    }

    public void setSpendableSkillPoints(int value) {
        this.setInt("spendableSkillPoints", value);
    }

    public int getOneShotProtectionCooldown() {
        return this.getInt("oneShotProtectionCooldown");
    }

    public void setOneShotProtectionCooldown(int points) {
        this.setInt("oneShotProtectionCooldown", points);
    }

    public int getSpentSkillPoints() {
        return this.getInt("spentSkillPoints");
    }

    public void setSpentSkillPoints(int points) {
        this.setInt("spentSkillPoints", points);
    }

    public int getSpendablePrestigePoints() {
        return this.getInt("spendablePrestigePoints");
    }

    public void setSpendablePrestigePoints(int value) {
        this.setInt("spendablePrestigePoints", value);
    }

    public int getCrossbowMagazine() {
        return this.getInt("crossbowMagazine");
    }

    public void setCrossbowMagazine(int points) {
        this.setInt("crossbowMagazine", points);
    }

    public int getSpentPrestigePoints() {
        return this.getInt("spentPrestigePoints");
    }

    public void setSpentPrestigePoints(int points) {
        this.setInt("spentPrestigePoints", points);
    }

    public int getRedeemableLevelTokens() {
        return this.getInt("redeemableLevelTokens");
    }

    public void setRedeemableLevelTokens(int value) {
        this.setInt("redeemableLevelTokens", value);
    }

    public int getItemCounterLimit() {
        return this.getInt("itemCounterLimit");
    }

    public void setItemCounterLimit(int value) {
        this.setInt("itemCounterLimit", value);
    }

    public int getImmunityFrameBonus() {
        return this.getInt("immunityFrameBonus");
    }

    public void setImmunityFrameBonus(int value) {
        this.setInt("immunityFrameBonus", value);
    }

    public int getJumpBonus() {
        return this.getInt("jumpBonus");
    }

    public void setJumpBonus(int value) {
        this.setInt("jumpBonus", value);
    }

    public float getJumpHeightBonus() {
        return this.getFloat("jumpHeightBonus");
    }

    public void setJumpHeightBonus(float value) {
        this.setFloat("jumpHeightBonus", value);
    }

    public float getBlockReachBonus() {
        return this.getFloat("blockReachBonus");
    }

    public void setBlockReachBonus(float value) {
        this.setFloat("blockReachBonus", value);
    }

    public float getStepHeightBonus() {
        return this.getFloat("stepHeightBonus");
    }

    public void setStepHeightBonus(float value) {
        this.setFloat("stepHeightBonus", value);
    }

    public float getScaleMultiplier() {
        return this.getFloat("scaleMultiplier");
    }

    public void setScaleMultiplier(float value) {
        this.setFloat("scaleMultiplier", value);
    }

    public float getAttackReachMultiplier() {
        return this.getFloat("attackReachMultiplier");
    }

    public void setAttackReachMultiplier(float value) {
        this.setFloat("attackReachMultiplier", value);
    }

    public float getDismountChance() {
        return this.getFloat("dismountChance");
    }

    public void setDismountChance(float value) {
        this.setFloat("dismountChance", value);
    }

    public int getParryEffectiveDuration() {
        return this.getInt("parryEffectiveDuration");
    }

    public void setParryEffectiveDuration(int value) {
        this.setInt("parryEffectiveDuration", value);
    }

    public int getParryVulnerableDuration() {
        return this.getInt("parryVulnerableDuration");
    }

    public void setParryVulnerableDuration(int value) {
        this.setInt("parryVulnerableDuration", value);
    }

    public int getParryEnemyDebuffDuration() {
        return this.getInt("parryEnemyDebuffDuration");
    }

    public void setParryEnemyDebuffDuration(int value) {
        this.setInt("parryEnemyDebuffDuration", value);
    }

    public int getParrySelfDebuffDuration() {
        return this.getInt("parrySelfDebuffDuration");
    }

    public void setParrySelfDebuffDuration(int value) {
        this.setInt("parrySelfDebuffDuration", value);
    }

    public float getParryDamageReduction() {
        return this.getFloat("parryDamageReduction");
    }

    public void setParryDamageReduction(int value) {
        this.setFloat("parryDamageReduction", value);
    }

    public int getParryCooldown() {
        return this.getInt("parryCooldown");
    }

    public void setParryCooldown(int value) {
        this.setInt("parryCooldown", value);
    }

    public float getParryCooldownSuccessReduction() {
        return this.getFloat("parryCooldownSuccessReduction");
    }

    public void setParryCooldownSuccessReduction(int value) {
        this.setFloat("parryCooldownSuccessReduction", value);
    }

    public float getImmunityFrameMultiplier() {
        return this.getFloat("immunityFrameMultiplier");
    }

    public void setImmunityFrameMultiplier(float value) {
        this.setFloat("immunityFrameMultiplier", value);
    }

    public float getHealthBonus() {
        return this.getFloat("healthBonus");
    }

    public void setHealthBonus(float value) {
        this.setFloat("healthBonus", value);
    }

    public float getHealthMultiplier() {
        return this.getFloat("healthMultiplier");
    }

    public void setHealthMultiplier(float value) {
        this.setFloat("healthMultiplier", value);
    }

    public float getMovementSpeedBonus() {
        return this.getFloat("movementSpeedBonus");
    }

    public void setMovementSpeedBonus(float value) {
        this.setFloat("movementSpeedBonus", value);
    }

    public float getSneakMovementSpeedBonus() {
        return this.getFloat("sneakMovementSpeedBonus");
    }

    public void setSneakMovementSpeedBonus(float value) {
        this.setFloat("sneakMovementSpeedBonus", value);
    }

    public float getSprintMovementSpeedBonus() {
        return this.getFloat("sprintMovementSpeedBonus");
    }

    public void setSprintMovementSpeedBonus(float value) {
        this.setFloat("sprintMovementSpeedBonus", value);
    }

    public float getKnockbackResistanceBonus() {
        return this.getFloat("knockbackResistanceBonus");
    }

    public void setKnockbackResistanceBonus(float value) {
        this.setFloat("knockbackResistanceBonus", value);
    }

    public float getArmorBonus() {
        return this.getFloat("armorBonus");
    }

    public void setArmorBonus(float value) {
        this.setFloat("armorBonus", value);
    }

    public float getArmorMultiplierBonus() {
        return this.getFloat("armorMultiplierBonus");
    }

    public void setArmorMultiplierBonus(float value) {
        this.setFloat("armorMultiplierBonus", value);
    }

    public float getToughnessBonus() {
        return this.getFloat("toughnessBonus");
    }

    public void setToughnessBonus(float value) {
        this.setFloat("toughnessBonus", value);
    }

    public float getAttackReachBonus() {
        return this.getFloat("attackReachBonus");
    }

    public void setAttackReachBonus(float value) {
        this.setFloat("attackReachBonus", value);
    }

    public float getAttackDamageBonus() {
        return this.getFloat("attackDamageBonus");
    }

    public void setAttackDamageBonus(float value) {
        this.setFloat("attackDamageBonus", value);
    }

    public float getFireDamageBonus() {
        return this.getFloat("fireDamageBonus");
    }

    public void setFireDamageBonus(float value) {
        this.setFloat("fireDamageBonus", value);
    }

    public float getExplosionDamageBonus() {
        return this.getFloat("explosionDamageBonus");
    }

    public void setExplosionDamageBonus(float value) {
        this.setFloat("explosionDamageBonus", value);
    }

    public float getBludgeoningDamageBonus() {
        return this.getFloat("bludgeoningDamageBonus");
    }

    public void setBludgeoningDamageBonus(float value) {
        this.setFloat("bludgeoningDamageBonus", value);
    }

    public float getLightningDamageBonus() {
        return this.getFloat("lightningDamageBonus");
    }

    public void setLightningDamageBonus(float value) {
        this.setFloat("lightningDamageBonus", value);
    }

    public float getFreezingingDamageBonus() {
        return this.getFloat("freezingDamageBonus");
    }

    public void setFreezingDamageBonus(float value) {
        this.setFloat("freezingDamageBonus", value);
    }

    public float getRadiantDamageBonus() {
        return this.getFloat("radiantDamageBonus");
    }

    public void setRadiantDamageBonus(float value) {
        this.setFloat("radiantDamageBonus", value);
    }

    public float getNecroticDamageBonus() {
        return this.getFloat("necroticDamageBonus");
    }

    public void setNecroticDamageBonus(float value) {
        this.setFloat("necroticDamageBonus", value);
    }

    public float getPoisonDamageBonus() {
        return this.getFloat("poisonDamageBonus");
    }

    public void setPoisonDamageBonus(float value) {
        this.setFloat("poisonDamageBonus", value);
    }

    public float getMagicDamageBonus() {
        return this.getFloat("magicDamageBonus");
    }

    public void setMagicDamageBonus(float value) {
        this.setFloat("magicDamageBonus", value);
    }

    public float getAttackDamageMultiplier() {
        return this.getFloat("attackDamageMultiplier");
    }

    public void setAttackDamageMultiplier(float value) {
        this.setFloat("attackDamageMultiplier", value);
    }

    public float getMeleeAttackDamageMultiplier() {
        return this.getFloat("meleeAttackDamageMultiplier");
    }

    public void setMeleeAttackDamageMultiplier(float value) {
        this.setFloat("meleeAttackDamageMultiplier", value);
    }

    public float getUnarmedAttackDamageMultiplier() {
        return this.getFloat("unarmedAttackDamageMultiplier");
    }

    public void setUnarmedAttackDamageMultiplier(float value) {
        this.setFloat("unarmedAttackDamageMultiplier", value);
    }

    public float getRangedAttackDamageMultiplier() {
        return this.getFloat("rangedAttackDamageMultiplier");
    }

    public void setRangedAttackDamageMultiplier(float value) {
        this.setFloat("rangedAttackDamageMultiplier", value);
    }

    public float getMagicDamageMultiplier() {
        return this.getFloat("magicDamageMultiplier");
    }

    public void setMagicDamageMultiplier(float value) {
        this.setFloat("magicDamageMultiplier", value);
    }

    public float getFireDamageMultiplier() {
        return this.getFloat("fireDamageMultiplier");
    }

    public void setFireDamageMultiplier(float value) {
        this.setFloat("fireDamageMultiplier", value);
    }

    public float getPoisonDamageMultiplier() {
        return this.getFloat("poisonDamageMultiplier");
    }

    public void setPoisonDamageMultiplier(float value) {
        this.setFloat("poisonDamageMultiplier", value);
    }

    public float getBludgeoningDamageMultiplier() {
        return this.getFloat("bludgeoningDamageMultiplier");
    }

    public void setBludgeoningDamageMultiplier(float value) {
        this.setFloat("bludgeoningDamageMultiplier", value);
    }

    public float getLightningDamageMultiplier() {
        return this.getFloat("lightningDamageMultiplier");
    }

    public void setLightningDamageMultiplier(float value) {
        this.setFloat("lightningDamageMultiplier", value);
    }

    public float getFreezingDamageMultiplier() {
        return this.getFloat("freezingDamageMultiplier");
    }

    public void setFreezingDamageMultiplier(float value) {
        this.setFloat("freezingDamageMultiplier", value);
    }

    public float getRadiantDamageMultiplier() {
        return this.getFloat("radiantDamageMultiplier");
    }

    public void setRadiantDamageMultiplier(float value) {
        this.setFloat("radiantDamageMultiplier", value);
    }

    public float getNecroticDamageMultiplier() {
        return this.getFloat("necroticDamageMultiplier");
    }

    public void setNecroticDamageMultiplier(float value) {
        this.setFloat("necroticDamageMultiplier", value);
    }

    public float getExplosionDamageMultiplier() {
        return this.getFloat("explosionDamageMultiplier");
    }

    public void setExplosionDamageMultiplier(float value) {
        this.setFloat("explosionDamageMultiplier", value);
    }

    public float getPlayerDamageMultiplier() {
        return this.getFloat("playerDamageMultiplier");
    }

    public void setPlayerDamageMultiplier(float value) {
        this.setFloat("playerDamageMultiplier", value);
    }

    public float getMountedDamageMultiplier() {
        return this.getFloat("mountedDamageMultiplier");
    }

    public void setMountedDamageMultiplier(float value) {
        this.setFloat("mountedDamageMultiplier", value);
    }

    public float getAttackSpeedBonus() {
        return this.getFloat("attackSpeedBonus");
    }

    public void setAttackSpeedBonus(float value) {
        this.setFloat("attackSpeedBonus", value);
    }

    public float getAttackKnockbackBonus() {
        return this.getFloat("attackKnockbackBonus");
    }

    public void setAttackKnockbackBonus(float value) {
        this.setFloat("attackKnockbackBonus", value);
    }

    public float getLuckBonus() {
        return this.getFloat("luckBonus");
    }

    public void setLuckBonus(float value) {
        this.setFloat("luckBonus", value);
    }

    public float getHealthRegenerationBonus() {
        return this.getFloat("healthRegenerationBonus");
    }

    public void setHealthRegenerationBonus(float value) {
        this.setFloat("healthRegenerationBonus", value);
    }

    public float getHungerSaveChance() {
        return this.getFloat("hungerSaveChance");
    }

    public void setHungerSaveChance(float value) {
        this.setFloat("hungerSaveChance", value);
    }

    public float getDamageResistance() {
        return this.getFloat("damageResistance");
    }

    public void setDamageResistance(float value) {
        this.setFloat("damageResistance", value);
    }

    public float getMeleeResistance() {
        return this.getFloat("meleeResistance");
    }

    public void setMeleeResistance(float value) {
        this.setFloat("meleeResistance", value);
    }

    public float getProjectileResistance() {
        return this.getFloat("projectileResistance");
    }

    public void setProjectileResistance(float value) {
        this.setFloat("projectileResistance", value);
    }

    public float getFireResistance() {
        return this.getFloat("fireResistance");
    }

    public void setFireResistance(float value) {
        this.setFloat("fireResistance", value);
    }

    public float getExplosionResistance() {
        return this.getFloat("explosionResistance");
    }

    public void setExplosionResistance(float value) {
        this.setFloat("explosionResistance", value);
    }

    public float getMagicResistance() {
        return this.getFloat("magicResistance");
    }

    public void setMagicResistance(float value) {
        this.setFloat("magicResistance", value);
    }

    public float getPoisonResistance() {
        return this.getFloat("poisonResistance");
    }

    public void setPoisonResistance(float value) {
        this.setFloat("poisonResistance", value);
    }

    public float getPvPResistance() {
        return this.getFloat("pvpResistance");
    }

    public void setPvPResistance(float value) {
        this.setFloat("pvpResistance", value);
    }

    public float getFallDamageResistance() {
        return this.getFloat("fallDamageResistance");
    }

    public void setFallDamageResistance(float value) {
        this.setFloat("fallDamageResistance", value);
    }

    public float getCritDamageResistance() {
        return this.getFloat("critDamageResistance");
    }

    public void setCritDamageResistance(float value) {
        this.setFloat("critDamageResistance", value);
    }

    public float getCritChanceResistance() {
        return this.getFloat("critChanceResistance");
    }

    public void setCritChanceResistance(float value) {
        this.setFloat("critChanceResistance", value);
    }

    public float getBludgeoningResistance() {
        return this.getFloat("bludgeoningResistance");
    }

    public void setBludgeoningResistance(float value) {
        this.setFloat("bludgeoningResistance", value);
    }

    public float getLightningResistance() {
        return this.getFloat("lightningResistance");
    }

    public void setLightningResistance(float value) {
        this.setFloat("lightningResistance", value);
    }

    public float getFreezingResistance() {
        return this.getFloat("freezingResistance");
    }

    public void setFreezingResistance(float value) {
        this.setFloat("freezingResistance", value);
    }

    public float getRadiantResistance() {
        return this.getFloat("radiantResistance");
    }

    public void setRadiantResistance(float value) {
        this.setFloat("radiantResistance", value);
    }

    public float getNecroticResistance() {
        return this.getFloat("necroticResistance");
    }

    public void setNecroticResistance(float value) {
        this.setFloat("necroticResistance", value);
    }

    public float getCooldownReduction() {
        return this.getFloat("cooldownReduction");
    }

    public void setCooldownReduction(float value) {
        this.setFloat("cooldownReduction", value);
    }

    public float getCraftingTimeReduction() {
        return this.getFloat("craftingTimeReduction");
    }

    public void setCraftingTimeReduction(float value) {
        this.setFloat("craftingTimeReduction", value);
    }

    public float getCookingSpeedBonus() {
        return this.getFloat("cookingSpeedBonus");
    }

    public void setCookingSpeedBonus(float value) {
        this.setFloat("cookingSpeedBonus", value);
    }

    public float getStunResistance() {
        return this.getFloat("stunResistance");
    }

    public void setStunResistance(float value) {
        this.setFloat("stunResistance", value);
    }

    public void setStunChance(float value) {
        this.setFloat("stunChance", value);
    }

    public float getStunChance() {
        return this.getFloat("stunChance");
    }

    public void setStunDurationBonus(float value) {
        this.setFloat("stunDurationBonus", value);
    }

    public float getStunDurationBonus() {
        return this.getFloat("stunDurationBonus");
    }

    public void setCritChance(float value) {
        this.setFloat("critChance", value);
    }

    public float getCritChance() {
        return this.getFloat("critChance");
    }

    public void setCritDamage(float value) {
        this.setFloat("critDamage", value);
    }

    public float getCritDamage() {
        return this.getFloat("critDamage");
    }

    public float getBleedChance() {
        return this.getFloat("bleedChance");
    }

    public void setBleedChance(float value) {
        this.setFloat("bleedChance", value);
    }

    public float getDodgeChance() {
        return this.getFloat("dodgeChance");
    }

    public void setDodgeChance(float value) {
        this.setFloat("dodgeChance", value);
    }

    public float getBleedDamage() {
        return this.getFloat("bleedDamage");
    }

    public void setBleedDamage(float value) {
        this.setFloat("bleedDamage", value);
    }

    public float getBleedDuration() {
        return this.getFloat("bleedDuration");
    }

    public void setBleedDuration(float value) {
        this.setFloat("bleedDuration", value);
    }

    public float getEntityDropMultiplier() {
        return this.getFloat("entityDropMultiplier");
    }

    public void setEntityDropMultiplier(float value) {
        this.setFloat("entityDropMultiplier", value);
    }

    public float getEntityRareDropMultiplier() {
        return this.getFloat("entityRareDropMultiplier");
    }

    public void setEntityRareDropMultiplier(float value) {
        this.setFloat("entityRareDropMultiplier", value);
    }

    public float getDurabilityMultiplier() {
        return this.getFloat("durabilityMultiplier");
    }

    public void setDurabilityMultiplier(float value) {
        this.setFloat("durabilityMultiplier", value);
    }

    public double getAllSkillEXPMultiplier() {
        return this.getDouble("allSkillEXPMultiplier");
    }

    public void setAllSkillEXPMultiplier(double value) {
        this.setDouble("allSkillEXPMultiplier", value);
    }

    public double getRedeemableExperiencePoints() {
        return this.getDouble("redeemableExperience");
    }

    public void setRedeemableExperiencePoints(double value) {
        this.setDouble("redeemableExperience", value);
    }

    public Collection<String> getUnlockedPerks() {
        return this.getStringSet("unlockedPerks");
    }

    public void setUnlockedPerks(Collection<String> value) {
        this.setStringSet("unlockedPerks", value);
    }

    public Collection<String> getPermanentlyUnlockedPerks() {
        return this.getStringSet("permanentlyUnlockedPerks");
    }

    public void setPermanentlyUnlockedPerks(Collection<String> value) {
        this.setStringSet("permanentlyUnlockedPerks", value);
    }

    public Collection<String> getFakeUnlockedPerks() {
        return this.getStringSet("fakeUnlockedPerks");
    }

    public void setFakeUnlockedPerks(Collection<String> value) {
        this.setStringSet("fakeUnlockedPerks", value);
    }

    public Collection<String> getUnlockedRecipes() {
        return this.getStringSet("unlockedRecipes");
    }

    public void setUnlockedRecipes(Collection<String> value) {
        this.setStringSet("unlockedRecipes", value);
    }

    public Collection<String> getPermanentlyLockedPerks() {
        return this.getStringSet("permanentlyLockedPerks");
    }

    public void setPermanentlyLockedPerks(Collection<String> value) {
        this.setStringSet("permanentlyLockedPerks", value);
    }

    public Collection<String> getUnlockedBlockConversions() {
        return this.getStringSet("unlockedBlockConversions");
    }

    public void setUnlockedBlockConversions(Collection<String> value) {
        this.setStringSet("unlockedBlockConversions", value);
    }

    public Collection<String> getPermanentPotionEffects() {
        return this.getStringSet("permanentPotionEffects");
    }

    public void setPermanentPotionEffects(Collection<String> value) {
        this.setStringSet("permanentPotionEffects", value);
    }

    public PowerProfile(UUID owner) {
        super(owner);
        this.intStat("spendableSkillPoints", new PropertyBuilder().format(StatFormat.INT).perkReward().create());
        this.intStat("spentSkillPoints", new PropertyBuilder().format(StatFormat.INT).perkReward().create());
        this.intStat("spendablePrestigePoints", new PropertyBuilder().format(StatFormat.INT).perkReward().create());
        this.intStat("spentPrestigePoints", new PropertyBuilder().format(StatFormat.INT).perkReward().create());
        this.intStat("redeemableLevelTokens", new PropertyBuilder().format(StatFormat.INT).min(0.0).perkReward().create());
        this.doubleStat("redeemableExperience", new PropertyBuilder().format(StatFormat.FLOAT_P2).min(0.0).perkReward().create());
        this.intStat("itemCounterLimit", new PropertyBuilder().format(StatFormat.INT).perkReward().create());
        this.doubleStat("allSkillEXPMultiplier", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P2).perkReward().create());
        this.floatStat("healthBonus", new PropertyBuilder().format(StatFormat.DIFFERENCE_FLOAT_P2).perkReward().create());
        this.floatStat("healthMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("movementSpeedBonus", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("sneakMovementSpeedBonus", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("sprintMovementSpeedBonus", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("knockbackResistanceBonus", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("armorBonus", new PropertyBuilder().format(StatFormat.FLOAT_P2).perkReward().create());
        this.floatStat("armorlessArmor", new PropertyBuilder().format(StatFormat.FLOAT_P2).perkReward().create());
        this.floatStat("armorMultiplierBonus", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("toughnessBonus", new PropertyBuilder().format(StatFormat.DIFFERENCE_FLOAT_P2).perkReward().create());
        this.floatStat("attackReachBonus", new PropertyBuilder().format(StatFormat.DIFFERENCE_FLOAT_P2).perkReward().create());
        this.floatStat("attackReachMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("blockReachBonus", new PropertyBuilder().format(StatFormat.DIFFERENCE_FLOAT_P2).perkReward().create());
        this.floatStat("stepHeightBonus", new PropertyBuilder().format(StatFormat.DIFFERENCE_FLOAT_P2).perkReward().create());
        this.floatStat("scaleMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("gravity", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("safeFallingDistance", new PropertyBuilder().format(StatFormat.DIFFERENCE_FLOAT_P2).perkReward().create());
        this.floatStat("attackDamageBonus", new PropertyBuilder().format(StatFormat.FLOAT_P2).perkReward().create());
        this.floatStat("fireDamageBonus", new PropertyBuilder().format(StatFormat.FLOAT_P2).perkReward().create());
        this.floatStat("explosionDamageBonus", new PropertyBuilder().format(StatFormat.FLOAT_P2).perkReward().create());
        this.floatStat("poisonDamageBonus", new PropertyBuilder().format(StatFormat.FLOAT_P2).perkReward().create());
        this.floatStat("bludgeoningDamageBonus", new PropertyBuilder().format(StatFormat.FLOAT_P2).perkReward().create());
        this.floatStat("magicDamageBonus", new PropertyBuilder().format(StatFormat.FLOAT_P2).perkReward().create());
        this.floatStat("radiantDamageBonus", new PropertyBuilder().format(StatFormat.FLOAT_P2).perkReward().create());
        this.floatStat("necroticDamageBonus", new PropertyBuilder().format(StatFormat.FLOAT_P2).perkReward().create());
        this.floatStat("freezingDamageBonus", new PropertyBuilder().format(StatFormat.FLOAT_P2).perkReward().create());
        this.floatStat("lightningDamageBonus", new PropertyBuilder().format(StatFormat.FLOAT_P2).perkReward().create());
        this.floatStat("powerAttackDamageMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("powerAttackFraction", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("powerAttackRadius", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("attackDamageMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("meleeAttackDamageMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("rangedAttackDamageMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("unarmedAttackDamageMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("magicDamageMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("fireDamageMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("poisonDamageMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("bludgeoningDamageMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("radiantDamageMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("necroticDamageMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("freezingDamageMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("lightningDamageMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("explosionDamageMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("playerDamageMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("mountedDamageMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("attackSpeedBonus", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("attackKnockbackBonus", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("luckBonus", new PropertyBuilder().format(StatFormat.FLOAT_P2).perkReward().create());
        this.floatStat("healthRegenerationBonus", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("hungerSaveChance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("damageResistance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("meleeResistance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("projectileResistance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("fireResistance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("bludgeoningResistance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("explosionResistance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("magicResistance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("poisonResistance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("radiantResistance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("necroticResistance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("freezingResistance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("lightningResistance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("fallDamageResistance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("critChanceResistance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("critDamageResistance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("pvpResistance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("cooldownReduction", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("craftingTimeReduction", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("cookingSpeedBonus", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.intStat("immunityFrameBonus", new PropertyBuilder().format(StatFormat.DIFFERENCE_INT).perkReward().create());
        this.floatStat("immunityFrameMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("stunResistance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("bleedResistance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("stunChance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("stunDurationBonus", new PropertyBuilder().format(StatFormat.DIFFERENCE_TIME_SECONDS_BASE_20_P1).perkReward().create());
        this.floatStat("critChance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("critDamage", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("bleedChance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("bleedDamage", new PropertyBuilder().format(StatFormat.FLOAT_P2).perkReward().create());
        this.floatStat("bleedDuration", new PropertyBuilder().format(StatFormat.DIFFERENCE_TIME_SECONDS_BASE_20_P1).perkReward().create());
        this.floatStat("durabilityMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("entityDropMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("entityRareDropMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("dodgeChance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("reflectChance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("reflectFraction", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("jumpHeightBonus", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.intStat("jumpBonus", new PropertyBuilder().format(StatFormat.DIFFERENCE_INT).min(0.0).perkReward().create());
        this.intStat("crossbowMagazine", new PropertyBuilder().format(StatFormat.INT).min(0.0).perkReward().create());
        this.intStat("parryEffectiveDuration", new PropertyBuilder().format(StatFormat.TIME_SECONDS_BASE_20_P1).min(0.0).perkReward().create());
        this.intStat("parryVulnerableDuration", new PropertyBuilder().format(StatFormat.TIME_SECONDS_BASE_20_P1).min(0.0).perkReward().create());
        this.intStat("parryEnemyDebuffDuration", new PropertyBuilder().format(StatFormat.TIME_SECONDS_BASE_20_P1).min(0.0).perkReward().create());
        this.intStat("parrySelfDebuffDuration", new PropertyBuilder().format(StatFormat.TIME_SECONDS_BASE_20_P1).min(0.0).perkReward().create());
        this.intStat("parryCooldown", new PropertyBuilder().format(StatFormat.TIME_SECONDS_BASE_20_P1).min(0.0).perkReward().create());
        this.floatStat("parryCooldownSuccessReduction", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("parryDamageReduction", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("shieldDisarming", new PropertyBuilder().format(StatFormat.DIFFERENCE_TIME_SECONDS_BASE_20_P1).perkReward().create());
        this.floatStat("lifeSteal", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P2).perkReward().create());
        this.floatStat("dismountChance", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("foodBonusVegetable", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("foodBonusSeasoning", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("foodBonusAlcoholic", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("foodBonusBeverage", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("foodBonusSpoiled", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("foodBonusSeafood", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("foodBonusMagical", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("foodBonusSweet", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("foodBonusGrain", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("foodBonusFruit", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("foodBonusNuts", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("foodBonusDairy", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("foodBonusMeat", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("foodBonusFats", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.booleanStat("badFoodImmune", new BooleanProperties(true, true));
        this.booleanStat("miningAffinityWater", new BooleanProperties(true, true));
        this.booleanStat("miningAffinityAir", new BooleanProperties(true, true));
        this.floatStat("oneShotProtectionFraction", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.intStat("oneShotProtectionCooldown", new PropertyBuilder().format(StatFormat.TIME_SECONDS_BASE_20_P1).perkReward().create());
        this.booleanStat("flight", new BooleanProperties(true, false));
        this.floatStat("waterMovementEfficiencyBonus", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("submergedMiningSpeedBonus", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("oxygenBonus", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("frontDamageReduction", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("backDamageReduction", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("damageAbsorption", new PropertyBuilder().format(StatFormat.FLOAT_P2).perkReward().create());
        this.stringSetStat("unlockedPerks");
        this.stringSetStat("permanentlyUnlockedPerks");
        this.stringSetStat("fakeUnlockedPerks");
        this.stringSetStat("permanentlyLockedPerks");
        this.stringSetStat("unlockedRecipes");
        this.stringSetStat("unlockedBlockConversions");
        this.stringSetStat("permanentPotionEffects");
        this.booleanStat("hidePotionEffectBar");
        this.booleanStat("hideCraftingEffects");
        this.booleanStat("hideExperienceGain");
        this.booleanStat("hideGlobalBuffs");
        this.floatStat("craftingEffectVolume", 1.0f, new PropertyBuilder().min(0.0).max(10.0).create());
        this.booleanStat("inventoryRepairingKeepEnchanting", new BooleanProperties(true, true));
    }

    @Override
    public String getTableName() {
        return "profiles_power";
    }

    @Override
    public Profile getBlankProfile(UUID owner) {
        return ProfileRegistry.copyDefaultStats(new PowerProfile(owner));
    }

    @Override
    public Class<? extends Skill> getSkillType() {
        return PowerSkill.class;
    }
}

