/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.playerstats.statsources;

import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatSource;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.playerstats.EntityProperties;
import me.athlaeos.valhallammo.potioneffects.CustomPotionEffect;
import me.athlaeos.valhallammo.potioneffects.PotionEffectRegistry;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.plugin.Plugin;

public class PotionEffectSingleUseSource
implements AccumulativeStatSource {
    private final String potionEffect;
    private final boolean negative;

    public PotionEffectSingleUseSource(String potionEffect) {
        this.potionEffect = potionEffect;
        this.negative = false;
    }

    public PotionEffectSingleUseSource(String potionEffect, boolean negative) {
        this.potionEffect = potionEffect;
        this.negative = negative;
    }

    @Override
    public double fetch(Entity statPossessor, boolean use) {
        if (statPossessor instanceof LivingEntity) {
            double amplifier;
            LivingEntity l = (LivingEntity)statPossessor;
            EntityProperties properties = EntityCache.getAndCacheProperties(l);
            CustomPotionEffect effect = properties.getActivePotionEffects().get(this.potionEffect);
            if (effect == null || effect.getEffectiveUntil() != -1L && effect.getEffectiveUntil() <= System.currentTimeMillis()) {
                return 0.0;
            }
            double d = amplifier = this.negative ? -effect.getAmplifier() : effect.getAmplifier();
            if (use) {
                effect.setEffectiveUntil(0L);
                PotionEffectRegistry.addEffect(l, null, effect, true, 1.0, EntityPotionEffectEvent.Cause.EXPIRATION, EntityPotionEffectEvent.Action.REMOVED);
            }
            ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> AccumulativeStatManager.uncache((Entity)l), 1L);
            return amplifier;
        }
        return 0.0;
    }
}

