/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.playerstats.statsources;

import java.util.UUID;
import me.athlaeos.valhallammo.entities.EntityClassification;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatSource;
import me.athlaeos.valhallammo.playerstats.EvEAccumulativeStatSource;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.skills.skills.SkillRegistry;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ProfileStatAttackerVictimClassSource
implements AccumulativeStatSource,
EvEAccumulativeStatSource {
    private final Class<? extends Profile> type;
    private final String stat;
    private final Class<? extends Number> numberType;
    private final Profile baseProfile;
    private final double def;
    private final EntityClassification entityClassification;
    private boolean negative = false;

    public ProfileStatAttackerVictimClassSource(Class<? extends Profile> type, String stat, EntityClassification entityClassification) {
        this.type = type;
        this.stat = stat;
        this.entityClassification = entityClassification;
        this.baseProfile = ProfileRegistry.getBlankProfile((UUID)null, type);
        if (this.baseProfile.intStatNames().contains(stat)) {
            this.def = this.baseProfile.getDefaultInt(stat);
            this.numberType = Integer.class;
        } else if (this.baseProfile.floatStatNames().contains(stat)) {
            this.def = this.baseProfile.getDefaultFloat(stat);
            this.numberType = Float.class;
        } else if (this.baseProfile.doubleStatNames().contains(stat)) {
            this.def = this.baseProfile.getDefaultDouble(stat);
            this.numberType = Double.class;
        } else {
            this.def = 0.0;
            this.numberType = null;
        }
        if (this.numberType == null) {
            throw new IllegalArgumentException("ProfileStatAttackerVictimClassSource:" + type.getSimpleName() + " with stat " + stat + " was initialized, but this profile type does not have such a stat");
        }
    }

    public ProfileStatAttackerVictimClassSource n() {
        this.negative = true;
        return this;
    }

    @Override
    public double fetch(Entity p, boolean use) {
        return 0.0;
    }

    public StatFormat getFormat() {
        return this.baseProfile.getNumberStatProperties().get(this.stat).getFormat();
    }

    @Override
    public double fetch(Entity victim, Entity attackedBy, boolean use) {
        if (attackedBy instanceof Player) {
            Player pl = (Player)attackedBy;
            if (EntityClassification.matchesClassification(victim.getType(), this.entityClassification)) {
                String requiredPermission;
                Profile profile = ProfileCache.getOrCache(pl, this.type);
                String string = requiredPermission = SkillRegistry.isRegistered(profile.getSkillType()) ? SkillRegistry.getSkill(profile.getSkillType()).getRequiredPermission() : null;
                if (requiredPermission != null && !pl.hasPermission(requiredPermission)) {
                    return this.def;
                }
                if (this.numberType.equals(Integer.class)) {
                    return (this.negative ? -1 : 1) * profile.getInt(this.stat);
                }
                if (this.numberType.equals(Float.class)) {
                    return (float)(this.negative ? -1 : 1) * profile.getFloat(this.stat);
                }
                return (double)(this.negative ? -1 : 1) * profile.getDouble(this.stat);
            }
        }
        return this.def;
    }
}

