/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.potioneffects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.potioneffects.CustomEffectDisplay;
import me.athlaeos.valhallammo.potioneffects.CustomPotionEffect;
import me.athlaeos.valhallammo.potioneffects.EffectClass;
import me.athlaeos.valhallammo.potioneffects.PotionEffectRegistry;
import me.athlaeos.valhallammo.potioneffects.PotionEffectWrapper;
import me.athlaeos.valhallammo.utility.SideBarUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CustomEffectSidebarDisplay
implements CustomEffectDisplay {
    @Override
    public void start() {
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskTimer((Plugin)ValhallaMMO.getInstance(), () -> {
            for (UUID uuid : new HashSet<UUID>(PotionEffectRegistry.affectedEntityTracker())) {
                Entity e = ValhallaMMO.getInstance().getServer().getEntity(uuid);
                if (!(e instanceof Player)) continue;
                Player p = (Player)e;
                if (!e.isValid()) {
                    PotionEffectRegistry.affectedEntityTracker().remove(e.getUniqueId());
                    continue;
                }
                PowerProfile profile = ProfileCache.getOrCache(p, PowerProfile.class);
                if (profile.hidePotionEffectBar()) continue;
                Map<String, CustomPotionEffect> activeEffects = EntityCache.getAndCacheProperties((LivingEntity)p).getActivePotionEffects().entrySet().stream().filter(ef -> ((CustomPotionEffect)ef.getValue()).getEffectiveUntil() == -1L || ((CustomPotionEffect)ef.getValue()).getRemainingDuration() > 0L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                if (activeEffects.isEmpty()) {
                    PotionEffectRegistry.affectedEntityTracker().remove(e.getUniqueId());
                    SideBarUtils.hideSideBarFromPlayer(p, "valhalla_effects");
                    continue;
                }
                ArrayList<String> effects = new ArrayList<String>();
                ArrayList<CustomPotionEffect> sortedEffects = new ArrayList<CustomPotionEffect>(activeEffects.values());
                sortedEffects.sort(Comparator.comparingLong(CustomPotionEffect::getRemainingDuration));
                Collections.reverse(sortedEffects);
                for (CustomPotionEffect effect : sortedEffects) {
                    PotionEffectWrapper wrapper = effect.getWrapper();
                    if (wrapper.isVanilla || wrapper.isInstant) continue;
                    String prefix = PotionEffectWrapper.prefix(wrapper.getClassification(effect.getAmplifier()) == EffectClass.BUFF);
                    effects.add(Utils.chat(prefix + wrapper.getEffectName().replace("%icon%", wrapper.getEffectIcon() + prefix).replace("%value%", wrapper.format.format(effect.getAmplifier())).replace("%duration%", String.format("(%s)", StringUtils.toTimeStamp(effect.getRemainingDuration(), 1000L))).trim()));
                }
                SideBarUtils.showSideBarToPlayer(p, "valhalla_effects", Utils.chat(TranslationManager.getTranslation("potion_effect_display")), effects, false);
            }
        }, 1L, 20L);
    }
}

