/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.potioneffects;

import me.athlaeos.valhallammo.potioneffects.PotionEffectWrapper;

public class CustomPotionEffect {
    private final PotionEffectWrapper effect;
    private long effectiveUntil;
    private double amplifier;
    private final int originalDuration;

    public CustomPotionEffect(PotionEffectWrapper effect, int duration, double amplifier) {
        this.effect = effect;
        this.originalDuration = duration;
        this.effectiveUntil = System.currentTimeMillis() + (long)duration * 50L;
        this.amplifier = amplifier;
    }

    public CustomPotionEffect(PotionEffectWrapper effect, long effectiveUntil, double amplifier) {
        this.effect = effect;
        this.originalDuration = effectiveUntil == -1L ? -1 : (int)Math.floor((double)Math.max(0L, effectiveUntil - System.currentTimeMillis()) / 50.0);
        this.effectiveUntil = effectiveUntil;
        this.amplifier = amplifier;
    }

    public PotionEffectWrapper getWrapper() {
        return this.effect;
    }

    public double getAmplifier() {
        return this.amplifier;
    }

    public long getEffectiveUntil() {
        return this.effectiveUntil;
    }

    public long getRemainingDuration() {
        return this.effectiveUntil == -1L ? -1L : Math.max(0L, this.effectiveUntil - System.currentTimeMillis());
    }

    public int getOriginalDuration() {
        return this.originalDuration;
    }

    public void setAmplifier(double amplifier) {
        this.amplifier = amplifier;
    }

    public void setEffectiveUntil(long effectiveUntil) {
        this.effectiveUntil = effectiveUntil;
    }
}

