/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.potioneffects;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.CustomDamageType;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.entity.Entity;

public class EffectResponsibility {
    private static final Map<UUID, Map<String, Responsibility>> responsibleUntil = new HashMap<UUID, Map<String, Responsibility>>();

    public static void clearResponsibility(UUID victim) {
        responsibleUntil.remove(victim);
    }

    public static void markResponsible(UUID victim, UUID offender, CustomDamageType damageType, int responsibleForTicks) {
        if (responsibleForTicks < 0) {
            return;
        }
        Map map = responsibleUntil.getOrDefault(victim, new HashMap());
        if (responsibleForTicks == 0) {
            map.remove(damageType.getType());
            if (map.isEmpty()) {
                responsibleUntil.remove(victim);
            } else {
                responsibleUntil.put(victim, map);
            }
        } else {
            Responsibility responsibility = new Responsibility(offender, victim, System.currentTimeMillis() + (long)responsibleForTicks * 50L);
            map.put(damageType.getType(), responsibility);
            responsibleUntil.put(victim, map);
        }
    }

    public static Entity getResponsible(UUID victim, CustomDamageType damageType) {
        Responsibility responsibility = (Responsibility)((Map)responsibleUntil.getOrDefault(victim, new HashMap())).get(damageType.getType());
        if (responsibility == null) {
            return null;
        }
        if (responsibility.responsibleUntil < System.currentTimeMillis()) {
            Map map = responsibleUntil.getOrDefault(victim, new HashMap());
            map.remove(damageType.getType());
            if (map.isEmpty()) {
                responsibleUntil.remove(victim);
            } else {
                responsibleUntil.put(victim, map);
            }
            return null;
        }
        Entity responsible = ValhallaMMO.getInstance().getServer().getEntity(responsibility.responsible);
        if (responsible == null || !responsible.isValid() || responsible.isDead()) {
            return null;
        }
        return responsible;
    }

    public static double getResponsibleDamageBuff(Entity victim, CustomDamageType damageType) {
        Entity responsible = EffectResponsibility.getResponsible(victim.getUniqueId(), damageType);
        if (responsible == null || damageType.damageMultiplier() == null) {
            return 0.0;
        }
        return AccumulativeStatManager.getCachedAttackerRelationalStats(damageType.damageMultiplier(), victim, responsible, 10000L, true);
    }

    public static double getResponsibleDamageBuff(Entity victim, Entity damagerDefault, CustomDamageType damageType) {
        Entity responsible = Utils.thisorDefault(EffectResponsibility.getResponsible(victim.getUniqueId(), damageType), damagerDefault);
        if (responsible == null || damageType.damageMultiplier() == null) {
            return 0.0;
        }
        return AccumulativeStatManager.getCachedAttackerRelationalStats(damageType.damageMultiplier(), victim, responsible, 10000L, true);
    }

    private record Responsibility(UUID responsible, UUID victim, long responsibleUntil) {
    }
}

