/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.potioneffects;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.potion_effects.PermanentPotionEffectAdd;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.potion_effects.PotionEffectAdd;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import me.athlaeos.valhallammo.potioneffects.EffectClass;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.version.PotionEffectMappings;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffectType;

public abstract class PotionEffectWrapper {
    protected final StatFormat format;
    protected final String effect;
    protected double amplifier;
    protected long duration;
    protected int charges;
    protected final boolean removable;
    protected final boolean isVanilla;
    protected final boolean isInstant;
    protected final PotionEffectType vanillaEffect;
    private static final Map<String, String> newToOldEffectMappings = new HashMap<String, String>();

    public PotionEffectWrapper(String effect, boolean removable, boolean instant, StatFormat format) {
        this.effect = effect;
        this.amplifier = 0.0;
        this.duration = 0L;
        this.charges = -1;
        this.removable = removable;
        this.vanillaEffect = Catch.catchOrElse(() -> PotionEffectMappings.getEffect(effect).getPotionEffectType(), null);
        this.isVanilla = this.vanillaEffect != null;
        this.isInstant = instant;
        this.format = format;
    }

    public PotionEffectWrapper addModifier(Material icon, double smallIncrement, double bigIncrement) {
        ModifierRegistry.register(new PotionEffectAdd("potion_effect_add_" + newToOldEffectMappings.getOrDefault(this.effect, this.effect).toLowerCase(Locale.US), this.effect, smallIncrement, bigIncrement, icon));
        ModifierRegistry.register(new PermanentPotionEffectAdd("permanent_effect_add_" + newToOldEffectMappings.getOrDefault(this.effect, this.effect).toLowerCase(Locale.US), this.effect, icon, this.isVanilla ? 1.0 : smallIncrement, this.isVanilla ? 3.0 : bigIncrement));
        return this;
    }

    public PotionEffectWrapper addModifier(Material icon) {
        return this.addModifier(icon, 0.01, 0.1);
    }

    public abstract void onApply(ItemBuilder var1);

    public abstract void onInflict(LivingEntity var1, LivingEntity var2, double var3, int var5, double var6);

    public abstract void onRemove(ItemBuilder var1);

    public abstract void onExpire(LivingEntity var1);

    public abstract EffectClass getClassification(double var1);

    public String getEffect() {
        return this.effect;
    }

    public double getAmplifier() {
        return this.amplifier;
    }

    public long getDuration() {
        return this.duration;
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public boolean isVanilla() {
        return this.isVanilla;
    }

    public PotionEffectType getVanillaEffect() {
        return this.vanillaEffect;
    }

    public boolean isInstant() {
        return this.isInstant;
    }

    public StatFormat getFormat() {
        return this.format;
    }

    public int getCharges() {
        return this.charges;
    }

    public String getPotionName() {
        return TranslationManager.getTranslation("potion_name_" + this.effect.toLowerCase(Locale.US));
    }

    public String getEffectName() {
        return TranslationManager.getTranslation("effect_name_" + this.effect.toLowerCase(Locale.US));
    }

    public String getEffectIcon() {
        return TranslationManager.getTranslation("stat_icon_" + this.effect.toLowerCase(Locale.US));
    }

    public abstract boolean isSingleUse();

    public PotionEffectWrapper setAmplifier(double amplifier) {
        this.amplifier = amplifier;
        return this;
    }

    public PotionEffectWrapper setDuration(long duration) {
        this.duration = duration;
        return this;
    }

    public PotionEffectWrapper setCharges(int charges) {
        this.charges = charges;
        return this;
    }

    public abstract PotionEffectWrapper copy();

    public static String prefix(boolean positive) {
        return TranslationManager.getTranslation("stat_potion_" + (positive ? "positive" : "negative") + "_prefix");
    }

    public String getTrimmedEffectName() {
        return this.getEffectName().replace("%icon%", "").replace("%duration%", "").replace("%value%", "").trim();
    }

    public String getFormattedEffectName(boolean positive, double value, long duration) {
        return this.getEffectName().replace("%icon%", this.getEffectIcon() + PotionEffectWrapper.prefix(positive)).replace("%value%", this.getFormat() == null ? "" : this.getFormat().format(value + (double)(this.isVanilla ? 1 : 0))).replace("%duration%", String.format("(%s)", StringUtils.toTimeStamp(duration, 20L))).trim();
    }

    static {
        newToOldEffectMappings.put("SWIFTNESS", "SPEED");
        newToOldEffectMappings.put("SLOWNESS", "SLOW");
        newToOldEffectMappings.put("HASTE", "FAST_DIGGING");
        newToOldEffectMappings.put("MINING_FATIGUE", "SLOW_DIGGING");
        newToOldEffectMappings.put("STRENGTH", "INCREASE_DAMAGE");
        newToOldEffectMappings.put("INSTANT_HEALTH", "HEAL");
        newToOldEffectMappings.put("INSTANT_DAMAGE", "HARM");
        newToOldEffectMappings.put("JUMP_BOOST", "JUMP");
        newToOldEffectMappings.put("NAUSEA", "CONFUSION");
        newToOldEffectMappings.put("RESISTANCE", "DAMAGE_RESISTANCE");
    }
}

