/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.potioneffects.effect_triggers.implementations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.CustomDamageType;
import me.athlaeos.valhallammo.listeners.EntityDamagedListener;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.playerstats.EntityProperties;
import me.athlaeos.valhallammo.potioneffects.effect_triggers.EffectTrigger;
import me.athlaeos.valhallammo.potioneffects.effect_triggers.EffectTriggerRegistry;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

public class OnDamageTick
implements EffectTrigger,
Listener {
    private static Listener singleListenerInstance = null;
    private static final Map<String, CustomDamageType> damageTypes = new HashMap<String, CustomDamageType>();
    private static final Map<String, String> damageTypesToIDMappings = new HashMap<String, String>();
    private final CustomDamageType damageType;

    public OnDamageTick(CustomDamageType damageType) {
        this.damageType = damageType;
    }

    @Override
    public String id() {
        return this.damageType == null ? "on_damaged" : "on_" + this.damageType.getType().toLowerCase(Locale.US) + "_damage";
    }

    @Override
    public void onRegister() {
        if (this.damageType != null) {
            damageTypes.put(this.damageType.getType(), this.damageType);
            damageTypesToIDMappings.put(this.damageType.getType(), this.id());
        }
        if (singleListenerInstance != null) {
            return;
        }
        ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)ValhallaMMO.getInstance());
        singleListenerInstance = this;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityDamaged(EntityDamageEvent e) {
        String damageCause;
        Entity entity;
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || !((entity = e.getEntity()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity le = (LivingEntity)entity;
        EntityProperties properties = EntityCache.getAndCacheProperties(le);
        if (!properties.getPermanentPotionEffects().isEmpty() && !((List)properties.getPermanentPotionEffects().getOrDefault("on_damaged", new ArrayList())).isEmpty()) {
            this.trigger(le, properties.getPermanentPotionEffects().getOrDefault("on_damaged", new ArrayList()));
        }
        if ((damageCause = EntityDamagedListener.getLastDamageCause(le)) == null) {
            return;
        }
        CustomDamageType type = CustomDamageType.getCustomType(damageCause);
        if (type == null || !damageTypes.containsKey(type.getType())) {
            return;
        }
        String id = damageTypesToIDMappings.get(type.getType());
        if (id == null) {
            return;
        }
        EffectTrigger trigger = EffectTriggerRegistry.getTrigger(id);
        if (trigger == null || !trigger.shouldTrigger(le)) {
            return;
        }
        if (((List)properties.getPermanentPotionEffects().getOrDefault(id, new ArrayList())).isEmpty()) {
            return;
        }
        this.trigger(le, properties.getPermanentPotionEffects().getOrDefault(id, new ArrayList()));
    }
}

