/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.resourcepack;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.resourcepack.ResourcePack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class Host {
    private static byte[] data;
    private static ServerSocket socket;
    private static boolean running;
    private static int port;
    private static String ip;
    private static BukkitTask task;

    public static boolean start() {
        try {
            if (port < 0) {
                throw new Exception();
            }
            if (task != null) {
                task.cancel();
            }
            if (socket == null) {
                socket = new ServerSocket(port);
                socket.setSoTimeout(0);
            }
            ValhallaMMO.logFine("Resource pack hosting established!");
        }
        catch (Exception ex) {
            ValhallaMMO.logInfo("Resource pack hosting not established! Use /val resourcepack setup if you want ValhallaMMO's resource pack hosted for you");
            return false;
        }
        Host.initializeTCP();
        return true;
    }

    public static void stop() {
        if (socket == null) {
            return;
        }
        try {
            running = false;
            socket.close();
            task.cancel();
        }
        catch (IOException ignored) {
            ValhallaMMO.logWarning("Could not properly close resource pack hosting");
        }
    }

    private static void initializeTCP() {
        task = ValhallaMMO.getInstance().getServer().getScheduler().runTaskAsynchronously((Plugin)ValhallaMMO.getInstance(), () -> {
            if (data != null) {
                try {
                    Socket s = socket.accept();
                    String response = "HTTP/1.1 200 OK\r\nContent-Type: application/zip\r\nContent-Disposition: attachment; filename=\"ValhallaMMO_" + ResourcePack.getVersion() + ".zip\"\r\nContent-Length: " + data.length + "\r\n\r\n";
                    s.getOutputStream().write(response.getBytes(StandardCharsets.UTF_8));
                    s.getOutputStream().write(data);
                    s.getOutputStream().flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (running) {
                Host.initializeTCP();
            }
        });
    }

    public static byte[] getData() {
        return data;
    }

    public static String getIp() {
        return ip;
    }

    public static void setIp(String ip) {
        Host.ip = ip;
    }

    public static int getPort() {
        return port;
    }

    public static void setPort(int port) {
        Host.port = port;
    }

    public static void setData(byte[] data) {
        Host.data = data;
    }

    public static void setRunning(boolean running) {
        Host.running = running;
    }

    static {
        socket = null;
        running = true;
        port = ValhallaMMO.getPluginConfig().getInt("resourcepack_port");
        ip = ValhallaMMO.getPluginConfig().getString("server_ip");
        task = null;
    }
}

