/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import org.bukkit.Chunk;
import org.bukkit.entity.Player;

public class ChunkEXPNerf {
    private static final int expEventNerfQuantity = ValhallaMMO.getPluginConfig().getInt("chunk_exp_nerf_quantity", 30);
    private static final double expEventNerfFactor = ValhallaMMO.getPluginConfig().getDouble("chunk_exp_nerf_factor", 0.1);
    private static final double expOrbsNerfFactor = ValhallaMMO.getPluginConfig().getDouble("chunk_exp_orbs_nerf_factor", 0.3);
    private static final Map<UUID, Map<String, Map<Integer, Integer>>> chunkEXPEventMap = new HashMap<UUID, Map<String, Map<Integer, Integer>>>();
    private static final Map<String, Map<Integer, Integer>> genericChunkEventMap = new HashMap<String, Map<Integer, Integer>>();

    public static boolean doesChunkEXPNerfApply(Chunk chunk, Player player, String key, int customLimit) {
        return ChunkEXPNerf.getCount(chunk, player, key) >= customLimit;
    }

    public static boolean doesChunkEXPNerfApply(Chunk chunk, Player player, String key) {
        return ChunkEXPNerf.doesChunkEXPNerfApply(chunk, player, key, expEventNerfQuantity);
    }

    public static double getChunkEXPNerf(Chunk chunk, Player player, String key) {
        return ChunkEXPNerf.getChunkEXPNerf(chunk, player, key, expEventNerfFactor);
    }

    public static double getChunkEXPNerf(Chunk chunk, Player player, String key, double customFactor) {
        if (ChunkEXPNerf.doesChunkEXPNerfApply(chunk, player, key)) {
            return customFactor;
        }
        return 1.0;
    }

    public static double getChunkEXPOrbsNerf(Chunk chunk, Player player, String key) {
        return ChunkEXPNerf.getChunkEXPOrbsNerf(chunk, player, key, expOrbsNerfFactor);
    }

    public static double getChunkEXPOrbsNerf(Chunk chunk, Player player, String key, double customFactor) {
        if (ChunkEXPNerf.doesChunkEXPNerfApply(chunk, player, key)) {
            return customFactor;
        }
        return 1.0;
    }

    public static void increment(Chunk chunk, Player player, String key) {
        ChunkEXPNerf.increment(chunk, player, key, 1);
    }

    public static void increment(Chunk chunk, Player player, String key, int quantity) {
        Map byKey = player == null ? genericChunkEventMap : (Map)chunkEXPEventMap.getOrDefault(player.getUniqueId(), new HashMap());
        Map countMap = byKey.getOrDefault(key, new HashMap());
        int counter = countMap.getOrDefault(ChunkEXPNerf.id(chunk), 0);
        countMap.put(ChunkEXPNerf.id(chunk), counter += quantity);
        byKey.put(key, countMap);
        if (player != null) {
            chunkEXPEventMap.put(player.getUniqueId(), byKey);
        }
    }

    public static int getCount(Chunk chunk, Player player, String key) {
        Map countMap = player == null ? (Map)genericChunkEventMap.getOrDefault(key, new HashMap()) : (Map)((Map)chunkEXPEventMap.getOrDefault(player.getUniqueId(), new HashMap())).getOrDefault(key, new HashMap());
        return countMap.getOrDefault(ChunkEXPNerf.id(chunk), 0);
    }

    private static int id(Chunk chunk) {
        return (chunk.getX() & 0xFFF) << 8 | chunk.getZ() & 0xFF;
    }
}

