/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.perk_rewards.implementations;

import java.util.Collection;
import java.util.List;
import me.athlaeos.valhallammo.dom.BiAction;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.skills.perk_rewards.PerkReward;
import me.athlaeos.valhallammo.skills.perk_rewards.PerkRewardArgumentType;
import org.bukkit.entity.Player;

public class ProfileStringListAdd
extends PerkReward {
    private List<String> value;
    private final String stat;
    private final Class<? extends Profile> type;
    private BiAction<String, Player> addAction = null;
    private BiAction<String, Player> removeAction = null;
    private boolean alwaysPersistent = false;

    public ProfileStringListAdd(String name, String stat, Class<? extends Profile> type) {
        super(name);
        this.stat = stat;
        this.type = type;
    }

    public ProfileStringListAdd(String name, String stat, Class<? extends Profile> type, boolean alwaysPersistent) {
        super(name);
        this.stat = stat;
        this.type = type;
        this.alwaysPersistent = alwaysPersistent;
    }

    public ProfileStringListAdd(String name, String stat, Class<? extends Profile> type, BiAction<String, Player> addAction, BiAction<String, Player> removeAction) {
        super(name);
        this.stat = stat;
        this.type = type;
        this.addAction = addAction;
        this.removeAction = removeAction;
    }

    public ProfileStringListAdd(String name, String stat, Class<? extends Profile> type, boolean alwaysPersistent, BiAction<String, Player> addAction, BiAction<String, Player> removeAction) {
        super(name);
        this.stat = stat;
        this.type = type;
        this.alwaysPersistent = alwaysPersistent;
        this.addAction = addAction;
        this.removeAction = removeAction;
    }

    @Override
    public void apply(Player player) {
        Profile profile = this.isPersistent() || this.alwaysPersistent ? ProfileRegistry.getPersistentProfile(player, this.type) : ProfileRegistry.getSkillProfile(player, this.type);
        Collection<String> existing = profile.getStringSet(this.stat);
        existing.addAll(this.value);
        profile.setStringSet(this.stat, existing);
        if (this.addAction != null) {
            this.value.forEach(s -> this.addAction.act((String)s, player));
        }
        if (this.isPersistent() || this.alwaysPersistent) {
            profile.setShouldForcePersist(true);
            ProfileRegistry.setPersistentProfile(player, profile, this.type);
        } else {
            ProfileRegistry.setSkillProfile(player, profile, this.type);
        }
        AccumulativeStatManager.uncacheProfile(player, this.type);
    }

    @Override
    public void remove(Player player) {
        Profile profile = this.isPersistent() || this.alwaysPersistent ? ProfileRegistry.getPersistentProfile(player, this.type) : ProfileRegistry.getSkillProfile(player, this.type);
        Collection<String> existing = profile.getStringSet(this.stat);
        existing.removeAll(this.value);
        profile.setStringSet(this.stat, existing);
        if (this.removeAction != null) {
            this.value.forEach(s -> this.removeAction.act((String)s, player));
        }
        if (this.isPersistent() || this.alwaysPersistent) {
            ProfileRegistry.setPersistentProfile(player, profile, this.type);
        } else {
            ProfileRegistry.setSkillProfile(player, profile, this.type);
        }
        AccumulativeStatManager.uncacheProfile(player, this.type);
    }

    @Override
    public void parseArgument(Object argument) {
        this.value = this.parseStringList(argument);
    }

    @Override
    public String rewardPlaceholder() {
        return "";
    }

    @Override
    public PerkRewardArgumentType getRequiredType() {
        return PerkRewardArgumentType.STRING_LIST;
    }
}

