/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.perkresourcecost.implementations;

import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.hooks.VaultHook;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.skills.perkresourcecost.ResourceExpense;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class EconomyExpense
implements ResourceExpense {
    private double cost = 0.0;
    private final boolean refundable = ConfigManager.getConfig("config.yml").reload().get().getBoolean("forgettable_perks_refund_money");

    @Override
    public void initExpense(Object value) {
        if (value instanceof Number) {
            this.cost = (Double)value;
        }
    }

    @Override
    public boolean canPurchase(Player p) {
        if (!this.canRegister()) {
            return true;
        }
        return ValhallaMMO.getHook(VaultHook.class).getEcon().getBalance((OfflinePlayer)p) >= this.cost;
    }

    @Override
    public void purchase(Player p, boolean initialPurchase) {
        if (!this.canRegister() || !initialPurchase) {
            return;
        }
        Economy e = ValhallaMMO.getHook(VaultHook.class).getEcon();
        if (e.getBalance((OfflinePlayer)p) >= this.cost) {
            e.withdrawPlayer((OfflinePlayer)p, this.cost);
        }
    }

    @Override
    public void refund(Player p) {
        if (!this.canRegister()) {
            return;
        }
        Economy e = ValhallaMMO.getHook(VaultHook.class).getEcon();
        e.depositPlayer((OfflinePlayer)p, this.cost);
    }

    @Override
    public boolean isRefundable() {
        return this.refundable;
    }

    @Override
    public ResourceExpense createInstance() {
        return new EconomyExpense();
    }

    @Override
    public String getInsufficientFundsMessage() {
        return TranslationManager.getTranslation("warning_insufficient_money");
    }

    @Override
    public String getCostMessage() {
        return TranslationManager.getTranslation("status_economy_cost").replace("%cost%", "" + this.cost);
    }

    @Override
    public String getCostPlaceholder() {
        return "%cost_money%";
    }

    @Override
    public String getInsufficientCostPlaceholder() {
        return "%warning_cost_money%";
    }

    @Override
    public boolean canRegister() {
        return ValhallaMMO.isHookFunctional(VaultHook.class);
    }
}

