/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.perkunlockconditions;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import me.athlaeos.valhallammo.skills.perkunlockconditions.UnlockCondition;
import me.athlaeos.valhallammo.skills.perkunlockconditions.implementations.AllPerksUnlockedRequirement;
import me.athlaeos.valhallammo.skills.perkunlockconditions.implementations.OtherSkillLevelRequirement;
import me.athlaeos.valhallammo.skills.perkunlockconditions.implementations.SinglePerkUnlockedRequirement;
import me.athlaeos.valhallammo.skills.perkunlockconditions.implementations.VersionMinimumRequirement;

public class UnlockConditionRegistry {
    private static final Map<String, UnlockCondition> conditions = new HashMap<String, UnlockCondition>();

    public static void registerDefaultConditions() {
        UnlockConditionRegistry.register(new AllPerksUnlockedRequirement());
        UnlockConditionRegistry.register(new SinglePerkUnlockedRequirement());
        UnlockConditionRegistry.register(new OtherSkillLevelRequirement());
        UnlockConditionRegistry.register(new VersionMinimumRequirement());
    }

    public static Collection<UnlockCondition> getConditionsSet() {
        return new HashSet<UnlockCondition>(conditions.values());
    }

    public static Map<String, UnlockCondition> getConditions() {
        return conditions;
    }

    public static void register(UnlockCondition expense) {
        if (expense.canRegister()) {
            conditions.put(expense.getValuePlaceholder(), expense);
        }
    }

    public static UnlockCondition createConditionInstance(String key) {
        UnlockCondition expense = conditions.get(key);
        if (expense == null) {
            return null;
        }
        return expense.createInstance();
    }

    public static Collection<String> getValuePlaceholders() {
        return new HashSet<String>(conditions.keySet());
    }

    public static Collection<String> getFailurePlaceholders() {
        HashSet<String> placeholders = new HashSet<String>();
        for (UnlockCondition unlockCondition : conditions.values()) {
            String failurePlaceholder = unlockCondition.getFailurePlaceholder();
            placeholders.add(failurePlaceholder);
        }
        return placeholders;
    }
}

