/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.perkunlockconditions.implementations;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.skills.perkunlockconditions.UnlockCondition;
import me.athlaeos.valhallammo.skills.skills.Perk;
import me.athlaeos.valhallammo.skills.skills.PerkRegistry;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.entity.Player;

public class AllPerksUnlockedRequirement
implements UnlockCondition {
    private List<String> perks = new ArrayList<String>();

    @Override
    public void initCondition(Object value) {
        if (value instanceof List) {
            this.perks = (List)value;
        }
    }

    @Override
    public String getValuePlaceholder() {
        return "requireperk_all";
    }

    @Override
    public boolean canUnlock(Player p, boolean forceTrue) {
        PowerProfile profile = ProfileRegistry.getPersistentProfile(p, PowerProfile.class);
        HashSet<String> unlocked = new HashSet<String>(profile.getUnlockedPerks());
        unlocked.addAll(profile.getPermanentlyUnlockedPerks());
        return this.perks == null || this.perks.isEmpty() || unlocked.containsAll(this.perks);
    }

    @Override
    public UnlockCondition createInstance() {
        return new AllPerksUnlockedRequirement();
    }

    @Override
    public String getFailedConditionMessage() {
        return TranslationManager.getTranslation("perk_requirement_warning_perks");
    }

    @Override
    public String getFailurePlaceholder() {
        return "warning_all_perks";
    }

    @Override
    public List<String> getConditionMessages() {
        String format = TranslationManager.getTranslation("perk_format_requirement_all");
        String entry = TranslationManager.getTranslation("perk_format_requirement");
        ArrayList<String> result = new ArrayList<String>();
        result.add(format);
        for (String p : this.perks) {
            Perk perk = PerkRegistry.getPerk(p);
            if (perk == null) continue;
            result.add(Utils.chat(entry.replace("%perk_required%", perk.getDisplayName())));
        }
        return result;
    }
}

