/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.skills;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.event.PlayerSkillExperienceGainEvent;
import me.athlaeos.valhallammo.event.PlayerSkillLevelUpEvent;
import me.athlaeos.valhallammo.event.ValhallaUpdatedStatsEvent;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.placeholder.PlaceholderRegistry;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.skills.perk_rewards.MultiplicativeReward;
import me.athlaeos.valhallammo.skills.perk_rewards.PerkReward;
import me.athlaeos.valhallammo.skills.perk_rewards.PerkRewardRegistry;
import me.athlaeos.valhallammo.skills.perkresourcecost.ResourceExpense;
import me.athlaeos.valhallammo.skills.perkresourcecost.ResourceExpenseRegistry;
import me.athlaeos.valhallammo.skills.perkunlockconditions.UnlockCondition;
import me.athlaeos.valhallammo.skills.perkunlockconditions.UnlockConditionRegistry;
import me.athlaeos.valhallammo.skills.skills.Perk;
import me.athlaeos.valhallammo.skills.skills.PerkConnectionIcon;
import me.athlaeos.valhallammo.skills.skills.implementations.PowerSkill;
import me.athlaeos.valhallammo.utility.BossBarUtils;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Utils;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class Skill {
    protected final String type;
    protected String requiredPermission;
    protected String displayName;
    protected String description;
    protected ItemStack icon;
    protected String expCurve;
    protected int maxLevel;
    protected List<PerkReward> startingPerks = new ArrayList<PerkReward>();
    protected List<PerkReward> levelingPerks = new ArrayList<PerkReward>();
    protected List<String> levelingMessages = new ArrayList<String>();
    protected List<String> levelingCommands = new ArrayList<String>();
    protected List<String> levelingUndoCommands = new ArrayList<String>();
    protected Map<Integer, List<PerkReward>> specialLevelingPerks = new HashMap<Integer, List<PerkReward>>();
    protected Map<Integer, List<String>> specialLevelingMessages = new HashMap<Integer, List<String>>();
    protected Map<Integer, List<String>> specialLevelingCommands = new HashMap<Integer, List<String>>();
    protected Map<Integer, List<String>> specialLevelingUndoCommands = new HashMap<Integer, List<String>>();
    protected List<Perk> perks = new ArrayList<Perk>();
    protected int centerX;
    protected int centerY;
    protected BarColor expBarColor;
    protected BarStyle expBarStyle;
    protected String expBarTitle;
    protected boolean isNavigable;
    protected double experienceLimit = -1.0;
    protected String experienceLimitMessage = null;
    private final Map<UUID, Double> experienceLimitMap = new HashMap<UUID, Double>();
    private final Map<UUID, Long> experienceLimitTimeMap = new HashMap<UUID, Long>();
    private final Collection<UUID> sentExperienceLimitMessage = new HashSet<UUID>();
    private final Map<UUID, EXPStatusStruct> expTracker = new HashMap<UUID, EXPStatusStruct>();
    private final boolean perksForgettable = ConfigManager.getConfig("config.yml").reload().get().getBoolean("forgettable_perks");

    public abstract void loadConfiguration();

    public abstract boolean isLevelableSkill();

    public abstract Class<? extends Profile> getProfileType();

    public abstract int getSkillTreeMenuOrderPriority();

    public boolean isExperienceScaling() {
        return true;
    }

    public int getCenterX() {
        return this.centerX;
    }

    public int getCenterY() {
        return this.centerY;
    }

    public BarColor getExpBarColor() {
        return this.expBarColor;
    }

    public BarStyle getExpBarStyle() {
        return this.expBarStyle;
    }

    public String getExpBarTitle() {
        return this.expBarTitle;
    }

    public boolean isNavigable() {
        return this.isNavigable;
    }

    public String getExpStatus() {
        return TranslationManager.getTranslation("status_experience_gained");
    }

    public Skill(String type) {
        this.type = type;
    }

    private int[] parseCoordinates(String coordinates) {
        if (coordinates == null) {
            return null;
        }
        int[] coords = new int[]{0, 0};
        try {
            String[] indivCoords = coordinates.split(",");
            if (indivCoords.length != 2) {
                throw new IllegalArgumentException();
            }
            coords[0] = Integer.parseInt(indivCoords[0]);
            coords[1] = Integer.parseInt(indivCoords[1]);
        }
        catch (IllegalArgumentException e) {
            ValhallaMMO.logWarning("invalid coordinates given for " + this.getClass().getSimpleName() + ", defaulting to 0,0. Coords are to be given in the format \"x,y\" where X and Y are whole numbers");
            coords[0] = 0;
        }
        return coords;
    }

    public void loadCommonConfig(YamlConfiguration baseSkillConfig, YamlConfiguration progressionConfig) {
        ConfigurationSection perksSection;
        ConfigurationSection levelingPerksSection;
        ItemMeta iconMeta;
        this.displayName = Utils.chat(TranslationManager.translatePlaceholders(baseSkillConfig.getString("display_name")));
        this.description = Utils.chat(TranslationManager.translatePlaceholders(baseSkillConfig.getString("description")));
        this.icon = ItemUtils.getIconFromConfig(baseSkillConfig, "icon", this.getClass().getSimpleName() + " skill config", new ItemStack(Material.BARRIER));
        this.requiredPermission = baseSkillConfig.getString("permission");
        this.isNavigable = progressionConfig.getBoolean("navigable", true);
        int modelData = baseSkillConfig.getInt("icon_data", -1);
        if (modelData >= 0 && (iconMeta = ItemUtils.getItemMeta(this.icon)) != null) {
            iconMeta.setCustomModelData(Integer.valueOf(modelData));
            ItemUtils.setMetaNoClone(this.icon, iconMeta);
        }
        this.expCurve = progressionConfig.getString("experience.exp_level_curve");
        this.maxLevel = progressionConfig.getInt("experience.max_level");
        this.levelingMessages = TranslationManager.translateListPlaceholders(progressionConfig.getStringList("messages"));
        this.levelingCommands = progressionConfig.getStringList("commands");
        this.levelingUndoCommands = progressionConfig.getStringList("undo_commands");
        this.experienceLimit = progressionConfig.getDouble("experience.daily_limit", -1.0);
        this.experienceLimitMessage = progressionConfig.getString("experience.daily_limit_warning", null);
        int[] coords = this.parseCoordinates(progressionConfig.getString("starting_coordinates", "0,0"));
        this.centerX = coords[0];
        this.centerY = coords[1];
        ConfigurationSection startingPerksSection = progressionConfig.getConfigurationSection("starting_perks");
        if (startingPerksSection != null) {
            for (Object startPerk : startingPerksSection.getKeys(false)) {
                PerkReward reward;
                Object arg = progressionConfig.get("starting_perks." + (String)startPerk);
                if (arg == null || (reward = PerkRewardRegistry.createReward((String)startPerk, arg)) == null) continue;
                this.startingPerks.add(reward);
            }
        }
        if ((levelingPerksSection = progressionConfig.getConfigurationSection("leveling_perks")) != null) {
            for (Object levelPerk : levelingPerksSection.getKeys(false)) {
                PerkReward reward;
                Object arg = progressionConfig.get("leveling_perks." + (String)levelPerk);
                if (arg == null || (reward = PerkRewardRegistry.createReward((String)levelPerk, arg)) == null) continue;
                this.levelingPerks.add(reward);
            }
        }
        if ((perksSection = progressionConfig.getConfigurationSection("perks")) != null) {
            for (Object perkName : perksSection.getKeys(false)) {
                String displayName = TranslationManager.translatePlaceholders(progressionConfig.getString("perks." + (String)perkName + ".name"));
                String description = TranslationManager.translatePlaceholders(progressionConfig.getString("perks." + (String)perkName + ".description"));
                ItemStack icon = ItemUtils.getIconFromConfig(progressionConfig, "perks." + (String)perkName + ".icon", this.getClass().getSimpleName() + " progression config", new ItemStack(Material.PAPER));
                String permission = progressionConfig.getString("perks." + (String)perkName + ".permission");
                int[] c = this.parseCoordinates(progressionConfig.getString("perks." + (String)perkName + ".coords", "0,0"));
                int perkX = c[0];
                int perkY = c[1];
                HashSet<ResourceExpense> expenses = new HashSet<ResourceExpense>();
                for (String string : ResourceExpenseRegistry.getExpenses().keySet()) {
                    ResourceExpense expense = ResourceExpenseRegistry.createExpenseInstance(string);
                    Object cost = progressionConfig.get("perks." + (String)perkName + "." + string);
                    if (expense == null || cost == null) continue;
                    expense.initExpense(cost);
                    expenses.add(expense);
                }
                HashSet<UnlockCondition> conditions = new HashSet<UnlockCondition>();
                for (String conditionKey : UnlockConditionRegistry.getValuePlaceholders()) {
                    UnlockCondition condition = UnlockConditionRegistry.createConditionInstance(conditionKey);
                    Object cost = progressionConfig.get("perks." + (String)perkName + "." + conditionKey);
                    if (condition == null || cost == null) continue;
                    condition.initCondition(cost);
                    conditions.add(condition);
                }
                boolean bl = progressionConfig.getBoolean("perks." + (String)perkName + ".hidden");
                int required_level = progressionConfig.getInt("perks." + (String)perkName + ".required_lv");
                ArrayList<PerkReward> perkRewards = new ArrayList<PerkReward>();
                ConfigurationSection perkRewardSection = progressionConfig.getConfigurationSection("perks." + (String)perkName + ".perk_rewards");
                if (perkRewardSection != null) {
                    for (String rewardString : perkRewardSection.getKeys(false)) {
                        PerkReward reward;
                        Object arg = progressionConfig.get("perks." + (String)perkName + ".perk_rewards." + rewardString);
                        if (arg == null || (reward = PerkRewardRegistry.createReward(rewardString, arg)) == null) continue;
                        perkRewards.add(reward);
                    }
                }
                List<String> perkMessages = TranslationManager.translateListPlaceholders(progressionConfig.getStringList("perks." + (String)perkName + ".messages"));
                List commands = progressionConfig.getStringList("perks." + (String)perkName + ".commands");
                List undoCommands = progressionConfig.getStringList("perks." + (String)perkName + ".undo_commands");
                int customModelDataUnlockable = progressionConfig.getInt("perks." + (String)perkName + ".custom_model_data_unlockable", -1);
                int customModelDataUnlocked = progressionConfig.getInt("perks." + (String)perkName + ".custom_model_data_unlocked", -1);
                int customModelDataVisible = progressionConfig.getInt("perks." + (String)perkName + ".custom_model_data_visible", -1);
                Perk newPerk = new Perk((String)perkName, displayName, description, icon, this, perkX, perkY, bl, expenses, conditions, required_level, permission, perkRewards, perkMessages, commands, undoCommands);
                if (customModelDataUnlockable > 0) {
                    newPerk.setCustomModelDataUnlockable(customModelDataUnlockable);
                }
                if (customModelDataUnlocked > 0) {
                    newPerk.setCustomModelDataUnlocked(customModelDataUnlocked);
                }
                if (customModelDataVisible > 0) {
                    newPerk.setCustomModelDataVisible(customModelDataVisible);
                }
                HashSet<PerkConnectionIcon> connectionLine = new HashSet<PerkConnectionIcon>();
                ConfigurationSection connectionSection = progressionConfig.getConfigurationSection("perks." + (String)perkName + ".connection_line");
                if (connectionSection != null) {
                    for (String i : connectionSection.getKeys(false)) {
                        int[] position = this.parseCoordinates(progressionConfig.getString("perks." + (String)perkName + ".connection_line." + i + ".position"));
                        if (position == null) {
                            ValhallaMMO.logWarning("Invalid perk connection piece at " + i + ", no position found.");
                            continue;
                        }
                        String[] lockedParts = progressionConfig.getString("perks." + (String)perkName + ".connection_line." + i + ".locked", "").split(":");
                        Material lockedMaterial = Material.valueOf((String)lockedParts[0]);
                        int lockedData = lockedParts.length > 1 ? Integer.parseInt(lockedParts[1]) : -1;
                        String[] unlockedParts = progressionConfig.getString("perks." + (String)perkName + ".connection_line." + i + ".unlocked", "").split(":");
                        Material unlockedMaterial = Material.valueOf((String)unlockedParts[0]);
                        int unlockedData = unlockedParts.length > 1 ? Integer.parseInt(unlockedParts[1]) : -1;
                        String[] unlockableParts = progressionConfig.getString("perks." + (String)perkName + ".connection_line." + i + ".unlockable", "").split(":");
                        Material unlockableMaterial = Material.valueOf((String)unlockableParts[0]);
                        int unlockableData = unlockableParts.length > 1 ? Integer.parseInt(unlockableParts[1]) : -1;
                        connectionLine.add(new PerkConnectionIcon(this, newPerk, position[0], position[1], lockedMaterial, unlockableMaterial, unlockedMaterial, lockedData, unlockableData, unlockedData));
                    }
                    newPerk.setConnectionLine(connectionLine);
                }
                this.perks.add(newPerk);
            }
        }
        this.perks.sort(Comparator.comparingInt(Perk::getLevelRequirement));
        ConfigurationSection specialSection = progressionConfig.getConfigurationSection("special_perks");
        if (specialSection != null) {
            for (String stringLevel : specialSection.getKeys(false)) {
                int level;
                try {
                    level = Integer.parseInt(stringLevel);
                }
                catch (IllegalArgumentException ignored) {
                    ValhallaMMO.logWarning("Invalid special level given at special_perks." + stringLevel + ". Cancelled this special level, it should be a whole number!");
                    continue;
                }
                this.specialLevelingCommands.put(level, progressionConfig.getStringList("special_perks." + stringLevel + ".commands"));
                this.specialLevelingUndoCommands.put(level, progressionConfig.getStringList("special_perks." + stringLevel + ".undo_commands"));
                this.specialLevelingMessages.put(level, TranslationManager.translateListPlaceholders(progressionConfig.getStringList("special_perks." + stringLevel + ".messages")));
                ArrayList<PerkReward> specialPerkRewards = new ArrayList<PerkReward>();
                ConfigurationSection perkSection = progressionConfig.getConfigurationSection("special_perks." + stringLevel + ".perk_rewards");
                if (perkSection != null) {
                    for (String perkName : perkSection.getKeys(false)) {
                        PerkReward reward;
                        Object arg = progressionConfig.get("special_perks." + stringLevel + ".perk_rewards." + perkName);
                        if (arg == null || (reward = PerkRewardRegistry.createReward(perkName, arg)) == null) continue;
                        specialPerkRewards.add(reward);
                    }
                }
                this.specialLevelingPerks.put(level, specialPerkRewards);
            }
        }
        this.expBarTitle = TranslationManager.translatePlaceholders(baseSkillConfig.getString("levelbar_title", ""));
        try {
            this.expBarColor = BarColor.valueOf((String)baseSkillConfig.getString("levelbar_color", "YELLOW"));
        }
        catch (IllegalArgumentException ignored) {
            this.expBarColor = BarColor.WHITE;
        }
        try {
            this.expBarStyle = BarStyle.valueOf((String)baseSkillConfig.getString("levelbar_style", "SEGMENTED_6"));
        }
        catch (IllegalArgumentException ignored) {
            this.expBarStyle = BarStyle.SEGMENTED_6;
        }
        this.normalizePerkCoordinates();
    }

    private void normalizePerkCoordinates() {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int offsetX = 0;
        int offsetY = 0;
        for (Perk perk : this.getPerks()) {
            minX = Math.min(perk.getX(), minX);
            maxX = Math.max(perk.getX(), maxX);
            minY = Math.min(perk.getY(), minY);
            maxY = Math.max(perk.getY(), maxY);
            for (PerkConnectionIcon line : perk.getConnectionLine()) {
                minX = Math.min(line.getX(), minX);
                maxX = Math.max(line.getX(), maxX);
                minY = Math.min(line.getY(), minY);
                maxY = Math.max(line.getY(), maxY);
            }
        }
        if (minX != 0) {
            offsetX = -minX;
            for (Perk p : this.getPerks()) {
                p.setX(p.getX() + offsetX);
                for (PerkConnectionIcon i : p.getConnectionLine()) {
                    i.setX(i.getX() + offsetX);
                }
            }
            this.centerX += offsetX;
        }
        if (minY != 0) {
            offsetY = -minY;
            for (Perk p : this.getPerks()) {
                p.setY(p.getY() + offsetY);
                for (PerkConnectionIcon i : p.getConnectionLine()) {
                    i.setY(i.getY() + offsetY);
                }
            }
            this.centerY += offsetY;
        }
    }

    public double expForLevel(int level) {
        if (this.isLevelableSkill() && level <= this.maxLevel) {
            return Utils.round6Decimals(Utils.eval(this.expCurve.replace("%level%", String.valueOf(level))));
        }
        return -1.0;
    }

    public void updateLevelUpConditions(Player p, boolean silent) {
        Profile profile = ProfileRegistry.getPersistentProfile(p, this.getProfileType());
        if (profile == null) {
            return;
        }
        int currentLevel = profile.getLevel();
        double EXP = profile.getEXP();
        int nextLevel = currentLevel;
        if (EXP < 0.0) {
            for (int i = --nextLevel; i >= 0; --i) {
                double expForLevel = this.expForLevel(i);
                if (-EXP >= expForLevel) {
                    --nextLevel;
                    EXP += expForLevel;
                    continue;
                }
                EXP += expForLevel;
                break;
            }
        } else {
            double expForLevel;
            if (profile.getLevel() >= this.maxLevel || profile.getLevel() >= profile.getMaxAllowedLevel()) {
                if (!ProfileCache.getOrCache(p, PowerProfile.class).hideExperienceGain()) {
                    this.showBossBar(p, profile, 0.0);
                }
                return;
            }
            for (int i = nextLevel + 1; i <= this.maxLevel && EXP >= (expForLevel = this.expForLevel(i)); ++i) {
                EXP -= expForLevel;
                if (++nextLevel < profile.getMaxAllowedLevel()) continue;
                EXP = 0.0;
            }
        }
        if (nextLevel == currentLevel) {
            return;
        }
        profile.setEXP(EXP);
        profile.setLevel(Math.max(0, nextLevel));
        if (profile.getLevel() <= 0 && profile.getEXP() < 0.0) {
            profile.setEXP(0.0);
        }
        if (profile.getLevel() <= 0 && profile.getTotalEXP() < 0.0) {
            profile.setTotalEXP(0.0);
        }
        ProfileRegistry.setPersistentProfile(p, profile, this.getProfileType());
        this.changePlayerLevel(p, currentLevel, Math.max(0, nextLevel), silent);
        if (!ProfileCache.getOrCache(p, PowerProfile.class).hideExperienceGain()) {
            this.showBossBar(p, profile, 0.0);
        }
    }

    public int getLevelFromEXP(double exp) {
        double neededExp;
        int level = 0;
        for (int i = 1; i <= this.getMaxLevel() && exp >= (neededExp = this.expForLevel(i)); ++i) {
            exp -= neededExp;
            ++level;
        }
        return level;
    }

    public void addEXP(Player p, double amount, boolean silent, PlayerSkillExperienceGainEvent.ExperienceGainReason reason) {
        if (!this.isLevelableSkill() || this.requiredPermission != null && !p.hasPermission(this.requiredPermission) || this.hasReachedLimit(p)) {
            return;
        }
        if (!(this instanceof PowerSkill) && p.getGameMode() == GameMode.CREATIVE && reason == PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION) {
            return;
        }
        if (this.isExperienceScaling() && (reason == PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION || reason == PlayerSkillExperienceGainEvent.ExperienceGainReason.EXP_SHARE)) {
            amount *= 1.0 + AccumulativeStatManager.getCachedStats("GLOBAL_EXP_GAIN", (Entity)p, 10000L, true);
        }
        PlayerSkillExperienceGainEvent event = new PlayerSkillExperienceGainEvent(p, amount, this, reason);
        if (Bukkit.isPrimaryThread()) {
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
        }
        if (!event.isCancelled()) {
            if (event.getAmount() == 0.0) {
                return;
            }
            Profile profile = ProfileRegistry.getPersistentProfile(p, event.getLeveledSkill().getProfileType());
            if (profile.getLevel() >= profile.getMaxAllowedLevel() && (reason == PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION || reason == PlayerSkillExperienceGainEvent.ExperienceGainReason.EXP_SHARE)) {
                return;
            }
            profile.setEXP(profile.getEXP() + event.getAmount());
            profile.setTotalEXP(profile.getTotalEXP() + event.getAmount());
            this.incrementExperienceLimit(p, event.getAmount());
            if (!silent) {
                double statusAmount = this.accumulateEXP(p, event.getAmount(), event.getLeveledSkill());
                if (!(this instanceof PowerSkill) && !me.athlaeos.valhallammo.utility.StringUtils.isEmpty(this.getExpStatus())) {
                    p.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(Utils.chat(this.getExpStatus().replace("%skill%", event.getLeveledSkill().displayName).replace("%exp%", (statusAmount >= 0.0 ? "+" : "") + String.format("%,.2f", statusAmount)))));
                }
                if (!ProfileCache.getOrCache(p, PowerProfile.class).hideExperienceGain()) {
                    this.showBossBar(p, profile, statusAmount);
                }
            }
            ProfileRegistry.setPersistentProfile(p, profile, profile.getClass());
            double nextLevelEXP = this.expForLevel(profile.getLevel() + 1);
            if (nextLevelEXP > 0.0 && profile.getEXP() >= nextLevelEXP || profile.getEXP() < 0.0) {
                this.updateLevelUpConditions(p, silent);
                AccumulativeStatManager.uncacheProfile(p.getUniqueId(), profile.getClass());
            }
        }
    }

    public boolean hasReachedLimit(Player p) {
        if (this.experienceLimit < 0.0 || this instanceof PowerSkill) {
            return false;
        }
        return this.experienceLimitMap.getOrDefault(p.getUniqueId(), 0.0) >= this.experienceLimit;
    }

    public void incrementExperienceLimit(Player p, double exp) {
        if (this.experienceLimit < 0.0 || this instanceof PowerSkill) {
            return;
        }
        if (!this.experienceLimitTimeMap.containsKey(p.getUniqueId()) || this.experienceLimitTimeMap.get(p.getUniqueId()) + 86400000L < System.currentTimeMillis()) {
            this.experienceLimitTimeMap.put(p.getUniqueId(), System.currentTimeMillis());
            this.experienceLimitMap.remove(p.getUniqueId());
            this.sentExperienceLimitMessage.remove(p.getUniqueId());
        }
        double existingValue = this.experienceLimitMap.getOrDefault(p.getUniqueId(), 0.0);
        this.experienceLimitMap.put(p.getUniqueId(), existingValue += exp);
        if (this.hasReachedLimit(p) && !this.sentExperienceLimitMessage.contains(p.getUniqueId())) {
            Utils.sendMessage((CommandSender)p, TranslationManager.translatePlaceholders(this.experienceLimitMessage));
        }
    }

    public void addLevels(Player player, int levels, boolean silent, PlayerSkillExperienceGainEvent.ExperienceGainReason reason) {
        if (levels == 0) {
            return;
        }
        Profile p = ProfileRegistry.getPersistentProfile(player, this.getProfileType());
        double expToGive = 0.0;
        if (levels < 0) {
            for (int level = p.getLevel() + levels; level < p.getLevel(); ++level) {
                expToGive -= this.expForLevel(level);
            }
        } else {
            for (int level = p.getLevel() + 1; level <= p.getLevel() + levels; ++level) {
                expToGive += this.expForLevel(level);
            }
        }
        this.addEXP(player, Math.ceil(expToGive), silent, reason);
    }

    private double accumulateEXP(Player p, double amount, Skill type) {
        EXPStatusStruct struct = this.expTracker.getOrDefault(p.getUniqueId(), new EXPStatusStruct(type, 0.0, System.currentTimeMillis()));
        if (!struct.getType().equals(type) || struct.getTime_since_last() + 3000L <= System.currentTimeMillis() || struct.getExp() > 1.0E8) {
            struct = new EXPStatusStruct(type, 0.0, System.currentTimeMillis());
        }
        struct.setExp(struct.getExp() + amount);
        struct.setTime_since_last(System.currentTimeMillis());
        struct.setType(type);
        this.expTracker.put(p.getUniqueId(), struct);
        return struct.getExp();
    }

    private void showBossBar(Player p, Profile profile, double accumulatedEXP) {
        if (!me.athlaeos.valhallammo.utility.StringUtils.isEmpty(this.expBarTitle)) {
            double expForNextLevel = this.expForLevel(profile.getLevel() + 1);
            String bossBarTitle = Utils.chat(this.expBarTitle.replace("%skill%", this.displayName).replace("%exp%", (accumulatedEXP >= 0.0 ? "+" : "") + String.format("%,.2f", accumulatedEXP)).replace("%exp_current%", String.format("%.2f", profile.getEXP())).replace("%lv_current%", String.valueOf(profile.getLevel())).replace("%lv_next%", expForNextLevel == -1.0 ? TranslationManager.getTranslation("max_level") : String.valueOf(profile.getLevel() + 1)).replace("%exp_next%", expForNextLevel == -1.0 ? TranslationManager.getTranslation("max_level") : String.format("%.2f", expForNextLevel)));
            float fraction = expForNextLevel <= 0.0 ? 1.0f : (float)Utils.round6Decimals(profile.getEXP() / expForNextLevel);
            BossBarUtils.showBossBarToPlayer(p, bossBarTitle, Math.min(fraction, 1.0f), 50, this.type, this.expBarColor, this.expBarStyle);
        }
    }

    private void changePlayerLevel(final Player p, int from, final int to, boolean silent) {
        if (!this.isLevelableSkill()) {
            return;
        }
        if (to < from) {
            for (int i = from - 1; i >= to; --i) {
                if (!this.specialLevelingUndoCommands.containsKey(i)) continue;
                for (String string : this.specialLevelingUndoCommands.get(i)) {
                    ValhallaMMO.getInstance().getServer().dispatchCommand((CommandSender)ValhallaMMO.getInstance().getServer().getConsoleSender(), string.replace("%player%", p.getName()));
                }
            }
            for (String command : this.levelingUndoCommands) {
                ValhallaMMO.getInstance().getServer().dispatchCommand((CommandSender)ValhallaMMO.getInstance().getServer().getConsoleSender(), command.replace("%player%", p.getName()));
            }
            ValhallaMMO.getInstance().getServer().getScheduler().runTaskAsynchronously((Plugin)ValhallaMMO.getInstance(), () -> {
                for (int i = from; i > to; --i) {
                    for (PerkReward reward : this.levelingPerks) {
                        if (reward instanceof MultiplicativeReward || reward.isPersistent()) continue;
                        reward.remove(p);
                    }
                    if (!this.specialLevelingPerks.containsKey(i)) continue;
                    for (PerkReward reward : this.specialLevelingPerks.get(i)) {
                        if (reward.isPersistent()) continue;
                        reward.remove(p);
                    }
                }
                for (PerkReward reward : this.levelingPerks) {
                    if (reward instanceof MultiplicativeReward) {
                        MultiplicativeReward r = (MultiplicativeReward)((Object)reward);
                        if (reward.isPersistent()) continue;
                        r.remove(p, from - to);
                        continue;
                    }
                    reward.remove(p);
                }
                if (this.arePerksForgettable()) {
                    ArrayList<Perk> sortedPerks = new ArrayList<Perk>(this.perks);
                    sortedPerks.sort(Comparator.comparingInt(Perk::getLevelRequirement));
                    Collections.reverse(sortedPerks);
                    for (Perk perk : sortedPerks) {
                        if (!perk.shouldLock(p)) continue;
                        perk.remove(p);
                        p.sendMessage(Utils.chat(TranslationManager.getTranslation("perk_forget").replace("%perk%", perk.getDisplayName())));
                    }
                }
            });
        } else {
            for (int i = from + 1; i <= to; ++i) {
                if (!silent && this.specialLevelingMessages.containsKey(i)) {
                    for (String string : this.specialLevelingMessages.get(i)) {
                        p.sendMessage(PlaceholderRegistry.parsePapi(PlaceholderRegistry.parse(Utils.chat(string.replace("%player%", p.getName())), p), p));
                    }
                }
                if (this.specialLevelingCommands.containsKey(i)) {
                    for (String string : this.specialLevelingCommands.get(i)) {
                        ValhallaMMO.getInstance().getServer().dispatchCommand((CommandSender)ValhallaMMO.getInstance().getServer().getConsoleSender(), string.replace("%player%", p.getName()));
                    }
                }
                for (String string : this.levelingCommands) {
                    ValhallaMMO.getInstance().getServer().dispatchCommand((CommandSender)ValhallaMMO.getInstance().getServer().getConsoleSender(), string.replace("%player%", p.getName()));
                }
            }
            if (!silent) {
                final HashMap<Integer, List> messages = new HashMap<Integer, List>();
                int lastDelay = 0;
                for (String message3 : this.levelingMessages) {
                    String[] matches = message3.startsWith("DELAY(") ? StringUtils.substringsBetween((String)message3, (String)"DELAY(", (String)")") : new String[]{};
                    int delay = Math.max(0, matches == null || matches.length == 0 ? 0 : Catch.catchOrElse(() -> Integer.parseInt(matches[0]), 0));
                    List thisDelayMessages = messages.getOrDefault(lastDelay += delay, new ArrayList());
                    thisDelayMessages.add(message3);
                    messages.put(lastDelay, thisDelayMessages);
                }
                if (lastDelay == 0) {
                    this.levelingMessages.forEach(message -> Utils.sendMessage((CommandSender)p, TranslationManager.translatePlaceholders(message).replace("%player%", p.getName()).replace("%level%", String.valueOf(to))));
                } else {
                    final int n = lastDelay;
                    new BukkitRunnable(this){
                        int timer = 0;
                        final /* synthetic */ Skill this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void run() {
                            if (this.timer >= n || !p.isOnline()) {
                                this.cancel();
                                return;
                            }
                            ((List)messages.getOrDefault(this.timer, new ArrayList())).forEach(message -> Utils.sendMessage((CommandSender)p, TranslationManager.translatePlaceholders(message).replace("%player%", p.getName()).replace("%level%", String.valueOf(to))));
                            ++this.timer;
                        }
                    }.runTaskTimer((Plugin)ValhallaMMO.getInstance(), 0L, 1L);
                }
            }
            ValhallaMMO.getInstance().getServer().getScheduler().runTaskAsynchronously((Plugin)ValhallaMMO.getInstance(), () -> {
                for (int i = from + 1; i <= to; ++i) {
                    for (PerkReward reward : this.levelingPerks) {
                        if (reward instanceof MultiplicativeReward) continue;
                        reward.apply(p);
                    }
                    if (!this.specialLevelingPerks.containsKey(i)) continue;
                    for (PerkReward reward : this.specialLevelingPerks.get(i)) {
                        reward.apply(p);
                    }
                }
                for (PerkReward reward : this.levelingPerks) {
                    if (reward instanceof MultiplicativeReward) {
                        MultiplicativeReward r = (MultiplicativeReward)((Object)reward);
                        r.apply(p, to - from);
                        continue;
                    }
                    reward.apply(p);
                }
            });
        }
        ValhallaMMO.getInstance().getServer().getScheduler().runTask((Plugin)ValhallaMMO.getInstance(), () -> ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)new PlayerSkillLevelUpEvent(p, this, from, to)));
    }

    public void updateSkillStats(Player p, boolean runPersistentStartingPerks) {
        Profile persistentProfile = ProfileRegistry.getPersistentProfile(p, this.getProfileType());
        int level = persistentProfile.getLevel();
        PowerProfile powerProfile = ProfileRegistry.getPersistentProfile(p, PowerProfile.class);
        for (PerkReward perkReward : this.startingPerks) {
            if (!runPersistentStartingPerks && perkReward.isPersistent()) continue;
            perkReward.apply(p);
        }
        if (level > 0) {
            for (int i = 1; i <= level; ++i) {
                for (PerkReward reward : this.levelingPerks) {
                    if (reward instanceof MultiplicativeReward || reward.isPersistent()) continue;
                    reward.apply(p);
                }
                if (!this.specialLevelingPerks.containsKey(i)) continue;
                for (PerkReward reward : this.specialLevelingPerks.get(i)) {
                    if (reward.isPersistent()) continue;
                    reward.apply(p);
                }
            }
            for (PerkReward perkReward : this.levelingPerks) {
                if (!(perkReward instanceof MultiplicativeReward)) continue;
                MultiplicativeReward r = (MultiplicativeReward)((Object)perkReward);
                if (perkReward.isPersistent()) continue;
                r.apply(p, level);
            }
        }
        Collection<String> unlockedPerks = powerProfile.getUnlockedPerks();
        unlockedPerks.addAll(powerProfile.getPermanentlyUnlockedPerks());
        Collection<String> collection = powerProfile.getFakeUnlockedPerks();
        Collection<String> permanentlyLockedPerks = powerProfile.getPermanentlyLockedPerks();
        for (Perk perk : this.perks) {
            if (collection.contains(perk.getName()) || permanentlyLockedPerks.contains(perk.getName()) || !unlockedPerks.contains(perk.getName())) continue;
            for (PerkReward reward : perk.getRewards()) {
                if (reward.isPersistent()) continue;
                reward.apply(p);
            }
            if (perk.getExpenses().isEmpty()) continue;
            ValhallaMMO.getInstance().getServer().getScheduler().runTask((Plugin)ValhallaMMO.getInstance(), () -> {
                for (ResourceExpense expense : perk.getExpenses()) {
                    expense.purchase(p, false);
                }
            });
        }
        ValhallaMMO.getInstance().getServer().getScheduler().runTask((Plugin)ValhallaMMO.getInstance(), () -> ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)new ValhallaUpdatedStatsEvent(p, this.getProfileType())));
    }

    public boolean arePerksForgettable() {
        return this.perksForgettable;
    }

    public String getType() {
        return this.type;
    }

    public String getRequiredPermission() {
        return this.requiredPermission;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public String getExpCurve() {
        return this.expCurve;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public List<PerkReward> getStartingPerks() {
        return this.startingPerks;
    }

    public List<PerkReward> getLevelingPerks() {
        return this.levelingPerks;
    }

    public List<String> getLevelingMessages() {
        return this.levelingMessages;
    }

    public List<String> getLevelingCommands() {
        return this.levelingCommands;
    }

    public List<String> getLevelingUndoCommands() {
        return this.levelingUndoCommands;
    }

    public Map<Integer, List<PerkReward>> getSpecialLevelingPerks() {
        return this.specialLevelingPerks;
    }

    public Map<Integer, List<String>> getSpecialLevelingMessages() {
        return this.specialLevelingMessages;
    }

    public Map<Integer, List<String>> getSpecialLevelingCommands() {
        return this.specialLevelingCommands;
    }

    public Map<Integer, List<String>> getSpecialLevelingUndoCommands() {
        return this.specialLevelingUndoCommands;
    }

    public List<Perk> getPerks() {
        return this.perks;
    }

    public boolean isPerksForgettable() {
        return this.perksForgettable;
    }

    public boolean hasPermissionAccess(Player p) {
        return this.requiredPermission == null || p.hasPermission(this.requiredPermission);
    }

    private static class EXPStatusStruct {
        private Skill type;
        private Long time_since_last;
        private double exp;

        public EXPStatusStruct(Skill type, double exp, Long time_since_last) {
            this.type = type;
            this.exp = exp;
            this.time_since_last = time_since_last;
        }

        public double getExp() {
            return this.exp;
        }

        public Long getTime_since_last() {
            return this.time_since_last;
        }

        public Skill getType() {
            return this.type;
        }

        public void setExp(double exp) {
            this.exp = exp;
        }

        public void setTime_since_last(Long time_since_last) {
            this.time_since_last = time_since_last;
        }

        public void setType(Skill type) {
            this.type = type;
        }
    }
}

