/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.skills.implementations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.animations.Animation;
import me.athlaeos.valhallammo.animations.AnimationRegistry;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.dom.CombatType;
import me.athlaeos.valhallammo.entities.EntityClassification;
import me.athlaeos.valhallammo.event.EntityCriticallyHitEvent;
import me.athlaeos.valhallammo.event.PlayerSkillExperienceGainEvent;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.listeners.EntityAttackListener;
import me.athlaeos.valhallammo.listeners.EntityDamagedListener;
import me.athlaeos.valhallammo.listeners.EntitySpawnListener;
import me.athlaeos.valhallammo.listeners.ProjectileListener;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.particle.implementations.GenericParticle;
import me.athlaeos.valhallammo.particle.implementations.RedstoneParticle;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.ArcheryProfile;
import me.athlaeos.valhallammo.potioneffects.implementations.Stun;
import me.athlaeos.valhallammo.skills.ChunkEXPNerf;
import me.athlaeos.valhallammo.skills.skills.Skill;
import me.athlaeos.valhallammo.utility.AnimationUtils;
import me.athlaeos.valhallammo.utility.Bleeder;
import me.athlaeos.valhallammo.utility.EntityUtils;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.MathUtils;
import me.athlaeos.valhallammo.utility.Timer;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.EnchantmentMappings;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;

public class ArcherySkill
extends Skill
implements Listener {
    private double expBaseBow = 0.0;
    private double expBaseCrossbow = 0.0;
    private double expDamageBonus = 0.0;
    private double expDistanceMultiplierBase = 0.0;
    private double expDistanceMultiplierBonus = 0.0;
    private int expDistanceLimit = 0;
    private int damageDistanceLimit = 0;
    private double expInfinityMultiplier = 0.0;
    private double expSpawnerMultiplier = 0.0;
    private double damageDiminishingReturnsLimit = 0.0;
    private double damageDiminishingReturnsMultiplier = 0.0;
    private Animation chargedShotActivationAnimation;
    private Animation chargedShotFireAnimation;
    private Animation chargedShotSonicBoomAnimation;
    private Animation chargedShotAmmoAnimation;
    private final Map<EntityType, Double> entityExpMultipliers = new HashMap<EntityType, Double>();
    private boolean maxHealthLimitation = false;
    private double pvpMultiplier = 0.1;
    private boolean isChunkNerfed = true;
    private Particle trail = null;
    private Particle.DustOptions trailOptions = null;
    private double sonicBoomRequiredVelocity = 0.0;
    public static Map<UUID, ChargedShotUser> chargedShotUsers = new HashMap<UUID, ChargedShotUser>();

    public ArcherySkill(String type) {
        super(type);
    }

    @Override
    public void loadConfiguration() {
        ValhallaMMO.getInstance().save("skills/archery_progression.yml");
        ValhallaMMO.getInstance().save("skills/archery.yml");
        YamlConfiguration skillConfig = ConfigManager.getConfig("skills/archery.yml").get();
        YamlConfiguration progressionConfig = ConfigManager.getConfig("skills/archery_progression.yml").get();
        this.loadCommonConfig(skillConfig, progressionConfig);
        this.damageDistanceLimit = skillConfig.getInt("distance_limit");
        this.damageDiminishingReturnsLimit = skillConfig.getDouble("diminishing_returns_limit");
        this.damageDiminishingReturnsMultiplier = skillConfig.getDouble("diminishing_returns_multiplier");
        this.expBaseBow = progressionConfig.getDouble("experience.bow_exp_base");
        this.expBaseCrossbow = progressionConfig.getDouble("experience.crossbow_exp_base");
        this.expDamageBonus = progressionConfig.getDouble("experience.damage_exp_bonus");
        this.expDistanceMultiplierBase = progressionConfig.getDouble("experience.distance_exp_multiplier_base");
        this.expDistanceMultiplierBonus = progressionConfig.getDouble("experience.distance_exp_multiplier");
        this.expDistanceLimit = progressionConfig.getInt("experience.distance_limit");
        this.expInfinityMultiplier = progressionConfig.getDouble("experience.infinity_multiplier");
        this.expSpawnerMultiplier = progressionConfig.getDouble("experience.spawner_spawned_multiplier");
        this.maxHealthLimitation = progressionConfig.getBoolean("experience.max_health_limitation");
        this.pvpMultiplier = progressionConfig.getDouble("experience.pvp_multiplier");
        this.isChunkNerfed = progressionConfig.getBoolean("experience.is_chunk_nerfed", true);
        ConfigurationSection entitySection = progressionConfig.getConfigurationSection("experience.entity_exp_multipliers");
        if (entitySection != null) {
            entitySection.getKeys(false).forEach(s -> {
                EntityType e = Catch.catchOrElse(() -> EntityType.valueOf((String)s), null, "Invalid entity type given in skills/archery_progression.yml experience.entity_exp_multipliers." + s);
                if (e == null) {
                    return;
                }
                double multiplier = progressionConfig.getDouble("experience.entity_exp_multipliers." + s);
                this.entityExpMultipliers.put(e, multiplier);
            });
        }
        this.trail = Catch.catchOrElse(() -> Particle.valueOf((String)skillConfig.getString("charged_shot_trail_particle")), null, "Invalid charged shot fire sound given in skills/archery.yml charged_shot_fire_sound");
        this.trailOptions = new Particle.DustOptions(Utils.hexToRgb(skillConfig.getString("charged_shot_trail_rgb", "#ffffff")), 0.5f);
        this.sonicBoomRequiredVelocity = MathUtils.pow(skillConfig.getDouble("charged_shot_sonic_boom_required_velocity"), 2.0);
        this.chargedShotSonicBoomAnimation = AnimationRegistry.CHARGED_SHOT_SONIC_BOOM;
        this.chargedShotAmmoAnimation = AnimationRegistry.CHARGED_SHOT_AMMO;
        this.chargedShotActivationAnimation = AnimationRegistry.CHARGED_SHOT_ACTIVATION;
        this.chargedShotFireAnimation = AnimationRegistry.CHARGED_SHOT_FIRE;
        ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)ValhallaMMO.getInstance());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCrossbowUnload(InventoryClickEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getWhoClicked().getWorld().getName()) || !Timer.isCooldownPassed(e.getWhoClicked().getUniqueId(), "delay_crossbow_unload_attempts") || WorldGuardHook.inDisabledRegion(e.getWhoClicked().getLocation(), (Player)e.getWhoClicked(), "vmmo-skill-archery")) {
            return;
        }
        if (!(e.getClickedInventory() instanceof PlayerInventory) || !e.isRightClick()) {
            return;
        }
        Timer.setCooldown(e.getWhoClicked().getUniqueId(), 500, "delay_crossbow_unload_attempts");
        if (ItemUtils.isEmpty(e.getCurrentItem()) || e.getCurrentItem().getType() != Material.CROSSBOW) {
            return;
        }
        ItemBuilder clicked = new ItemBuilder(e.getCurrentItem());
        ItemMeta itemMeta = clicked.getMeta();
        if (itemMeta instanceof CrossbowMeta) {
            CrossbowMeta m = (CrossbowMeta)itemMeta;
            ItemStack projectile = m.getChargedProjectiles().stream().findFirst().orElse(null);
            if (ItemUtils.isEmpty(projectile)) {
                return;
            }
            projectile = projectile.clone();
            projectile.setAmount(1);
            ItemUtils.addItem((Player)e.getWhoClicked(), projectile, true);
            e.getWhoClicked().getWorld().playSound(e.getWhoClicked().getLocation(), Sound.ITEM_CROSSBOW_LOADING_END, 1.0f, 1.0f);
            m.setChargedProjectiles(new ArrayList());
            e.setCurrentItem(clicked.get());
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInteract(PlayerInteractEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName()) || e.getHand() == EquipmentSlot.OFF_HAND || e.useItemInHand() == Event.Result.DENY || !Timer.isCooldownPassed(e.getPlayer().getUniqueId(), "delay_charged_shot_attempts") || WorldGuardHook.inDisabledRegion(e.getPlayer().getLocation(), e.getPlayer(), "vmmo-skill-archery") || WorldGuardHook.inDisabledRegion(e.getPlayer().getLocation(), e.getPlayer(), "vmmo-combat-chargedshot") || !this.hasPermissionAccess(e.getPlayer())) {
            return;
        }
        Timer.setCooldown(e.getPlayer().getUniqueId(), 500, "delay_charged_shot_attempts");
        if (!e.getPlayer().isSneaking() && e.getAction() != Action.LEFT_CLICK_AIR && e.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        ItemStack mainHand = e.getPlayer().getInventory().getItemInMainHand();
        if (ItemUtils.isEmpty(mainHand) || !e.getPlayer().isSneaking()) {
            return;
        }
        if (mainHand.getType() != Material.BOW && mainHand.getType() != Material.CROSSBOW) {
            return;
        }
        ArcheryProfile profile = ProfileCache.getOrCache(e.getPlayer(), ArcheryProfile.class);
        if (!profile.isChargedShotUnlocked() || profile.getChargedShotCharges() <= 0 || !Timer.isCooldownPassed(e.getPlayer().getUniqueId(), "cooldown_charged_shot")) {
            if (!Timer.isCooldownPassed(e.getPlayer().getUniqueId(), "cooldown_charged_shot")) {
                Timer.sendCooldownStatus(e.getPlayer(), "cooldown_charged_shot", TranslationManager.getTranslation("ability_charged_shot"));
            }
            return;
        }
        chargedShotUsers.put(e.getPlayer().getUniqueId(), new ChargedShotUser(profile.getChargedShotCharges(), profile.getChargedShotVelocityBonus(), profile.getChargedShotDamageMultiplier(), profile.getChargedShotKnockback(), profile.getChargedShotPiercing(), profile.getChargedShotAccuracy(), profile.doChargedShotsFireAtFullVelocity(), profile.isChargedShotAntiGravity(), profile.doChargedShotCrossbowsInstantlyReload()));
        Timer.setCooldownIgnoreIfPermission((Entity)e.getPlayer(), profile.getChargedShotCooldown() * 50, "cooldown_charged_shot");
        if (this.chargedShotActivationAnimation != null) {
            this.chargedShotActivationAnimation.animate((LivingEntity)e.getPlayer(), e.getPlayer().getEyeLocation(), e.getPlayer().getEyeLocation().getDirection(), 0);
        }
        if (this.chargedShotAmmoAnimation != null) {
            this.chargedShotAmmoAnimation.animate((LivingEntity)e.getPlayer(), e.getPlayer().getEyeLocation(), e.getPlayer().getEyeLocation().getDirection(), 0);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onArrowHit(EntityDamageByEntityEvent e) {
        IronGolem g;
        boolean facing;
        double baseExp;
        LivingEntity v;
        Player p;
        AbstractArrow a;
        block16: {
            block15: {
                if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName())) {
                    return;
                }
                Entity entity = e.getDamager();
                if (!(entity instanceof AbstractArrow)) break block15;
                a = (AbstractArrow)entity;
                entity = EntityUtils.getTrueDamager(e);
                if (!(entity instanceof Player)) break block15;
                p = (Player)entity;
                if (!(a instanceof Trident) && (entity = e.getEntity()) instanceof LivingEntity && !EntityClassification.matchesClassification((v = (LivingEntity)entity).getType(), EntityClassification.UNALIVE)) break block16;
            }
            return;
        }
        if (WorldGuardHook.inDisabledRegion(p.getLocation(), p, "vmmo-skill-archery")) {
            return;
        }
        ArcheryProfile profile = ProfileCache.getOrCache(p, ArcheryProfile.class);
        ItemBuilder bow = ProjectileListener.getBow((Projectile)a);
        if (bow == null) {
            return;
        }
        boolean hasInfinity = bow.getItem().containsEnchantment(EnchantmentMappings.INFINITY.getEnchantment());
        if (!p.getWorld().equals((Object)v.getWorld())) {
            return;
        }
        int distance = (int)p.getLocation().distance(v.getLocation());
        int damageDistance = (int)Math.ceil((double)Math.min(this.damageDistanceLimit, distance) / 10.0);
        int expDistance = (int)Math.ceil((double)Math.min(this.expDistanceLimit, distance) / 10.0);
        double damage = e.getDamage();
        double damageDistanceMultiplier = 1.0f + profile.getDistanceDamageBase() + (float)damageDistance * profile.getDistanceDamageBonus();
        damage *= damageDistanceMultiplier;
        double d = baseExp = bow.getItem().getType() == Material.BOW ? this.expBaseBow : this.expBaseCrossbow;
        if (hasInfinity) {
            damage *= (double)(1.0f + profile.getInfinityDamageMultiplier());
        }
        if (profile.doesCritOnBleed() && Bleeder.getBleedingEntities().containsKey(v.getUniqueId())) {
            EntityAttackListener.critNextAttack((LivingEntity)p);
        } else if (profile.doesCritOnStun() && Stun.isStunned(v)) {
            EntityAttackListener.critNextAttack((LivingEntity)p);
        } else if (profile.doesCritOnStealth() && !(facing = EntityUtils.isEntityFacing(v, a.getLocation(), EntityAttackListener.getFacingAngleCos())) && p.isSneaking() && !EntityAttackListener.isInCombat(p)) {
            EntityAttackListener.critNextAttack((LivingEntity)p);
        }
        if (damage > this.damageDiminishingReturnsLimit) {
            double excess = damage - damageDistanceMultiplier;
            damage = this.damageDiminishingReturnsLimit + excess * this.damageDiminishingReturnsMultiplier;
        }
        e.setDamage(damage);
        if (v instanceof IronGolem && (g = (IronGolem)v).isPlayerCreated() || EntityClassification.matchesClassification(v.getType(), EntityClassification.ANIMAL)) {
            return;
        }
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
            if (!p.isOnline()) {
                return;
            }
            double damageTaken = EntityDamagedListener.getLastDamageTaken(v.getUniqueId(), e.getFinalDamage());
            if (damageTaken > 1000000.0) {
                return;
            }
            double chunkNerf = !this.isChunkNerfed || EntitySpawnListener.isTrialSpawned((Entity)v) ? 1.0 : ChunkEXPNerf.getChunkEXPNerf(v.getLocation().getChunk(), p, "archery");
            double entityExpMultiplier = this.entityExpMultipliers.getOrDefault(v.getType(), 1.0);
            double exp = (this.expDistanceMultiplierBase * baseExp + baseExp * this.expDistanceMultiplierBonus * (double)expDistance) * entityExpMultiplier * chunkNerf;
            if (hasInfinity) {
                exp *= this.expInfinityMultiplier;
            }
            double pvpMult = e.getEntity() instanceof Player ? this.pvpMultiplier : 1.0;
            this.addEXP(p, pvpMult * (1.0 + this.expDamageBonus * (this.maxHealthLimitation ? Math.min(EntityUtils.getMaxHP(v), damageTaken) : damageTaken)) * exp * entityExpMultiplier * (EntitySpawnListener.getSpawnReason((Entity)v) == CreatureSpawnEvent.SpawnReason.SPAWNER ? this.expSpawnerMultiplier : 1.0), false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
            if (this.isChunkNerfed && !EntitySpawnListener.isTrialSpawned((Entity)v)) {
                ChunkEXPNerf.increment(v.getLocation().getChunk(), p, "archery");
            }
        }, 2L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCrit(EntityCriticallyHitEvent e) {
        AbstractArrow a;
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName())) {
            return;
        }
        Entity entity = e.getCritter();
        if (entity instanceof AbstractArrow && (entity = (a = (AbstractArrow)entity).getShooter()) instanceof Player) {
            Player p = (Player)entity;
            entity = e.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity l = (LivingEntity)entity;
                if (WorldGuardHook.inDisabledRegion(p.getLocation(), p, "vmmo-skill-archery")) {
                    return;
                }
                ArcheryProfile profile = ProfileCache.getOrCache(p, ArcheryProfile.class);
                if (profile.doesBleedOnCrit()) {
                    Bleeder.inflictBleed(l, (Entity)p, CombatType.RANGED);
                }
                if (profile.doesStunOnCrit()) {
                    Stun.attemptStun(l, (LivingEntity)p);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onArrowShot(final EntityShootBowEvent e) {
        Player p;
        AbstractArrow a;
        ItemStack consumable;
        ItemStack bow;
        block16: {
            block15: {
                if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName())) {
                    return;
                }
                bow = e.getBow();
                consumable = e.getConsumable();
                Entity entity = e.getProjectile();
                if (!(entity instanceof AbstractArrow) || (a = (AbstractArrow)entity) instanceof Trident || ItemUtils.isEmpty(consumable) || ItemUtils.isEmpty(bow)) {
                    return;
                }
                ProjectileSource projectileSource = a.getShooter();
                if (!(projectileSource instanceof Player)) break block15;
                p = (Player)projectileSource;
                if (!ProjectileListener.isShotFromMultishot(a)) break block16;
            }
            return;
        }
        if (WorldGuardHook.inDisabledRegion(p.getLocation(), p, "vmmo-skill-archery")) {
            return;
        }
        ChargedShotUser user = chargedShotUsers.get(p.getUniqueId());
        if (user == null) {
            return;
        }
        if (user.spendCharge()) {
            a.setKnockbackStrength(a.getKnockbackStrength() + user.knockbackBuff);
            a.setPierceLevel(a.getPierceLevel() + user.piercingBuff);
            a.setDamage(a.getDamage() * (double)(1.0f + user.damageBuff));
            if (user.noGravity) {
                a.setGravity(false);
                new BukkitRunnable(this){
                    final /* synthetic */ ArcherySkill this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        e.getProjectile().remove();
                    }
                }.runTaskLater((Plugin)ValhallaMMO.getInstance(), 200L);
            }
            if (this.chargedShotFireAnimation != null) {
                this.chargedShotFireAnimation.animate((LivingEntity)p, p.getEyeLocation(), p.getEyeLocation().getDirection(), 0);
            }
            if (this.chargedShotSonicBoomAnimation != null && a.getVelocity().lengthSquared() >= this.sonicBoomRequiredVelocity) {
                this.chargedShotSonicBoomAnimation.animate((LivingEntity)p, p.getEyeLocation(), p.getEyeLocation().getDirection(), 0);
            }
            if (this.trail != null) {
                AnimationUtils.trailProjectile((Projectile)a, this.trail == Particle.valueOf((String)Utils.oldOrNew("REDSTONE", "DUST")) ? new RedstoneParticle(this.trailOptions) : new GenericParticle(this.trail), 60);
            }
            if (user.crossbowInstantReload && bow.getType() == Material.CROSSBOW) {
                ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
                    ItemMeta patt0$temp;
                    ItemStack crossbow;
                    boolean mainHand = !ItemUtils.isEmpty(p.getInventory().getItemInMainHand()) && p.getInventory().getItemInMainHand().getType() == Material.CROSSBOW;
                    ItemStack itemStack = crossbow = mainHand ? p.getInventory().getItemInMainHand() : p.getInventory().getItemInOffHand();
                    if (ItemUtils.isEmpty(crossbow) || !((patt0$temp = crossbow.getItemMeta()) instanceof CrossbowMeta)) {
                        return;
                    }
                    CrossbowMeta crossbowMeta = (CrossbowMeta)patt0$temp;
                    crossbowMeta.addChargedProjectile(consumable);
                    crossbow.setItemMeta((ItemMeta)crossbowMeta);
                }, 1L);
            }
        } else {
            chargedShotUsers.remove(p.getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void arrowShotSpeedMinimalizer(EntityShootBowEvent e) {
        AbstractArrow a;
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName())) {
            return;
        }
        Entity entity = e.getProjectile();
        if (!(entity instanceof AbstractArrow) || (a = (AbstractArrow)entity) instanceof Trident || ItemUtils.isEmpty(e.getConsumable()) || ItemUtils.isEmpty(e.getBow())) {
            return;
        }
        ProjectileSource projectileSource = a.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player p = (Player)projectileSource;
        if (WorldGuardHook.inDisabledRegion(p.getLocation(), p, "vmmo-skill-archery")) {
            return;
        }
        ChargedShotUser user = chargedShotUsers.get(p.getUniqueId());
        if (user != null && user.maxVelocity && user.charges > 0) {
            a.setVelocity(a.getVelocity().normalize().multiply(3));
        }
    }

    public static double getChargedShotDamageBuff(UUID uuid) {
        ChargedShotUser user = chargedShotUsers.get(uuid);
        if (user == null) {
            return 0.0;
        }
        return user.damageBuff;
    }

    public static int getChargedShotCharges(UUID uuid) {
        ChargedShotUser user = chargedShotUsers.get(uuid);
        if (user == null) {
            return 0;
        }
        return user.charges;
    }

    @Override
    public boolean isLevelableSkill() {
        return true;
    }

    @Override
    public Class<? extends Profile> getProfileType() {
        return ArcheryProfile.class;
    }

    @Override
    public int getSkillTreeMenuOrderPriority() {
        return 55;
    }

    @Override
    public boolean isExperienceScaling() {
        return true;
    }

    @Override
    public void addEXP(Player p, double amount, boolean silent, PlayerSkillExperienceGainEvent.ExperienceGainReason reason) {
        if (WorldGuardHook.inDisabledRegion(p.getLocation(), p, "vmmo-skill-archery")) {
            return;
        }
        if (reason == PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION) {
            amount *= 1.0 + AccumulativeStatManager.getCachedStats("ARCHERY_EXP_GAIN", (Entity)p, 10000L, true);
        }
        super.addEXP(p, amount, silent, reason);
    }

    public void setChargedShotActivationAnimation(Animation chargedShotActivationAnimation) {
        this.chargedShotActivationAnimation = chargedShotActivationAnimation;
    }

    public void setChargedShotSonicBoomAnimation(Animation chargedShotSonicBoomAnimation) {
        this.chargedShotSonicBoomAnimation = chargedShotSonicBoomAnimation;
    }

    public void setChargedShotAmmoAnimation(Animation chargedShotAmmoAnimation) {
        this.chargedShotAmmoAnimation = chargedShotAmmoAnimation;
    }

    public void setChargedShotFireAnimation(Animation chargedShotFireAnimation) {
        this.chargedShotFireAnimation = chargedShotFireAnimation;
    }

    public static Map<UUID, ChargedShotUser> getChargedShotUsers() {
        return chargedShotUsers;
    }

    public static class ChargedShotUser {
        private int charges;
        private final float velocityBuff;
        private final float damageBuff;
        private final int knockbackBuff;
        private final int piercingBuff;
        private final float accuracyBuff;
        private final boolean maxVelocity;
        private final boolean crossbowInstantReload;
        private final boolean noGravity;

        public ChargedShotUser(int charges, float velocity, float damage, int knockback, int piercing, float accuracyBuff, boolean maxVelocity, boolean noGravity, boolean crossbowInstantReload) {
            this.charges = charges;
            this.velocityBuff = velocity;
            this.damageBuff = damage;
            this.knockbackBuff = knockback;
            this.piercingBuff = piercing;
            this.accuracyBuff = accuracyBuff;
            this.maxVelocity = maxVelocity;
            this.noGravity = noGravity;
            this.crossbowInstantReload = crossbowInstantReload;
        }

        public boolean spendCharge() {
            --this.charges;
            return this.charges >= 0;
        }

        public int getCharges() {
            return this.charges;
        }

        public float getVelocityBuff() {
            return this.velocityBuff;
        }

        public float getDamageBuff() {
            return this.damageBuff;
        }

        public int getKnockbackBuff() {
            return this.knockbackBuff;
        }

        public int getPiercingBuff() {
            return this.piercingBuff;
        }

        public float getAccuracyBuff() {
            return this.accuracyBuff;
        }

        public boolean isMaxVelocity() {
            return this.maxVelocity;
        }

        public boolean isNoGravity() {
            return this.noGravity;
        }

        public boolean isCrossbowInstantReload() {
            return this.crossbowInstantReload;
        }
    }
}

