/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.utility;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.BiFetcher;
import me.athlaeos.valhallammo.item.EquipmentClass;
import me.athlaeos.valhallammo.item.ItemAttributesRegistry;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.ItemSkillRequirements;
import me.athlaeos.valhallammo.item.PermanentPotionEffects;
import me.athlaeos.valhallammo.item.WeightClass;
import me.athlaeos.valhallammo.item.item_attributes.AttributeWrapper;
import me.athlaeos.valhallammo.listeners.EntityDamagedListener;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.playerstats.EntityProperties;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.potioneffects.PotionEffectRegistry;
import me.athlaeos.valhallammo.potioneffects.effect_triggers.EffectTriggerRegistry;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.MathUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.AttributeMappings;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class EntityUtils {
    private static final String DAMAGE_CAUSE_KEY = "custom_damage_cause";
    private static final double inaccuracyConstant = ValhallaMMO.getPluginConfig().getDouble("inaccuracy_constant", 0.015);
    private static final Map<Integer, Integer> levelExperienceCache = new HashMap<Integer, Integer>();
    private static Method isOnGroundMethod = null;
    private static final Collection<BiFetcher<List<ItemStack>, LivingEntity>> otherEquipmentFetchers = new HashSet<BiFetcher<List<ItemStack>, LivingEntity>>();
    private static final Attribute attackReachAttribute = AttributeMappings.ENTITY_INTERACTION_RANGE.getAttribute();
    private static final Attribute miningSpeedAttribute = AttributeMappings.BLOCK_BREAK_SPEED.getAttribute();
    private static final Collection<UUID> activeDamageProcesses = new HashSet<UUID>();

    public static int getTotalExperience(Player player) {
        return Math.round(player.getExp() * (float)player.getExpToLevel()) + EntityUtils.getTotalExperience(player.getLevel());
    }

    public static void applyInaccuracy(Entity projectile, Vector primaryDirection, double inaccuracy) {
        Vector projectileVelocity = projectile.getVelocity().clone();
        double strength = projectileVelocity.length();
        projectileVelocity = projectileVelocity.normalize();
        primaryDirection = primaryDirection.clone().normalize();
        projectileVelocity.setX(primaryDirection.getX());
        projectileVelocity.setY(primaryDirection.getY());
        projectileVelocity.setZ(primaryDirection.getZ());
        projectileVelocity.multiply(strength);
        inaccuracy = Math.max(0.0, inaccuracy);
        projectileVelocity.setX(projectileVelocity.getX() + Utils.getRandom().nextGaussian() * inaccuracyConstant * inaccuracy);
        projectileVelocity.setY(projectileVelocity.getY() + Utils.getRandom().nextGaussian() * inaccuracyConstant * inaccuracy);
        projectileVelocity.setZ(projectileVelocity.getZ() + Utils.getRandom().nextGaussian() * inaccuracyConstant * inaccuracy);
        projectile.setVelocity(projectileVelocity);
    }

    public static double getMaxHP(LivingEntity l) {
        AttributeInstance instance = l.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        return instance == null ? -1.0 : instance.getValue();
    }

    public static BlockFace getSelectedBlockFace(Player player) {
        List lastTwoTargetBlocks = player.getLastTwoTargetBlocks(null, 100);
        if (lastTwoTargetBlocks.size() != 2 || !((Block)lastTwoTargetBlocks.get(1)).getType().isOccluding()) {
            return null;
        }
        Block targetBlock = (Block)lastTwoTargetBlocks.get(1);
        Block adjacentBlock = (Block)lastTwoTargetBlocks.get(0);
        return targetBlock.getFace(adjacentBlock);
    }

    public static int getTotalExperience(int level) {
        if (levelExperienceCache.containsKey(level)) {
            return levelExperienceCache.get(level);
        }
        int xp = 0;
        if (level >= 0 && level <= 15) {
            xp = (int)Math.round(Math.pow(level, 2.0) + (double)(6 * level));
        } else if (level > 15 && level <= 30) {
            xp = (int)Math.round(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        } else if (level > 30) {
            xp = (int)Math.round(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
        }
        levelExperienceCache.put(level, xp);
        return xp;
    }

    public static boolean isOnGround(Entity e) {
        return e.isOnGround();
    }

    private static boolean downwardsRaytraceBlockSegment(Location l, Vector direction, double length) {
        if (l.getWorld() == null) {
            return false;
        }
        RayTraceResult result = l.getWorld().rayTraceBlocks(l, direction, length, FluidCollisionMode.NEVER, true);
        return result != null && result.getHitBlock() != null && !result.getHitBlock().getType().isAir();
    }

    public static void setTotalExperience(Player player, int amount) {
        float a = 0.0f;
        float b = 0.0f;
        float c = -amount;
        if (amount > EntityUtils.getTotalExperience(0) && amount <= EntityUtils.getTotalExperience(15)) {
            a = 1.0f;
            b = 6.0f;
        } else if (amount > EntityUtils.getTotalExperience(15) && amount <= EntityUtils.getTotalExperience(30)) {
            a = 2.5f;
            b = -40.5f;
            c += 360.0f;
        } else if (amount > EntityUtils.getTotalExperience(30)) {
            a = 4.5f;
            b = -162.5f;
            c += 2220.0f;
        }
        int level = (int)Math.floor(((double)(-b) + Math.sqrt(Math.pow(b, 2.0) - (double)(4.0f * a * c))) / (double)(2.0f * a));
        int xp = amount - EntityUtils.getTotalExperience(level);
        player.setLevel(level);
        player.setExp(0.0f);
        player.giveExp(xp);
    }

    public static void addUniqueAttribute(LivingEntity e, UUID uuid, String identifier, Attribute type, double amount, AttributeModifier.Operation operation) {
        ValhallaMMO.getNms().addUniqueAttribute(e, uuid, identifier, type, amount, operation);
    }

    public static boolean hasUniqueAttribute(LivingEntity e, UUID uuid, String identifier, Attribute type) {
        return ValhallaMMO.getNms().hasUniqueAttribute(e, uuid, identifier, type);
    }

    public static double getUniqueAttributeValue(LivingEntity e, UUID uuid, String identifier, Attribute type) {
        return ValhallaMMO.getNms().getUniqueAttributeValue(e, uuid, identifier, type);
    }

    public static void removeUniqueAttribute(LivingEntity e, String identifier, Attribute type) {
        ValhallaMMO.getNms().removeUniqueAttribute(e, identifier, type);
    }

    public static boolean addExperience(Player player, int amount) {
        if (amount > 0) {
            player.giveExp(amount);
            return true;
        }
        int exp = EntityUtils.getTotalExperience(player);
        if (exp >= amount) {
            EntityUtils.setTotalExperience(player, exp + amount);
            return true;
        }
        return false;
    }

    public static void registerEquipmentFetcher(BiFetcher<List<ItemStack>, LivingEntity> fetcher) {
        otherEquipmentFetchers.add(fetcher);
    }

    public static EntityProperties getEntityProperties(LivingEntity e, boolean getEquipment, boolean getHands, boolean getPotionEffects) {
        EntityProperties equipment = new EntityProperties();
        if (e == null) {
            return equipment;
        }
        return EntityUtils.updateProperties(equipment, e, getEquipment, getHands, getPotionEffects);
    }

    public static double combinedAttributeValue(LivingEntity entity, String attribute, WeightClass weightFilter, String equipmentPenalty, boolean mainHandOnly) {
        double total = 0.0;
        EntityProperties properties = EntityCache.getAndCacheProperties(entity);
        if (properties.getHelmet() != null && (weightFilter == null || WeightClass.getWeightClass(properties.getHelmet().getMeta()) == weightFilter)) {
            total += EntityUtils.getValue(entity, equipmentPenalty, properties.getHelmet(), properties.getHelmetAttributes(), attribute, null);
        }
        if (properties.getChestplate() != null && (weightFilter == null || WeightClass.getWeightClass(properties.getChestplate().getMeta()) == weightFilter)) {
            total += EntityUtils.getValue(entity, equipmentPenalty, properties.getChestplate(), properties.getChestPlateAttributes(), attribute, null);
        }
        if (properties.getLeggings() != null && (weightFilter == null || WeightClass.getWeightClass(properties.getLeggings().getMeta()) == weightFilter)) {
            total += EntityUtils.getValue(entity, equipmentPenalty, properties.getLeggings(), properties.getLeggingsAttributes(), attribute, null);
        }
        if (properties.getBoots() != null && (weightFilter == null || WeightClass.getWeightClass(properties.getBoots().getMeta()) == weightFilter)) {
            total += EntityUtils.getValue(entity, equipmentPenalty, properties.getBoots(), properties.getBootsAttributes(), attribute, null);
        }
        if (properties.getMainHand() != null && ItemUtils.usedMainHand(properties.getMainHand(), properties.getOffHand())) {
            total += EntityUtils.getValue(entity, equipmentPenalty, properties.getMainHand(), properties.getMainHandAttributes(), attribute, null);
        } else if (!mainHandOnly && properties.getOffHand() != null) {
            total += EntityUtils.getValue(entity, equipmentPenalty, properties.getOffHand(), properties.getOffHandAttributes(), attribute, null);
        }
        for (ItemBuilder extra : properties.getMiscEquipment()) {
            total += EntityUtils.getValue(entity, equipmentPenalty, extra, properties.getMiscEquipmentAttributes().get(extra), attribute, null);
        }
        return total;
    }

    public static double combinedAttackerAttributeValue(LivingEntity entity, String attribute, WeightClass weightFilter, String equipmentPenalty, boolean mainHand) {
        double total = 0.0;
        EntityProperties properties = EntityCache.getAndCacheProperties(entity);
        if (properties.getHelmet() != null && (weightFilter == null || WeightClass.getWeightClass(properties.getHelmet().getMeta()) == weightFilter)) {
            total += EntityUtils.getValue(entity, equipmentPenalty, properties.getHelmet(), properties.getHelmetAttributes(), attribute, null);
        }
        if (properties.getChestplate() != null && (weightFilter == null || WeightClass.getWeightClass(properties.getChestplate().getMeta()) == weightFilter)) {
            total += EntityUtils.getValue(entity, equipmentPenalty, properties.getChestplate(), properties.getChestPlateAttributes(), attribute, null);
        }
        if (properties.getLeggings() != null && (weightFilter == null || WeightClass.getWeightClass(properties.getLeggings().getMeta()) == weightFilter)) {
            total += EntityUtils.getValue(entity, equipmentPenalty, properties.getLeggings(), properties.getLeggingsAttributes(), attribute, null);
        }
        if (properties.getBoots() != null && (weightFilter == null || WeightClass.getWeightClass(properties.getBoots().getMeta()) == weightFilter)) {
            total += EntityUtils.getValue(entity, equipmentPenalty, properties.getBoots(), properties.getBootsAttributes(), attribute, null);
        }
        if (mainHand && properties.getMainHand() != null) {
            total += EntityUtils.getValue(entity, equipmentPenalty, properties.getMainHand(), properties.getMainHandAttributes(), attribute, null);
        }
        if (!mainHand && properties.getOffHand() != null) {
            total += EntityUtils.getValue(entity, equipmentPenalty, properties.getOffHand(), properties.getOffHandAttributes(), attribute, null);
        }
        for (ItemBuilder extra : properties.getMiscEquipment()) {
            total += EntityUtils.getValue(entity, equipmentPenalty, extra, properties.getMiscEquipmentAttributes().get(extra), attribute, null);
        }
        return total;
    }

    public static List<Player> getNearbyPlayers(Location from, double radius) {
        return EntityUtils.getNearbyPlayers(from, radius, true);
    }

    public static List<Player> getNearbyPlayers(Location from, double radius, boolean sorted) {
        double squared = radius * radius;
        ArrayList<Player> nearby = new ArrayList<Player>();
        if (from.getWorld() == null) {
            return nearby;
        }
        for (Player p2 : from.getWorld().getPlayers()) {
            if (!(from.distanceSquared(p2.getLocation()) <= squared)) continue;
            nearby.add(p2);
        }
        if (sorted) {
            nearby.sort(Comparator.comparingDouble(p -> p.getLocation().distanceSquared(from)));
        }
        return nearby;
    }

    public static double getPlayerReach(Player p) {
        if (attackReachAttribute == null) {
            return 3.0;
        }
        AttributeInstance reach = p.getAttribute(attackReachAttribute);
        if (reach != null) {
            return reach.getBaseValue();
        }
        return 3.0;
    }

    public static double getPlayerMiningSpeed(Player p) {
        if (miningSpeedAttribute == null) {
            return 1.0;
        }
        AttributeInstance speed = p.getAttribute(miningSpeedAttribute);
        if (speed != null) {
            return speed.getValue();
        }
        return 1.0;
    }

    public static double combinedAttributeValue(LivingEntity entity, String attribute, AttributeModifier.Operation operation, WeightClass weightFilter, String equipmentPenalty, boolean mainHandOnly) {
        ItemBuilder boots;
        ItemBuilder leggings;
        ItemBuilder chestPlate;
        double total = 0.0;
        EntityProperties properties = EntityCache.getAndCacheProperties(entity);
        ItemBuilder helmet = properties.getHelmet();
        if (helmet != null && (weightFilter == null || WeightClass.getWeightClass(helmet.getMeta()) == weightFilter)) {
            total += EntityUtils.getValue(entity, equipmentPenalty, helmet, properties.getHelmetAttributes(), attribute, operation);
        }
        if ((chestPlate = properties.getChestplate()) != null && (weightFilter == null || WeightClass.getWeightClass(chestPlate.getMeta()) == weightFilter)) {
            total += EntityUtils.getValue(entity, equipmentPenalty, chestPlate, properties.getChestPlateAttributes(), attribute, operation);
        }
        if ((leggings = properties.getLeggings()) != null && (weightFilter == null || WeightClass.getWeightClass(leggings.getMeta()) == weightFilter)) {
            total += EntityUtils.getValue(entity, equipmentPenalty, leggings, properties.getLeggingsAttributes(), attribute, operation);
        }
        if ((boots = properties.getBoots()) != null && (weightFilter == null || WeightClass.getWeightClass(boots.getMeta()) == weightFilter)) {
            total += EntityUtils.getValue(entity, equipmentPenalty, boots, properties.getBootsAttributes(), attribute, operation);
        }
        if (properties.getMainHand() != null && ItemUtils.usedMainHand(properties.getMainHand(), properties.getOffHand())) {
            total += EntityUtils.getValue(entity, equipmentPenalty, properties.getMainHand(), properties.getMainHandAttributes(), attribute, operation);
        } else if (!mainHandOnly && properties.getOffHand() != null) {
            total += EntityUtils.getValue(entity, equipmentPenalty, properties.getOffHand(), properties.getOffHandAttributes(), attribute, operation);
        }
        for (ItemBuilder extra : properties.getMiscEquipment()) {
            if (WeightClass.getWeightClass(extra.getMeta()) != weightFilter) continue;
            total += EntityUtils.getValue(entity, equipmentPenalty, extra, properties.getMiscEquipmentAttributes().get(extra), attribute, operation);
        }
        return total;
    }

    private static double getValue(LivingEntity entity, String statPenalty, ItemBuilder item, Map<String, AttributeWrapper> wrappers, String attribute, AttributeModifier.Operation operation) {
        AttributeWrapper attributeWrapper = wrappers.get(attribute);
        if (attributeWrapper == null || operation != null && attributeWrapper.isVanilla() && attributeWrapper.getOperation() != operation) {
            return 0.0;
        }
        double value = attributeWrapper.getValue();
        if (statPenalty != null && entity instanceof Player) {
            Player p = (Player)entity;
            value *= 1.0 + ItemSkillRequirements.getPenalty(p, item, statPenalty);
        }
        return value;
    }

    public static EntityProperties updateProperties(EntityProperties properties, LivingEntity e, boolean equipment, boolean hands, boolean getPotionEffects) {
        EntityEquipment eEquipment = e.getEquipment();
        if (eEquipment != null) {
            if (e instanceof Player) {
                Player p = (Player)e;
                PowerProfile profile = ProfileCache.getOrCache(p, PowerProfile.class);
                properties.setPowerPotionEffects(PermanentPotionEffects.fromString(String.join((CharSequence)";", profile.getPermanentPotionEffects())));
            }
            if (equipment) {
                ItemBuilder boots;
                ItemBuilder leggings;
                ItemBuilder chestPlate;
                properties.getCombinedEnchantments().clear();
                properties.setHelmet(eEquipment.getHelmet());
                properties.setChestplate(eEquipment.getChestplate());
                properties.setLeggings(eEquipment.getLeggings());
                properties.setBoots(eEquipment.getBoots());
                int[] armorWeights = WeightClass.getWeightClasses(properties);
                properties.setHeavyArmorCount(armorWeights[2]);
                properties.setLightArmorCount(armorWeights[1]);
                properties.setWeightlessArmorCount(armorWeights[0]);
                ItemBuilder helmet = properties.getHelmet();
                if (helmet != null) {
                    properties.addCombinedEnchantments(helmet);
                    properties.setHelmetAttributes(ItemAttributesRegistry.getStats(helmet.getMeta(), false));
                    properties.setHelmetPotionEffects(PermanentPotionEffects.getPermanentPotionEffects(helmet.getMeta()));
                }
                if ((chestPlate = properties.getChestplate()) != null) {
                    properties.addCombinedEnchantments(chestPlate);
                    properties.setChestPlateAttributes(ItemAttributesRegistry.getStats(chestPlate.getMeta(), false));
                    properties.setChestplatePotionEffects(PermanentPotionEffects.getPermanentPotionEffects(chestPlate.getMeta()));
                }
                if ((leggings = properties.getLeggings()) != null) {
                    properties.addCombinedEnchantments(leggings);
                    properties.setLeggingsAttributes(ItemAttributesRegistry.getStats(leggings.getMeta(), false));
                    properties.setLeggingsPotionEffects(PermanentPotionEffects.getPermanentPotionEffects(leggings.getMeta()));
                }
                if ((boots = properties.getBoots()) != null) {
                    properties.addCombinedEnchantments(boots);
                    properties.setBootsAttributes(ItemAttributesRegistry.getStats(boots.getMeta(), false));
                    properties.setBootsPotionEffects(PermanentPotionEffects.getPermanentPotionEffects(boots.getMeta()));
                }
                properties.getMiscEquipment().clear();
                for (BiFetcher<List<ItemStack>, LivingEntity> fetcher : otherEquipmentFetchers) {
                    for (ItemStack otherEquipment : fetcher.get(e)) {
                        ItemBuilder builder = new ItemBuilder(otherEquipment);
                        properties.getMiscEquipment().add(builder);
                        properties.getMiscEquipmentAttributes().put(builder, ItemAttributesRegistry.getStats(builder.getMeta(), false));
                        properties.getMiscEquipmentPotionEffects().put(builder, PermanentPotionEffects.getPermanentPotionEffects(builder.getMeta()));
                    }
                }
            }
            if (hands) {
                properties.setMainHand(e.getEquipment().getItemInMainHand());
                properties.setOffHand(e.getEquipment().getItemInOffHand());
                ItemBuilder mainHand = properties.getMainHand();
                properties.addCombinedEnchantments(mainHand);
                if (mainHand != null && EquipmentClass.isHandHeld(mainHand.getMeta()) && EquipmentClass.getMatchingClass(mainHand.getMeta()) != EquipmentClass.TRINKET) {
                    properties.setMainHandAttributes(ItemAttributesRegistry.getStats(mainHand.getMeta(), false));
                    properties.setMainHandPotionEffects(PermanentPotionEffects.getPermanentPotionEffects(mainHand.getMeta()));
                }
                ItemBuilder offHand = properties.getOffHand();
                properties.addCombinedEnchantments(offHand);
                if (offHand != null && EquipmentClass.isHandHeld(offHand.getMeta()) && EquipmentClass.getMatchingClass(offHand.getMeta()) != EquipmentClass.TRINKET) {
                    properties.setOffHandAttributes(ItemAttributesRegistry.getStats(offHand.getMeta(), false));
                    properties.setOffHandPotionEffects(PermanentPotionEffects.getPermanentPotionEffects(offHand.getMeta()));
                }
            }
        }
        if (getPotionEffects) {
            properties.getActivePotionEffects().clear();
            properties.getActivePotionEffects().putAll(PotionEffectRegistry.getActiveEffects(e));
        }
        if (equipment || hands || getPotionEffects) {
            properties.computePermanentEffects();
            EffectTriggerRegistry.setEntityTriggerTypesAffected(e, properties.getPermanentPotionEffects().keySet());
            if (properties.getPermanentPotionEffects().isEmpty()) {
                PermanentPotionEffects.setHasNoPermanentEffects(e);
            } else {
                PermanentPotionEffects.setHasPermanentEffects(e);
            }
        }
        return properties;
    }

    public static double cooldownDamageMultiplier(float cooldown) {
        return Math.min(1.0, 0.2 + MathUtils.pow(cooldown + 0.05f, 2.0) * 0.8);
    }

    public static void damage(LivingEntity entity, double amount, String type, boolean ignoreImmunity) {
        EntityUtils.damage(entity, null, amount, type, ignoreImmunity);
    }

    public static boolean hasActiveDamageProcess(Entity damaged) {
        return activeDamageProcesses.contains(damaged.getUniqueId());
    }

    public static void damage(LivingEntity entity, Entity by, double amount, String type, boolean ignoreImmunity) {
        if (entity.isDead() || activeDamageProcesses.contains(entity.getUniqueId())) {
            return;
        }
        int immunityBefore = entity.getNoDamageTicks();
        if (ignoreImmunity) {
            entity.setNoDamageTicks(0);
        }
        EntityDamagedListener.setCustomDamageCause(entity.getUniqueId(), type);
        entity.setMetadata(DAMAGE_CAUSE_KEY, (MetadataValue)new FixedMetadataValue((Plugin)ValhallaMMO.getInstance(), (Object)type));
        activeDamageProcesses.add(entity.getUniqueId());
        if (by != null) {
            EntityDamagedListener.setDamager((Entity)entity, by);
            entity.damage(amount, by);
        } else {
            entity.damage(amount);
        }
        activeDamageProcesses.remove(entity.getUniqueId());
        entity.removeMetadata(DAMAGE_CAUSE_KEY, (Plugin)ValhallaMMO.getInstance());
        entity.setNoDamageTicks(immunityBefore);
    }

    public static Entity getTrueDamager(EntityDamageByEntityEvent e) {
        EnderPearl p;
        Entity entity = e.getDamager();
        if (entity instanceof EnderPearl && (p = (EnderPearl)entity).getShooter() instanceof Entity) {
            return p;
        }
        Entity entity2 = e.getDamager();
        if (entity2 instanceof Projectile && (entity2 = (p = (Projectile)entity2).getShooter()) instanceof Entity) {
            Entity t = entity2;
            return t;
        }
        return e.getDamager();
    }

    public static boolean isEntityFacing(LivingEntity who, Location at, double cos_angle) {
        Vector dir = at.toVector().subtract(who.getEyeLocation().toVector()).normalize();
        double dot = dir.dot(who.getEyeLocation().getDirection());
        return dot >= cos_angle;
    }

    public static boolean isUnarmed(LivingEntity player) {
        WeightClass weightClass;
        EntityProperties properties = EntityCache.getAndCacheProperties(player);
        WeightClass weightClass2 = weightClass = properties.getMainHand() == null ? null : WeightClass.getWeightClass(properties.getMainHand().getMeta());
        if (weightClass != null && weightClass != WeightClass.WEIGHTLESS) {
            return false;
        }
        if (properties.getMainHand() == null) {
            return true;
        }
        AttributeWrapper damageAttribute = ItemAttributesRegistry.getAnyAttribute(properties.getMainHand().getMeta(), "GENERIC_ATTACK_DAMAGE");
        return damageAttribute == null || WeightClass.hasDefinedWeightClass(properties.getMainHand().getMeta());
    }

    public static String getCustomDamageType(Entity entity) {
        if (!entity.hasMetadata(DAMAGE_CAUSE_KEY)) {
            return null;
        }
        return ((MetadataValue)entity.getMetadata(DAMAGE_CAUSE_KEY).getFirst()).asString();
    }
}

